/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.expander.BindingsBeanInterface;
import org.openprovenance.prov.template.expander.OldBindings;

public class BindingsBeanGenerator {
    private final ProvFactory pFactory;
    static ProvUtilities u = new ProvUtilities();
    final CompilerUtil gu = new CompilerUtil();

    public BindingsBeanGenerator(ProvFactory pFactory) {
        this.pFactory = pFactory;
    }

    public boolean generate(Document doc, String templateName, String packge, String location, String resource) {
        try {
            String bn = this.beanName(templateName);
            String destinationDir = location + "/" + packge.replace('.', '/') + "/";
            String destination = destinationDir + bn + ".java";
            JavaFile spec = this.generateSpecification(doc, bn, templateName, packge, resource);
            try {
                File dir = new File(destinationDir);
                if (!dir.exists() && !dir.mkdirs()) {
                    System.err.println("failed to create directory " + destinationDir);
                    return false;
                }
                PrintWriter out = new PrintWriter(destination);
                out.print(spec);
                out.close();
                return true;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String beanName(String templateName) {
        return this.gu.capitalize(templateName) + "BindingsBean";
    }

    public JavaFile generateSpecification(Document doc, String name, String templateName, String packge, String resource) {
        Bundle bun = (Bundle)u.getBundle(doc).get(0);
        HashSet<QualifiedName> allVars = new HashSet<QualifiedName>();
        HashSet<QualifiedName> allAtts = new HashSet<QualifiedName>();
        this.gu.extractVariablesAndAttributes(bun, allVars, allAtts, this.pFactory);
        return this.generate(allVars, allAtts, name, templateName, packge, resource);
    }

    public JavaFile generate(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, String resource) {
        TypeSpec.Builder builder = this.generateClassBuilder(name);
        builder.addMethod(this.generateConstructor());
        for (QualifiedName q : allVars) {
            builder.addMethod(this.generateVarMutator(q));
        }
        for (QualifiedName q : allAtts) {
            if (!allVars.contains(q)) {
                builder.addMethod(this.generateAttMutator(q, QualifiedName.class));
            }
            builder.addMethod(this.generateAttMutator(q, String.class));
        }
        builder.addMethod(this.generateBindingsGetter());
        builder.addMethod(this.generateTemplateResourceGetter(resource));
        TypeSpec bean = builder.build();
        JavaFile myfile = JavaFile.builder((String)packge, (TypeSpec)bean).addFileComment("Generated Automatically by ProvToolbox for template $S", new Object[]{templateName}).build();
        return myfile;
    }

    public TypeSpec.Builder generateClassBuilder(String name) {
        return TypeSpec.classBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(BindingsBeanInterface.class).addField(OldBindings.class, "bindings", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(ProvFactory.class, "pf", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
    }

    public MethodSpec generateConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ProvFactory.class, "pf", new Modifier[0]).addStatement("this.$N = $N", new Object[]{"pf", "pf"}).addStatement("this.bindings = new $T($N)", new Object[]{OldBindings.class, "pf"}).build();
    }

    public MethodSpec generateVarMutator(QualifiedName v) {
        String local = v.getLocalPart();
        String localCamel = this.gu.camelcase(local);
        MethodSpec method = MethodSpec.methodBuilder((String)("add" + localCamel)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addParameter(QualifiedName.class, "arg", new Modifier[0]).addStatement("bindings.addVariable($S,arg)", new Object[]{local}).build();
        return method;
    }

    public MethodSpec generateAttMutator(QualifiedName v, Class typ) {
        String local = v.getLocalPart();
        String localCamel = this.gu.camelcase(local);
        MethodSpec method = MethodSpec.methodBuilder((String)("add" + localCamel)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addParameter((Type)typ, "arg", new Modifier[0]).addStatement("bindings.addAttribute($S,arg)", new Object[]{local}).build();
        return method;
    }

    public MethodSpec generateBindingsGetter() {
        MethodSpec method = MethodSpec.methodBuilder((String)"getBindings").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(OldBindings.class).addStatement("return bindings", new Object[0]).build();
        return method;
    }

    public MethodSpec generateTemplateResourceGetter(String resource) {
        MethodSpec method = MethodSpec.methodBuilder((String)"getTemplate").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $S", new Object[]{resource}).build();
        return method;
    }
}

