/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.sql;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.openprovenance.prov.template.compiler.sql.AllowBreak;
import org.openprovenance.prov.template.compiler.sql.Block;
import org.openprovenance.prov.template.compiler.sql.Newline;
import org.openprovenance.prov.template.compiler.sql.Overrun;
import org.openprovenance.prov.template.compiler.sql.StringItem;
import org.openprovenance.prov.template.compiler.sql.StringItem0;

public class PrettyPrinter {
    private final ByteArrayOutputStream o;
    String HEADER = "\u001b[95m";
    String OKBLUE = "\u001b[94m";
    String OKCYAN = "\u001b[96m";
    String OKGREEN = "\u001b[92m";
    String WARNING = "\u001b[93m";
    String FAIL = "\u001b[91m";
    String ENDC = "\u001b[0m";
    String BOLD = "\u001b[1m";
    String UNDERLINE = "\u001b[4m";
    String YELLOW_BRIGHT = "\u001b[0;93m";
    public static String colorEnd = "\u001b[0m";
    String ORANGE24 = PrettyPrinter.color(255, 127, 0);
    public static String GREEN_256 = PrettyPrinter.color256(2);
    public static String RED256 = PrettyPrinter.color256(9);
    public static String ORANGE256 = PrettyPrinter.color256(202);
    public static String GREEN3_256 = PrettyPrinter.color256(34);
    public static String PURPLE256 = PrettyPrinter.color256(129);
    public static String END256 = "\u001b[0m";
    Block input;
    Block current;
    DataOutputStream output;
    int width;

    public PrettyPrinter(ByteArrayOutputStream o, int width) {
        this.output = new DataOutputStream(o);
        this.width = width;
        this.current = this.input = new Block(null, 0);
        this.o = o;
    }

    public ByteArrayOutputStream getOutputStream() {
        return this.o;
    }

    public void writeBlue(String s) {
        this.write0(this.OKBLUE);
        this.write(s);
        this.write0(this.ENDC);
    }

    public void writeOrange(String s) {
        this.write0(ORANGE256);
        this.write(s);
        this.write0(END256);
    }

    public void writeGreen(String s) {
        this.write0(GREEN3_256);
        this.write(s);
        this.write0(END256);
    }

    public void writeRed(String s) {
        this.write0(RED256);
        this.write(s);
        this.write0(END256);
    }

    public void writePurple(String s) {
        this.write0(PURPLE256);
        this.write(s);
        this.write0(END256);
    }

    public void write(String s) {
        this.current.add(new StringItem(s));
    }

    public void write0(String s) {
        this.current.add(new StringItem0(s));
    }

    public void begin(int n) {
        Block b = new Block(this.current, n);
        this.current.add(b);
        this.current = b;
    }

    public void end() {
        this.current = this.current.parent;
        if (this.current == null) {
            throw new RuntimeException();
        }
    }

    public void allowBreak(int n) {
        this.current.add(new AllowBreak(n));
    }

    public void newline(int n) {
        this.current.add(new Newline(n));
    }

    public static String color(int r, int g, int b) {
        return "\u001b[38;2;" + r + ";" + g + ";" + b + "m";
    }

    public static String color256(int v) {
        return "\u001b[38;5;" + v + "m";
    }

    public void flush() {
        try {
            this.input.format(0, 0, this.width, true);
        }
        catch (Overrun overrun) {
            // empty catch block
        }
        try {
            this.input.sendOutput(this.output, 0, 0);
            this.output.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.current = this.input = new Block(null, 0);
    }

    public void comma() {
        this.write(", ");
        this.allowBreak(0);
    }

    public void open() {
        this.write("(");
        this.begin(0);
    }

    public void close() {
        this.end();
        this.write(")");
    }
}

