/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.CompositeTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;

public class CompilerQueryInvoker {
    private final CompilerUtil compilerUtil = new CompilerUtil();

    public SpecificationFile generateQueryInvoker(TemplatesCompilerConfig configs, Locations locations, boolean withBean, String fileName) {
        String strVariable;
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit(withBean ? "QueryInvoker" : "QueryInvoker2");
        if (withBean) {
            builder.addSuperinterface((TypeName)ClassName.get((String)locations.getFilePackage(configs.beanProcessor), (String)configs.beanProcessor, (String[])new String[0]));
        } else {
            builder.addSuperinterface((TypeName)ClassName.get((String)locations.getFilePackage("InputProcessor"), (String)"InputProcessor", (String[])new String[0]));
        }
        String sbVar = "sb";
        builder.addField(StringBuilder.class, sbVar, new Modifier[]{Modifier.FINAL});
        MethodSpec.Builder cbuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(StringBuilder.class, sbVar, new Modifier[0]).addStatement("this.$N = $N", new Object[]{sbVar, sbVar});
        builder.addMethod(cbuilder.build());
        HashSet<String> foundSpecialTypes = new HashSet<String>();
        for (TemplateCompilerConfig config : configs.templates) {
            String beanNameClass = this.compilerUtil.commonNameClass(config.name);
            String inputsNameClass = this.compilerUtil.inputsNameClass(config.name);
            locations.updateWithConfig(config);
            ClassName className = ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)beanNameClass, (String[])new String[0]);
            ClassName inputClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.INPUTS), (String)inputsNameClass, (String[])new String[0]);
            MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            this.compilerUtil.specWithComment(mspec);
            mspec.addParameter(ParameterSpec.builder((TypeName)(withBean ? className : inputClassName), (String)"bean", (Modifier[])new Modifier[0]).build()).returns((TypeName)(withBean ? className : inputClassName));
            if (config instanceof SimpleTemplateCompilerConfig) {
                this.simpleQueryInvoker(configs, config, foundSpecialTypes, sbVar, mspec, "bean");
                mspec.addStatement("return $N", new Object[]{"bean"});
            } else {
                this.compositeQueryInvoker(configs, locations, config, foundSpecialTypes, sbVar, mspec, "bean", withBean);
                mspec.addStatement("return $N", new Object[]{"bean"});
            }
            builder.addMethod(mspec.build());
        }
        if (foundSpecialTypes.contains("timestamptz")) {
            String timeVariable = "time";
            MethodSpec.Builder mbuilder2 = MethodSpec.methodBuilder((String)"convertToTimestamptz");
            this.compilerUtil.specWithComment(mbuilder2);
            mbuilder2.addModifiers(new Modifier[]{Modifier.FINAL}).addParameter(String.class, "time", new Modifier[0]).returns(String.class).beginControlFlow("if ($N==null)", new Object[]{"time"}).addStatement("return $S", new Object[]{"NULL"}).nextControlFlow("else", new Object[0]).addStatement("return $S+$N+$S", new Object[]{"'", "time", "'::timestamptz"}).endControlFlow();
            builder.addMethod(mbuilder2.build());
        }
        if (foundSpecialTypes.contains("date")) {
            String dateVariable = "date";
            MethodSpec.Builder mbuilder2 = MethodSpec.methodBuilder((String)"convertToDate");
            this.compilerUtil.specWithComment(mbuilder2);
            mbuilder2.addModifiers(new Modifier[]{Modifier.FINAL}).addParameter(String.class, "date", new Modifier[0]).returns(String.class).beginControlFlow("if ($N==null)", new Object[]{"date"}).addStatement("return $S", new Object[]{"NULL"}).nextControlFlow("else", new Object[0]).addStatement("return $S+$N+$S", new Object[]{"'", "date", "'::date"}).endControlFlow();
            builder.addMethod(mbuilder2.build());
        }
        if (foundSpecialTypes.contains("nullableTEXT")) {
            strVariable = "str";
            MethodSpec.Builder mbuilder3 = MethodSpec.methodBuilder((String)"convertToNullableTEXT");
            this.compilerUtil.specWithComment(mbuilder3);
            mbuilder3.addModifiers(new Modifier[]{Modifier.FINAL}).addParameter(String.class, "str", new Modifier[0]).returns(String.class).beginControlFlow("if ($N==null)", new Object[]{"str"}).addStatement("return $S", new Object[]{"''::TEXT"}).nextControlFlow("else", new Object[0]).addStatement("return $S+$N.replace($S,$S)+$S", new Object[]{"'", "str", "'", "''", "'::TEXT"}).endControlFlow();
            builder.addMethod(mbuilder3.build());
        }
        if (foundSpecialTypes.contains("json")) {
            strVariable = "str";
            MethodSpec.Builder mbuilder3 = MethodSpec.methodBuilder((String)"convertToJsonTEXT");
            this.compilerUtil.specWithComment(mbuilder3);
            mbuilder3.addModifiers(new Modifier[]{Modifier.FINAL}).addParameter(String.class, "str", new Modifier[0]).returns(String.class).beginControlFlow("if ($N==null)", new Object[]{"str"}).addStatement("return $S", new Object[]{"''::json"}).nextControlFlow("else", new Object[0]).addStatement("return $S+$N.replace($S,$S)+$S", new Object[]{"'", "str", "'", "''", "'::json"}).endControlFlow();
            builder.addMethod(mbuilder3.build());
        }
        TypeSpec theLogger = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(myPackage), fileName + ".java", myPackage);
    }

    private void simpleQueryInvoker(TemplatesCompilerConfig configs, TemplateCompilerConfig config, Set<String> foundSpecialTypes, String sbVar, MethodSpec.Builder mspec, String variableBean) {
        TemplateBindingsSchema bindingsSchema = this.compilerUtil.getBindingsSchema((SimpleTemplateCompilerConfig)config);
        String startCallString = "insert_" + config.name + " (";
        this.compilerUtil.specWithComment(mspec);
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "select * from "});
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, startCallString});
        boolean first = true;
        for (String key : ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema)) {
            if (!ConfigProcessor.descriptorUtils.isInput(key, bindingsSchema)) continue;
            Class<?> cl = this.compilerUtil.getJavaTypeForDeclaredType(bindingsSchema.getVar(), key);
            if (first) {
                first = false;
            } else {
                mspec.addStatement("$N.append($S)", new Object[]{sbVar, ","});
            }
            String sqlType = ConfigProcessor.descriptorUtils.getSqlType(key, bindingsSchema);
            if (sqlType != null) {
                String fun = this.converterForSpecialType(sqlType);
                if (fun != null) {
                    mspec.addStatement("$N.append($N($N.$N))", new Object[]{sbVar, fun, variableBean, key});
                    foundSpecialTypes.add(sqlType);
                    continue;
                }
                mspec.addStatement("$N.append($N.$N)", new Object[]{sbVar, variableBean, key});
                continue;
            }
            mspec.addStatement("$N.append($N.$N)", new Object[]{sbVar, variableBean, key});
        }
        String endCallString = ");";
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, endCallString});
    }

    private void simpleQueryInvokerEmbedded(TemplatesCompilerConfig configs, TemplateCompilerConfig config, Set<String> foundSpecialTypes, String sbVar, MethodSpec.Builder mspec, String variableBean, List<String> sharing) {
        TemplateBindingsSchema bindingsSchema = this.compilerUtil.getBindingsSchema((SimpleTemplateCompilerConfig)config);
        String startCallString = "insert_" + config.name + " (";
        this.compilerUtil.specWithComment(mspec);
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "( "});
        boolean first = true;
        for (String key : ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema)) {
            boolean doProcess = true;
            if (!doProcess) continue;
            Class<?> cl = this.compilerUtil.getJavaTypeForDeclaredType(bindingsSchema.getVar(), key);
            if (first) {
                first = false;
            } else {
                mspec.addStatement("$N.append($S)", new Object[]{sbVar, ","});
            }
            if (ConfigProcessor.descriptorUtils.isInput(key, bindingsSchema) || sharing != null && sharing.contains(key)) {
                String sqlType;
                String comment = "";
                if (sharing != null && sharing.contains(key)) {
                    comment = "/* sharing */";
                }
                if ((sqlType = ConfigProcessor.descriptorUtils.getSqlType(key, bindingsSchema)) != null) {
                    String fun = this.converterForSpecialType(sqlType);
                    if (fun != null) {
                        mspec.addStatement("$N.append($N($N.$N)) $L", new Object[]{sbVar, fun, variableBean, key, comment});
                        foundSpecialTypes.add(sqlType);
                        continue;
                    }
                    mspec.addStatement("$N.append($N.$N) $L", new Object[]{sbVar, variableBean, key, comment});
                    continue;
                }
                mspec.addStatement("$N.append($N.$N) $L", new Object[]{sbVar, variableBean, key, comment});
                continue;
            }
            mspec.addStatement("$N.append($S) /* output */", new Object[]{sbVar, "null"});
        }
        String endCallString = ") :: " + config.name + "_type";
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, endCallString});
    }

    public void compositeQueryInvoker(TemplatesCompilerConfig configs, Locations locations, TemplateCompilerConfig config, Set<String> foundSpecialTypes, String sbVar, MethodSpec.Builder mspec, String variableBean, boolean withBean) {
        CompositeTemplateCompilerConfig compositeConfig = (CompositeTemplateCompilerConfig)config;
        this.compilerUtil.specWithComment(mspec);
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "---- query invoker for  " + compositeConfig.name + "\n\n"});
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "select * from "});
        String startCallString = "insert_" + config.name + "_array (";
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, startCallString});
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "ARRAY[\n"});
        String variableBean1 = variableBean + "_1";
        mspec.addStatement("boolean first=true", new Object[0]);
        SimpleTemplateCompilerConfig composee = null;
        for (TemplateCompilerConfig c : configs.templates) {
            if (!compositeConfig.consistsOf.equals(c.name)) continue;
            composee = (SimpleTemplateCompilerConfig)c;
        }
        mspec.beginControlFlow("for ($T $N: $N.$N)", new Object[]{withBean ? ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)this.compilerUtil.commonNameClass(compositeConfig.consistsOf), (String[])new String[0]) : ClassName.get((String)locations.getFilePackage(BeanDirection.INPUTS), (String)this.compilerUtil.beanNameClass(compositeConfig.consistsOf, BeanDirection.INPUTS, "_1"), (String[])new String[0]), variableBean1, variableBean, "__elements"});
        mspec.beginControlFlow("if (first)", new Object[0]).addStatement("first=false", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("$N.append($S)", new Object[]{sbVar, ",\n     "}).endControlFlow();
        if (composee == null) {
            throw new IllegalStateException("No composee found " + compositeConfig.consistsOf);
        }
        this.simpleQueryInvokerEmbedded(configs, composee, foundSpecialTypes, sbVar, mspec, variableBean1, compositeConfig.sharing);
        mspec.endControlFlow();
        mspec.addStatement("$N.append($S)", new Object[]{sbVar, "]);\n"});
    }

    public String converterForSpecialType(String specialType) {
        switch (specialType) {
            case "date": {
                return "convertToDate";
            }
            case "timestamptz": {
                return "convertToTimestamptz";
            }
            case "nullableTEXT": {
                return "convertToNullableTEXT";
            }
            case "json": {
                return "convertToJsonTEXT";
            }
        }
        return null;
    }
}

