/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.integration;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.tuple.Triple;
import org.openprovenance.prov.template.compiler.CompilerBeanGenerator;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.common.BeanKind;
import org.openprovenance.prov.template.compiler.common.CompilerCommon;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;

public class CompilerIntegrator {
    private final CompilerCommon compilerCommon;
    private final CompilerUtil compilerUtil = new CompilerUtil();
    private final boolean debugComment = true;
    private final CompilerBeanGenerator compilerBeanGenerator;

    public CompilerIntegrator(CompilerCommon compilerCommon, CompilerBeanGenerator compilerBeanGenerator) {
        this.compilerCommon = compilerCommon;
        this.compilerBeanGenerator = compilerBeanGenerator;
    }

    public SpecificationFile generateIntegrator(Locations locations, String templateName, String integrator_package, TemplateBindingsSchema bindingsSchema, String logger, BeanKind beanKind, String consistsOf, String directory, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit(this.compilerUtil.integratorBuilderNameClass(templateName));
        if (beanKind == BeanKind.SIMPLE) {
            builder.addMethod(this.compilerCommon.generateProcessorConverter(templateName, integrator_package, bindingsSchema, BeanDirection.OUTPUTS));
            builder.addMethod(this.compilerCommon.generateFactoryMethodToBeanWithArray("toInputs", templateName, integrator_package, bindingsSchema, BeanDirection.INPUTS, null, null));
            builder.addField(this.compilerCommon.generateField4aBeanConverter2("toInputs", templateName, integrator_package, "aRecord2InputsConverter", BeanDirection.INPUTS));
        } else {
            builder.addField(this.compilerCommon.generateField4aBeanConverter3("toInputs", templateName, integrator_package, "aRecord2InputsConverter", BeanDirection.INPUTS));
            Map<String, Triple<String, List<String>, TemplateBindingsSchema>> variants = this.compilerBeanGenerator.variantTable.get(consistsOf);
            if (variants != null) {
                variants.keySet().forEach(variant -> {
                    Triple triple = (Triple)variants.get(variant);
                    String extension = (String)triple.getLeft();
                    TemplateBindingsSchema tbs = (TemplateBindingsSchema)triple.getRight();
                    List shared = (List)triple.getMiddle();
                    builder.addMethod(this.compilerCommon.generateFactoryMethodToBeanWithArray("toInputs" + extension, consistsOf, integrator_package, tbs, BeanDirection.INPUTS, extension, shared));
                    builder.addMethod(this.compilerCommon.generateFactoryMethodToBeanWithArrayComposite("toInputs", templateName, integrator_package, bindingsSchema, locations.getFilePackage(logger), logger, BeanDirection.INPUTS, extension, shared));
                });
            } else {
                builder.addMethod(this.compilerCommon.generateFactoryMethodToBeanWithArrayComposite("toInputs", templateName, integrator_package, bindingsSchema, locations.getFilePackage(logger), logger, BeanDirection.INPUTS, null, null));
            }
        }
        builder.addMethod(this.compilerCommon.generateNameAccessor(templateName));
        builder.addMethod(this.generateNewOutputConstructor(templateName, integrator_package, bindingsSchema, BeanDirection.OUTPUTS));
        TypeSpec spec = builder.build();
        JavaFile myfile = this.compilerUtil.specWithComment(spec, templateName, integrator_package, stackTraceElement);
        return new SpecificationFile(myfile, directory, fileName, integrator_package);
    }

    public MethodSpec generateNewOutputConstructor(String templateName, String packge, TemplateBindingsSchema bindingsSchema, BeanDirection outputs) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"newOutput").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)packge, (String)this.compilerUtil.outputsNameClass(templateName), (String[])new String[0]));
        builder.addComment("Generated by method $N", new Object[]{this.getClass().getName() + ".generateNewOutputConstructor()"});
        builder.addStatement("return new $N()", new Object[]{this.compilerUtil.outputsNameClass(templateName)});
        return builder.build();
    }
}

