/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.sql;

import java.io.DataOutputStream;
import java.io.IOException;
import org.openprovenance.prov.template.compiler.sql.Item;
import org.openprovenance.prov.template.compiler.sql.Overrun;

class Block
extends Item {
    Block parent;
    Item first;
    Item last;
    int indent;

    Block(Block parent, int indent) {
        this.parent = parent;
        this.last = null;
        this.first = null;
        this.indent = indent;
    }

    void add(Item it) {
        if (this.first == null) {
            this.first = it;
        } else {
            this.last.next = it;
        }
        this.last = it;
    }

    @Override
    int format1(int lmargin, int pos, int rmargin, boolean canBreak) throws Overrun {
        if (this.first == null) {
            return pos;
        }
        try {
            return this.first.format(pos + this.indent, pos, rmargin, false);
        }
        catch (Overrun overrun) {
            if (!canBreak) {
                throw overrun;
            }
            return this.first.format(pos + this.indent, pos, rmargin, true);
        }
    }

    @Override
    int sendOutput(DataOutputStream o, int lmargin, int pos) throws IOException {
        Item it = this.first;
        lmargin = pos + this.indent;
        while (it != null) {
            pos = it.sendOutput(o, lmargin, pos);
            it = it.next;
        }
        return pos;
    }
}

