/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.template.compiler.CompilerConfigurations;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;

public class CompilerLogger {
    private final CompilerUtil compilerUtil = new CompilerUtil();
    static final ParameterizedTypeName mapType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), TypeVariableName.get((String)"T")});
    static final ParameterizedTypeName mapType2 = ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{TypeName.get(String.class), TypeVariableName.get((String)"T")});

    SpecificationFile generateLogger(TemplatesCompilerConfig configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit(configs.logger);
        builder.addSuperinterface((TypeName)ClassName.get((String)"org.openprovenance.prov.client", (String)"LoggerInterface", (String[])new String[0]));
        for (TemplateCompilerConfig config : configs.templates) {
            String templateNameClass = this.compilerUtil.templateNameClass(config.name);
            locations.updateWithConfig(config);
            ClassName className = ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)templateNameClass, (String[])new String[0]);
            FieldSpec fspec = FieldSpec.builder((TypeName)className, (String)("___" + config.name), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("new $T()", new Object[]{className}).build();
            builder.addField(fspec);
        }
        Object names = "";
        boolean first = true;
        for (TemplateCompilerConfig templateCompilerConfig : configs.templates) {
            if (first) {
                first = false;
            } else {
                names = (String)names + ", ";
            }
            names = (String)names + "___" + templateCompilerConfig.name;
        }
        ClassName cln = ClassName.get((String)"org.openprovenance.prov.client", (String)"Builder", (String[])new String[0]);
        ArrayTypeName builderArrayType = ArrayTypeName.of((TypeName)cln);
        FieldSpec fspec = FieldSpec.builder((TypeName)builderArrayType, (String)"__builders", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("new $T[] {" + (String)names + "}", new Object[]{cln}).build();
        builder.addField(fspec);
        builder.addMethod(this.generateGetBuilderMethod(builderArrayType));
        for (TemplateCompilerConfig config : configs.templates) {
            locations.updateWithConfig(config);
            if (!(config instanceof SimpleTemplateCompilerConfig)) continue;
            builder.addMethod(this.generateStaticLogMethod((SimpleTemplateCompilerConfig)config, locations));
            builder.addMethod(this.generateStaticBeanMethod((SimpleTemplateCompilerConfig)config, locations));
        }
        builder.addMethod(this.generateInitializeBeanTableMethod(configs, locations));
        builder.addMethod(this.generateInitializeCompositeBeanTableMethod(configs, locations));
        builder.addField(FieldSpec.builder((TypeName)CompilerUtil.builderMapType, (String)"simpleBuilders", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).initializer("$N(new $T())", new Object[]{"initializeBeanTable", ClassName.get((String)configs.configurator_package, (String)"BuilderConfigurator", (String[])new String[0])}).build());
        builder.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), CompilerConfigurations.processorOfUnknown}), (String)"simpleBeanConverters", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).initializer("$N(new $T())", new Object[]{"initializeBeanTable", ClassName.get((String)configs.configurator_package, (String)"ConverterConfigurator", (String[])new String[0])}).build());
        TypeSpec typeSpec = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(typeSpec, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(myPackage), fileName + ".java", myPackage);
    }

    private MethodSpec generateInitializeBeanTableMethod(TemplatesCompilerConfig configs, Locations locations) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"initializeBeanTable").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariable(ConfigProcessor.typeT).returns((TypeName)mapType);
        this.compilerUtil.specWithComment(builder);
        builder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage(configs.tableConfigurator), (String)configs.tableConfigurator, (String[])new String[0]), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}), "configurator", new Modifier[0]);
        builder.addStatement("$T aTable=new $T()", new Object[]{mapType, mapType2});
        for (TemplateCompilerConfig config : configs.templates) {
            String thisBuilderName = "___" + config.name;
            builder.addStatement("aTable.put($N.getName(),configurator.$N($N))", new Object[]{thisBuilderName, config.name, thisBuilderName});
        }
        builder.addStatement("return aTable", new Object[0]);
        return builder.build();
    }

    private MethodSpec generateInitializeCompositeBeanTableMethod(TemplatesCompilerConfig configs, Locations locations) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"initializeCompositeBeanTable").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariable(ConfigProcessor.typeT).returns((TypeName)mapType);
        this.compilerUtil.specWithComment(builder);
        String compositeTableConfigurator = "Composite" + configs.tableConfigurator;
        builder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage(compositeTableConfigurator), (String)compositeTableConfigurator, (String[])new String[0]), (TypeName[])new TypeName[]{ConfigProcessor.typeT}), "configurator", new Modifier[0]);
        builder.addStatement("$T aTable=new $T()", new Object[]{mapType, mapType2});
        for (TemplateCompilerConfig config : configs.templates) {
            if (config instanceof SimpleTemplateCompilerConfig) continue;
            String thisBuilderName = "___" + config.name;
            builder.addStatement("aTable.put($N.getName(),configurator.$N($N))", new Object[]{thisBuilderName, config.name, thisBuilderName});
        }
        builder.addStatement("return aTable", new Object[0]);
        return builder.build();
    }

    SpecificationFile generateBuilderInterface(TemplatesCompilerConfig configs, String directory, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateInterfaceInit("Builder");
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"getNodes").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(int[].class);
        builder.addMethod(builder2.build());
        MethodSpec.Builder builder3 = MethodSpec.methodBuilder((String)"getSuccessors").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)CompilerUtil.mapIntArrayType);
        builder.addMethod(builder3.build());
        MethodSpec.Builder builder3b = MethodSpec.methodBuilder((String)"getTypedSuccessors").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)CompilerUtil.mapIntArrayType);
        builder.addMethod(builder3b.build());
        MethodSpec.Builder builder4 = MethodSpec.methodBuilder((String)"getName").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(String.class);
        builder.addMethod(builder4.build());
        ParameterizedTypeName myType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get(String.class)});
        MethodSpec.Builder builder5 = MethodSpec.methodBuilder((String)"record2csv").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ArrayTypeName.of(Object.class), (String)"record", (Modifier[])new Modifier[0]).build()).returns((TypeName)myType);
        builder.addMethod(builder5.build());
        MethodSpec.Builder builder6 = MethodSpec.methodBuilder((String)"getPropertyOrder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(String[].class);
        builder.addMethod(builder6.build());
        TypeSpec theInterface = builder.build();
        JavaFile myfile = this.compilerUtil.specWithComment(theInterface, configs, "org.openprovenance.prov.client", stackTraceElement);
        return new SpecificationFile(myfile, directory, fileName, "org.openprovenance.prov.client");
    }

    SpecificationFile generateLoggerInterface(TemplatesCompilerConfig configs, String directory, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateInterfaceInit("LoggerInterface");
        ClassName cln = ClassName.get((String)"org.openprovenance.prov.client", (String)"Builder", (String[])new String[0]);
        ArrayTypeName builderArrayType = ArrayTypeName.of((TypeName)cln);
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"getBuilders").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)builderArrayType);
        builder.addMethod(builder2.build());
        TypeSpec theInterface = builder.build();
        JavaFile myfile = this.compilerUtil.specWithComment(theInterface, configs, "org.openprovenance.prov.client", stackTraceElement);
        return new SpecificationFile(myfile, directory, fileName, "org.openprovenance.prov.client");
    }

    public MethodSpec generateStaticLogMethod(SimpleTemplateCompilerConfig config, Locations locations) {
        String loggerName = this.compilerUtil.loggerName(config.name);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)loggerName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.STATIC}).returns(String.class);
        this.compilerUtil.specWithComment(builder);
        JsonNode bindings_schema = this.compilerUtil.get_bindings_schema(config);
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        JsonNode the_documentation = bindings_schema.get("@documentation");
        JsonNode the_return = bindings_schema.get("@return");
        this.compilerUtil.generateSpecializedParameters(builder, the_var);
        this.compilerUtil.generateSpecializedParametersJavadoc(builder, the_var, the_documentation, the_return);
        int count = 1;
        Iterator iter = the_var.fieldNames();
        Object args = "";
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (count > 1) {
                args = (String)args + ", ";
            }
            args = (String)args + key;
            ++count;
        }
        builder.addStatement("return $N.$N().process(" + (String)args + ")", new Object[]{"___" + config.name, "args2csv"});
        return builder.build();
    }

    public MethodSpec generateStaticBeanMethod(SimpleTemplateCompilerConfig config, Locations locations) {
        String beanCreatorName = "bean" + this.compilerUtil.capitalize(config.name);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)beanCreatorName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.STATIC}).returns((TypeName)ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)this.compilerUtil.commonNameClass(config.name), (String[])new String[0]));
        JsonNode bindings_schema = this.compilerUtil.get_bindings_schema(config);
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        JsonNode the_documentation = bindings_schema.get("@documentation");
        JsonNode the_return = bindings_schema.get("@return");
        this.compilerUtil.generateSpecializedParameters(builder, the_var);
        this.compilerUtil.generateSpecializedParametersJavadoc(builder, the_var, the_documentation, the_return);
        int count = 1;
        Iterator iter = the_var.fieldNames();
        Object args = "";
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (count > 1) {
                args = (String)args + ", ";
            }
            args = (String)args + key;
            ++count;
        }
        builder.addStatement("return $N.$N.process(" + (String)args + ")", new Object[]{"___" + config.name, "aArgs2BeanConverter"});
        return builder.build();
    }

    public MethodSpec generateGetBuilderMethod(ArrayTypeName builderArrayType) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getBuilders").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)builderArrayType);
        this.compilerUtil.specWithComment(builder);
        builder.addStatement("return __builders", new Object[0]);
        return builder.build();
    }

    public SpecificationFile generateProcessorArgsInterface(TemplatesCompilerConfig configs, String directory, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateInterfaceInitParameter("ProcessorArgsInterface", CompilerUtil.typeT);
        Object[] args = new Object[]{};
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ArrayTypeName.get(args.getClass()), (String)"args", (Modifier[])new Modifier[0]).build()).returns((TypeName)ConfigProcessor.typeT);
        builder.addMethod(builder2.build());
        TypeSpec theInterface = builder.build();
        JavaFile myfile = this.compilerUtil.specWithComment(theInterface, configs, "org.openprovenance.prov.client", stackTraceElement);
        return new SpecificationFile(myfile, directory, fileName, "org.openprovenance.prov.client");
    }

    public SpecificationFile generateRecordsProcessorInterface(TemplatesCompilerConfig configs, String directory, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateInterfaceInitParameter("RecordsProcessorInterface", CompilerUtil.typeT);
        Object[] args = new Object[]{};
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ArrayTypeName.get(args.getClass())}), (String)"args", (Modifier[])new Modifier[0]).build()).returns((TypeName)ConfigProcessor.typeT);
        builder.addMethod(builder2.build());
        TypeSpec theInterface = builder.build();
        JavaFile myfile = this.compilerUtil.specWithComment(theInterface, configs, "org.openprovenance.prov.client", stackTraceElement);
        return new SpecificationFile(myfile, directory, fileName, "org.openprovenance.prov.client");
    }
}

