/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;

public class CompilerScript {
    private final ConfigProcessor configProcessor;

    public CompilerScript(ConfigProcessor configProcessor) {
        this.configProcessor = configProcessor;
    }

    public void generateScript(TemplatesCompilerConfig configs) {
        new File(configs.script_dir).mkdirs();
        try {
            String path = configs.script_dir + "/" + configs.script;
            PrintStream os = new PrintStream(path);
            InputStream in = this.configProcessor.getClass().getResourceAsStream("/script.sh");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            while (line != null) {
                line = line.replace("${COMMENTS}", "generated by " + CompilerScript.class + ".generateScript");
                line = line.replace("${SCRIPT}", configs.script);
                line = line.replace("${VERSION}", configs.version);
                line = line.replace("${NAME}", configs.name);
                line = line.replace("${GROUP}", configs.group.replace(".", "/"));
                line = line.replace("${INIT}", configs.init_package + ".Init");
                os.println(line);
                line = reader.readLine();
            }
            os.close();
            in.close();
            Files.setPosixFilePermissions(new File(path).toPath(), PosixFilePermissions.fromString("rwxr-xr-x"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

