/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openprovenance.prov.model.exception.InvalidCaseException;
import org.openprovenance.prov.template.types.Descriptor;
import org.openprovenance.prov.template.types.DescriptorTree;

@JsonPropertyOrder(value={"@type", "number", "value"})
public class DescriptorAtom
implements Descriptor {
    Integer number;
    List<String> value;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    Map<String, Collection<String>> idata;

    public DescriptorAtom(Integer number, List<String> value, Map<String, Collection<String>> idata) {
        this.number = number;
        this.value = value;
        if (idata != null && !idata.isEmpty()) {
            this.idata = new HashMap<String, Collection<String>>(idata);
        }
    }

    @Override
    public String toText(Function<String, String> relationTranslator) {
        return this.value.stream().collect(Collectors.joining(","));
    }

    @Override
    @JsonProperty(value="@type")
    public String getCategory() {
        return "atom";
    }

    public Integer getNumber() {
        return this.number;
    }

    public List<String> getValue() {
        return this.value;
    }

    public Map<String, Collection<String>> getIdata() {
        return this.idata;
    }

    @Override
    public int compareTo(Descriptor o) {
        if (o instanceof DescriptorTree) {
            return -1;
        }
        if (o instanceof DescriptorAtom) {
            DescriptorAtom that = (DescriptorAtom)o;
            int relCompare = this.value.toString().compareTo(that.value.toString());
            if (relCompare != 0) {
                return relCompare;
            }
            if (this.idata == null) {
                if (that.idata == null) {
                    return 0;
                }
                return -1;
            }
            if (that.idata == null) {
                return 1;
            }
            LinkedList<String> allIdataKeys = new LinkedList<String>();
            allIdataKeys.addAll(this.idata.keySet());
            allIdataKeys.addAll(that.idata.keySet());
            allIdataKeys.sort(String::compareTo);
            AtomicInteger theComparison = new AtomicInteger();
            for (String k : allIdataKeys) {
                List thatL;
                Collection<String> thisData = this.idata.get(k);
                Collection<String> thatData = this.idata.get(k);
                if (thisData == null && thatData == null) break;
                if (thisData == null) {
                    theComparison.set(-1);
                    break;
                }
                if (thatData == null) {
                    theComparison.set(1);
                    break;
                }
                List thisL = thisData.stream().sorted(String::compareTo).collect(Collectors.toList());
                if (thisL.equals(thatL = thatData.stream().sorted(String::compareTo).collect(Collectors.toList()))) continue;
                theComparison.set(thisL.toString().compareTo(thatL.toString()));
                break;
            }
            return theComparison.get();
        }
        throw new InvalidCaseException(o.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescriptorAtom that = (DescriptorAtom)o;
        return Objects.equals(this.number, that.number) && Objects.equals(this.value, that.value) && Objects.equals(this.idata, that.idata);
    }

    public int hashCode() {
        return Objects.hash(this.number, this.value, this.idata);
    }
}

