/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.QuintetConsumer;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;

public class CompilerConfigurations {
    public static final String RECORD_2_RECORD = "Record2Record";
    public static final String PROCESS = "process";
    private final CompilerUtil compilerUtil = new CompilerUtil();
    static final ParameterizedTypeName processorOfString = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{TypeName.get(String.class)});
    static final ParameterizedTypeName processorOfUnknown = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"ProcessorArgsInterface", (String[])new String[0]), (TypeName[])new TypeName[]{TypeVariableName.get((String)"?")});
    static final TypeName stringArray = ArrayTypeName.get(String[].class);
    String enactorVar = "beanEnactor";

    public SpecificationFile generateConfigurator(TemplatesCompilerConfig configs, Locations locations, String theConfiguratorName, TypeName typeName, QuintetConsumer<String, MethodSpec.Builder, TypeName, TypeName, TypeName> generator, String generatorMethod, BeanDirection direction, TypeName beanProcessor, boolean defaultBehaviour, String beanPackage, BeanDirection outDirection, String directory, String fileName) {
        return this.generateConfigurator(configs, locations, theConfiguratorName, typeName, generator, generatorMethod, direction, beanProcessor, defaultBehaviour, beanPackage, outDirection, directory, fileName, null);
    }

    public SpecificationFile generateConfigurator(TemplatesCompilerConfig configs, Locations locations, String theConfiguratorName, TypeName typeName, QuintetConsumer<String, MethodSpec.Builder, TypeName, TypeName, TypeName> generator, String generatorMethod, BeanDirection direction, TypeName beanProcessor, boolean defaultBehaviour, String beanPackage, BeanDirection outDirection, String directory, String fileName, Consumer<TypeSpec.Builder> optionalCode) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        if (configs.configurator_package == null) {
            throw new NullPointerException("configurator_package is null");
        }
        ParameterizedTypeName tableConfiguratorType = ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage(configs.tableConfigurator), (String)configs.tableConfigurator, (String[])new String[0]), (TypeName[])new TypeName[]{typeName});
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit(theConfiguratorName);
        if (beanProcessor != null) {
            builder.addField(beanProcessor, this.enactorVar, new Modifier[]{Modifier.FINAL, Modifier.PRIVATE});
            MethodSpec.Builder cspec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)beanProcessor, (String)this.enactorVar, (Modifier[])new Modifier[0]).build());
            this.compilerUtil.specWithComment(cspec);
            cspec.addStatement("this.$N=$N", new Object[]{this.enactorVar, this.enactorVar});
            builder.addMethod(cspec.build());
        }
        builder.addSuperinterface((TypeName)tableConfiguratorType);
        for (TemplateCompilerConfig config : configs.templates) {
            String templateNameClass = this.compilerUtil.templateNameClass(config.name);
            String inBeanNameClass = this.compilerUtil.beanNameClass(config.name, direction);
            String outBeanNameClass = this.compilerUtil.beanNameClass(config.name, outDirection);
            locations.updateWithConfig(config);
            ClassName className = ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)templateNameClass, (String[])new String[0]);
            String builderParameter = "builder";
            MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)config.name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(ParameterSpec.builder((TypeName)className, (String)builderParameter, (Modifier[])new Modifier[0]).build()).returns(typeName);
            this.compilerUtil.specWithComment(mspec);
            if (config instanceof SimpleTemplateCompilerConfig || defaultBehaviour) {
                generator.accept(builderParameter, mspec, (TypeName)className, (TypeName)ClassName.get((String)(direction == BeanDirection.COMMON ? locations.getFilePackage(BeanDirection.COMMON) : beanPackage), (String)inBeanNameClass, (String[])new String[0]), (TypeName)ClassName.get((String)(direction == BeanDirection.COMMON ? locations.getFilePackage(BeanDirection.COMMON) : beanPackage), (String)outBeanNameClass, (String[])new String[0]));
            } else {
                mspec.addStatement("return null", new Object[0]);
            }
            builder.addMethod(mspec.build());
        }
        if (optionalCode != null) {
            optionalCode.accept(builder);
        }
        TypeSpec theConfigurator = builder.build();
        JavaFile myfile = this.compilerUtil.specWithComment(theConfigurator, configs, configs.configurator_package, stackTraceElement);
        return new SpecificationFile(myfile, directory, fileName, configs.configurator_package);
    }

    public SpecificationFile generateSqlConfigurator(TemplatesCompilerConfig configs, String theConfiguratorName, Locations locations, String directory, String fileName) {
        return this.generateConfigurator(configs, locations, theConfiguratorName, (TypeName)processorOfString, this::generateMethodRecord2SqlConverter, "generateSqlConfigurator", BeanDirection.COMMON, null, false, null, BeanDirection.COMMON, directory, fileName);
    }

    public SpecificationFile generatePropertyOrderConfigurator(TemplatesCompilerConfig configs, String theConfiguratorName, Locations locations, String directory, String fileName) {
        return this.generateConfigurator(configs, locations, theConfiguratorName, stringArray, this::generatePropertyOrder, "generatePropertyOrderConfigurator", BeanDirection.COMMON, null, true, null, BeanDirection.COMMON, directory, fileName);
    }

    public SpecificationFile generateCsvConfigurator(TemplatesCompilerConfig configs, String theConfiguratorName, Locations locations, String directory, String fileName) {
        return this.generateConfigurator(configs, locations, theConfiguratorName, (TypeName)processorOfString, this::generateMethodRecord2CsvConverter, "generateCsvConfigurator", BeanDirection.COMMON, null, false, null, BeanDirection.COMMON, directory, fileName);
    }

    public SpecificationFile generateSqlInsertConfigurator(TemplatesCompilerConfig configs, String theConfiguratorName, Locations locations, String directory, String fileName) {
        return this.generateConfigurator(configs, locations, theConfiguratorName, (TypeName)ClassName.get(String.class), this::generateSqlInsert, "generateSqlInsertConfigurator", BeanDirection.COMMON, null, false, null, BeanDirection.COMMON, directory, fileName);
    }

    public SpecificationFile generateConverterConfigurator(TemplatesCompilerConfig configs, String theConfiguratorName, Locations locations, String directory, String fileName) {
        return this.generateConfigurator(configs, locations, theConfiguratorName, (TypeName)processorOfUnknown, this::generateMethodRecordConverter, "generateConverterConfigurator", BeanDirection.COMMON, null, false, null, BeanDirection.COMMON, directory, fileName);
    }

    public SpecificationFile generateRecord2RecordConfiguration(TemplatesCompilerConfig configs, String theConfiguratorName, Locations locations, String directory, String fileName) {
        Consumer<TypeSpec.Builder> optionalCode = builder -> builder.addType(TypeSpec.interfaceBuilder((String)RECORD_2_RECORD).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addMethod(MethodSpec.methodBuilder((String)PROCESS).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(TypeName.get(Object[].class), "args", new Modifier[0]).returns(TypeName.get(Object[].class)).build()).build());
        ClassName record2recordType = ClassName.get((String)configs.configurator_package, (String)"CsvRecord2ObjectRecordConfigurator", (String[])new String[]{RECORD_2_RECORD});
        return this.generateConfigurator(configs, locations, theConfiguratorName, (TypeName)record2recordType, this::generateMethodRecord2RecordConverter, "generateConverterConfigurator", BeanDirection.COMMON, null, false, null, BeanDirection.COMMON, directory, fileName, optionalCode);
    }

    public SpecificationFile generateEnactorConfigurator(TemplatesCompilerConfig configs, String theConfiguratorName, Locations locations, String directory, String fileName) {
        return this.generateConfigurator(configs, locations, theConfiguratorName, (TypeName)processorOfUnknown, this::generateMethodEnactor, "generateEnactorConfigurator", BeanDirection.COMMON, (TypeName)ClassName.get((String)locations.getFilePackage(configs.beanProcessor), (String)configs.beanProcessor, (String[])new String[0]), false, null, BeanDirection.COMMON, directory, fileName);
    }

    public SpecificationFile generateEnactorConfigurator2(TemplatesCompilerConfig configs, String theConfiguratorName, String integrator_package, Locations locations, String directory, String fileName) {
        return this.generateConfigurator(configs, locations, theConfiguratorName, (TypeName)processorOfUnknown, this::generateMethodEnactor2, "generateEnactorConfigurator2", BeanDirection.INPUTS, (TypeName)ClassName.get((String)locations.getFilePackage("InputOutputProcessor"), (String)"InputOutputProcessor", (String[])new String[0]), false, integrator_package, BeanDirection.OUTPUTS, directory, fileName);
    }

    public void generateMethodRecord2SqlConverter(String builderParameter, MethodSpec.Builder mspec, TypeName className, TypeName beanType, TypeName _out) {
        mspec.addStatement("return $N.aRecord2SqlConverter", new Object[]{builderParameter});
    }

    public void generateMethodRecord2CsvConverter(String builderParameter, MethodSpec.Builder mspec, TypeName className, TypeName beanType, TypeName _out) {
        mspec.addStatement("return $N.processorConverter($N.aArgs2CsVConverter)", new Object[]{builderParameter, builderParameter});
    }

    public void generatePropertyOrder(String builderParameter, MethodSpec.Builder mspec, TypeName className, TypeName beanType, TypeName _out) {
        mspec.addStatement("return $N.getPropertyOrder()", new Object[]{builderParameter});
    }

    public void generateSqlInsert(String builderParameter, MethodSpec.Builder mspec, TypeName className, TypeName beanType, TypeName _out) {
        mspec.addStatement("return $N.getSQLInsert()", new Object[]{builderParameter});
    }

    public void generateMethodRecordConverter(String builderParameter, MethodSpec.Builder mspec, TypeName className, TypeName beanType, TypeName _out) {
        mspec.addStatement("return $N.aRecord2BeanConverter", new Object[]{builderParameter});
    }

    public void generateMethodRecord2RecordConverter(String builderParameter, MethodSpec.Builder mspec, TypeName className, TypeName beanType, TypeName _out) {
        mspec.addStatement("return x -> builder.aRecord2BeanConverter.process(x).process(builder.aArgs2RecordConverter())", new Object[0]);
    }

    public void generateMethodEnactor(String builderParameter, MethodSpec.Builder mspec, TypeName className, TypeName beanType, TypeName _out) {
        mspec.addStatement("$N<$T> beanConverter=$N.aRecord2BeanConverter", new Object[]{"ProcessorArgsInterface", beanType, builderParameter});
        mspec.addStatement("$N<$T> enactor=(array) -> {\n                    $T bean=beanConverter.process(array);\n                    return $N.process(bean);\n                }", new Object[]{"ProcessorArgsInterface", beanType, beanType, this.enactorVar});
        mspec.addStatement("return enactor", new Object[0]);
    }

    public void generateMethodEnactor2(String builderParameter, MethodSpec.Builder mspec, TypeName className, TypeName inputBeanType, TypeName outputBeanType) {
        mspec.addComment("Generated Automatically by ProvToolbox method $N.$N()", new Object[]{this.getClass().getName(), "generateMethodEnactor2"});
        mspec.addStatement("$N<$T> beanConverter=$N.getIntegrator().aRecord2InputsConverter", new Object[]{"ProcessorArgsInterface", inputBeanType, builderParameter});
        mspec.addStatement("$N<$T> enactor=(array) -> {\n                    $T bean=beanConverter.process(array);\n                    return $N.process(bean);\n                }", new Object[]{"ProcessorArgsInterface", outputBeanType, inputBeanType, this.enactorVar});
        mspec.addStatement("return enactor", new Object[0]);
    }

    public SpecificationFile generateBuilderConfigurator(TemplatesCompilerConfig configs, String theConfiguratorName, Locations locations, String directory, String fileName) {
        return this.generateConfigurator(configs, locations, theConfiguratorName, (TypeName)ClassName.get((String)"org.openprovenance.prov.client", (String)"Builder", (String[])new String[0]), this::generateReturnSelf, "generateBuilderConfigurator", BeanDirection.COMMON, null, false, null, BeanDirection.COMMON, directory, fileName);
    }

    public void generateReturnSelf(String builderParameter, MethodSpec.Builder mspec, TypeName className, TypeName beanType, TypeName _out) {
        mspec.addStatement("return $N", new Object[]{builderParameter});
    }
}

