/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.configuration;

import java.io.File;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;

public class Locations {
    private final String cli_src_dir;
    private final TemplatesCompilerConfig configs;
    private final String configurator_package;
    private final String logger_package;
    private final String configurator_package2;
    private String config_common_package;
    private String config_backend;
    private String config_integrator_package;
    private final String compositeTableConfigurator;
    static String INTEGRATOR = "integrator";
    static String CLIENT = "client";
    static String COMMON = "common";
    static final String CONFIG2_EXTENSION = "2";

    public void updateWithConfig(TemplateCompilerConfig config) {
        this.config_common_package = config.package_ + "." + CLIENT + "." + COMMON;
        this.config_integrator_package = config.package_ + "." + CLIENT + "." + INTEGRATOR;
        this.config_backend = config.package_;
    }

    public Locations(TemplatesCompilerConfig configs, String cli_src_dir) {
        this.configs = configs;
        this.cli_src_dir = cli_src_dir;
        this.compositeTableConfigurator = "Composite" + configs.tableConfigurator;
        this.configurator_package = configs.configurator_package;
        this.configurator_package2 = configs.configurator_package + CONFIG2_EXTENSION;
        this.logger_package = configs.logger_package;
    }

    public String convertToDirectory(String rootDir, String aPackage) {
        String theDirectory = rootDir + "/" + aPackage.replace('.', '/') + "/";
        new File(theDirectory).mkdirs();
        return theDirectory;
    }

    public String convertToDirectory(String aPackage) {
        return this.cli_src_dir + "/" + aPackage.replace('.', '/') + "/";
    }

    public String getFilePackage(String file) {
        if (file.equals(this.configs.logger)) {
            return this.logger_package;
        }
        if (file.equals(this.configs.tableConfigurator)) {
            return this.configurator_package;
        }
        if (file.equals(this.configs.tableConfigurator + "WithMap")) {
            return this.configurator_package;
        }
        if (file.equals(this.compositeTableConfigurator)) {
            return this.configurator_package;
        }
        if (file.equals(this.configs.beanProcessor)) {
            return this.config_common_package;
        }
        if (file.equals(this.configs.templateBuilders)) {
            return this.logger_package;
        }
        switch (file) {
            case "BeanEnactor2": 
            case "TemplateInvoker": 
            case "InputOutputProcessor": 
            case "QueryInvoker2": 
            case "InputProcessor": 
            case "CompositeBeanCompleter2": 
            case "TypeConverter": 
            case "BeanChecker2": 
            case "BeanCompleter2": {
                return this.config_integrator_package;
            }
            case "ConverterConfigurator": 
            case "BuilderConfigurator": 
            case "SqlInsertConfigurator": 
            case "PropertyOrderConfigurator": 
            case "SqlConfigurator": 
            case "CsvConfigurator": 
            case "EnactorConfigurator": 
            case "CompositeEnactorConfigurator": 
            case "CsvRecord2ObjectRecordConfigurator": {
                return this.configurator_package;
            }
            case "CompositeEnactorConfigurator2": 
            case "EnactorConfigurator2": {
                return this.configurator_package2;
            }
            case "Delegator": 
            case "BeanCompleter": 
            case "BeanChecker": 
            case "QueryInvoker": 
            case "BeanEnactor": {
                return this.config_common_package;
            }
            case "SQL": {
                return "org.openprovenance.prov.client";
            }
        }
        throw new UnsupportedOperationException("Unknown file " + file);
    }

    public String getFilePackage(BeanDirection dir) {
        switch (dir) {
            case INPUTS: {
                return this.config_integrator_package;
            }
            case OUTPUTS: {
                return this.config_integrator_package;
            }
            case COMMON: {
                return this.config_common_package;
            }
        }
        throw new IllegalStateException("never here");
    }

    public String getFileBackendPackage(String name) {
        return this.config_backend;
    }
}

