/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;

public class CompilerClientTest {
    final CompilerUtil compilerUtil;

    public CompilerClientTest(ProvFactory pFactory) {
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    public SpecificationFile generateTestFile_cli(TemplatesCompilerConfig configs, Locations locations, String directory, String fileName) {
        TypeSpec.Builder builder = this.compilerUtil.generateClassInitExtends("ExampleTest", "junit.framework", "TestCase");
        MethodSpec.Builder mbuilder = MethodSpec.methodBuilder((String)"testMain").addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(Exception.class).returns(Void.TYPE);
        int count = 0;
        String resvar = "res";
        for (TemplateCompilerConfig config : configs.templates) {
            locations.updateWithConfig(config);
            String bn = this.compilerUtil.templateNameClass(config.name);
            mbuilder.addStatement("System.setOut(new java.io.PrintStream(\"target/example_" + config.name + ".json\"))", new Object[0]);
            mbuilder.addStatement("Object $N=$T.examplar()", new Object[]{resvar + count, ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)bn, (String[])new String[0])});
            mbuilder.addStatement("new $T().writeValue(System.out,$N)", new Object[]{ObjectMapper.class, resvar + count});
            ++count;
        }
        MethodSpec method = mbuilder.build();
        builder.addMethod(method);
        TypeSpec theInitializer = builder.build();
        JavaFile myfile = JavaFile.builder((String)configs.init_package, (TypeSpec)theInitializer).addFileComment("Generated Automatically by ProvToolbox ($N) for templates config $N", new Object[]{this.getClass().getName(), configs.name}).build();
        return new SpecificationFile(myfile, directory, fileName, configs.init_package);
    }
}

