/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;

public class CompilerDelegator {
    private final CompilerUtil compilerUtil;

    public CompilerDelegator(ProvFactory pFactory) {
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    public SpecificationFile generateDelegator(TemplatesCompilerConfig configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("Delegator");
        ClassName beanProcessorClass = ClassName.get((String)locations.getFilePackage(configs.beanProcessor), (String)configs.beanProcessor, (String[])new String[0]);
        builder.addSuperinterface((TypeName)beanProcessorClass);
        builder.addField((TypeName)beanProcessorClass, "delegator", new Modifier[]{Modifier.FINAL, Modifier.PRIVATE});
        MethodSpec.Builder mspec2 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)beanProcessorClass, "delegator", new Modifier[0]);
        this.compilerUtil.specWithComment(mspec2);
        mspec2.addStatement("this.$N=$N", new Object[]{"delegator", "delegator"});
        builder.addMethod(mspec2.build());
        for (TemplateCompilerConfig config : configs.templates) {
            String beanNameClass = this.compilerUtil.commonNameClass(config.name);
            locations.updateWithConfig(config);
            ClassName className = ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)beanNameClass, (String[])new String[0]);
            MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)className, (String)"bean", (Modifier[])new Modifier[0]).build()).returns((TypeName)className);
            this.compilerUtil.specWithComment(mspec);
            mspec.addStatement("return $N.process($N)", new Object[]{"delegator", "bean"});
            builder.addMethod(mspec.build());
        }
        TypeSpec theLogger = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(myPackage), fileName + ".java", myPackage);
    }
}

