/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.descriptors.AttributeDescriptor;
import org.openprovenance.prov.template.descriptors.Descriptor;
import org.openprovenance.prov.template.descriptors.NameDescriptor;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;

public class CompilerProcessor {
    private final ProvFactory pFactory;
    private final CompilerUtil compilerUtil;
    private final boolean debugComment = true;

    public CompilerProcessor(ProvFactory pFactory) {
        this.pFactory = pFactory;
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    public TypeSpec.Builder generateProcessorClassInit(String name) {
        return TypeSpec.interfaceBuilder((String)name).addTypeVariable(CompilerUtil.typeT).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public SpecificationFile generateProcessor(Locations locations, String templateName, String packge, TemplateBindingsSchema bindingsSchema, boolean inIntegrator, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.generateProcessorClassInit(inIntegrator ? this.compilerUtil.integratorNameClass(templateName) : this.compilerUtil.processorNameClass(templateName));
        MethodSpec.Builder mbuilder = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).returns((TypeName)CompilerUtil.typeT);
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        CodeBlock.Builder jdoc = CodeBlock.builder();
        String docString = bindingsSchema.getDocumentation();
        String retString = "@return not specified";
        jdoc.add(docString == null ? "No @documentation" : docString, new Object[0]);
        jdoc.add("\n\n", new Object[0]);
        for (String key : ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema)) {
            if (inIntegrator && !ConfigProcessor.descriptorUtils.isInput(key, bindingsSchema)) continue;
            mbuilder.addParameter(this.compilerUtil.getJavaTypeForDeclaredType(theVar, key), key, new Modifier[0]);
            Descriptor descriptor = theVar.get(key).get(0);
            Function<NameDescriptor, Void> nf = nd -> {
                String documentation = nd.getDocumentation() == null ? "-- no @documentation" : nd.getDocumentation();
                String type = nd.getType() == null ? "xsd:string" : nd.getType();
                jdoc.add("@param $N: $L (expected type: $L)\n", new Object[]{key, documentation, type});
                return null;
            };
            Function<AttributeDescriptor, Void> af = nd -> {
                String documentation = nd.getDocumentation() == null ? "-- no @documentation" : nd.getDocumentation();
                String type = nd.getType() == null ? "xsd:string" : nd.getType();
                jdoc.add("@param $N: $L (expected type: $L)\n", new Object[]{key, documentation, type});
                return null;
            };
            ConfigProcessor.descriptorUtils.getFromDescriptor(descriptor, af, nf);
        }
        jdoc.add(retString, new Object[0]);
        mbuilder.addJavadoc(jdoc.build());
        builder.addMethod(mbuilder.build());
        TypeSpec bean = builder.build();
        JavaFile myfile = this.compilerUtil.specWithComment(bean, templateName, packge, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(packge), fileName, packge);
    }
}

