/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;
import org.openprovenance.prov.template.log2prov.FileBuilder;

public class CompilerTableConfiguratorWithMap {
    public static final String PREFIX = "_b_";
    private final CompilerUtil compilerUtil;

    public CompilerTableConfiguratorWithMap(ProvFactory pFactory) {
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    SpecificationFile generateTableConfigurator(TemplatesCompilerConfig configs, Locations locations, String l2p_src_dir) {
        return this.generateTableConfigurator(configs, false, locations, l2p_src_dir);
    }

    SpecificationFile generateCompositeTableConfigurator(TemplatesCompilerConfig configs, Locations locations, String l2p_src_dir) {
        return this.generateTableConfigurator(configs, true, locations, l2p_src_dir);
    }

    SpecificationFile generateTableConfigurator(TemplatesCompilerConfig configs, boolean compositeOnly, Locations locations, String l2p_src_dir) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        if (configs.tableConfigurator == null) {
            throw new NullPointerException("tableConfigurator is null");
        }
        Object originalTableClassName = compositeOnly ? "Composite" + configs.tableConfigurator : configs.tableConfigurator;
        String tableClassName = (String)originalTableClassName + "WithMap";
        String directory = locations.convertToDirectory(l2p_src_dir, "configurator");
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit(tableClassName);
        builder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage((String)originalTableClassName), (String)originalTableClassName, (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get(FileBuilder.class)}));
        builder.addField(CompilerUtil.mapString2StringType, "map", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addParameter(CompilerUtil.mapString2StringType, "map", new Modifier[0]).addParameter(ProvFactory.class, "pf", new Modifier[0]).addStatement("this.map=map", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC});
        ClassName fileBuilderClassName = ClassName.get(FileBuilder.class);
        for (TemplateCompilerConfig config : configs.templates) {
            String templateNameClass = this.compilerUtil.templateNameClass(config.name);
            locations.updateWithConfig(config);
            ClassName className = ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)templateNameClass, (String[])new String[0]);
            MethodSpec.Builder mspec_builder = MethodSpec.methodBuilder((String)config.name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)className, (String)"builder", (Modifier[])new Modifier[0]).build()).returns((TypeName)fileBuilderClassName);
            if (config instanceof SimpleTemplateCompilerConfig) {
                SimpleTemplateCompilerConfig simpleConfig = (SimpleTemplateCompilerConfig)config;
                ClassName builderClassName = ClassName.get((String)simpleConfig.package_, (String)templateNameClass, (String[])new String[0]);
                String builderVar = PREFIX + config.name;
                builder.addField((TypeName)builderClassName, builderVar, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                constructor.addStatement("$N=new $T(pf)", new Object[]{builderVar, builderClassName});
                mspec_builder.addStatement("if (map!=null) $N.setVariableMap(map)", new Object[]{builderVar});
                mspec_builder.addStatement("return $N", new Object[]{builderVar});
            } else {
                mspec_builder.addStatement("return null", new Object[0]);
            }
            MethodSpec mspec = mspec_builder.build();
            builder.addMethod(mspec);
        }
        builder.addMethod(constructor.build());
        TypeSpec theLogger = builder.build();
        String myPackage = configs.init_package + ".configurator";
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, directory, tableClassName + ".java", myPackage);
    }
}

