/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.expansion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.StringSubstitutor;
import org.openprovenance.prov.interop.Formats;
import org.openprovenance.prov.interop.Framework;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.exception.InvalidCaseException;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.common.CompilerCommon;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;
import org.openprovenance.prov.template.compiler.expansion.CompilerTypeManagement;
import org.openprovenance.prov.template.compiler.expansion.StatementCompilerAction;
import org.openprovenance.prov.template.descriptors.Descriptor;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;
import org.openprovenance.prov.template.expander.ExpandAction;
import org.openprovenance.prov.template.expander.ExpandUtil;
import org.openprovenance.prov.template.expander.exception.MissingAttributeValue;
import org.openprovenance.prov.template.types.TypesRecordProcessor;

public class CompilerExpansionBuilder {
    private final CompilerUtil compilerUtil;
    private final ProvFactory pFactory;
    private final boolean withMain;
    private final CompilerCommon compilerCommon;
    private final boolean debugComment;
    private final CompilerTypeManagement compilerTypeManagement;
    static final ArrayTypeName recordType = ArrayTypeName.of((TypeName)ClassName.get(Object.class));
    public static final ParameterizedTypeName levelNMapType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), TypeName.get(Integer.class)});
    static final ParameterizedTypeName levelNP1MapType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), TypeName.get(int[].class)});
    public static final ParameterizedTypeName levelNP1CMapType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), ParameterizedTypeName.get((ClassName)ClassName.get(Collection.class), (TypeName[])new TypeName[]{TypeName.get(int[].class)})});
    static final ParameterizedTypeName successorType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(Integer.class), TypeName.get(int[].class)});

    private TypeName processorInterfaceType(String template, String packge) {
        return ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)(this.compilerUtil.templateNameClass(template) + "Interface"), (String[])new String[0]), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
    }

    public CompilerExpansionBuilder(boolean withMain, CompilerCommon compilerCommon, ProvFactory pFactory, boolean debugComment, CompilerTypeManagement compilerTypeManagement) {
        this.pFactory = pFactory;
        this.withMain = withMain;
        this.compilerCommon = compilerCommon;
        this.debugComment = debugComment;
        this.compilerTypeManagement = compilerTypeManagement;
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    public SpecificationFile generateBuilderInterfaceSpecification(TemplatesCompilerConfig configs, Locations locations, Document doc, String name, String templateName, String packge, TemplateBindingsSchema bindingsSchema, String directory, String fileName) {
        Bundle bun = (Bundle)CompilerUtil.u.getBundle(doc).get(0);
        HashSet<QualifiedName> allVars = new HashSet<QualifiedName>();
        HashSet<QualifiedName> allAtts = new HashSet<QualifiedName>();
        this.compilerUtil.extractVariablesAndAttributes(bun, allVars, allAtts, this.pFactory);
        return this.generateBuilderInterfaceSpecification_aux(configs, locations, name, templateName, packge, bindingsSchema, directory, fileName);
    }

    SpecificationFile generateBuilderInterfaceSpecification_aux(TemplatesCompilerConfig configs, Locations locations, String name, String templateName, String packge, TemplateBindingsSchema bindingsSchema, String directory, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateInterfaceInitParameter(name + "Interface", "T");
        builder.addMethod(this.generateTemplateGeneratorInterface(bindingsSchema));
        TypeSpec theInterface = builder.build();
        JavaFile myfile = this.compilerUtil.specWithComment(theInterface, templateName, packge, stackTraceElement);
        return new SpecificationFile(myfile, directory, fileName, packge);
    }

    public SpecificationFile generateBuilderSpecification(TemplatesCompilerConfig configs, Locations locations, Document doc, String name, String templateName, String packge, JsonNode bindings_schema, TemplateBindingsSchema bindingsSchema, Map<Integer, List<Integer>> successorTable, String directory, String fileName) {
        Bundle bun = (Bundle)CompilerUtil.u.getBundle(doc).get(0);
        HashSet<QualifiedName> allVars = new HashSet<QualifiedName>();
        HashSet<QualifiedName> allAtts = new HashSet<QualifiedName>();
        this.compilerUtil.extractVariablesAndAttributes(bun, allVars, allAtts, this.pFactory);
        return this.generateBuilderSpecification_aux(configs, locations, doc, new ArrayList<QualifiedName>(allVars), new ArrayList<QualifiedName>(allAtts), name, templateName, packge, bindings_schema, bindingsSchema, successorTable, directory, fileName);
    }

    public MethodSpec generateTemplateGeneratorInterface(TemplateBindingsSchema bindingsSchema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"call").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).returns((TypeName)CompilerUtil.typeT);
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        this.compilerUtil.generateDocumentSpecializedParameters(builder, theVar, variables);
        return builder.build();
    }

    SpecificationFile generateBuilderSpecification_aux(TemplatesCompilerConfig configs, Locations locations, Document doc, Collection<QualifiedName> allVars, Collection<QualifiedName> allAtts, String name, String templateName, String packge, JsonNode bindings_schema, TemplateBindingsSchema bindingsSchema, Map<Integer, List<Integer>> successorTable, String directory, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassBuilder2(name);
        Hashtable<QualifiedName, String> vmap = this.generateQualifiedNames(doc, builder);
        builder.addMethod(this.compilerUtil.generateConstructor2(vmap));
        builder.addMethod(this.generateTemplateGenerator(allVars, allAtts, doc, vmap, bindings_schema));
        builder.addMethod(this.compilerCommon.generateNameAccessor(templateName));
        builder.addMethod(this.compilerCommon.commonAccessorGenerator(templateName, locations.getFilePackage(BeanDirection.COMMON)));
        builder.addMethod(this.typeManagerGenerator(templateName, packge));
        builder.addMethod(this.compilerCommon.typedRecordGenerator(templateName, packge));
        builder.addMethod(this.generateTypePropagator(allVars, allAtts, doc, vmap, packge + ".client", bindings_schema, successorTable));
        builder.addMethod(this.generateTypePropagatorN_new());
        if (this.withMain) {
            builder.addMethod(this.generateMain(allVars, allAtts, name, bindings_schema, bindingsSchema));
        }
        if (bindings_schema != null) {
            builder.addMethod(this.generateFactoryMethod(allVars, allAtts, name, bindings_schema, bindingsSchema));
            builder.addMethod(this.generateFactoryMethodWithContinuation(allVars, allAtts, name, templateName, packge, bindings_schema));
            builder.addMethod(this.generateFactoryMethodWithArray(allVars, allAtts, name, bindings_schema));
            builder.addMethod(this.generateFactoryMethodWithArrayAndContinuation(name, templateName, packge, bindings_schema));
        }
        TypeSpec bean = builder.build();
        JavaFile myfile = this.compilerUtil.specWithComment(bean, templateName, packge, stackTraceElement);
        return new SpecificationFile(myfile, directory, fileName, packge);
    }

    public MethodSpec generateTemplateGenerator(Collection<QualifiedName> allVars, Collection<QualifiedName> allAtts, Document doc, Hashtable<QualifiedName, String> vmap, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"generator").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Document.class);
        this.compilerUtil.specWithComment(builder);
        builder.addStatement("$T nullqn = null", new Object[]{QualifiedName.class}).addStatement("$T attrs=null", new Object[]{StatementCompilerAction.cl_collectionOfAttributes}).addStatement("$T __C_document = pf.newDocument()", new Object[]{Document.class});
        for (QualifiedName qualifiedName : allVars) {
            builder.addParameter(QualifiedName.class, qualifiedName.getLocalPart(), new Modifier[0]);
        }
        for (QualifiedName qualifiedName : allAtts) {
            if (allVars.contains(qualifiedName)) continue;
            builder.addParameter(Object.class, qualifiedName.getLocalPart(), new Modifier[0]);
        }
        for (QualifiedName qualifiedName : allVars) {
            if (!ExpandUtil.isGensymVariable((QualifiedName)qualifiedName)) continue;
            String vgen = qualifiedName.getLocalPart();
            builder.addStatement("if ($N==null) $N=$T.getUUIDQualifiedName2(pf)", new Object[]{vgen, vgen, ExpandAction.class});
        }
        StatementCompilerAction action = new StatementCompilerAction(this.pFactory, allVars, allAtts, vmap, builder, "__C_document.getStatementOrBundle()", bindings_schema);
        for (StatementOrBundle s : doc.getStatementOrBundle()) {
            CompilerUtil.u.doAction(s, (StatementAction)action);
        }
        builder.addStatement("new $T().updateNamespaces(__C_document)", new Object[]{ProvUtilities.class});
        builder.addStatement("return __C_document", new Object[0]);
        MethodSpec methodSpec = builder.build();
        return methodSpec;
    }

    public MethodSpec generateTypePropagator(Collection<QualifiedName> allVars, Collection<QualifiedName> allAtts, Document doc, Hashtable<QualifiedName, String> vmap, String packge, JsonNode bindings_schema, Map<Integer, List<Integer>> successorTable) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"propagateTypes").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE);
        builder.addParameter(ParameterSpec.builder((TypeName)recordType, (String)"record", (Modifier[])new Modifier[0]).build());
        builder.addParameter(ParameterSpec.builder((TypeName)levelNMapType, (String)"mapLevelN", (Modifier[])new Modifier[0]).build());
        builder.addParameter(ParameterSpec.builder((TypeName)levelNP1CMapType, (String)"mapLevelNP1", (Modifier[])new Modifier[0]).build());
        builder.addParameter(ParameterSpec.builder((TypeName)levelNMapType, (String)"mapLevel0", (Modifier[])new Modifier[0]).build());
        builder.addParameter(ParameterSpec.builder((TypeName)levelNMapType, (String)"uniqId", (Modifier[])new Modifier[0]).build());
        this.compilerUtil.specWithComment(builder);
        builder.addComment(successorTable.toString(), new Object[0]);
        int count = 1;
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        Iterator iter = the_var.fieldNames();
        Map successors1 = this.compilerCommon.getSuccessors1();
        Map<String, Set<Pair<QualifiedName, WasAttributedTo>>> successors2 = this.compilerCommon.getSuccessors2();
        Map<String, Set<Pair<QualifiedName, HadMember>>> successors3 = this.compilerCommon.getSuccessors3();
        Map successors3b = this.compilerCommon.getSuccessors3b();
        Map<String, Set<Pair<QualifiedName, SpecializationOf>>> successors4 = this.compilerCommon.getSuccessors4();
        Map<String, Collection<String>> knownTypes = this.compilerTypeManagement.getKnownTypes();
        Map<String, Collection<String>> unknownTypes = this.compilerTypeManagement.getUnknownTypes();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (this.compilerUtil.isVariableDenotingQualifiedName(key, the_var)) {
                builder.addComment("Variable: " + key, new Object[0]);
                builder.addComment("Count: " + count, new Object[0]);
                if (successors1.get(key) != null || successors2.get(key) != null || successors3.get(key) != null || successors3b.get(key) != null || successors4.get(key) != null) {
                    List<Integer> rowValues = successorTable.get(count);
                    if (rowValues == null || rowValues.isEmpty()) {
                        throw new InvalidCaseException("successor table incorrect");
                    }
                    for (int i = 0; i < rowValues.size() / 2; ++i) {
                        int successor = rowValues.get(i * 2);
                        int relation = rowValues.get(i * 2 + 1);
                        if (relation == StatementOrBundle.Kind.PROV_DERIVATION.ordinal()) {
                            this.generateStatementForRelation_NEW(builder, count, successor, relation, the_var, successors1, knownTypes, unknownTypes, key);
                            continue;
                        }
                        if (relation == StatementOrBundle.Kind.PROV_MEMBERSHIP.ordinal()) {
                            this.generateStatementForRelation_NEW(builder, count, successor, relation, the_var, successors3b, knownTypes, unknownTypes, key);
                            continue;
                        }
                        builder.addStatement("propagateTypes_n(record,mapLevelN,mapLevelNP1,$L,$L,$L,$L,uniqId)", new Object[]{count, successor, relation, -1});
                    }
                } else {
                    builder.addComment("No successor for: " + count, new Object[0]);
                }
            }
            builder.addComment("", new Object[0]);
            ++count;
        }
        return builder.build();
    }

    private <ARELATION extends Identifiable> void generateStatementForRelation_NEW(MethodSpec.Builder builder, int count, int successor, int relation, JsonNode the_var, Map<String, Set<Pair<QualifiedName, ARELATION>>> successors, Map<String, Collection<String>> knownTypes, Map<String, Collection<String>> unknownTypes, String key) {
        if (successors.get(key) != null) {
            List relations = successors.get(key).stream().map(Pair::getRight).collect(Collectors.toList());
            List identifiers = relations.stream().map(Identifiable::getId).collect(Collectors.toList());
            builder.addComment("Identifiers: " + identifiers, new Object[0]);
            builder.addComment("KnownTypes: " + successors.get(key).stream().map(p -> (Collection)knownTypes.get(((Identifiable)p.getRight()).getId().getUri())).collect(Collectors.toList()), new Object[0]);
            builder.addComment("UnknownTypes: " + successors.get(key).stream().map(p -> (Collection)unknownTypes.get(((Identifiable)p.getRight()).getId().getUri())).collect(Collectors.toList()), new Object[0]);
            List optionalActivityTypes = relations.stream().map(p -> this.doCollectElementVariables((Statement)p, "http://openprovenance.org/tmpl#activityType")).collect(Collectors.toList());
            List optionalActivities = relations.stream().map(p -> this.doCollectElementVariables((Statement)p, "http://openprovenance.org/tmpl#activity")).collect(Collectors.toList());
            builder.addComment("ActivityTypes: " + optionalActivityTypes, new Object[0]);
            builder.addComment("Activities: " + optionalActivities, new Object[0]);
            if (optionalActivityTypes.isEmpty() || optionalActivityTypes.get(0) == null) {
                builder.addStatement("propagateTypes_n(record,mapLevelN,mapLevelNP1,$L,$L,$L,$L,uniqId)", new Object[]{count, successor, relation, -1});
            } else {
                QualifiedName firstRelationIdentifier = (QualifiedName)identifiers.get(0);
                Identifiable firstRelation = (Identifiable)relations.get(0);
                Optional firstActivityType = ((Collection)optionalActivityTypes.get(0)).stream().findFirst();
                if (firstActivityType.isEmpty()) {
                    builder.addStatement("propagateTypes_n(record,mapLevelN,mapLevelNP1,$L,$L,$L,$L,uniqId)", new Object[]{count, successor, relation, -1});
                } else {
                    if (optionalActivities.isEmpty() || optionalActivities.get(0) == null) {
                        throw new MissingAttributeValue("http://openprovenance.org/tmpl#activity in " + firstRelation);
                    }
                    Optional firstActivity = ((Collection)optionalActivities.get(0)).stream().findFirst();
                    if (firstActivity.isEmpty()) {
                        throw new MissingAttributeValue("http://openprovenance.org/tmpl#activity in " + firstRelation);
                    }
                    builder.addComment("propagating for $N", new Object[]{key});
                    builder.addComment("URI: " + ((QualifiedName)firstActivity.get()).getUri(), new Object[0]);
                    String tmpa = "l1a_" + count;
                    String tmpb = "l1b_" + count;
                    builder.addComment("Position: " + this.findPosition(TypesRecordProcessor.localName(((QualifiedName)firstActivity.get()).getUri()), the_var), new Object[0]);
                    builder.addStatement("$T $N=mapLevel0.get($S + (($T)record[$L]).getLocalPart())", new Object[]{Integer.class, tmpa, firstRelationIdentifier.getUri() + ".", QualifiedName.class, this.findPosition(TypesRecordProcessor.localName(((QualifiedName)firstActivity.get()).getUri()), the_var)});
                    builder.addStatement("int $N=($N==null)?-1:$N", new Object[]{tmpb, tmpa, tmpa});
                    builder.addStatement("propagateTypes_n(record,mapLevelN,mapLevelNP1,$L,$L,$L,$N, uniqId)", new Object[]{count, successor, relation, tmpb});
                }
            }
        } else {
            builder.addStatement("propagateTypes_n(record,mapLevelN,mapLevelNP1,$L,$L,$L,$L,uniqId)", new Object[]{count, successor, relation, -1});
        }
    }

    private int findPosition(String name, JsonNode the_var) {
        Iterator iter = the_var.fieldNames();
        int count = 1;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (key.equals(name)) {
                return count;
            }
            ++count;
        }
        return count;
    }

    public static String escape(QualifiedName qn) {
        String uri = qn.getUri();
        return uri.replace("/", "_").replace("#", "_").replace(":", "_").replace(".", "_");
    }

    public Collection<QualifiedName> doCollectElementVariables(Statement s, String search) {
        return CompilerExpansionBuilder.doCollectElementVariables(this.pFactory, s, search);
    }

    public static Collection<QualifiedName> doCollectElementVariables(ProvFactory pFactory, Statement s, String search) {
        Collection attributes = pFactory.getAttributes(s);
        if (!attributes.isEmpty()) {
            boolean found = false;
            LinkedList<QualifiedName> res = new LinkedList<QualifiedName>();
            for (Attribute attribute : attributes) {
                QualifiedName element = attribute.getElementName();
                Object value = attribute.getValue();
                if (!(value instanceof QualifiedName)) continue;
                QualifiedName vq = (QualifiedName)value;
                if (!search.equals(element.getUri())) continue;
                res.add(vq);
                found = true;
            }
            if (found) {
                return res;
            }
        }
        return null;
    }

    public MethodSpec generateTypePropagatorN_new() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"propagateTypes_n").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE);
        this.compilerUtil.specWithComment(builder);
        String var_successor = "successor";
        String var_genericRelation = "genericRelation";
        String var_record = "record";
        String var_specificRelation = "specificRelation";
        String var_count = "count";
        String var_in_type = "in_type";
        builder.addParameter(ParameterSpec.builder((TypeName)recordType, (String)"record", (Modifier[])new Modifier[0]).build());
        builder.addParameter(ParameterSpec.builder((TypeName)levelNMapType, (String)"mapLevelN", (Modifier[])new Modifier[0]).build());
        builder.addParameter(ParameterSpec.builder((TypeName)levelNP1CMapType, (String)"mapLevelNP1", (Modifier[])new Modifier[0]).build());
        builder.addParameter(ParameterSpec.builder(Integer.class, (String)"count", (Modifier[])new Modifier[0]).build());
        builder.addParameter(ParameterSpec.builder(Integer.TYPE, (String)"successor", (Modifier[])new Modifier[0]).build());
        builder.addParameter(ParameterSpec.builder(Integer.TYPE, (String)"genericRelation", (Modifier[])new Modifier[0]).build());
        builder.addParameter(ParameterSpec.builder(Integer.TYPE, (String)"specificRelation", (Modifier[])new Modifier[0]).build());
        builder.addParameter(ParameterSpec.builder((TypeName)levelNMapType, (String)"uniqId", (Modifier[])new Modifier[0]).build());
        builder.beginControlFlow("if ($N[$N]!=null)", new Object[]{"record", "count"});
        builder.addStatement("String uri=(($T)($N[$L])).getUri()", new Object[]{QualifiedName.class, "record", "count"});
        builder.addStatement("Integer $N=mapLevelN.get(uri)", new Object[]{"in_type"});
        builder.beginControlFlow("if ($N!=null)", new Object[]{"in_type"});
        builder.beginControlFlow("if ($N[$N]!=null)", new Object[]{"record", "successor"});
        builder.addStatement("String uri2=(($T)($N[$N])).getUri()", new Object[]{QualifiedName.class, "record", "successor"});
        builder.addStatement("mapLevelNP1.computeIfAbsent(uri2, k -> new $T<>())", new Object[]{LinkedList.class});
        builder.addStatement("mapLevelNP1.get(uri2).add(new int[] { $N, $N, $N, $N, $N, uniqId.get($N)})", new Object[]{"successor", "genericRelation", "specificRelation", "in_type", "count", "uri"});
        builder.endControlFlow();
        builder.endControlFlow();
        builder.endControlFlow();
        return builder.build();
    }

    public Hashtable<QualifiedName, String> generateQualifiedNames(Document doc, TypeSpec.Builder builder) {
        Bundle bun = (Bundle)CompilerUtil.u.getBundle(doc).get(0);
        HashSet<QualifiedName> set = new HashSet<QualifiedName>();
        this.compilerUtil.allQualifiedNames(bun, set, this.pFactory);
        set.remove(this.pFactory.newQualifiedName("http://openprovenance.org/tmpl#", "label", "tmpl"));
        set.add(this.pFactory.getName().PROV_LABEL);
        Hashtable<QualifiedName, String> qnVariables = new Hashtable<QualifiedName, String>();
        for (QualifiedName qn : set) {
            if (ExpandUtil.isVariable((QualifiedName)qn)) continue;
            String v = this.variableForQualifiedName(qn);
            qnVariables.put(qn, v);
            builder.addField(QualifiedName.class, v, new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        }
        return qnVariables;
    }

    public String variableForQualifiedName(QualifiedName qn) {
        return "_Q_" + qn.getPrefix() + "_" + qn.getLocalPart();
    }

    public MethodSpec generateFactoryMethod(Collection<QualifiedName> allVars, Collection<QualifiedName> allAtts, String name, JsonNode bindings_schema, TemplateBindingsSchema bindingsSchema) {
        JsonNode entry;
        String newName;
        String key;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"make").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Document.class);
        this.compilerUtil.specWithComment(builder);
        builder.addStatement("$T __C_document = null", new Object[]{Document.class}).addStatement("$T __C_ns = new Namespace()", new Object[]{Namespace.class}).addStatement("$T subst= new StringSubstitutor(getVariableMap())", new Object[]{StringSubstitutor.class});
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        this.compilerUtil.generateSpecializedParameters(builder, the_var);
        Iterator iter2 = the_context.fieldNames();
        while (iter2.hasNext()) {
            String prefix = (String)iter2.next();
            String uri = the_context.get(prefix).textValue();
            builder.addStatement("__C_ns.register($S,subst.replace($S))", new Object[]{prefix, uri});
        }
        Object args = "";
        boolean first = true;
        HashSet<String> seen = new HashSet<String>();
        for (QualifiedName q : allVars) {
            key = q.getLocalPart();
            seen.add(key);
            newName = this.compilerUtil.varPrefix(key);
            entry = the_var.path(key);
            if (entry != null && !(entry instanceof MissingNode)) {
                String s = entry.get(0).get("@id").textValue();
                JsonNode toEscapeEntry = entry.get(0).get("@escape");
                boolean toEscape = toEscapeEntry != null && toEscapeEntry.textValue() != null && "true".equals(toEscapeEntry.textValue());
                String s2 = "\"" + s.replace("*", "\" + $N + \"") + "\"";
                if (toEscape) {
                    builder.addStatement("$T $N=($N==null)?null:__C_ns.stringToQualifiedName(" + s2 + ",pf,false)", new Object[]{QualifiedName.class, newName, key, key});
                } else {
                    builder.addStatement("$T $N=($N==null)?null:__C_ns.stringToQualifiedName(" + s2 + ",pf)", new Object[]{QualifiedName.class, newName, key, key});
                }
            } else {
                builder.addStatement("$T $N=null", new Object[]{QualifiedName.class, newName});
            }
            if (first) {
                first = false;
                args = newName;
                continue;
            }
            args = (String)args + ", " + newName;
        }
        for (QualifiedName q : allAtts) {
            JsonNode jentry;
            newName = key = q.getLocalPart();
            if (seen.contains(key)) continue;
            entry = the_var.path(key);
            if (entry != null && !(entry instanceof MissingNode) && (jentry = entry.get(0).get("@id")) != null) {
                String s = jentry.textValue();
                String s2 = "\"" + s.replace("*", "\" + $N + \"") + "\"";
                newName = this.compilerUtil.attPrefix(key);
                builder.addStatement("$T $N=($N==null)?null:__C_ns.stringToQualifiedName(" + s2 + ",pf)", new Object[]{QualifiedName.class, newName, key, key});
            }
            if (first) {
                first = false;
                args = newName;
                continue;
            }
            args = (String)args + ", " + newName;
        }
        builder.addStatement("__C_document = generator(" + (String)args + ")", new Object[0]);
        builder.addStatement("return __C_document", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateFactoryMethodWithContinuation(Collection<QualifiedName> allVars, Collection<QualifiedName> allAtts, String name, String template, String packge, JsonNode bindings_schema) {
        String s;
        String key;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"make").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"T")).addTypeVariable(TypeVariableName.get((String)"T"));
        this.compilerUtil.specWithComment(builder);
        builder.addStatement("$T __C_result = null", new Object[]{TypeVariableName.get((String)"T")}).addStatement("$T __C_ns = new Namespace()", new Object[]{Namespace.class}).addStatement("$T subst= new StringSubstitutor(getVariableMap())", new Object[]{StringSubstitutor.class});
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        this.compilerUtil.generateSpecializedParameters(builder, the_var);
        builder.addParameter(this.processorInterfaceType(template, packge), "processor", new Modifier[0]);
        Iterator iter2 = the_context.fieldNames();
        while (iter2.hasNext()) {
            String prefix = (String)iter2.next();
            String uri = the_context.get(prefix).textValue();
            builder.addStatement("__C_ns.register($S,subst.replace($S))", new Object[]{prefix, uri});
        }
        HashMap<String, String> translator = new HashMap<String, String>();
        HashSet<String> seen = new HashSet<String>();
        for (QualifiedName q : allVars) {
            key = q.getLocalPart();
            seen.add(key);
            String newName = this.compilerUtil.varPrefix(key);
            translator.put(key, newName);
            JsonNode entry = the_var.path(key);
            if (entry != null && !(entry instanceof MissingNode)) {
                s = entry.get(0).get("@id").textValue();
                JsonNode toEscapeEntry = entry.get(0).get("@escape");
                boolean toEscape = toEscapeEntry != null && toEscapeEntry.textValue() != null && "true".equals(toEscapeEntry.textValue());
                String s2 = "\"" + s.replace("*", "\" + $N + \"") + "\"";
                if (toEscape) {
                    builder.addStatement("$T $N=($N==null)?null:__C_ns.stringToQualifiedName(" + s2 + ",pf,false)", new Object[]{QualifiedName.class, newName, key, key});
                    continue;
                }
                builder.addStatement("$T $N=($N==null)?null:__C_ns.stringToQualifiedName(" + s2 + ",pf)", new Object[]{QualifiedName.class, newName, key, key});
                continue;
            }
            builder.addStatement("$T $N=null", new Object[]{QualifiedName.class, newName});
        }
        for (QualifiedName q : allAtts) {
            JsonNode jentry;
            JsonNode entry;
            key = q.getLocalPart();
            if (seen.contains(key) || (entry = the_var.path(key)) == null || entry instanceof MissingNode || (jentry = entry.get(0).get("@id")) == null) continue;
            s = jentry.textValue();
            String s2 = "\"" + s.replace("*", "\" + $N + \"") + "\"";
            String newName = this.compilerUtil.attPrefix(key);
            translator.put(key, newName);
            builder.addStatement("$T $N=($N==null)?null:__C_ns.stringToQualifiedName(" + s2 + ",pf)", new Object[]{QualifiedName.class, newName, key, key});
        }
        String args = this.compilerUtil.generateArgumentsListForCall(the_var, translator);
        builder.addStatement("__C_result = processor.call(" + args + ")", new Object[0]);
        builder.addStatement("return __C_result", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateFactoryMethodWithArray(Collection<QualifiedName> allVars, Collection<QualifiedName> allAtts, String name, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"make").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Document.class);
        this.compilerUtil.specWithComment(builder);
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        builder.addParameter(Object[].class, "__record", new Modifier[0]);
        int count = 1;
        Iterator iter = the_var.fieldNames();
        Object args = "";
        while (iter.hasNext()) {
            String statement;
            String key = (String)iter.next();
            Class<?> atype = this.compilerUtil.getJavaTypeForDeclaredType(the_var, key);
            String converter = this.compilerUtil.getConverterForDeclaredType(atype);
            if (converter == null) {
                statement = "$T $N=($T) __record[" + count + "]";
                builder.addStatement(statement, new Object[]{atype, key, atype});
            } else {
                statement = "$T $N=$N(__record[" + count + "])";
                builder.addStatement(statement, new Object[]{atype, key, converter});
            }
            if (count > 1) {
                args = (String)args + ", ";
            }
            args = (String)args + key;
            ++count;
        }
        builder.addStatement("return make(" + (String)args + ")", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateFactoryMethodWithArrayAndContinuation(String name, String template, String packge, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"make").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"T")).addTypeVariable(TypeVariableName.get((String)"T"));
        this.compilerUtil.specWithComment(builder);
        JsonNode the_var = bindings_schema.get("var");
        builder.addParameter(Object[].class, "__record", new Modifier[0]);
        builder.addParameter(this.processorInterfaceType(template, packge), "_processor", new Modifier[0]);
        int count = 1;
        Iterator iter = the_var.fieldNames();
        Object args = "";
        while (iter.hasNext()) {
            String statement;
            String key = (String)iter.next();
            Class<?> atype = this.compilerUtil.getJavaTypeForDeclaredType(the_var, key);
            String converter = this.compilerUtil.getConverterForDeclaredType(atype);
            if (converter == null) {
                statement = "$T $N=($T) __record[" + count + "]";
                builder.addStatement(statement, new Object[]{atype, key, atype});
            } else {
                statement = "$T $N=$N(__record[" + count + "])";
                builder.addStatement(statement, new Object[]{atype, key, converter});
            }
            if (count > 1) {
                args = (String)args + ", ";
            }
            args = (String)args + key;
            ++count;
        }
        builder.addStatement("return make(" + (String)args + ",_processor)", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    /*
     * WARNING - void declaration
     */
    public MethodSpec generateMain(Collection<QualifiedName> allVars, Collection<QualifiedName> allAtts, String name, JsonNode bindings_schema, TemplateBindingsSchema bindingsSchema) {
        void var8_15;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"main").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(Void.TYPE).addParameter(String[].class, "args", new Modifier[0]);
        this.compilerUtil.specWithComment(builder);
        builder.addStatement("$T fr=$T.dynamicLoad()", new Object[]{Framework.class, Framework.class}).addStatement("$T pf=fr.getFactory()", new Object[]{ProvFactory.class}).addStatement("$N me=new $N(pf)", new Object[]{name, name});
        for (QualifiedName qualifiedName : allVars) {
            builder.addStatement("$T $N=pf.newQualifiedName($S,$S,$S)", new Object[]{QualifiedName.class, this.compilerUtil.varPrefix(qualifiedName.getLocalPart()), "http://example.org/", qualifiedName.getLocalPart(), "ex"});
        }
        JsonNode the_var2 = bindings_schema == null ? null : bindings_schema.get("var");
        for (QualifiedName q : allAtts) {
            String declaredType = null;
            if (the_var2 != null) {
                Iterator iter = the_var2.fieldNames();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    if (!q.getLocalPart().equals(key)) continue;
                    declaredType = this.compilerUtil.getDeclaredType(the_var2, key);
                }
            }
            Iterator<QualifiedName> example = this.compilerUtil.generateExampleForType(declaredType, q.getLocalPart(), this.pFactory);
            builder.addStatement("$T $N=$S", new Object[]{String.class, this.compilerUtil.attPrefix(q.getLocalPart()), example});
        }
        String string = "";
        boolean first = true;
        HashSet<String> seen = new HashSet<String>();
        for (QualifiedName q : allVars) {
            if (first) {
                first = false;
                String string2 = this.compilerUtil.varPrefix(q.getLocalPart());
            } else {
                void var8_11;
                String string3 = (String)var8_11 + ", " + this.compilerUtil.varPrefix(q.getLocalPart());
            }
            seen.add(q.getLocalPart());
        }
        for (QualifiedName q : allAtts) {
            if (seen.contains(q.getLocalPart())) continue;
            String key = this.compilerUtil.attPrefix(q.getLocalPart());
            if (first) {
                first = false;
                String string4 = key;
                continue;
            }
            String string5 = (String)var8_15 + ", " + key;
        }
        builder.addStatement("$T document=me.generator(" + (String)var8_15 + ")", new Object[]{Document.class});
        builder.addStatement("fr.writeDocument($T.out,document,$T.PROVN)", new Object[]{System.class, Formats.ProvFormat.class});
        if (bindings_schema != null) {
            void var8_19;
            JsonNode the_var = bindings_schema.get("var");
            Iterator iter = the_var.fieldNames();
            String string6 = "";
            first = true;
            int count = 0;
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (first) {
                    first = false;
                    String string7 = this.compilerUtil.createExamplar(the_var, key, count++, this.pFactory);
                    continue;
                }
                String string8 = (String)var8_19 + ", " + this.compilerUtil.createExamplar(the_var, key, count++, this.pFactory);
            }
            builder.addStatement("document=me.make(" + (String)var8_19 + ")", new Object[0]);
            builder.addStatement("fr.writeDocument($T.out,document,$T.PROVN)", new Object[]{System.class, Formats.ProvFormat.class});
        }
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec typeManagerGenerator(String templateName, String packge) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getTypeManager").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)packge, (String)(this.compilerUtil.templateNameClass(templateName) + "TypeManagement"), (String[])new String[0]));
        this.compilerUtil.specWithComment(builder);
        builder.addParameter(ParameterSpec.builder((TypeName)CompilerTypeManagement.Map_QN_S_of_String, (String)"knownTypeMap", (Modifier[])new Modifier[0]).build());
        builder.addParameter(ParameterSpec.builder((TypeName)CompilerTypeManagement.Map_QN_S_of_String, (String)"unknownTypeMap", (Modifier[])new Modifier[0]).build());
        builder.addParameter(ParameterSpec.builder((TypeName)CompilerTypeManagement.Map_S_Map_S_to_Function, (String)"propertyConverters", (Modifier[])new Modifier[0]).build());
        builder.addParameter(ParameterSpec.builder((TypeName)CompilerTypeManagement.Map_QN_Col_of_String, (String)"idata", (Modifier[])new Modifier[0]).build());
        builder.addParameter(ParameterSpec.builder((TypeName)CompilerTypeManagement.Map_S_Map_S_to_Function, (String)"idataConverters", (Modifier[])new Modifier[0]).build());
        builder.addStatement("return new $T($N,$N,$N,$N,$N,$N)", new Object[]{ClassName.get((String)packge, (String)(this.compilerUtil.templateNameClass(templateName) + "TypeManagement"), (String[])new String[0]), "pf", "knownTypeMap", "unknownTypeMap", "propertyConverters", "idata", "idataConverters"});
        return builder.build();
    }
}

