/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.expansion;

import com.fasterxml.jackson.databind.JsonNode;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.CompilerCommon;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;
import org.openprovenance.prov.template.descriptors.Descriptor;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;

public class CompilerTypedRecord {
    private final CompilerUtil compilerUtil;
    private final ProvFactory pFactory;
    private final boolean withMain;
    private final CompilerCommon compilerCommon;
    private final boolean debugComment;

    public CompilerTypedRecord(boolean withMain, CompilerCommon compilerCommon, ProvFactory pFactory, boolean debugComment) {
        this.pFactory = pFactory;
        this.withMain = withMain;
        this.compilerCommon = compilerCommon;
        this.debugComment = debugComment;
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    public SpecificationFile generatedTypedRecordConstructor(TemplatesCompilerConfig configs, Locations locations, Document doc, String name, String templateName, String packge, String resource, JsonNode bindings_schema, TemplateBindingsSchema bindingsSchema, String directory, String fileName) {
        Bundle bun = (Bundle)CompilerUtil.u.getBundle(doc).get(0);
        HashSet<QualifiedName> allVars = new HashSet<QualifiedName>();
        HashSet<QualifiedName> allAtts = new HashSet<QualifiedName>();
        this.compilerUtil.extractVariablesAndAttributes(bun, allVars, allAtts, this.pFactory);
        return this.generateTypeDeclaration_aux(configs, locations, doc, allVars, allAtts, name, templateName, packge, resource, bindings_schema, bindingsSchema, directory, fileName);
    }

    public SpecificationFile generateTypeDeclaration_aux(TemplatesCompilerConfig configs, Locations locations, Document doc, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, String resource, JsonNode bindings_schema, TemplateBindingsSchema bindingsSchema, String directory, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        MethodSpec.Builder mbuilder = MethodSpec.methodBuilder((String)"call").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeVariableName.get(Object[].class));
        this.compilerUtil.specWithComment(mbuilder);
        JsonNode the_var = bindings_schema.get("var");
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        this.compilerUtil.generateDocumentSpecializedParameters(mbuilder, theVar, variables);
        String allArgs = this.compilerUtil.generateArgumentsListForCall(the_var, null);
        mbuilder.addStatement("return new Object[] { $S , " + allArgs + "}", new Object[]{templateName});
        TypeSpec.Builder builder = this.compilerUtil.generateTypedRecordClass(name);
        ParameterizedTypeName superinterface = ParameterizedTypeName.get((ClassName)ClassName.get((String)packge, (String)(name + "Interface"), (String[])new String[0]), (TypeName[])new TypeName[]{TypeName.get(Object[].class)});
        builder.addSuperinterface((TypeName)superinterface);
        builder.addMethod(mbuilder.build());
        TypeSpec bean = builder.build();
        JavaFile myfile = this.compilerUtil.specWithComment(bean, templateName, packge, stackTraceElement);
        return new SpecificationFile(myfile, directory, fileName, packge);
    }
}

