/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.emitter.minilanguage;

import java.util.List;
import org.openprovenance.prov.template.emitter.Element;
import org.openprovenance.prov.template.emitter.minilanguage.Expression;
import org.openprovenance.prov.template.emitter.minilanguage.Statement;
import org.openprovenance.prov.template.emitter.minilanguage.Symbol;
import org.openprovenance.prov.template.emitter.minilanguage.emitters.Python;

public class Assignment
extends Statement {
    private final Object type;
    private final Expression variable;
    private final Expression value;

    public Assignment(Object type, Expression variable, Expression value, List<Element> elementList) {
        super(elementList);
        this.type = type;
        this.variable = variable;
        this.value = value;
    }

    @Override
    public String toString() {
        return "Assignment{type=" + this.type + ", variable=" + this.variable + ", value=" + this.value + "}";
    }

    @Override
    public void emit(Python emitter, List<String> classVariables, List<String> instanceVariables) {
        if (this.variable instanceof Symbol && ((Symbol)this.variable).symbol.equals("self")) {
            return;
        }
        emitter.emitBeginLine("");
        this.variable.emit(emitter, true, classVariables, instanceVariables);
        emitter.emitContinueLine("=");
        this.value.emit(emitter, true, classVariables, instanceVariables);
        emitter.emitNewline();
    }
}

