/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.emitter.minilanguage;

import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.template.emitter.minilanguage.Parameter;
import org.openprovenance.prov.template.emitter.minilanguage.Statement;
import org.openprovenance.prov.template.emitter.minilanguage.emitters.Python;

public class Method {
    public String name;
    public String returnType;
    public List<Parameter> parameters;
    public List<Statement> body;
    public Set<Modifier> modifiers;

    public String toString() {
        return "Method{name='" + this.name + "', returnType='" + this.returnType + "', parameters=" + this.parameters + ", body=" + this.body + "}";
    }

    public boolean isStatic() {
        return this.modifiers.contains((Object)Modifier.STATIC);
    }

    public void emit(Python emitter, List<String> classVariables, List<String> instanceVariables) {
        if (this.isStatic()) {
            emitter.emitBeginLine("@classmethod");
            emitter.emitNewline();
        }
        emitter.emitBeginLine("def ");
        emitter.emitContinueLine(this.name);
        emitter.emitContinueLine("(");
        if (this.isStatic()) {
            emitter.emitContinueLine("cls");
        } else {
            emitter.emitContinueLine("self");
        }
        for (Parameter p : this.parameters) {
            emitter.emitContinueLine(",");
            emitter.emitContinueLine(p.name);
        }
        emitter.emitContinueLine("):");
        emitter.emitNewline();
        emitter.indent();
        for (Statement s : this.body) {
            s.emit(emitter, classVariables, instanceVariables);
        }
        emitter.unindent();
        emitter.emitNewline();
    }
}

