/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.emitter.minilanguage;

import java.util.LinkedList;
import java.util.List;
import org.openprovenance.prov.template.emitter.Element;
import org.openprovenance.prov.template.emitter.Pair;
import org.openprovenance.prov.template.emitter.Token;
import org.openprovenance.prov.template.emitter.minilanguage.Assignment;
import org.openprovenance.prov.template.emitter.minilanguage.Comment;
import org.openprovenance.prov.template.emitter.minilanguage.Constant;
import org.openprovenance.prov.template.emitter.minilanguage.ConstantInteger;
import org.openprovenance.prov.template.emitter.minilanguage.Expression;
import org.openprovenance.prov.template.emitter.minilanguage.MethodCall;
import org.openprovenance.prov.template.emitter.minilanguage.Return;
import org.openprovenance.prov.template.emitter.minilanguage.Symbol;
import org.openprovenance.prov.template.emitter.minilanguage.emitters.Python;

public class Statement {
    protected List<Element> elements;

    public Statement(List<Element> elements) {
        this.elements = elements;
    }

    public static Statement makeStatement(List<Element> elements) {
        if (elements.size() > 3 && elements.get(2) instanceof Token && Pair.getToken(elements.get(2)).equals("=")) {
            return new Assignment(Pair.getArg(elements.get(0)), new Symbol((String)Pair.getArg(elements.get(1)), null), Expression.makeExpression(elements.subList(3, elements.size())), elements);
        }
        if (elements.size() >= 2 && elements.get(0) instanceof Token && Pair.getToken(elements.get(0)).startsWith("return")) {
            return new Return(elements.subList(1, elements.size()), elements);
        }
        if (!elements.isEmpty() && elements.get(0) instanceof Token && Pair.getToken(elements.get(0)).startsWith("//")) {
            return new Comment(elements);
        }
        if (elements.size() > 3 && elements.get(3) instanceof Token && elements.get(3).equals(new Token("="))) {
            List<Element> allArgsIncludingMarkers = elements.subList(3, elements.size());
            MethodCall object = new MethodCall(((Pair)elements.get(0)).getArg(), (String)((Pair)elements.get(2)).getArg(), null, elements);
            allArgsIncludingMarkers.add(0, new Pair("$L", object));
            return Statement.makeStatement(allArgsIncludingMarkers);
        }
        if (elements.size() > 3 && elements.get(3) instanceof Token && elements.get(3).equals(new Token("=("))) {
            List<Element> allArgsIncludingMarkers = elements.subList(3, elements.size());
            MethodCall object = new MethodCall(((Pair)elements.get(0)).getArg(), (String)((Pair)elements.get(2)).getArg(), null, elements);
            allArgsIncludingMarkers.remove(0);
            allArgsIncludingMarkers.add(0, new Token("("));
            allArgsIncludingMarkers.add(0, new Token("="));
            allArgsIncludingMarkers.add(0, new Pair("$L", object));
            return Statement.makeStatement(allArgsIncludingMarkers);
        }
        if (elements.size() == 3 && elements.get(1) instanceof Token && Pair.getToken(elements.get(1)).equals("=")) {
            return new Assignment(null, (Expression)Pair.getArg(elements.get(0)), new Constant((String)Pair.getArg(elements.get(2)), null), elements);
        }
        if (elements.size() > 3 && Statement.tokenExists(elements, 1, "=") && Statement.tokenExists(elements, 2, "(") && Statement.tokenExists(elements, 4, ")") && Statement.tokenExists(elements, 6, "[")) {
            LinkedList<ConstantInteger> ll = new LinkedList<ConstantInteger>();
            ll.add(new ConstantInteger((Integer)Pair.getArg(elements.get(7)), null));
            return new Assignment(null, (Expression)Pair.getArg(elements.get(0)), new MethodCall((String)Pair.getArg(elements.get(5)), "get", ll, elements), elements);
        }
        if (elements.size() > 3 && Statement.tokenExists(elements, 1, "=") && Statement.tokenExists(elements, 2, "(") && Statement.tokenExists(elements, 4, "[")) {
            LinkedList<ConstantInteger> ll = new LinkedList<ConstantInteger>();
            ll.add(new ConstantInteger((Integer)Pair.getArg(elements.get(5)), null));
            return new Assignment(null, (Expression)Pair.getArg(elements.get(0)), new MethodCall((String)Pair.getArg(elements.get(3)), "get", ll, elements), elements);
        }
        return Expression.makeExpression(elements);
    }

    public static boolean tokenExists(List<Element> elements, int i, String s) {
        return elements.get(i) instanceof Token && Pair.getToken(elements.get(i)).equals(s);
    }

    public String toString() {
        return "Statement{elements=" + this.elements + "}";
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public void emit(Python emitter, List<String> classVariables, List<String> instanceVariables) {
        emitter.emitLine(this.toString());
    }

    public static String localized(String str, List<String> classVariables, List<String> instanceVariables) {
        if (classVariables.contains(str)) {
            return "cls." + str;
        }
        if (instanceVariables.contains(str)) {
            return "self." + str;
        }
        return str;
    }
}

