/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openprovenance.apache.commons.lang.StringEscapeUtils;
import org.openprovenance.prov.template.emitter.Element;
import org.openprovenance.prov.template.emitter.Pair;
import org.openprovenance.prov.template.emitter.Token;
import org.openprovenance.prov.template.emitter.minilanguage.Class;
import org.openprovenance.prov.template.emitter.minilanguage.Comment;
import org.openprovenance.prov.template.emitter.minilanguage.Conditional;
import org.openprovenance.prov.template.emitter.minilanguage.Expression;
import org.openprovenance.prov.template.emitter.minilanguage.Field;
import org.openprovenance.prov.template.emitter.minilanguage.Method;
import org.openprovenance.prov.template.emitter.minilanguage.Parameter;
import org.openprovenance.prov.template.emitter.minilanguage.Statement;

public class PoetParser {
    private StringBuffer sb = new StringBuffer();
    int indent = 0;

    public StringBuffer getSb() {
        return this.sb;
    }

    public Class parse(TypeSpec spec, Set<String> selectedExports) {
        this.emitLine("\nfrom dataclasses import dataclass");
        if (!spec.name.equals("Logger") && spec.name.endsWith("Builder")) {
            this.emitLine("from " + StringEscapeUtils.class.getName() + " import " + StringEscapeUtils.class.getSimpleName());
        }
        this.emitNewline();
        this.emitNewline();
        LinkedList<Field> fields = new LinkedList<Field>();
        spec.fieldSpecs.forEach(field -> {
            Field f = this.parse((FieldSpec)field, selectedExports);
            if (f != null) {
                fields.add(f);
            }
        });
        LinkedList<Method> methods = new LinkedList<Method>();
        spec.methodSpecs.forEach(method -> {
            Method m = this.parse((MethodSpec)method, selectedExports);
            if (m != null) {
                methods.add(m);
            }
        });
        return new Class(spec.name, new LinkedList<String>(), fields, methods, this.getComments(spec.javadoc));
    }

    private Method parse(MethodSpec method, Set<String> names) {
        if (names == null || names.contains(method.name)) {
            Method methodResult = new Method();
            methodResult.name = method.name;
            methodResult.returnType = method.returnType == null ? "VOID" : method.returnType.toString();
            methodResult.parameters = method.parameters.stream().map(p -> new Parameter(p.name, p.type.toString())).collect(Collectors.toList());
            methodResult.modifiers = method.modifiers;
            CodeBlock codeBlock = method.code;
            methodResult.body = this.parse(codeBlock);
            return methodResult;
        }
        return null;
    }

    private List<Statement> parse(CodeBlock codeBlock) {
        CodeBlock.Builder builder = codeBlock.toBuilder();
        LinkedList<Statement> statements = new LinkedList<Statement>();
        LinkedList<Element> elements = new LinkedList<Element>();
        Conditional conditional = null;
        LinkedList<Object> back = new LinkedList();
        int i = 0;
        for (String formatPart : builder.formatParts) {
            if (formatPart.equals("$[")) {
                if (!elements.isEmpty()) {
                    statements.add(Statement.makeStatement(elements));
                }
                elements = new LinkedList();
                continue;
            }
            if (formatPart.equals("$]")) {
                if (elements.isEmpty()) continue;
                statements.add(Statement.makeStatement(elements));
                elements = new LinkedList();
                continue;
            }
            if (formatPart.startsWith("//") || formatPart.startsWith("/*")) {
                if (!elements.isEmpty()) {
                    statements.add(Statement.makeStatement(elements));
                    elements = new LinkedList();
                }
                elements.add(new Token(formatPart));
                continue;
            }
            if (formatPart.trim().equals("=")) {
                elements.add(new Token(formatPart));
                continue;
            }
            if (formatPart.trim().equals("return")) {
                elements.add(new Token(formatPart));
                continue;
            }
            if (formatPart.trim().isEmpty()) continue;
            if (formatPart.trim().startsWith("if")) {
                if (!elements.isEmpty()) {
                    statements.add(Statement.makeStatement(elements));
                    elements = new LinkedList();
                }
                conditional = new Conditional(null);
                continue;
            }
            if (formatPart.trim().equals(".")) {
                elements.add(new Token(formatPart));
                continue;
            }
            if (formatPart.trim().equals(",")) {
                elements.add(new Token(formatPart));
                continue;
            }
            if (formatPart.trim().equals("(")) {
                elements.add(new Token(formatPart));
                continue;
            }
            if (formatPart.trim().equals(")")) {
                elements.add(new Token(formatPart));
                continue;
            }
            if (formatPart.trim().equals("))")) continue;
            if (formatPart.trim().equals("$<")) {
                elements.add(new Token(formatPart));
                continue;
            }
            if (formatPart.trim().equals("$>")) {
                elements.add(new Token(formatPart));
                continue;
            }
            if (formatPart.trim().startsWith(";")) {
                if (elements.isEmpty()) continue;
                statements.add(Statement.makeStatement(elements));
                elements = new LinkedList();
                continue;
            }
            if (formatPart.trim().startsWith("()")) {
                elements.add(new Token(formatPart));
                continue;
            }
            if (formatPart.trim().startsWith("{")) continue;
            if (formatPart.equals("$L") || formatPart.equals("$S") || formatPart.equals("$N") || formatPart.equals("$T")) {
                Object arg_i = builder.args.get(i);
                if (arg_i instanceof CodeBlock) {
                    elements.add(new Pair(formatPart, this.parse((CodeBlock)arg_i)));
                } else {
                    elements.add(new Pair(formatPart, arg_i));
                    if (arg_i instanceof String) {
                        String arg_i_str = (String)arg_i;
                        if (arg_i_str.contains("/*#endif#*/") && conditional != null) {
                            statements.add(Statement.makeStatement(elements));
                            conditional.alternates = statements;
                            statements = back;
                            statements.add(conditional);
                            back = null;
                            conditional = null;
                        }
                        if (arg_i_str.contains("/*#else#*/") && conditional != null) {
                            statements.add(Statement.makeStatement(elements));
                            conditional.consequents = statements;
                            statements = new LinkedList();
                            elements = new LinkedList();
                        }
                        if (arg_i_str.contains("/*#then#*/") && conditional != null) {
                            conditional.predicate = Expression.makeExpression(elements);
                            back = statements;
                            statements = new LinkedList();
                            elements = new LinkedList();
                        }
                        if (arg_i_str.contains("/*#params#*/")) {
                            // empty if block
                        }
                    }
                }
                ++i;
                continue;
            }
            elements.add(new Token(formatPart));
        }
        if (!elements.isEmpty()) {
            statements.add(Statement.makeStatement(elements));
        }
        return statements;
    }

    private void emitNewline() {
        this.sb.append("\n");
    }

    public void emitLine(String s) {
        for (int i = 0; i < this.indent; ++i) {
            this.sb.append("    ");
        }
        this.sb.append(s);
        this.emitNewline();
    }

    private void indent() {
        ++this.indent;
    }

    public void emitPrelude(String comment) {
        this.emitLine("#!/usr/bin/env/python");
        this.emitLine("");
        Arrays.asList(comment.split("\n")).forEach(s -> this.emitLine("# " + s));
        this.emitLine("");
    }

    public List<Statement> parseJavadoc(CodeBlock javadoc) {
        return this.parse(javadoc);
    }

    public Field parse(FieldSpec f, Set<String> names) {
        if (names == null || names.contains(f.name)) {
            List<Statement> initialiser1 = this.parse(f.initializer);
            assert (initialiser1.isEmpty() || initialiser1.size() == 1);
            Expression initialiser = null;
            if (!initialiser1.isEmpty()) {
                initialiser = (Expression)initialiser1.get(0);
            }
            return new Field(f.name, this.convertType(f.type), f.annotations.stream().map(a -> a.toString()).collect(Collectors.toList()), initialiser, this.getComments2(f.javadoc));
        }
        return null;
    }

    private List<Comment> getComments2(CodeBlock javadoc) {
        return Arrays.stream(javadoc.toString().split("\n")).map(Comment::new).collect(Collectors.toList());
    }

    private List<Comment> getComments(CodeBlock comments) {
        return this.parseJavadoc(comments).stream().map(s -> s instanceof Comment ? (Comment)s : new Comment(((Expression)s).getElements().toString())).collect(Collectors.toList());
    }

    private String convertType(TypeName type) {
        TypeName box = type.withoutAnnotations().box();
        switch (box.toString()) {
            case "java.lang.String": {
                return "str";
            }
            case "java.lang.Integer": {
                return "int";
            }
            case "java.lang.Float": {
                return "float";
            }
            case "java.lang.Double": {
                return "float";
            }
            case "java.lang.String[]": {
                return "str[]";
            }
        }
        return box.toString();
    }
}

