/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.QuadConsumer;
import org.openprovenance.prov.template.compiler.QuintetConsumer;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;

public class CompilerCompositeConfigurations {
    private final CompilerUtil compilerUtil;
    String enactorVar = "beanEnactor";
    static final ParameterizedTypeName recordsProcessorOfUnknown = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.openprovenance.prov.client", (String)"RecordsProcessorInterface", (String[])new String[0]), (TypeName[])new TypeName[]{TypeVariableName.get((String)"?")});

    public CompilerCompositeConfigurations(ProvFactory pFactory) {
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    public SpecificationFile generateCompositeConfigurator(TemplatesCompilerConfig configs, Locations locations, TypeName typeName, QuadConsumer<String, MethodSpec.Builder, TypeName, TypeName> generator, String generatorMethod, TypeName beanProcessor, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        if (configs.configurator_package == null) {
            throw new NullPointerException("configurator_package is null");
        }
        String compositeTableConfigurator = "Composite" + configs.tableConfigurator;
        ParameterizedTypeName tableConfiguratorType = ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage(compositeTableConfigurator), (String)compositeTableConfigurator, (String[])new String[0]), (TypeName[])new TypeName[]{typeName});
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit(fileName);
        if (beanProcessor != null) {
            builder.addField(beanProcessor, this.enactorVar, new Modifier[]{Modifier.FINAL, Modifier.PRIVATE});
            MethodSpec.Builder cspec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)beanProcessor, (String)this.enactorVar, (Modifier[])new Modifier[0]).build());
            this.compilerUtil.specWithComment(cspec);
            cspec.addStatement("this.$N=$N", new Object[]{this.enactorVar, this.enactorVar});
            builder.addMethod(cspec.build());
        }
        builder.addSuperinterface((TypeName)tableConfiguratorType);
        for (TemplateCompilerConfig config : configs.templates) {
            if (config instanceof SimpleTemplateCompilerConfig) continue;
            String templateNameClass = this.compilerUtil.templateNameClass(config.name);
            String beanNameClass = this.compilerUtil.commonNameClass(config.name);
            locations.updateWithConfig(config);
            ClassName className = ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)templateNameClass, (String[])new String[0]);
            String builderParameter = "builder";
            MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)config.name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(ParameterSpec.builder((TypeName)className, (String)builderParameter, (Modifier[])new Modifier[0]).build()).returns(typeName);
            this.compilerUtil.specWithComment(mspec);
            generator.accept(builderParameter, mspec, (TypeName)className, (TypeName)ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)beanNameClass, (String[])new String[0]));
            builder.addMethod(mspec.build());
        }
        TypeSpec theConfigurator = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theConfigurator, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateCompositeEnactorConfigurator(TemplatesCompilerConfig configs, Locations locations, String fileName) {
        return this.generateCompositeConfigurator(configs, locations, (TypeName)recordsProcessorOfUnknown, this::generateMethodEnactor, "generateCompositeConfigurator", (TypeName)ClassName.get((String)locations.getFilePackage(configs.beanProcessor), (String)configs.beanProcessor, (String[])new String[0]), fileName);
    }

    public void generateMethodEnactor(String builderParameter, MethodSpec.Builder mspec, TypeName className, TypeName beanType) {
        mspec.addStatement("$N<$T> beanConverter=$N.aRecord2BeanConverter", new Object[]{"RecordsProcessorInterface", beanType, builderParameter});
        mspec.addStatement("$N<$T> enactor=(array) -> {\n                    $T bean=beanConverter.process(array);\n                    return $N.process(bean);\n                }", new Object[]{"RecordsProcessorInterface", beanType, beanType, this.enactorVar});
        mspec.addStatement("return enactor", new Object[0]);
    }

    public SpecificationFile generateCompositeConfigurator2(TemplatesCompilerConfig configs, Locations locations, TypeName typeName, QuintetConsumer<String, MethodSpec.Builder, TypeName, TypeName, TypeName> generator, String generatorMethod, TypeName beanProcessor, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        if (configs.configurator_package == null) {
            throw new NullPointerException("configurator_package is null");
        }
        String compositeTableConfigurator = "Composite" + configs.tableConfigurator;
        ParameterizedTypeName tableConfiguratorType = ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage(compositeTableConfigurator), (String)compositeTableConfigurator, (String[])new String[0]), (TypeName[])new TypeName[]{typeName});
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit(fileName);
        if (beanProcessor != null) {
            builder.addField(beanProcessor, this.enactorVar, new Modifier[]{Modifier.FINAL, Modifier.PRIVATE});
            MethodSpec.Builder cspec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)beanProcessor, (String)this.enactorVar, (Modifier[])new Modifier[0]).build());
            this.compilerUtil.specWithComment(cspec);
            cspec.addStatement("this.$N=$N", new Object[]{this.enactorVar, this.enactorVar});
            builder.addMethod(cspec.build());
        }
        builder.addSuperinterface((TypeName)tableConfiguratorType);
        for (TemplateCompilerConfig config : configs.templates) {
            if (config instanceof SimpleTemplateCompilerConfig) continue;
            String templateNameClass = this.compilerUtil.templateNameClass(config.name);
            String beanNameClass = this.compilerUtil.commonNameClass(config.name);
            String inputNameClass = this.compilerUtil.inputsNameClass(config.name);
            String outputNameClass = this.compilerUtil.outputsNameClass(config.name);
            locations.updateWithConfig(config);
            ClassName commonClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)templateNameClass, (String[])new String[0]);
            String builderParameter = "builder";
            MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)config.name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(ParameterSpec.builder((TypeName)commonClassName, (String)builderParameter, (Modifier[])new Modifier[0]).build()).returns(typeName);
            this.compilerUtil.specWithComment(mspec);
            generator.accept(builderParameter, mspec, (TypeName)commonClassName, (TypeName)ClassName.get((String)locations.getFilePackage(BeanDirection.INPUTS), (String)inputNameClass, (String[])new String[0]), (TypeName)ClassName.get((String)locations.getFilePackage(BeanDirection.OUTPUTS), (String)outputNameClass, (String[])new String[0]));
            builder.addMethod(mspec.build());
        }
        TypeSpec theConfigurator = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theConfigurator, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateCompositeEnactorConfigurator2(TemplatesCompilerConfig configs, Locations locations, String fileName) {
        return this.generateCompositeConfigurator2(configs, locations, (TypeName)recordsProcessorOfUnknown, this::generateMethodEnactor2, "generateCompositeConfigurator", (TypeName)ClassName.get((String)locations.getFilePackage(BeanDirection.INPUTS), (String)"InputOutputProcessor", (String[])new String[0]), fileName);
    }

    public void generateMethodEnactor2(String builderParameter, MethodSpec.Builder mspec, TypeName className, TypeName inBeanType, TypeName outBeanType) {
        mspec.addStatement("$N<$T> beanConverter=$N.getIntegrator().aRecord2InputsConverter", new Object[]{"RecordsProcessorInterface", inBeanType, builderParameter});
        mspec.addStatement("$N<$T> enactor=(array) -> {\n                    $T bean=beanConverter.process(array);\n                    return $N.process(bean);\n                }", new Object[]{"RecordsProcessorInterface", outBeanType, inBeanType, this.enactorVar});
        mspec.addStatement("return enactor", new Object[0]);
    }
}

