/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesCompilerConfig;

public class CompilerInputOutputProcessor {
    private final CompilerUtil compilerUtil;

    public CompilerInputOutputProcessor(ProvFactory pFactory) {
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    SpecificationFile generateInputOutputProcessor(TemplatesCompilerConfig configs, Locations locations, String package_, boolean ioConverter, String directory, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateInterfaceInit(ioConverter ? "InputOutputProcessor" : "InputProcessor");
        for (TemplateCompilerConfig config : configs.templates) {
            String inputsNameClass = this.compilerUtil.inputsNameClass(config.name);
            String outputsNameClass = this.compilerUtil.outputsNameClass(config.name);
            ClassName inputClassName = ClassName.get((String)package_, (String)inputsNameClass, (String[])new String[0]);
            ClassName outputClassName = ClassName.get((String)package_, (String)outputsNameClass, (String[])new String[0]);
            MethodSpec mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)inputClassName, (String)"bean", (Modifier[])new Modifier[0]).build()).returns((TypeName)(ioConverter ? outputClassName : inputClassName)).build();
            builder.addMethod(mspec);
        }
        TypeSpec theLogger = builder.build();
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, package_, stackTraceElement);
        return new SpecificationFile(myfile, directory, fileName, package_);
    }
}

