/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerSQL;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.sql.PrettyPrinter;
import org.openprovenance.prov.template.compiler.sql.QueryBuilder;
import org.openprovenance.prov.template.descriptors.AttributeDescriptor;
import org.openprovenance.prov.template.descriptors.Descriptor;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;

public class CompilerSqlComposer {
    public static final String[] ARRAY_OF_STRING = new String[0];
    public static final String TOKEN_VAR_NAME = "_token";
    public static final String DUMMY = "__dummy_";
    private final CompilerUtil compilerUtil;
    final Map<String, String> functionDeclarations;
    final Map<String, String> arrayFunctionDeclarations;
    public final boolean withRelationId;
    private final String tableKey;
    Map<String, String> nameMap = this.initNameMap();

    public CompilerSqlComposer(ProvFactory pFactory, boolean withRelationId, String tableKey, Map<String, String> functionDeclarations, Map<String, String> arrayFunctionDeclarations) {
        this.withRelationId = withRelationId;
        this.tableKey = tableKey;
        this.functionDeclarations = functionDeclarations;
        this.arrayFunctionDeclarations = arrayFunctionDeclarations;
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    public static <T> Collector<T, List<T>, List<T>> toListCollector() {
        return Collector.of(ArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, new Collector.Characteristics[0]);
    }

    public static <T> Collector<Pair<T, T>, List<T>, List<T>> toListCollector2() {
        return Collector.of(ArrayList::new, (l, p) -> {
            l.add(p.getLeft());
            l.add(p.getRight());
        }, (left, right) -> {
            left.addAll(right);
            return left;
        }, new Collector.Characteristics[0]);
    }

    public void generateSQLInsertFunction(String jsonschema, String templateName, String consistOf, String root_dir, TemplateBindingsSchema templateBindingsSchema, List<String> shared) {
        final String orig_templateName = consistOf == null ? templateName : consistOf;
        Map<String, List<Descriptor>> var = templateBindingsSchema.getVar();
        String insertFunctionName = "insert_" + templateName;
        Map funParams = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(key -> ConfigProcessor.descriptorUtils.isInput((String)key, templateBindingsSchema) || shared.contains(key)).collect(Collectors.toMap(key -> this.appendPossiblySharedOutput((String)key, shared.contains(key)), key -> QueryBuilder.unquote(CompilerSqlComposer.getTheSqlType(this.compilerUtil, key, templateBindingsSchema, var)), (x, y) -> y, LinkedHashMap::new));
        Map functionReturns = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(key -> ConfigProcessor.descriptorUtils.isOutput((String)key, templateBindingsSchema) && !shared.contains(key)).collect(Collectors.toMap(this::sqlify, key -> QueryBuilder.unquote(CompilerSqlComposer.getTheSqlType(this.compilerUtil, key, templateBindingsSchema, var)), (x, y) -> y, () -> new LinkedHashMap<String, Object>(){
            {
                if (CompilerSqlComposer.this.withRelationId) {
                    this.put(CompilerSqlComposer.this.tableKey, QueryBuilder.unquote("INT"));
                }
            }
        }));
        if (functionReturns.keySet().size() == 1) {
            functionReturns.put(DUMMY, QueryBuilder.unquote("INT"));
        }
        Map insertValues2 = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().collect(Collectors.toMap(this::sqlify, key -> {
            if (ConfigProcessor.descriptorUtils.isInput((String)key, templateBindingsSchema)) {
                return QueryBuilder.unquote("input_" + this.sqlify((String)key));
            }
            boolean isShared = shared.contains(key);
            if (isShared) {
                return QueryBuilder.unquote(this.appendPossiblySharedOutput((String)key, isShared));
            }
            String the_table = ConfigProcessor.descriptorUtils.getOutputSqlTable((String)key, templateBindingsSchema).orElse((String)key);
            String new_table = this.newTableWithId((String)key);
            String new_id = the_table + "_id";
            return pp -> QueryBuilder.select(new_id).apply((PrettyPrinter)pp).from(new_table);
        }, (x, y) -> y, LinkedHashMap::new));
        Function<String, Map> otherInputs = key -> {
            Optional<Map<String, String>> sqlNewInputs = ConfigProcessor.descriptorUtils.getSqlNewInputs((String)key, templateBindingsSchema);
            if (sqlNewInputs.isPresent()) {
                Map<String, String> theInputs = sqlNewInputs.get();
                ConfigProcessor.descriptorUtils.checkSqlInputs(theInputs, templateBindingsSchema);
                ArrayList<String> newIns = new ArrayList<String>(theInputs.keySet());
                Map m = newIns.stream().collect(Collectors.toMap(i -> i, i -> QueryBuilder.unquote("input_" + this.sqlify((String)theInputs.get(i))), (x, y) -> y, LinkedHashMap::new));
                return m;
            }
            Optional<Map<String, String>> sqlAlsoOutputs = ConfigProcessor.descriptorUtils.getSqlAlsoOutputs((String)key, templateBindingsSchema);
            if (sqlAlsoOutputs.isPresent()) {
                Map<String, String> theOutputs = sqlAlsoOutputs.get();
                ConfigProcessor.descriptorUtils.checkSqlOutputs(theOutputs, templateBindingsSchema);
                ArrayList<String> newOuts = new ArrayList<String>(theOutputs.keySet());
                Map m = newOuts.stream().collect(Collectors.toMap(i -> i, i -> QueryBuilder.unquote("input_policy"), (x, y) -> y, LinkedHashMap::new));
                return m;
            }
            return CompilerSqlComposer.Default_Values();
        };
        Map cteValues2 = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(key -> ConfigProcessor.descriptorUtils.isOutput((String)key, templateBindingsSchema) && !shared.contains(key)).collect(Collectors.toMap(this::newTableWithId, key -> {
            final String the_table = ConfigProcessor.descriptorUtils.getOutputSqlTable((String)key, templateBindingsSchema).orElse((String)key);
            Optional<AttributeDescriptor.SqlForeign> sqlForeign = ConfigProcessor.descriptorUtils.getOutputSqlForeign((String)key, templateBindingsSchema);
            if (sqlForeign.isPresent()) {
                String foreignType = "input_" + sqlForeign.get().getType();
                String foreignAttribute = "input_" + sqlForeign.get().getAttribute();
                String foreignItem = "input_" + sqlForeign.get().getItem();
                String theTable = ConfigProcessor.descriptorUtils.getOutputSqlTable((String)key, templateBindingsSchema).orElse((String)key);
                return pp -> new QueryBuilder((PrettyPrinter)pp).selectExp("f_build_and_execute_select(" + foreignType + ", " + foreignAttribute + ", " + foreignItem + " )").alias(key + "_id");
            }
            return pp -> new QueryBuilder((PrettyPrinter)pp).insertInto(the_table).values((Map)otherInputs.apply((String)key)).returning((Collection<String>)new LinkedList<String>(){
                {
                    this.add(the_table + ".ID AS " + the_table + "_id");
                }
            });
        }, (x, y) -> y, LinkedHashMap::new));
        List outputs = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(key -> ConfigProcessor.descriptorUtils.isOutput((String)key, templateBindingsSchema) && !shared.contains(key)).map(key -> orig_templateName + "." + key).collect(Collectors.toCollection(() -> new LinkedList<String>(){
            {
                if (CompilerSqlComposer.this.withRelationId) {
                    this.add(orig_templateName + "." + CompilerSqlComposer.this.tableKey);
                }
            }
        }));
        if (outputs.size() == 1) {
            outputs.add("1 AS __dummy_");
        }
        QueryBuilder fun = new QueryBuilder().comment("Generated by method " + this.getClass().getName() + ".generateSQLInsertFunctionWithSharing").next(QueryBuilder.createFunction(insertFunctionName)).params(funParams).returns("table", functionReturns).bodyStart("").cte(cteValues2).insertInto(orig_templateName).values(insertValues2).returning(outputs).bodyEnd("");
        String sql = fun.getSQL();
        this.functionDeclarations.put(templateName, sql);
    }

    private String localId(String key) {
        return "_" + key + "_id";
    }

    public void generateSQLInsertArrayFunction(String templateName, String consistOf, TemplateBindingsSchema templateBindingsSchema, List<String> shared) {
        final String template_type = (consistOf == null ? templateName : consistOf) + "_type";
        Map<String, List<Descriptor>> var = templateBindingsSchema.getVar();
        String insertFunctionName = "insert_" + templateName + "_array";
        Predicate<String> isOutput = key -> ConfigProcessor.descriptorUtils.isOutput((String)key, templateBindingsSchema);
        Predicate<String> isInput = key -> ConfigProcessor.descriptorUtils.isInput((String)key, templateBindingsSchema);
        Function<String, String> table = key -> ConfigProcessor.descriptorUtils.getOutputSqlTable((String)key, templateBindingsSchema).orElse((String)key);
        HashMap<String, Object> funParams = new HashMap<String, Object>(){
            {
                this.put("_records", QueryBuilder.arrayOf(template_type));
            }
        };
        Map functionReturns = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(isOutput).collect(Collectors.toMap(this::sqlify, key -> QueryBuilder.unquote(CompilerSqlComposer.getTheSqlType(this.compilerUtil, key, templateBindingsSchema, var)), (x, y) -> y, () -> new LinkedHashMap<String, Object>(){
            {
                if (CompilerSqlComposer.this.withRelationId) {
                    this.put(CompilerSqlComposer.this.tableKey, QueryBuilder.unquote("INT"));
                }
            }
        }));
        Map cteValues1 = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(key -> isOutput.test((String)key) && shared.contains(key)).collect(Collectors.toMap(this::table_tokens, key -> pp0 -> QueryBuilder.select(TOKEN_VAR_NAME, "id", this.insert_into_table((String)table.apply((String)key), this.additionalColumnsWithoutAlias2(templateBindingsSchema, (String)key))).apply((PrettyPrinter)pp0).from(pp -> QueryBuilder.select(this.makeArray(TOKEN_VAR_NAME, this.nextVal((String)table.apply((String)key)), this.additionalColumnsWithAlias(templateBindingsSchema, (String)key))).apply((PrettyPrinter)pp).from(pp1 -> QueryBuilder.select(this.makeArray("DISTINCT ON (" + key + ") " + key + " AS _token", this.additionalColumnsWithoutAlias(templateBindingsSchema, (String)key))).apply((PrettyPrinter)pp1).from("_input_table"), this.table_tokens0((String)key)), this.table_tokens((String)key)), (x, y) -> y, () -> new LinkedHashMap<String, Function<PrettyPrinter, ?>>(){
            {
                this.put("_input_table", pp -> QueryBuilder.select("*").apply((PrettyPrinter)pp).from("unnest (_records)"));
            }
        }));
        List insertColumns = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(isOutput).map(key -> shared.contains(key) ? this.localId((String)key) : "(_arecord)." + this.sqlify((String)key)).collect(Collectors.toCollection(() -> new LinkedList<String>(){
            {
                if (CompilerSqlComposer.this.withRelationId) {
                    this.add("(_arecord)." + CompilerSqlComposer.this.tableKey);
                }
            }
        }));
        List theArguments = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(key -> isInput.test((String)key) || shared.contains(key)).map(key -> shared.contains(key) ? this.table_token_id_pairs((String)key) + ".id" : key).collect(Collectors.toList());
        String PRELUDE_TO_AUTO_GENERATE = "\n\n--- PRELUDE_TO_AUTO_GENERATE\n\n CREATE OR REPLACE FUNCTION insert_into_activity (input_id BIGINT)\n    returns table(id INT)\nas $$\nINSERT INTO activity (id)\nSELECT input_id\nRETURNING activity.id as id\n$$ language SQL;\n\n\nCREATE OR REPLACE FUNCTION insert_into_policy (input_id BIGINT, input_serial INT)\n                    returns table(id INT) \n                as $$\n                INSERT INTO policy (id, serial)\n                SELECT input_id, input_serial\n                RETURNING policy.id as id\n                $$ language SQL;\n\t\t\t\t\n\nCREATE OR REPLACE FUNCTION insert_into_assembled_collection (input_id BIGINT)\n    returns table(id INT)\nas $$\nINSERT INTO assembled_collection (id)\nSELECT input_id\nRETURNING assembled_collection.id as id\n$$ language SQL;\n\n\n\t\t\t\t\n\nCREATE OR REPLACE FUNCTION insert_into_chart (input_id BIGINT)\n    returns table(id INT)\nas $$\nINSERT INTO chart (id)\nSELECT input_id\nRETURNING chart.id as id\n$$ language SQL;\n\n\n";
        QueryBuilder fun = new QueryBuilder().comment(PRELUDE_TO_AUTO_GENERATE).comment("Generated by method " + this.getClass().getName() + ".generateSQLInsertArrayFunction").next(QueryBuilder.createFunction(insertFunctionName)).params(funParams).returns("table", functionReturns).bodyStart("").cte(cteValues1).selectExp(insertColumns.toArray(ARRAY_OF_STRING)).from(pp -> shared.stream().reduce(QueryBuilder.select(this.makeArray(shared.stream().map(theColumn -> this.table_token_id_pairs((String)theColumn) + ".id AS " + this.localId((String)theColumn)).collect(Collectors.toList()), QueryBuilder.functionCall("insert_" + templateName, theArguments, "_arecord"))).apply((PrettyPrinter)pp).from("_input_table"), (qb, s) -> qb.join(pp1 -> QueryBuilder.select(this.getId(this.table_tokens((String)s)), this.getToken(this.table_tokens((String)s))).apply((PrettyPrinter)pp1).from(this.table_tokens((String)s)), this.table_token_id_pairs((String)s)).on((String)s, "=", this.getToken(this.table_token_id_pairs((String)s))), (qb1, qb2) -> {
            throw new UnsupportedOperationException();
        }), "inserted_rows").bodyEnd("");
        String sql = fun.getSQL();
        this.arrayFunctionDeclarations.put(insertFunctionName, sql);
        System.out.println("=== PRETTY2 ==>\n " + sql + "\n===========");
    }

    private List<String> additionalColumnsWithAlias(TemplateBindingsSchema templateBindingsSchema, String key) {
        Map newInputs = ConfigProcessor.descriptorUtils.getSqlNewInputs(key, templateBindingsSchema).orElseGet(HashMap::new);
        return newInputs.keySet().stream().map(k -> (String)newInputs.get(k) + " AS " + k + " -- @sql.new.inputs").collect(Collectors.toList());
    }

    private List<String> additionalColumnsWithoutAlias(TemplateBindingsSchema templateBindingsSchema, String key) {
        Map newInputs = ConfigProcessor.descriptorUtils.getSqlNewInputs(key, templateBindingsSchema).orElseGet(HashMap::new);
        return newInputs.keySet().stream().map(newInputs::get).collect(Collectors.toList());
    }

    private List<String> additionalColumnsWithoutAlias2(TemplateBindingsSchema templateBindingsSchema, String key) {
        Map newInputs = ConfigProcessor.descriptorUtils.getSqlNewInputs(key, templateBindingsSchema).orElseGet(HashMap::new);
        return new ArrayList<String>(newInputs.keySet());
    }

    private Object[] makeArray(List<String> strings, Function<PrettyPrinter, QueryBuilder> funarg) {
        int size = strings.size();
        Object[] result = new Object[size + 1];
        strings.toArray(result);
        result[size] = funarg;
        return result;
    }

    private Object[] makeArray(String s1, String s2, List<String> strings) {
        int size = strings.size();
        Object[] result = new Object[size + 2];
        int i = 2;
        result[0] = s1;
        result[1] = s2;
        for (String s : strings) {
            result[i] = s;
            ++i;
        }
        return result;
    }

    private Object[] makeArray(String s1, List<String> strings) {
        int size = strings.size();
        Object[] result = new Object[size + 1];
        int i = 1;
        result[0] = s1;
        for (String s : strings) {
            result[i] = s;
            ++i;
        }
        return result;
    }

    private String insert_into_table(String table) {
        return "insert_into_" + table + "(id) as id";
    }

    private String insert_into_table(String table, List<String> strings) {
        String suffix = String.join((CharSequence)",", strings);
        if (suffix.isBlank()) {
            return "insert_into_" + table + "(id) as _newid";
        }
        return "insert_into_" + table + "(id, " + suffix + ") as _newid";
    }

    private String nextVal(String key) {
        return "cast(nextval('" + key + "_id_seq') as INT) as id";
    }

    static HashMap<String, Object> Default_Values() {
        return new HashMap<String, Object>();
    }

    private String newTableWithId(String key) {
        return "_new_" + key + "_with_id";
    }

    private String table_tokens(String key) {
        return "_" + key + "_tokens";
    }

    private String table_tokens0(String key) {
        return "_" + key + "_tokens0";
    }

    private String getToken(String table) {
        return table + "._token";
    }

    private String getId(String table) {
        return table + ".id";
    }

    private String table_token_id_pairs(String key) {
        return "_" + key + "_token_id_pairs";
    }

    private String table_ids(String key) {
        return "_" + key + "_ids";
    }

    public static String getTheSqlType(CompilerUtil compilerUtil, String key, TemplateBindingsSchema templateBindingsSchema, Map<String, List<Descriptor>> var) {
        String defaultSqlType = CompilerSQL.convertToSQLType(compilerUtil.getJavaTypeForDeclaredType(var, key).getName());
        String overrideSqlType = ConfigProcessor.descriptorUtils.getSqlType(key, templateBindingsSchema);
        String theSqlType = overrideSqlType != null && !"nullableTEXT".equals(overrideSqlType) && !"nonNullableTEXT".equals(overrideSqlType) ? overrideSqlType : defaultSqlType;
        return theSqlType;
    }

    private String appendPossiblySharedOutput(String key, boolean isShared) {
        return (isShared ? "composite_" : "input_") + this.sqlify(key);
    }

    private Map<String, String> initNameMap() {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("order", "_order");
        return res;
    }

    public String sqlify(String key) {
        return this.nameMap.getOrDefault(key, key);
    }
}

