/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.sql;

import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openprovenance.prov.template.compiler.sql.PrettyPrinter;
import org.openprovenance.prov.template.compiler.sql.ResultSetAdapter;

public class QueryBuilder {
    private StringBuilder sqlBuilder;
    protected PrettyPrinter prettyPrinter;
    private List<String> parameters = new LinkedList<String>();
    private List<Map<String, Object>> results = null;
    private int updateCount = -1;
    private List<Object> generatedKeys = null;
    List<Supplier<Void>> suppliers = new LinkedList<Supplier<Void>>();

    public QueryBuilder(ByteArrayOutputStream o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        this.sqlBuilder = new StringBuilder();
        this.prettyPrinter = QueryBuilder.newPrettyPrinter(o);
    }

    public QueryBuilder() {
        this(new ByteArrayOutputStream());
    }

    public QueryBuilder(PrettyPrinter pp) {
        if (pp == null) {
            throw new IllegalArgumentException();
        }
        this.sqlBuilder = new StringBuilder();
        this.prettyPrinter = pp;
    }

    public PrettyPrinter getPrettyPrinter() {
        return this.prettyPrinter;
    }

    private static PrettyPrinter newPrettyPrinter(ByteArrayOutputStream o) {
        return new PrettyPrinter(o, 160);
    }

    private QueryBuilder(StringBuilder sqlBuilder, PrettyPrinter prettyPrinter) {
        this.sqlBuilder = sqlBuilder;
        this.prettyPrinter = prettyPrinter;
    }

    public static Function<PrettyPrinter, QueryBuilder> select(Object ... columns) {
        if (columns == null || columns.length == 0) {
            throw new IllegalArgumentException();
        }
        return pp -> {
            StringBuilder sqlBuilder = new StringBuilder();
            pp.write("SELECT ");
            pp.begin(0);
            QueryBuilder queryBuilder = new QueryBuilder(sqlBuilder, (PrettyPrinter)pp);
            for (int i = 0; i < columns.length; ++i) {
                if (i > 0) {
                    pp.comma();
                }
                if (columns[i] instanceof String) {
                    pp.write((String)columns[i]);
                    continue;
                }
                pp.begin(0);
                ((Function)columns[i]).apply(pp);
                pp.end();
            }
            pp.end();
            pp.write(" ");
            pp.allowBreak(0);
            return queryBuilder;
        };
    }

    public static Function<PrettyPrinter, QueryBuilder> functionCall(String function, List<?> values, String alias) {
        if (function == null) {
            throw new IllegalArgumentException();
        }
        return prettyPrinter -> {
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append(function);
            prettyPrinter.write(function);
            QueryBuilder queryBuilder = new QueryBuilder(sqlBuilder, (PrettyPrinter)prettyPrinter);
            queryBuilder.args(values);
            prettyPrinter.write(" ");
            queryBuilder.alias(alias);
            return queryBuilder;
        };
    }

    public QueryBuilder selectExp(String ... columns) {
        if (columns == null || columns.length == 0) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.write("SELECT ");
        this.prettyPrinter.begin(0);
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                this.prettyPrinter.comma();
            }
            this.prettyPrinter.write(columns[i]);
        }
        this.prettyPrinter.end();
        this.prettyPrinter.newline(0);
        return this;
    }

    public QueryBuilder from(String ... tables) {
        if (tables == null || tables.length == 0) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.write("FROM ");
        boolean first = true;
        for (String table : tables) {
            if (first) {
                first = false;
            } else {
                this.prettyPrinter.comma();
            }
            this.prettyPrinter.write(table);
        }
        return this;
    }

    public QueryBuilder from(Function<PrettyPrinter, QueryBuilder> queryBuilderFun, String alias) {
        if (queryBuilderFun == null || alias == null) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.write("FROM ");
        this.prettyPrinter.open();
        QueryBuilder queryBuilder = queryBuilderFun.apply(this.prettyPrinter);
        this.prettyPrinter.close();
        this.prettyPrinter.write(" ");
        this.prettyPrinter.write(alias);
        this.parameters.addAll(queryBuilder.parameters);
        return this;
    }

    public QueryBuilder join(String table) {
        if (table == null) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.write(" join ");
        this.prettyPrinter.write(table);
        return this;
    }

    public QueryBuilder join(Function<PrettyPrinter, QueryBuilder> queryBuilderFun, String alias) {
        if (queryBuilderFun == null || alias == null) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.newline(0);
        this.prettyPrinter.write("JOIN ");
        this.prettyPrinter.open();
        QueryBuilder queryBuilder = queryBuilderFun.apply(this.prettyPrinter);
        this.prettyPrinter.close();
        this.prettyPrinter.write(" ");
        this.prettyPrinter.write(alias);
        this.prettyPrinter.newline(0);
        this.parameters.addAll(queryBuilder.parameters);
        return this;
    }

    public QueryBuilder leftJoin(String table) {
        if (table == null) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.write(" LEFT JOIN ");
        this.prettyPrinter.write(table);
        return this;
    }

    public QueryBuilder rightJoin(String table) {
        if (table == null) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.write(" right join ");
        this.prettyPrinter.write(table);
        return this;
    }

    public QueryBuilder on(String ... predicates) {
        return this.filter("ON", predicates);
    }

    public QueryBuilder where(String ... predicates) {
        return this.filter(" WHERE", predicates);
    }

    private QueryBuilder filter(String clause, String ... predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.write(clause);
        this.prettyPrinter.write(" ");
        for (int i = 0; i < predicates.length; ++i) {
            if (i > 0) {
                this.prettyPrinter.write(" ");
            }
            this.append(predicates[i]);
        }
        return this;
    }

    public QueryBuilder and(String ... predicates) {
        return this.conditional(" AND", predicates);
    }

    public QueryBuilder or(String ... predicates) {
        return this.conditional(" OR", predicates);
    }

    private QueryBuilder conditional(String operator, String ... predicates) {
        if (predicates == null || predicates.length == 0) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.write(operator);
        this.prettyPrinter.write(" ");
        if (predicates.length > 1) {
            this.prettyPrinter.open();
        }
        for (int i = 0; i < predicates.length; ++i) {
            if (i > 0) {
                this.prettyPrinter.write(" ");
            }
            this.prettyPrinter.write(predicates[i]);
        }
        if (predicates.length > 1) {
            this.prettyPrinter.close();
        }
        return this;
    }

    public static String allOf(String ... predicates) {
        if (predicates == null || predicates.length == 0) {
            throw new IllegalArgumentException();
        }
        return QueryBuilder.conditionalGroup("and", predicates);
    }

    public static String anyOf(String ... predicates) {
        if (predicates == null || predicates.length == 0) {
            throw new IllegalArgumentException();
        }
        return QueryBuilder.conditionalGroup("or", predicates);
    }

    private static String conditionalGroup(String operator, String ... predicates) {
        if (predicates == null || predicates.length == 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < predicates.length; ++i) {
            if (i > 0) {
                stringBuilder.append(" ");
                stringBuilder.append(operator);
                stringBuilder.append(" ");
            }
            stringBuilder.append(predicates[i]);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String equalTo(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException();
        }
        return String.format("= (%s)", queryBuilder);
    }

    public static String notEqualTo(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException();
        }
        return String.format("!= (%s)", queryBuilder);
    }

    public static String in(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException();
        }
        return String.format("in (%s)", queryBuilder);
    }

    public static String notIn(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException();
        }
        return String.format("not in (%s)", queryBuilder);
    }

    public static String exists(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException();
        }
        return String.format("exists (%s)", queryBuilder);
    }

    public static String notExists(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException();
        }
        return String.format("not exists (%s)", queryBuilder);
    }

    public QueryBuilder orderBy(String ... columns) {
        if (columns == null || columns.length == 0) {
            throw new IllegalArgumentException();
        }
        this.sqlBuilder.append(" order by ");
        this.sqlBuilder.append(String.join((CharSequence)", ", columns));
        return this;
    }

    public QueryBuilder returning(Collection<String> outputs) {
        return this.returning(false, outputs);
    }

    public QueryBuilder returning(boolean brackets, Collection<String> outputs) {
        if (outputs == null || outputs.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.newline(0);
        this.prettyPrinter.write("RETURNING ");
        if (brackets) {
            this.prettyPrinter.open();
        } else {
            this.prettyPrinter.begin(0);
        }
        boolean first = true;
        for (String output : outputs) {
            if (first) {
                first = false;
            } else {
                this.prettyPrinter.comma();
            }
            this.prettyPrinter.write(output);
        }
        if (brackets) {
            this.prettyPrinter.close();
        } else {
            this.prettyPrinter.end();
        }
        return this;
    }

    public QueryBuilder alias(String alias) {
        this.prettyPrinter.write("AS ");
        this.prettyPrinter.write(alias);
        this.prettyPrinter.write(" ");
        return this;
    }

    public QueryBuilder comment(String comment) {
        this.prettyPrinter.newline(0);
        this.prettyPrinter.write("\n-- ");
        this.prettyPrinter.write(comment);
        this.prettyPrinter.newline(0);
        return this;
    }

    public QueryBuilder defaultValues() {
        this.prettyPrinter.write(" DEFAULT VALUES ");
        return this;
    }

    public QueryBuilder limit(int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        this.sqlBuilder.append(" limit ");
        this.sqlBuilder.append(count);
        return this;
    }

    public QueryBuilder forUpdate() {
        this.sqlBuilder.append(" for update");
        return this;
    }

    public QueryBuilder union(Function<PrettyPrinter, QueryBuilder> queryBuilderFun) {
        if (queryBuilderFun == null) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.write("UNION ");
        QueryBuilder queryBuilder = queryBuilderFun.apply(this.prettyPrinter);
        this.parameters.addAll(queryBuilder.parameters);
        return queryBuilder;
    }

    public QueryBuilder insertInto(String table) {
        if (table == null) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.begin(1);
        this.prettyPrinter.write("INSERT INTO ");
        this.prettyPrinter.write(table);
        this.prettyPrinter.end();
        return this;
    }

    public QueryBuilder values(Map<String, ?> values) {
        int i;
        if (values == null) {
            throw new IllegalArgumentException();
        }
        if (values.isEmpty()) {
            this.prettyPrinter.write(" DEFAULT VALUES ");
            return this;
        }
        this.prettyPrinter.open();
        ArrayList<String> columns = new ArrayList<String>(values.keySet());
        int n = columns.size();
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                this.prettyPrinter.comma();
            }
            this.prettyPrinter.write((String)columns.get(i));
        }
        this.prettyPrinter.close();
        this.prettyPrinter.newline(0);
        this.prettyPrinter.write("VALUES ");
        this.prettyPrinter.open();
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                this.prettyPrinter.comma();
            }
            this.encode(values.get(columns.get(i)));
        }
        this.prettyPrinter.close();
        return this;
    }

    public QueryBuilder args(List<?> values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        if (values.isEmpty()) {
            this.prettyPrinter.write("()");
            return this;
        }
        this.prettyPrinter.open();
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.prettyPrinter.comma();
            }
            this.prettyPrinter.write(String.valueOf(values.get(i)));
        }
        this.prettyPrinter.close();
        return this;
    }

    public QueryBuilder cte(Map<String, Function<PrettyPrinter, ?>> values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        if (values.isEmpty()) {
            return this;
        }
        this.prettyPrinter.write("WITH");
        this.prettyPrinter.begin(2);
        this.prettyPrinter.newline(0);
        ArrayList<String> columns = new ArrayList<String>(values.keySet());
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.prettyPrinter.comma();
            }
            this.prettyPrinter.write((String)columns.get(i));
            this.prettyPrinter.write(" AS ");
            this.encode(values.get(columns.get(i)));
        }
        this.prettyPrinter.end();
        this.prettyPrinter.newline(0);
        return this;
    }

    public static QueryBuilder update(String table) {
        if (table == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sqlBuilder = new StringBuilder();
        PrettyPrinter prettyPrinter = QueryBuilder.newPrettyPrinter(null);
        sqlBuilder.append("update ");
        sqlBuilder.append(table);
        prettyPrinter.write("update ");
        prettyPrinter.write(table);
        return new QueryBuilder(sqlBuilder, prettyPrinter);
    }

    public QueryBuilder set(Map<String, ?> values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        this.sqlBuilder.append(" set ");
        int i = 0;
        for (Map.Entry<String, ?> entry : values.entrySet()) {
            if (i > 0) {
                this.sqlBuilder.append(", ");
            }
            this.sqlBuilder.append(entry.getKey());
            this.sqlBuilder.append(" = ");
            this.encode(entry.getValue());
            ++i;
        }
        return this;
    }

    public QueryBuilder bodyEnd(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.end();
        this.prettyPrinter.newline(0);
        this.prettyPrinter.write("$");
        this.prettyPrinter.write(key);
        this.prettyPrinter.write("$ language SQL;\n");
        this.prettyPrinter.end();
        return this;
    }

    public QueryBuilder bodyStart(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.newline(0);
        this.prettyPrinter.begin(1);
        this.prettyPrinter.write("AS $");
        this.prettyPrinter.write(key);
        this.prettyPrinter.write("$");
        this.prettyPrinter.newline(0);
        return this;
    }

    public <T extends QueryBuilder> T next(Function<PrettyPrinter, T> qb) {
        if (qb == null) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.newline(0);
        this.prettyPrinter.begin(2);
        return (T)((QueryBuilder)qb.apply(this.prettyPrinter));
    }

    public QueryBuilder andThen(Supplier<Void> supplier) {
        this.suppliers.add(supplier);
        return this;
    }

    public QueryBuilder returns(String relation, Map<String, ?> params) {
        if (params == null || relation == null) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.newline(0);
        this.prettyPrinter.write("RETURNS ");
        this.prettyPrinter.write(relation);
        this.prettyPrinter.open();
        int i = 0;
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            if (i > 0) {
                this.prettyPrinter.comma();
            }
            this.prettyPrinter.write(entry.getKey());
            this.prettyPrinter.write(" ");
            this.encode(entry.getValue());
            ++i;
        }
        this.prettyPrinter.close();
        return this;
    }

    public QueryBuilder params(Map<String, ?> params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        this.prettyPrinter.open();
        int i = 0;
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            if (i > 0) {
                this.prettyPrinter.comma();
            }
            this.prettyPrinter.write(entry.getKey());
            this.prettyPrinter.write(" ");
            this.encode(entry.getValue());
            ++i;
        }
        this.prettyPrinter.close();
        return this;
    }

    public QueryBuilder end() {
        for (Supplier<Void> supplier : this.suppliers) {
            supplier.get();
        }
        this.prettyPrinter.end();
        return null;
    }

    public void flush() {
        this.prettyPrinter.flush();
    }

    public static Function<PrettyPrinter, FunctionQueryBuilder> createFunction(String fun) {
        return pp -> {
            if (fun == null) {
                throw new IllegalArgumentException();
            }
            StringBuilder sqlBuilder = new StringBuilder();
            pp.begin(1);
            pp.write("CREATE OR REPLACE FUNCTION ");
            pp.write(fun);
            return new FunctionQueryBuilder(sqlBuilder, (PrettyPrinter)pp);
        };
    }

    public static QueryBuilder deleteFrom(String table) {
        if (table == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sqlBuilder = new StringBuilder();
        PrettyPrinter prettyPrinter = QueryBuilder.newPrettyPrinter(null);
        sqlBuilder.append("delete from ");
        sqlBuilder.append(table);
        return new QueryBuilder(sqlBuilder, prettyPrinter);
    }

    public QueryBuilder execute(Connection connection) throws SQLException {
        return this.execute(connection, new HashMap());
    }

    public QueryBuilder execute(Connection connection, Map<String, ?> arguments) throws SQLException {
        block22: {
            if (connection == null || arguments == null) {
                throw new IllegalArgumentException();
            }
            try (PreparedStatement statement = this.prepare(connection);){
                this.apply(statement, arguments);
                if (statement.execute()) {
                    try (ResultSetAdapter resultSetAdapter = new ResultSetAdapter(statement.getResultSet());){
                        this.results = resultSetAdapter.stream().collect(Collectors.toList());
                        break block22;
                    }
                }
                this.updateCount = statement.getUpdateCount();
                try (ResultSet generatedKeys = statement.getGeneratedKeys();){
                    if (generatedKeys.next()) {
                        ResultSetMetaData generatedKeysMetaData = generatedKeys.getMetaData();
                        int n = generatedKeysMetaData.getColumnCount();
                        this.generatedKeys = new ArrayList<Object>(n);
                        for (int i = 0; i < n; ++i) {
                            this.generatedKeys.add(generatedKeys.getObject(i + 1));
                        }
                    } else {
                        this.generatedKeys = null;
                    }
                }
            }
        }
        return this;
    }

    public Map<String, Object> getResult() {
        if (this.results == null) {
            return null;
        }
        switch (this.results.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.results.get(0);
            }
        }
        throw new IllegalStateException("Unexpected result count.");
    }

    public List<Map<String, Object>> getResults() {
        return this.results;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public List<Object> getGeneratedKeys() {
        return this.generatedKeys;
    }

    public PreparedStatement prepare(Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        return connection.prepareStatement(this.getSQL(), 1);
    }

    public ResultSet executeQuery(PreparedStatement statement, Map<String, ?> arguments) throws SQLException {
        if (statement == null || arguments == null) {
            throw new IllegalArgumentException();
        }
        this.apply(statement, arguments);
        return statement.executeQuery();
    }

    public int executeUpdate(PreparedStatement statement, Map<String, ?> arguments) throws SQLException {
        if (statement == null || arguments == null) {
            throw new IllegalArgumentException();
        }
        this.apply(statement, arguments);
        return statement.executeUpdate();
    }

    private void apply(PreparedStatement statement, Map<String, ?> arguments) throws SQLException {
        int i = 1;
        for (String parameter : this.parameters) {
            if (parameter == null) continue;
            statement.setObject(i++, arguments.get(parameter));
        }
    }

    public Collection<String> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public String getSQL() {
        this.flush();
        return this.prettyPrinter.getOutputStream().toString();
    }

    private void append(String sql) {
        boolean quoted = false;
        int n = sql.length();
        int i = 0;
        while (i < n) {
            char c;
            if ((c = sql.charAt(i++)) == ':' && !quoted) {
                StringBuilder parameterBuilder = new StringBuilder();
                while (i < n && Character.isJavaIdentifierPart(c = sql.charAt(i))) {
                    parameterBuilder.append(c);
                    ++i;
                }
                if (parameterBuilder.length() == 0) {
                    // empty if block
                }
                this.parameters.add(parameterBuilder.toString());
                this.prettyPrinter.write("?");
                continue;
            }
            if (c == '?' && !quoted) {
                this.parameters.add(null);
                this.prettyPrinter.write(String.valueOf(c));
                continue;
            }
            if (c == '\'') {
                quoted = !quoted;
            }
            this.prettyPrinter.write(String.valueOf(c));
        }
    }

    static Unquote unquote(String val) {
        return new Unquote(val);
    }

    static Unquote arrayOf(String val) {
        return new Unquote(val + " []");
    }

    private void encode(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            if (string.startsWith(":") || string.equals("?")) {
                this.append(string);
            } else {
                this.prettyPrinter.write("'");
                int n = string.length();
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    if (c == '\'') {
                        this.prettyPrinter.write(String.valueOf(c));
                    }
                    this.prettyPrinter.write(String.valueOf(c));
                }
                this.prettyPrinter.write("'");
            }
        } else if (value instanceof Function) {
            Function queryBuilderMaker = (Function)value;
            this.prettyPrinter.open();
            this.prettyPrinter.begin(0);
            QueryBuilder queryBuilder = (QueryBuilder)queryBuilderMaker.apply(this.prettyPrinter);
            this.prettyPrinter.end();
            this.prettyPrinter.close();
            this.parameters.addAll(queryBuilder.parameters);
        } else {
            this.prettyPrinter.write(value.toString());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> parameterIterator = this.parameters.iterator();
        int n = this.sqlBuilder.length();
        for (int i = 0; i < n; ++i) {
            char c = this.sqlBuilder.charAt(i);
            if (c == '?') {
                String parameter = parameterIterator.next();
                if (parameter == null) {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append(':');
                stringBuilder.append(parameter);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static class Unquote {
        String val;

        public Unquote(String val) {
            this.val = val;
        }

        public String toString() {
            return this.val;
        }
    }

    static class FunctionQueryBuilder
    extends QueryBuilder {
        public FunctionQueryBuilder(StringBuilder sqlBuilder, PrettyPrinter prettyPrinter) {
            super(sqlBuilder, prettyPrinter);
        }

        @Override
        public QueryBuilder end() {
            this.prettyPrinter.end();
            return null;
        }
    }
}

