/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ResultSetAdapter
implements Iterable<Map<String, Object>>,
AutoCloseable {
    private ResultSet resultSet;
    private ResultSetMetaData resultSetMetaData;
    private Iterator<Map<String, Object>> iterator = new Iterator<Map<String, Object>>(){
        Boolean hasNext = null;

        @Override
        public boolean hasNext() {
            if (this.hasNext == null) {
                try {
                    this.hasNext = ResultSetAdapter.this.resultSet.next() ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (SQLException exception) {
                    throw new RuntimeException(exception);
                }
            }
            return this.hasNext;
        }

        @Override
        public Map<String, Object> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            try {
                int n = ResultSetAdapter.this.resultSetMetaData.getColumnCount();
                for (int i = 1; i <= n; ++i) {
                    row.put(ResultSetAdapter.this.resultSetMetaData.getColumnLabel(i), ResultSetAdapter.this.resultSet.getObject(i));
                }
            }
            catch (SQLException exception) {
                throw new RuntimeException(exception);
            }
            this.hasNext = null;
            return row;
        }
    };

    public ResultSetAdapter(ResultSet resultSet) {
        if (resultSet == null) {
            throw new IllegalArgumentException();
        }
        this.resultSet = resultSet;
        try {
            this.resultSetMetaData = resultSet.getMetaData();
        }
        catch (SQLException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        return this.iterator;
    }

    @Override
    public void close() throws SQLException {
        this.resultSet.close();
    }

    public Stream<Map<String, Object>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

