/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.descriptors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum InputFieldValue {
    Compulsory,
    Optional,
    False;

    private static final Map<String, InputFieldValue> namesMap;

    @JsonCreator
    public static InputFieldValue forValue(String value) {
        InputFieldValue inputFieldValue = namesMap.get(StringUtils.lowerCase((String)value));
        if (inputFieldValue == null) {
            throw new UnsupportedOperationException("Unknown input field value " + value);
        }
        return inputFieldValue;
    }

    @JsonValue
    public String toValue() {
        for (Map.Entry<String, InputFieldValue> entry : namesMap.entrySet()) {
            if (entry.getValue() != this) continue;
            return entry.getKey();
        }
        return null;
    }

    @JsonIgnore
    public static boolean isInput(InputFieldValue inputFieldValue) {
        if (inputFieldValue == null) {
            return false;
        }
        switch (inputFieldValue.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new UnsupportedOperationException("never reaching this point");
    }

    @JsonIgnore
    public static boolean isCompulsoryInput(InputFieldValue inputFieldValue) {
        if (inputFieldValue == null) {
            return false;
        }
        switch (inputFieldValue.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
        }
        throw new UnsupportedOperationException("never reaching this point");
    }

    static {
        namesMap = new HashMap<String, InputFieldValue>(3);
        namesMap.put("compulsory", Compulsory);
        namesMap.put("optional", Optional);
        namesMap.put("false", False);
    }
}

