/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.emitter.minilanguage;

import java.util.List;
import org.openprovenance.prov.template.emitter.Element;
import org.openprovenance.prov.template.emitter.minilanguage.Expression;
import org.openprovenance.prov.template.emitter.minilanguage.emitters.Python;

public class Constructor
extends Expression {
    private final String type;
    private final List<Expression> array;

    public Constructor(String type, List<Element> elements) {
        super(elements);
        this.type = type;
        this.array = null;
    }

    public Constructor(String type, List<Expression> array, List<Element> elements) {
        super(elements);
        this.type = type;
        this.array = array;
    }

    @Override
    public String toString() {
        return "Constructor{type='" + this.type + "'}";
    }

    @Override
    public void emit(Python emitter, boolean continueLine, List<String> classVariables, List<String> instanceVariables) {
        if (this.type.equals("java.lang.StringBuffer")) {
            emitter.emitLine("[]", continueLine);
        } else if (this.type.startsWith("java.util.HashMap<")) {
            emitter.emitLine("{}", continueLine);
        } else if (this.type.contains(".")) {
            if (this.array != null) {
                emitter.emitContinueLine("[");
                boolean first = true;
                for (Expression e : this.array) {
                    if (!first) {
                        emitter.emitContinueLine(", ");
                    } else {
                        first = false;
                    }
                    e.emit(emitter, true, classVariables, instanceVariables);
                }
                emitter.emitContinueLine("]");
            } else {
                String[] parts = this.type.split("\\.");
                String localType = parts[parts.length - 1];
                emitter.getImports().add("from " + this.type + " import " + localType);
                emitter.emitLine(localType, continueLine);
                emitter.emitContinueLine("()");
            }
        } else {
            emitter.emitLine(this.type + "()", continueLine);
        }
    }
}

