/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.emitter.minilanguage;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.openprovenance.prov.template.emitter.Element;
import org.openprovenance.prov.template.emitter.Pair;
import org.openprovenance.prov.template.emitter.Token;
import org.openprovenance.prov.template.emitter.minilanguage.BinaryOp;
import org.openprovenance.prov.template.emitter.minilanguage.Constant;
import org.openprovenance.prov.template.emitter.minilanguage.Constructor;
import org.openprovenance.prov.template.emitter.minilanguage.Lambda;
import org.openprovenance.prov.template.emitter.minilanguage.MethodCall;
import org.openprovenance.prov.template.emitter.minilanguage.Parameter;
import org.openprovenance.prov.template.emitter.minilanguage.Statement;
import org.openprovenance.prov.template.emitter.minilanguage.Symbol;
import org.openprovenance.prov.template.emitter.minilanguage.emitters.Python;

public class Expression
extends Statement {
    public Expression(List<Element> elements) {
        super(elements);
    }

    public static Expression makeExpression(List<Element> elements) {
        if (elements.size() == 1 && elements.get(0) instanceof Pair && Pair.getFormat(elements.get(0)).equals("$N")) {
            return new Symbol((String)Pair.getArg(elements.get(0)), elements);
        }
        if (elements.size() == 1 && elements.get(0) instanceof Pair && Pair.getFormat(elements.get(0)).equals("$S")) {
            return new Constant((String)Pair.getArg(elements.get(0)), elements);
        }
        if (elements.size() == 1 && elements.get(0) instanceof Pair && Pair.getFormat(elements.get(0)).equals("$L")) {
            return (Expression)((List)Pair.getArg(elements.get(0))).get(0);
        }
        if (elements.size() > 1 && Pair.isPair(elements.get(0)) && "/*#lambda#*/".equals(Pair.getArg(elements.get(0)))) {
            List<Element> ll = elements.subList(1, elements.size());
            assert (ll.size() == 1);
            List parameters_and_body = ((List)Pair.getArg(ll.get(0))).stream().map(x -> Expression.makeStatement(x.getElements())).collect(Collectors.toList());
            List<Element> parameterElements = ((Statement)parameters_and_body.get(0)).getElements();
            assert (parameterElements.size() > 4);
            assert (parameterElements.get(0).equals(new Token("(")));
            assert (parameterElements.get(1) instanceof Pair);
            assert (parameterElements.get(2).equals(new Token(") -> ")));
            List<Element> _params = ((Expression)((List)Pair.getArg(parameterElements.get(1))).get(0)).getElements();
            LinkedList<Parameter> parameters = new LinkedList<Parameter>();
            Parameter parameter = null;
            for (Element e : _params) {
                if (e instanceof Pair) {
                    Pair p = (Pair)e;
                    if (p.getFormatPart().equals("$T")) {
                        parameter = new Parameter(null, p.getArg().toString());
                        continue;
                    }
                    if (!p.getFormatPart().equals("$N")) continue;
                    assert (parameter != null);
                    parameter.name = p.getArg().toString();
                    parameters.add(parameter);
                    continue;
                }
                if (e instanceof Token) {
                    assert (Pair.getToken(e).equals(", "));
                    continue;
                }
                throw new UnsupportedOperationException("Cannot handle " + String.valueOf(e));
            }
            List<Statement> body = parameters_and_body.subList(1, parameters_and_body.size());
            return new Lambda(parameters, body, elements);
        }
        if (elements.size() > 1 && Pair.isPair(elements.get(0)) && "new".equals(Pair.getArg(elements.get(0)))) {
            if (elements.size() > 3 && Pair.isPair(elements.get(2)) && "/*#array#*/".equals(Pair.getArg(elements.get(2)))) {
                List<Element> allArgs = elements.subList(3, elements.size());
                return new Constructor(Pair.getArg(elements.get(1)).toString(), Expression.makeExpressions(allArgs), elements);
            }
            return new Constructor(Pair.getArg(elements.get(1)).toString(), elements);
        }
        if (elements.size() > 3 && elements.get(1) instanceof Token && Pair.getToken(elements.get(1)).equals(".")) {
            List<Element> allArgsIncludingMarkers = elements.subList(3, elements.size());
            if (allArgsIncludingMarkers.size() == 1 && allArgsIncludingMarkers.get(0).equals(new Token("()"))) {
                return new MethodCall(((Pair)elements.get(0)).getArg(), (String)((Pair)elements.get(2)).getArg(), new LinkedList(), elements);
            }
            if (allArgsIncludingMarkers.size() == 3 && allArgsIncludingMarkers.get(0).equals(new Token("(")) && allArgsIncludingMarkers.get(2).equals(new Token(")"))) {
                Object arg = Pair.getArg(allArgsIncludingMarkers.get(1));
                String format = Pair.getFormat(allArgsIncludingMarkers.get(1));
                if (arg instanceof List) {
                    List ll = (List)arg;
                    assert (ll.size() == 1);
                    List<Element> _elements = ((Statement)ll.get(0)).getElements();
                    List args = _elements.stream().filter(x -> x instanceof Pair).map(x -> ((Pair)x).getArg()).collect(Collectors.toList());
                    return new MethodCall(Pair.getArg(elements.get(0)), (String)Pair.getArg(elements.get(2)), args, elements);
                }
                if (arg instanceof String) {
                    LinkedList<Object> args = new LinkedList<Object>();
                    if (format.equals("$S")) {
                        args.add("\"" + String.valueOf(arg) + "\"");
                    } else {
                        args.add(arg);
                    }
                    return new MethodCall(((Pair)elements.get(0)).getArg(), (String)((Pair)elements.get(2)).getArg(), args, elements);
                }
                throw new UnsupportedOperationException("Cannot handle " + String.valueOf(arg));
            }
            if (allArgsIncludingMarkers.get(0).equals(new Token("("))) {
                return new MethodCall(((Pair)elements.get(0)).getArg(), (String)((Pair)elements.get(2)).getArg(), Expression.makeExpressions(allArgsIncludingMarkers.subList(1, allArgsIncludingMarkers.size())), elements);
            }
            if (allArgsIncludingMarkers.get(0).equals(new Token("."))) {
                MethodCall object = new MethodCall(((Pair)elements.get(0)).getArg(), (String)((Pair)elements.get(2)).getArg(), null, elements);
                allArgsIncludingMarkers.add(0, new Pair("$L", object));
                return Expression.makeExpression(allArgsIncludingMarkers);
            }
            if (allArgsIncludingMarkers.get(0).equals(new Token("()."))) {
                MethodCall object = new MethodCall(((Pair)elements.get(0)).getArg(), (String)((Pair)elements.get(2)).getArg(), new LinkedList(), elements);
                allArgsIncludingMarkers.remove(0);
                allArgsIncludingMarkers.add(0, new Token("."));
                allArgsIncludingMarkers.add(0, new Pair("$L", object));
                return Expression.makeExpression(allArgsIncludingMarkers);
            }
            System.out.println("Falling through " + String.valueOf(elements));
            System.out.println(" Falling through " + String.valueOf(allArgsIncludingMarkers));
            return Expression.makeExpression(allArgsIncludingMarkers);
        }
        if (elements.size() > 3 && Expression.tokenExists(elements, 1, "(")) {
            List<Element> allArgs = elements.subList(2, elements.size());
            List<Expression> arguments = Expression.makeExpressions(allArgs);
            assert (arguments.size() == 1);
            List<Element> _elements = arguments.get(0).getElements();
            if ("new".equals(Pair.getArg(_elements.get(0)))) {
                return new MethodCall(null, (String)((Pair)elements.get(0)).getArg(), arguments, elements);
            }
            List args = _elements.stream().filter(x -> x instanceof Pair).map(x -> ((Pair)x).getArg()).collect(Collectors.toList());
            return new MethodCall(null, (String)((Pair)elements.get(0)).getArg(), args, elements);
        }
        if (elements.size() >= 3 && Expression.tokenExists(elements, 1, "==")) {
            return new BinaryOp(Pair.getArg(elements.get(0)), Pair.getToken(elements.get(1)), Pair.getArg(elements.get(2)), elements);
        }
        return new Expression(elements);
    }

    private static List<Expression> makeExpressions(List<Element> elements) {
        LinkedList ll = new LinkedList();
        LinkedList<Element> current = new LinkedList<Element>();
        for (Element e : elements) {
            if (e instanceof Pair && Pair.getArg(e).equals("/*#params#*/")) {
                ll.add(current);
                current = new LinkedList();
                continue;
            }
            if (e instanceof Token && (Pair.getToken(e).equals(",") || Pair.getToken(e).equals("}") || Pair.getToken(e).equals(")"))) continue;
            current.add(e);
        }
        if (!current.isEmpty()) {
            ll.add(current);
        }
        return ll.stream().map(Expression::makeExpression).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        return "Expression{elements=" + String.valueOf(this.elements) + "}";
    }

    @Override
    public void emit(Python emitter, List<String> classVariables, List<String> instanceVariables) {
        this.emit(emitter, false, classVariables, instanceVariables);
    }

    public void emit(Python emitter, boolean continueLine, List<String> classVariables, List<String> instanceVariables) {
        emitter.emitLine("#" + this.toString());
    }
}

