/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.emitter.minilanguage;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.template.emitter.minilanguage.Comment;
import org.openprovenance.prov.template.emitter.minilanguage.Expression;
import org.openprovenance.prov.template.emitter.minilanguage.Lambda;
import org.openprovenance.prov.template.emitter.minilanguage.Method;
import org.openprovenance.prov.template.emitter.minilanguage.Parameter;
import org.openprovenance.prov.template.emitter.minilanguage.Statement;
import org.openprovenance.prov.template.emitter.minilanguage.emitters.Python;

public class Field {
    public final String name;
    private final List<String> attributes = new LinkedList<String>();
    private final String type;
    public final Expression initialiser;
    private final List<Comment> comments = new LinkedList<Comment>();
    static final Map<String, String> typeConversionTable = new HashMap<String, String>(){
        {
            this.put("org.openprovenance.prov.client.Builder[]", "List[Builder]");
            this.put("java.util.Map<java.lang.String, org.openprovenance.prov.client.Builder>", "Dict[str,Builder]");
            this.put("java.util.Map<java.lang.String, org.openprovenance.prov.client.ProcessorArgsInterface<?>>", "Dict[str,ProcessorArgsInterface]");
        }
    };
    static final Map<String, String[]> typeToImportsTable = new HashMap<String, String[]>(){
        {
            this.put("org.openprovenance.prov.client.Builder[]", new String[]{"from typing import List", "from org.openprovenance.prov.client.Builder import Builder"});
            this.put("java.util.Map<java.lang.String, org.openprovenance.prov.client.Builder>", new String[]{"from typing import Dict"});
            this.put("java.util.Map<java.lang.String, org.openprovenance.prov.client.ProcessorArgsInterface<?>>", new String[]{"from org.openprovenance.prov.client.ProcessorArgsInterface import ProcessorArgsInterface"});
        }
    };

    public Field(String name, String type, List<String> attributes, Expression initialiser, List<Comment> comments) {
        this.name = name;
        this.type = type;
        this.attributes.addAll(attributes);
        this.initialiser = initialiser;
        this.comments.addAll(comments);
    }

    public void emit(Python emitter) {
        this.emit(emitter, false);
    }

    public void emit(Python emitter, boolean continueLine) {
        for (Comment c : this.comments) {
            if (c.comment == null || c.comment.trim().isEmpty()) continue;
            emitter.emitLine("#" + c.comment, continueLine);
            emitter.emitNewline();
        }
        if (this.name.equals("aArgs2BeanConverter")) {
            Lambda lambda = (Lambda)this.initialiser;
            List<Parameter> parameters = lambda.parameters;
            List<Statement> body = lambda.body;
            Method method = new Method();
            method.name = "aArgs2BeanConverter";
            method.parameters = parameters;
            method.body = body;
            method.modifiers = Collections.singleton(Modifier.STATIC);
            method.emit(emitter, new LinkedList<String>(), new LinkedList<String>());
        } else {
            emitter.emitBeginLine(this.name);
            String mappedType = typeConversionTable.get(this.type);
            if (mappedType != null) {
                emitter.emitContinueLine(" : " + mappedType);
                String[] imprts = this.getImportTypes(this.type);
                if (imprts != null) {
                    Arrays.asList(imprts).forEach(imprt -> emitter.getImports().add((String)imprt));
                }
            } else if (this.type != null && !this.type.trim().isEmpty()) {
                if (this.type.contains(".")) {
                    String[] parts = this.type.split("\\.");
                    String localType = parts[parts.length - 1];
                    emitter.getImports().add("from " + this.type + " import " + localType);
                    emitter.emitContinueLine(" : " + Field.convertType(localType));
                } else {
                    emitter.emitContinueLine(" : " + this.type);
                }
            }
            if (this.initialiser != null && !this.initialiser.toString().trim().isEmpty()) {
                emitter.emitContinueLine(" = ");
                this.initialiser.emit(emitter, true, new LinkedList<String>(), new LinkedList<String>());
            } else {
                emitter.emitContinueLine(" = None");
            }
        }
        emitter.emitNewline();
        emitter.emitNewline();
    }

    public String toString() {
        return "Field{name='" + this.name + "', attributes=" + String.valueOf(this.attributes) + ", type='" + this.type + "', initialiser=" + String.valueOf(this.initialiser) + ", comments=" + String.valueOf(this.comments) + "}";
    }

    public static String convertType(String type) {
        String res = typeConversionTable.get(type);
        if (res != null) {
            return res;
        }
        if (type.contains("<")) {
            return type.substring(0, type.indexOf("<"));
        }
        return type;
    }

    private String[] getImportTypes(String type) {
        String[] strings = typeToImportsTable.get(type);
        if (strings != null) {
            return strings;
        }
        if (type.contains("<") && type.contains(">")) {
            String contentType = type.substring(type.indexOf("<") + 1, type.indexOf(">"));
            System.out.println("contentType=" + contentType);
            if (contentType.contains(".")) {
                String[] parts = contentType.split("\\.");
                String localType = parts[parts.length - 1];
                return new String[]{"from " + contentType + " import " + localType};
            }
        }
        return null;
    }
}

