/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.HashSet;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.CompositeTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesProjectConfiguration;

public class CompilerBeanCompleter3 {
    private final CompilerUtil compilerUtil;
    private final boolean debugComment = true;

    public CompilerBeanCompleter3(ProvFactory pFactory) {
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    SpecificationFile generateBeanCompleter3(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        CompositeTemplateCompilerConfig config1;
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("BeanCompleter3");
        builder.superclass((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter2"), (String)"BeanCompleter2", (String[])new String[0]));
        builder.addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC});
        MethodSpec.Builder cbuilder2 = MethodSpec.constructorBuilder();
        this.compilerUtil.specWithComment(cbuilder2);
        cbuilder2.addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(CompilerUtil.mapType, "m", new Modifier[0]).addStatement("super(m)", new Object[0]);
        builder.addMethod(cbuilder2.build());
        MethodSpec.Builder cbuilder3 = MethodSpec.constructorBuilder();
        this.compilerUtil.specWithComment(cbuilder3);
        cbuilder3.addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeVariableName.get((String)"Getter"), "getter", new Modifier[0]).addStatement("super(getter)", new Object[0]);
        builder.addMethod(cbuilder3.build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getValueFromLocation").addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).returns(Integer.class).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"setValueInLocation").addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).returns(TypeName.VOID).build());
        HashSet<String> composeeTemplates = new HashSet<String>();
        for (TemplateCompilerConfig config : configs.templates) {
            if (!(config instanceof CompositeTemplateCompilerConfig)) continue;
            config1 = (CompositeTemplateCompilerConfig)config;
            composeeTemplates.add(config1.consistsOf);
        }
        for (TemplateCompilerConfig config : configs.templates) {
            locations.updateWithConfig(config);
            if (config instanceof SimpleTemplateCompilerConfig) {
                if (!composeeTemplates.contains(config.name)) continue;
                String outputBeanNameClass = this.compilerUtil.outputsNameClass(config.name);
                ClassName outputClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.OUTPUTS), (String)outputBeanNameClass, (String[])new String[0]);
                MethodSpec.Builder mspec = this.createSimpleProcessMethod(outputClassName, config.name);
                builder.addMethod(mspec.build());
                continue;
            }
            config1 = (CompositeTemplateCompilerConfig)config;
            String outputBeanNameClass = this.compilerUtil.outputsNameClass(config.name);
            ClassName outputClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.OUTPUTS), (String)outputBeanNameClass, (String[])new String[0]);
            MethodSpec.Builder mspec = this.createCompositeProcessMethod(config.name, outputClassName);
            builder.addMethod(mspec.build());
        }
        TypeSpec theLogger = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(myPackage), fileName + ".java", myPackage);
    }

    private MethodSpec.Builder createSimpleProcessMethod(ClassName outputClassName, String template) {
        MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)outputClassName, (String)"bean", (Modifier[])new Modifier[0]).build()).returns((TypeName)outputClassName);
        this.compilerUtil.specWithComment(mspec);
        mspec.addStatement("super.$N($N)", new Object[]{"process", "bean"});
        mspec.addStatement("setValueInLocation()", new Object[0]);
        mspec.addStatement("return $N", new Object[]{"bean"});
        mspec.addAnnotation(Override.class);
        return mspec;
    }

    private MethodSpec.Builder createCompositeProcessMethod(String template, ClassName outputClassName) {
        MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)outputClassName, (String)"bean", (Modifier[])new Modifier[0]).build()).returns((TypeName)outputClassName);
        this.compilerUtil.specWithComment(mspec);
        mspec.addStatement("$T result=super.$N($N)", new Object[]{outputClassName, "process", "bean"});
        mspec.addStatement("result.ID=getValueFromLocation()", new Object[0]);
        mspec.addStatement("$N($N.ID,$S)", new Object[]{"postEnactmentProcessing", "result", template});
        mspec.addStatement("return $N", new Object[]{"result"});
        mspec.addAnnotation(Override.class);
        return mspec;
    }
}

