/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesProjectConfiguration;

public class CompilerDelegator {
    private final CompilerUtil compilerUtil;

    public CompilerDelegator(ProvFactory pFactory) {
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    public SpecificationFile generateDelegator(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("Delegator");
        ClassName beanProcessorClass = this.compilerUtil.getClass("BeanProcessor", locations);
        builder.addSuperinterface((TypeName)beanProcessorClass);
        builder.addJavadoc("Delegator for processing beans\n", new Object[0]);
        builder.addField((TypeName)beanProcessorClass, "delegator", new Modifier[]{Modifier.FINAL, Modifier.PRIVATE});
        MethodSpec.Builder mspec2 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)beanProcessorClass, "delegator", new Modifier[0]);
        CodeBlock.Builder jdoc = CodeBlock.builder();
        jdoc.add("Constructor for Delegator\n", new Object[0]);
        jdoc.add("@param delegator a processor to which processing of beans is delegated\n", new Object[0]);
        mspec2.addJavadoc(jdoc.build());
        this.compilerUtil.specWithComment(mspec2);
        mspec2.addStatement("this.$N=$N", new Object[]{"delegator", "delegator"});
        builder.addMethod(mspec2.build());
        for (TemplateCompilerConfig config : configs.templates) {
            String beanNameClass = this.compilerUtil.commonNameClass(config.name);
            locations.updateWithConfig(config);
            ClassName className = ClassName.get((String)locations.getFilePackage(BeanDirection.COMMON), (String)beanNameClass, (String[])new String[0]);
            MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)className, (String)"bean", (Modifier[])new Modifier[0]).build()).returns((TypeName)className);
            this.compilerUtil.specWithComment(mspec);
            CodeBlock.Builder jdoc2 = CodeBlock.builder();
            jdoc2.add("Porcessing method\n", new Object[0]);
            jdoc2.add("@param bean an input bean\n", new Object[0]);
            jdoc2.add("@return a processed bean\n", new Object[0]);
            mspec.addJavadoc(jdoc2.build());
            mspec.addStatement("return $N.process($N)", new Object[]{"delegator", "bean"});
            builder.addMethod(mspec.build());
        }
        TypeSpec theLogger = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(myPackage), fileName + ".java", myPackage);
    }
}

