/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationMessage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.JsonSchemaTesting;
import org.openprovenance.prov.template.descriptors.AttributeDescriptor;
import org.openprovenance.prov.template.descriptors.Descriptor;
import org.openprovenance.prov.template.descriptors.NameDescriptor;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;

public class CompilerJsonSchema {
    private final CompilerUtil compilerUtil;
    private final ProvFactory pFactory;
    ObjectMapper om = new ObjectMapper();
    Map<String, Object> jsonSchemaAsAMap = this.initializeSchemaMap();
    boolean draft04 = false;
    final Tester tester = new Tester();

    public CompilerJsonSchema(ProvFactory pFactory) {
        this.compilerUtil = new CompilerUtil(pFactory);
        this.pFactory = pFactory;
    }

    public void generateJSonSchemaEnd(String jsonschema, String root_dir) {
        new File(root_dir).mkdirs();
        String path = root_dir + "/" + jsonschema;
        this.jsonSchemaAsAMap.put(this.get$id(), "https://openprovenance.org/template/beans#" + jsonschema);
        this.jsonSchemaAsAMap.put("type", "object");
        this.jsonSchemaAsAMap.put("title", "The Root Schema");
        try {
            this.om.writerWithDefaultPrettyPrinter().writeValue(new File(path), this.jsonSchemaAsAMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> initializeSchemaMap() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("definitions", new HashMap());
        res.put("allOf", new LinkedList());
        res.put("type", "object");
        return res;
    }

    public void generateJSonSchema(String templateName, TemplateBindingsSchema bindingsSchema, String consistsOf, String idPrefix, List<String> sharing) {
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        HashMap<String, Object> aSchema = new HashMap<String, Object>();
        aSchema.put(this.get$id(), idPrefix + templateName);
        aSchema.put("type", "object");
        HashMap properties = new HashMap();
        aSchema.put("properties", properties);
        LinkedList<String> requiredProperties = new LinkedList<String>();
        requiredProperties.add("isA");
        for (String key : variables) {
            Descriptor descriptor;
            String documentation;
            requiredProperties.add(key);
            HashMap<String, Object> atype = new HashMap<String, Object>();
            atype.put(this.get$id(), idPrefix + templateName + "/properties/" + key);
            atype.put("title", this.title(key));
            String jsonType = CompilerJsonSchema.convertToJsonType(this.compilerUtil.getJavaTypeForDeclaredType(theVar, key).getName());
            atype.put("type", jsonType);
            if (consistsOf != null && key.equals("type")) {
                atype.put("readOnly", "true");
                atype.put("default", consistsOf);
            }
            if ((documentation = ConfigProcessor.descriptorUtils.getFromDescriptor(descriptor = theVar.get(key).get(0), AttributeDescriptor::getDocumentation, NameDescriptor::getDocumentation)) == null) {
                documentation = "";
            }
            atype.put("description", documentation + " (" + jsonType + ")");
            properties.put(key, atype);
        }
        if (consistsOf != null) {
            String elementKey = "__elements";
            requiredProperties.add(elementKey);
            HashMap<String, Object> atype2 = new HashMap<String, Object>();
            atype2.put(this.get$id(), idPrefix + templateName + "/properties/" + elementKey);
            atype2.put("title", this.title(elementKey));
            atype2.put("type", "array");
            Map subschema = (Map)((Map)this.jsonSchemaAsAMap.get("definitions")).get(consistsOf);
            HashMap<String, CallSite> subschema2 = subschema == null ? new HashMap<String, CallSite>() : new HashMap(subschema);
            subschema2.put("title", (CallSite)((Object)(consistsOf + " {{idx}}")));
            Map propertiesMap = (Map)subschema2.get("properties");
            for (String sharingKey : sharing) {
                Map sharedKeyMap = (Map)propertiesMap.get(sharingKey);
                sharedKeyMap.put("required", "true");
                if ("integer".equals(sharedKeyMap.get("type"))) {
                    sharedKeyMap.put("maximum", -1);
                    sharedKeyMap.put("description", "<span class='shared_var'>Shared variable:</span> " + ((String)sharedKeyMap.get("description")).replace("integer", "<span class='shared_var'>convention: negative integer</span>"));
                    continue;
                }
                sharedKeyMap.put("description", "<span class='shared_var'>Shared variable:</span> " + String.valueOf(sharedKeyMap.get("description")));
            }
            atype2.put("items", subschema2);
            properties.put(elementKey, atype2);
            ((Map)properties.get("count")).put("readOnly", "true");
        }
        String key = "isA";
        HashMap<String, Object> atype = new HashMap<String, Object>();
        atype.put(this.get$id(), idPrefix + templateName + "/properties/" + key);
        atype.put("title", this.title(key));
        atype.put("type", "string");
        atype.put("readOnly", "true");
        atype.put("default", templateName);
        atype.put("pattern", "^" + templateName + "$");
        properties.put(key, atype);
        atype.put("required", true);
        this.jsonSchemaAsAMap.put("properties", Map.of("isA", Map.of("type", "string", "pattern", "^template_block$")));
        aSchema.put("required", requiredProperties);
        aSchema.put("additionalProperties", false);
        ((Map)this.jsonSchemaAsAMap.get("definitions")).put(templateName, aSchema);
        HashMap<String, Map<Object, Object>> ifThenBlock = new HashMap<String, Map<Object, Object>>();
        HashMap<String, Object> ifBlock = new HashMap<String, Object>();
        ifThenBlock.put("if", ifBlock);
        ifThenBlock.put("then", Map.of("$ref", idPrefix + templateName));
        ifBlock.put("type", "object");
        ifBlock.put("properties", Map.of("isA", Map.of("const", templateName)));
        ((List)this.jsonSchemaAsAMap.get("allOf")).add(ifThenBlock);
    }

    public Object defaultValue(String jsonType) {
        switch (jsonType) {
            case "integer": {
                return 0;
            }
            case "float": {
                return 0.0;
            }
        }
        return null;
    }

    public String title(String key) {
        return key;
    }

    public String get$id() {
        if (this.draft04) {
            return "id";
        }
        return "$id";
    }

    static String convertToJsonType(String name) {
        switch (name) {
            case "java.lang.String": {
                return "string";
            }
            case "java.lang.Integer": {
                return "integer";
            }
            case "java.lang.Float": {
                return "number";
            }
            case "java.lang.Double": {
                return "number";
            }
            case "java.lang.Boolean": {
                return "boolean";
            }
        }
        throw new UnsupportedOperationException("conversion to json type " + name);
    }

    public JsonSchema setupJsonSchemaFromClasspath(String file) {
        System.out.println("### getting schema from classpath " + file);
        JsonSchema schema2 = this.tester.getJsonSchemaFromClasspath(file);
        return schema2;
    }

    public JsonSchema setupJsonSchemaFromClasspathV7(String file) {
        System.out.println("### getting schema from classpath " + file);
        JsonSchema schema2 = this.tester.getJsonSchemaFromClasspathV7(file);
        return schema2;
    }

    public JsonSchema setupJsonSchemaFromFile(String file) throws FileNotFoundException {
        System.out.println("#### getting schema from File " + file);
        JsonSchema schema2 = this.tester.getJsonSchemaFromFile(file);
        return schema2;
    }

    public Set<ValidationMessage> checkSchema(JsonSchema schema, String file) throws IOException {
        JsonNode node = this.om.readTree(new File(file));
        Set errors = schema.validate(node);
        return errors;
    }

    static class Tester
    extends JsonSchemaTesting {
        Tester() {
        }

        @Override
        public JsonSchema getJsonSchemaFromClasspath(String name) {
            return super.getJsonSchemaFromClasspath(name);
        }

        @Override
        public JsonSchema getJsonSchemaFromClasspathV7(String name) {
            return super.getJsonSchemaFromClasspathV7(name);
        }

        @Override
        protected JsonSchema getJsonSchemaFromFile(String name) throws FileNotFoundException {
            return super.getJsonSchemaFromFile(name);
        }
    }
}

