/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.lang.model.element.Modifier;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.openprovenance.prov.configuration.Configuration;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesProjectConfiguration;

public class CompilerMaven {
    private final ConfigProcessor configProcessor;
    private final CompilerUtil compilerUtil;

    public CompilerMaven(ProvFactory pFactory, ConfigProcessor configProcessor) {
        this.configProcessor = configProcessor;
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    public boolean makeRootPom(TemplatesProjectConfiguration configs, String root_dir, String cli_lib, String l2p_lib) {
        Model model = new Model();
        model.setGroupId(configs.group);
        model.setArtifactId(configs.name);
        model.setVersion(configs.version);
        model.setName(configs.name);
        model.setPackaging("pom");
        model.setDescription(configs.description);
        model.setModelVersion("4.0.0");
        model.addModule(cli_lib);
        model.addModule(l2p_lib);
        this.addCompilerDeclaration(model);
        this.addJunitDependency(model);
        try {
            new MavenXpp3Writer().write((Writer)new FileWriter(root_dir + "/pom.xml"), model);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean makeSubPom(TemplatesProjectConfiguration configs, String dir, String name, boolean dependencies, boolean jsweet, boolean jackson, boolean escape) {
        Model model = new Model();
        model.setArtifactId(name);
        model.setName(name);
        model.setPackaging("jar");
        model.setDescription(configs.description + " (" + name + ")");
        Parent parent = new Parent();
        parent.setArtifactId(configs.name);
        parent.setGroupId(configs.group);
        parent.setVersion(configs.version);
        model.setParent(parent);
        model.setModelVersion("4.0.0");
        if (dependencies) {
            this.addClientBuilderDependency(name.replace("l2p", "cli"), configs.group, configs.version, model);
            this.addProvDependency("prov-model", model);
            this.addProvDependency("prov-n", model);
            this.addProvDependency("prov-template-compiler", model);
            this.addProvDependency("prov-interop", model);
        } else if (escape) {
            this.addProvDependency("prov-model", model);
        }
        if (jsweet) {
            this.addJSweetDependency(model);
            this.addProvDependency("prov-jsweet-candy-java", model);
        }
        if (jackson) {
            this.addJacksonDependency(model);
        }
        if (jsweet) {
            this.addBuildHelperMavenPlugin(model);
        }
        try {
            new MavenXpp3Writer().write((Writer)new FileWriter(dir + "/pom.xml"), model);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getProvPackageId() {
        return "org.openprovenance.prov";
    }

    public void addClientBuilderDependency(String artifact, String group, String version, Model model) {
        Dependency dep = new Dependency();
        dep.setArtifactId(artifact);
        dep.setGroupId(group);
        dep.setVersion(version);
        model.addDependency(dep);
    }

    public void addProvDependency(String artifact, Model model) {
        Dependency dep = new Dependency();
        dep.setArtifactId(artifact);
        dep.setGroupId(this.getProvPackageId());
        dep.setVersion(this.getProvVersion());
        model.addDependency(dep);
    }

    public void addJunitDependency(Model model) {
        Dependency dep = new Dependency();
        dep.setArtifactId("junit");
        dep.setGroupId("junit");
        dep.setVersion("4.11");
        dep.setScope("test");
        model.addDependency(dep);
    }

    public void addJacksonDependency(Model model) {
        Dependency dep = new Dependency();
        dep.setArtifactId("jackson-databind");
        dep.setGroupId("com.fasterxml.jackson.core");
        dep.setVersion("2.9.9");
        dep.setScope("test");
        model.addDependency(dep);
    }

    public void addJSweetDependency(Model model) {
        Plugin plugin = new Plugin();
        plugin.setArtifactId("jsweet-maven-plugin");
        plugin.setGroupId("org.jsweet");
        plugin.setVersion("3.1.0");
        StringBuilder configString = new StringBuilder().append("<configuration>").append("<verbose>false</verbose>").append("<outDir>target/js</outDir>").append("<tsOut>target/ts</tsOut>").append("<candiesJsOut>webapp/candies</candiesJsOut>").append("<targetVersion>ES6</targetVersion>").append("<module>none</module>").append("<moduleResolution>classic</moduleResolution>").append("</configuration>");
        Xpp3Dom config = null;
        try {
            config = Xpp3DomBuilder.build((Reader)new StringReader(configString.toString()));
        }
        catch (IOException | XmlPullParserException ex) {
            throw new RuntimeException("Issue creating config for enforcer plugin", ex);
        }
        plugin.setConfiguration((Object)config);
        PluginExecution pe1 = new PluginExecution();
        pe1.addGoal("jsweet");
        pe1.setId("generate-js");
        pe1.setPhase("generate-sources");
        PluginExecution pe2 = new PluginExecution();
        pe2.addGoal("clean");
        pe2.setId("clean");
        pe2.setPhase("clean");
        plugin.addExecution(pe1);
        plugin.addExecution(pe2);
        Build b = new Build();
        b.addPlugin(plugin);
        model.setBuild(b);
    }

    public void addBuildHelperMavenPlugin(Model model) {
        Plugin plugin = new Plugin();
        plugin.setArtifactId("build-helper-maven-plugin");
        plugin.setGroupId("org.codehaus.mojo");
        plugin.setVersion("3.0.0");
        StringBuilder configString = new StringBuilder().append("\n\n<configuration>\n  <resources>\n    <resource>\n      <directory>${project.build.directory}</directory>\n      <targetPath>META-INF/resources/webjars/${project.artifactId}/${project.version}/json</targetPath>\n      <includes>\n        <include>*.json</include>\n      </includes>\n    </resource>\n    <resource>\n      <directory>${project.build.directory}/js</directory>\n      <targetPath>META-INF/resources/webjars/${project.artifactId}/${project.version}/js</targetPath>\n      <excludes>\n        <exclude>**/junk/**</exclude>\n      </excludes>\n    </resource>\n    <resource>\n      <directory>src/main/js</directory>\n      <targetPath>META-INF/resources/webjars/${project.artifactId}/${project.version}/js</targetPath>\n      <excludes>\n        <exclude>**/junk/**</exclude>\n      </excludes>\n    </resource>\n    <resource>\n      <directory>src/main/resources</directory>\n      <targetPath>META-INF/resources/webjars/${project.artifactId}/${project.version}/schema</targetPath>\n      <includes>\n        <includes>schema.json</includes>\n      </includes>\n    </resource>\n    <resource>\n      <directory>src/main/css</directory>\n      <targetPath>META-INF/resources/webjars/${project.artifactId}/${project.version}/css</targetPath>\n      <includes>\n        <includes>*.css</includes>\n      </includes>\n    </resource>\n    <resource>\n      <directory>${project.build.directory}/ts</directory>\n      <targetPath>META-INF/resources/webjars/${project.artifactId}/${project.version}/ts</targetPath>\n      <excludes>\n        <exclude>**/junk/**</exclude>\n      </excludes>\n    </resource>\n    <resource>\n      <directory>/bindings</directory>\n      <targetPath>META-INF/resources/webjars/${project.artifactId}/${project.version}/bindings</targetPath>\n      <excludes>\n        <exclude>**/junk/**</exclude>\n      </excludes>\n    </resource>\n    <resource>\n      <directory>${project.build.directory}/templates</directory>\n      <targetPath>META-INF/resources/webjars/${project.artifactId}/${project.version}/templates</targetPath>\n      <excludes>\n        <exclude>**/junk/**</exclude>\n      </excludes>\n    </resource>\n    <resource>\n      <directory>${project.build.directory}/resources</directory>\n      <targetPath>META-INF/resources/webjars/${project.artifactId}/${project.version}/schema</targetPath>\n      <excludes>\n        <exclude>**/junk/**</exclude>\n      </excludes>\n    </resource>\n  </resources>\n</configuration>\n");
        Xpp3Dom config = null;
        try {
            config = Xpp3DomBuilder.build((Reader)new StringReader(configString.toString()));
        }
        catch (IOException | XmlPullParserException ex) {
            throw new RuntimeException("Issue creating config for enforcer plugin", ex);
        }
        plugin.setConfiguration((Object)config);
        PluginExecution pe1 = new PluginExecution();
        pe1.addGoal("add-resource");
        pe1.setId("prepare-webjar");
        pe1.setPhase("generate-sources");
        plugin.addExecution(pe1);
        Build b = model.getBuild();
        if (b == null) {
            b = new Build();
        }
        b.addPlugin(plugin);
        model.setBuild(b);
    }

    public SpecificationFile generateTestFile_l2p(TemplatesProjectConfiguration configs, String directory, String fileName) {
        TypeSpec.Builder builder = this.compilerUtil.generateClassInitExtends("ExampleTest", "junit.framework", "TestCase");
        MethodSpec.Builder mbuilder = MethodSpec.methodBuilder((String)"testMain").addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(Exception.class).returns(Void.TYPE).addStatement("$T pf=org.openprovenance.prov.interop.InteropFramework.getDefaultFactory()", new Object[]{ProvFactory.class});
        for (TemplateCompilerConfig template : configs.templates) {
            String bn = this.compilerUtil.templateNameClass(template.name);
            mbuilder.addStatement("System.setOut(new java.io.PrintStream(\"target/" + template.name + ".provn\"))", new Object[0]);
            mbuilder.addStatement("$T.main(null)", new Object[]{ClassName.get((String)template.package_, (String)bn, (String[])new String[0])});
        }
        MethodSpec method = mbuilder.build();
        builder.addMethod(method);
        TypeSpec theInitializer = builder.build();
        JavaFile myfile = JavaFile.builder((String)configs.root_package, (TypeSpec)theInitializer).addFileComment("Generated Automatically by ProvToolbox ($N) for templates config $N", new Object[]{this.getClass().getName(), configs.name}).build();
        return new SpecificationFile(myfile, directory, fileName, configs.root_package);
    }

    public void addCompilerDeclaration(Model model) {
        Plugin plugin1 = new Plugin();
        plugin1.setGroupId("org.apache.maven.plugins");
        plugin1.setArtifactId("maven-compiler-plugin");
        plugin1.setVersion("3.8.1");
        StringBuilder configString1 = new StringBuilder().append("<configuration>").append("<source>1.8</source>").append("<target>1.8</target>").append("</configuration>");
        Plugin plugin2 = new Plugin();
        plugin2.setGroupId("org.apache.maven.plugins");
        plugin2.setArtifactId("maven-javadoc-plugin");
        plugin2.setVersion("3.1.1");
        StringBuilder configString2 = new StringBuilder().append("<configuration>").append("<source>1.8</source>").append("</configuration>");
        Xpp3Dom config1 = null;
        Xpp3Dom config2 = null;
        try {
            config1 = Xpp3DomBuilder.build((Reader)new StringReader(configString1.toString()));
            config2 = Xpp3DomBuilder.build((Reader)new StringReader(configString2.toString()));
        }
        catch (IOException | XmlPullParserException ex) {
            throw new RuntimeException("Issue creating config for enforcer plugin", ex);
        }
        PluginManagement pm = new PluginManagement();
        pm.addPlugin(plugin1);
        plugin1.setConfiguration((Object)config1);
        pm.addPlugin(plugin2);
        plugin2.setConfiguration((Object)config2);
        Build build = new Build();
        model.setBuild(build);
        build.setPluginManagement(pm);
    }

    public String getProvVersion() {
        return Configuration.toolboxVersion;
    }
}

