/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.lang.model.element.Modifier;
import org.apache.commons.text.CaseUtils;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.ValueConverter;
import org.openprovenance.prov.notation.ProvDeserialiser;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesProjectConfiguration;
import org.openprovenance.prov.template.descriptors.AttributeDescriptor;
import org.openprovenance.prov.template.descriptors.AttributeDescriptorList;
import org.openprovenance.prov.template.descriptors.Descriptor;
import org.openprovenance.prov.template.descriptors.NameDescriptor;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;
import org.openprovenance.prov.template.expander.ExpandUtil;
import org.openprovenance.prov.template.log2prov.FileBuilder;
import org.openprovenance.prov.template.log2prov.interfaces.ProxyClientAccessorInterface;

public class CompilerUtil {
    private final ProvFactory pFactory;
    boolean debugComment = true;
    public static final TypeVariableName typeT = TypeVariableName.get((String)"T");
    static final TypeName stringArrayType = ArrayTypeName.get(String[].class);
    static final TypeName classType = ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{typeT});
    static final TypeName mapType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Object.class)});
    static final TypeName mapString2StringType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(String.class)});
    static final TypeName mapString2StringArrayType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), stringArrayType});
    static final TypeName listMapType = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{mapType});
    static final TypeName hashMapType = ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Object.class)});
    static final TypeName mapTypeT = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), typeT});
    static final TypeName hashMapTypeT = ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), typeT});
    public static final ParameterizedTypeName hashmapType = ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{TypeName.get(Integer.class), TypeName.get(int[].class)});
    public static final ParameterizedTypeName builderMapType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get((String)"org.openprovenance.prov.client", (String)"Builder", (String[])new String[0])});
    public static final ParameterizedTypeName fileBuilderMapType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(FileBuilder.class)});
    public static final TypeName listOfArrays = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ArrayTypeName.get(Object[].class)});
    static final TypeName setStringT = ParameterizedTypeName.get((ClassName)ClassName.get(Set.class), (TypeName[])new TypeName[]{ClassName.get(String.class)});
    static final TypeName mapQualifiedName2StringSetType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(QualifiedName.class), setStringT});
    static final TypeName mapString2StringSetType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), setStringT});
    public static final ProvUtilities u = new ProvUtilities();
    public static final ParameterizedTypeName mapIntArrayType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(Integer.class), TypeName.get(int[].class)});
    public static final ParameterizedTypeName mapStringArrayType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), TypeName.get(int[].class)});
    public static final ParameterizedTypeName mapStringMapStringArrayType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), mapStringArrayType});
    public static final ParameterizedTypeName hashmapStringMapStringArrayType = ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{TypeName.get(String.class), mapStringArrayType});

    public CompilerUtil(ProvFactory pFactory) {
        this.pFactory = pFactory;
    }

    public String generateNewNameForVariable(String key) {
        return "__" + key;
    }

    public String capitalize(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public String templateNameClass(String templateName) {
        return this.capitalize(templateName) + "Builder";
    }

    public String beanNameClass(String templateName, BeanDirection beanDirection) {
        String name;
        switch (beanDirection) {
            case INPUTS: {
                name = this.inputsNameClass(templateName);
                break;
            }
            case OUTPUTS: {
                name = this.outputsNameClass(templateName);
                break;
            }
            case COMMON: {
                name = this.commonNameClass(templateName);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)beanDirection));
            }
        }
        return name;
    }

    public String beanNameClass(String templateName, BeanDirection beanDirection, String extension) {
        Object name = this.beanNameClass(templateName, beanDirection);
        if (extension != null) {
            name = (String)name + extension;
        }
        return name;
    }

    public String commonNameClass(String templateName) {
        return this.capitalize(templateName) + "Bean";
    }

    public String outputsNameClass(String templateName) {
        return this.capitalize(templateName) + "Outputs";
    }

    public String inputsNameClass(String templateName) {
        return this.capitalize(templateName) + "Inputs";
    }

    public String inputsNameClass(String templateName, String extension) {
        if (extension != null) {
            return this.inputsNameClass(templateName) + extension;
        }
        return this.inputsNameClass(templateName);
    }

    public String processorNameClass(String templateName) {
        return this.capitalize(templateName) + "Processor";
    }

    public String integratorBuilderNameClass(String templateName) {
        return this.capitalize(templateName) + "IntegratorBuilder";
    }

    public String integratorNameClass(String templateName) {
        return this.capitalize(templateName) + "Integrator";
    }

    public String loggerName(String template) {
        return "log" + this.capitalize(template);
    }

    public String sqlName(String template) {
        return "sqlTuple";
    }

    public void extractVariablesAndAttributes(Bundle bundle, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, ProvFactory pFactory) {
        for (Statement statement : bundle.getStatement()) {
            Set vars = ExpandUtil.freeVariables((Statement)statement);
            allVars.addAll(vars);
            allVars.addAll(ExpandUtil.freeVariables((Bundle)bundle));
            Set vars2 = ExpandUtil.freeAttributeVariables((Statement)statement, (ProvFactory)pFactory);
            allAtts.addAll(vars2);
        }
    }

    public TypeSpec.Builder generateClassInit(String name) {
        return TypeSpec.classBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateClassInitExtends(String name, String packge, String supername) {
        return TypeSpec.classBuilder((String)name).superclass((TypeName)ClassName.get((String)packge, (String)supername, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateInterfaceInit(String name) {
        return TypeSpec.interfaceBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateInterfaceInitParameter(String name, String type) {
        return TypeSpec.interfaceBuilder((String)name).addTypeVariable(TypeVariableName.get((String)type)).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateInterfaceInitParameter(String name, TypeVariableName type) {
        return TypeSpec.interfaceBuilder((String)name).addTypeVariable(type).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateClassBuilder3(String name) {
        return TypeSpec.classBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateClassBuilder2(String name) {
        return TypeSpec.classBuilder((String)name).superclass(FileBuilder.class).addSuperinterface((TypeName)ClassName.get(ProxyClientAccessorInterface.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(ProvFactory.class, "pf", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(ValueConverter.class, "vc", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
    }

    public TypeSpec.Builder generateTypeManagementClass(String name) {
        return TypeSpec.classBuilder((String)(name + "TypeManagement")).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateTypePropagateClass(String name) {
        return TypeSpec.classBuilder((String)(name + "TypePropagate")).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public TypeSpec.Builder generateTypedRecordClass(String name) {
        return TypeSpec.classBuilder((String)(name + "TypedRecord")).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public MethodSpec generateConstructor2(Hashtable<QualifiedName, String> vmap) {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ProvFactory.class, "pf", new Modifier[0]).addStatement("this.$N = $N", new Object[]{"pf", "pf"});
        for (Map.Entry<QualifiedName, String> e : vmap.entrySet()) {
            QualifiedName q = e.getKey();
            builder.addStatement("this.$N = pf.newQualifiedName($S,$S,$S)", new Object[]{e.getValue(), q.getNamespaceURI(), q.getLocalPart(), q.getPrefix()});
        }
        builder.addStatement("this.vc = new ValueConverter(pf)", new Object[0]);
        builder.addStatement("register(this)", new Object[0]);
        return builder.build();
    }

    public String camelcase(String s) {
        return CaseUtils.toCamelCase((String)s, (boolean)true, (char[])new char[0]);
    }

    public Set<QualifiedName> allQualifiedNames(Statement statement) {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        for (int i = 0; i < ExpandUtil.getFirstTimeIndex((Statement)statement); ++i) {
            Object o = u.getter(statement, i);
            if (o instanceof QualifiedName) {
                QualifiedName name = (QualifiedName)o;
                result.add(name);
                continue;
            }
            if (!(o instanceof List)) continue;
            List ll = (List)o;
            for (QualifiedName name : ll) {
                result.add(name);
            }
        }
        return result;
    }

    public HashSet<QualifiedName> allQualifiedNamesInAttributes(Statement statement, ProvFactory pf) {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        Collection ll = pf.getAttributes(statement);
        for (Attribute attr : ll) {
            result.add(attr.getElementName());
            if (attr.getType() != null) {
                result.add(attr.getType());
            }
            if (!(attr.getValue() instanceof QualifiedName)) continue;
            result.add((QualifiedName)attr.getValue());
        }
        return result;
    }

    public void allQualifiedNames(Bundle bundle, Set<QualifiedName> result, ProvFactory pFactory) {
        result.add(bundle.getId());
        for (Statement statement : bundle.getStatement()) {
            Set<QualifiedName> vars = this.allQualifiedNames(statement);
            result.addAll(vars);
            HashSet<QualifiedName> vars2 = this.allQualifiedNamesInAttributes(statement, pFactory);
            result.addAll(vars2);
        }
    }

    public Document readDocumentFromFile(String file) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, FileNotFoundException {
        try {
            Object interop = this.getInteropFramework();
            Method method = interop.getClass().getMethod("readDocumentFromFile", String.class);
            Document doc = (Document)method.invoke(interop, file);
            return doc;
        }
        catch (ClassNotFoundException e) {
            return new ProvDeserialiser(this.pFactory).deserialiseDocument((InputStream)new FileInputStream(file));
        }
    }

    public void writeDocument(String file, Document doc) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object interop = this.getInteropFramework();
        Method method = interop.getClass().getMethod("writeDocument", String.class, Document.class);
        method.invoke(interop, file, doc);
    }

    public Object getInteropFramework() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> clazz = Class.forName("org.openprovenance.prov.interop.InteropFramework");
        Constructor<?> ctor = clazz.getConstructor(new Class[0]);
        return ctor.newInstance(new Object[0]);
    }

    public boolean saveToFile(String destinationDir, String destination, JavaFile spec) {
        try {
            File dir = new File(destinationDir);
            if (!dir.exists() && !dir.mkdirs()) {
                System.err.println("failed to create directory " + destinationDir);
                return false;
            }
            PrintWriter out = new PrintWriter(destination);
            out.print(spec);
            out.close();
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean saveToFile(String destinationDir, String destination, Supplier<String> spec) {
        try {
            File dir = new File(destinationDir);
            if (!dir.exists() && !dir.mkdirs()) {
                System.err.println("failed to create directory " + destinationDir);
                return false;
            }
            PrintWriter out = new PrintWriter(destination);
            out.print(spec.get());
            out.close();
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public JsonNode get_bindings_schema(SimpleTemplateCompilerConfig config) {
        JsonNode bindings_schema = null;
        if (config.bindings != null) {
            try {
                bindings_schema = ConfigProcessor.objectMapper.readTree(new File(config.bindings));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bindings_schema;
    }

    public TemplateBindingsSchema getBindingsSchema(SimpleTemplateCompilerConfig config) {
        TemplateBindingsSchema bindingsSchema = this.getBindingsSchema(config.bindings);
        return bindingsSchema;
    }

    public TemplateBindingsSchema getBindingsSchema(String bindings) {
        TemplateBindingsSchema bindingsSchema = null;
        if (bindings != null) {
            if (bindings.equals("openprovenance:composite-bean.json")) {
                try {
                    bindingsSchema = (TemplateBindingsSchema)ConfigProcessor.objectMapper.readValue(this.getClass().getResourceAsStream("/composite/composite-bean.json"), TemplateBindingsSchema.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                bindingsSchema = (TemplateBindingsSchema)ConfigProcessor.objectMapper.readValue(new File(bindings), TemplateBindingsSchema.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return bindingsSchema;
    }

    public Class<?> getJavaTypeForDeclaredType(Map<String, List<Descriptor>> varMap, String key) {
        Descriptor descriptor = varMap.get(key).get(0);
        switch (descriptor.getDescriptorType()) {
            case ATTRIBUTE: {
                AttributeDescriptor ad = ((AttributeDescriptorList)descriptor).getItems().get(0);
                String hasType = ad.getType();
                if (hasType != null) {
                    return this.getClassForType(hasType);
                }
                System.out.println("key is " + key);
                System.out.println("decl is " + String.valueOf(varMap));
                throw new UnsupportedOperationException();
            }
            case NAME: {
                NameDescriptor nd = (NameDescriptor)descriptor;
                String idType = nd.getType();
                if (idType == null) {
                    return String.class;
                }
                return this.getClassForType(idType);
            }
        }
        throw new UnsupportedOperationException("This exception is never reached");
    }

    public Class<?> getJavaTypeForDeclaredType(JsonNode the_var, String key) {
        JsonNode the_key = the_var.get(key);
        if (the_key != null && the_key.get(0).get("@id") != null) {
            String idType;
            JsonNode jsonNode = the_key.get(0).get("@type");
            String string = idType = jsonNode == null ? null : jsonNode.textValue();
            if (idType == null) {
                return String.class;
            }
            return this.getClassForType(idType);
        }
        if (the_key == null || the_key.get(0).get(0) == null) {
            System.out.println("key is " + key);
            System.out.println("decl is " + String.valueOf(the_var));
            throw new UnsupportedOperationException("no value associated with key '" + key + "'");
        }
        JsonNode hasType = the_key.get(0).get(0).get("@type");
        if (hasType != null) {
            String keyType = hasType.textValue();
            return this.getClassForType(keyType);
        }
        System.out.println("key is " + key);
        System.out.println("decl is " + String.valueOf(the_var));
        throw new UnsupportedOperationException();
    }

    private Class<? extends Serializable> getClassForType(String keyType) {
        switch (keyType) {
            case "xsd:int": {
                return Integer.class;
            }
            case "xsd:long": {
                return Long.class;
            }
            case "xsd:string": {
                return String.class;
            }
            case "xsd:boolean": {
                return Boolean.class;
            }
            case "xsd:float": {
                return Float.class;
            }
            case "xsd:double": {
                return Double.class;
            }
            case "xsd:dateTime": {
                return String.class;
            }
            case "xsd:date": {
                return String.class;
            }
            case "json": {
                return String.class;
            }
        }
        throw new UnsupportedOperationException("getClassForType " + keyType);
    }

    public Class<?> getJavaDocumentTypeForDeclaredType(Map<String, List<Descriptor>> theVar, String key) {
        if (theVar.get(key).get(0) instanceof NameDescriptor) {
            return QualifiedName.class;
        }
        AttributeDescriptor ad = ((AttributeDescriptorList)theVar.get(key).get(0)).getItems().get(0);
        if (ad == null) {
            System.out.println("key is " + key);
            System.out.println("decl is " + String.valueOf(theVar));
            throw new UnsupportedOperationException();
        }
        String keyType = ad.getType();
        if (keyType != null) {
            switch (keyType) {
                case "xsd:int": 
                case "xsd:long": 
                case "xsd:string": 
                case "xsd:boolean": 
                case "xsd:float": 
                case "xsd:double": 
                case "xsd:dateTime": 
                case "xsd:date": {
                    return Object.class;
                }
            }
            throw new UnsupportedOperationException();
        }
        System.out.println("key is " + key);
        System.out.println("decl is " + String.valueOf(theVar));
        throw new UnsupportedOperationException("Null type");
    }

    public void generateSpecializedParameters(MethodSpec.Builder builder, JsonNode the_var) {
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            builder.addParameter(this.getJavaTypeForDeclaredType(the_var, key), key, new Modifier[0]);
        }
    }

    public void generateDocumentSpecializedParameters(MethodSpec.Builder builder, Map<String, List<Descriptor>> theVar, Collection<String> variables) {
        for (String key : variables) {
            builder.addParameter(this.getJavaDocumentTypeForDeclaredType(theVar, key), key, new Modifier[0]);
        }
    }

    public boolean isVariableDenotingQualifiedName(String key, JsonNode the_var) {
        JsonNode entry = the_var.path(key);
        return entry != null && !(entry instanceof MissingNode) && entry.get(0).get("@id") != null;
    }

    public boolean isVariableDenotingQualifiedName(String key, Map<String, List<Descriptor>> theVar) {
        return theVar.containsKey(key) && theVar.get(key) != null && theVar.get(key).get(0) instanceof NameDescriptor;
    }

    public String generateArgumentsListForCall(JsonNode the_var, Map<String, String> translator) {
        Iterator iter = the_var.fieldNames();
        boolean first = true;
        Object args = "";
        while (iter.hasNext()) {
            String tmp;
            String key = (String)iter.next();
            if (first) {
                first = false;
            } else {
                args = (String)args + ", ";
            }
            String newName = key;
            if (translator != null && (tmp = translator.get(key)) != null) {
                newName = tmp;
            }
            args = (String)args + newName;
        }
        return args;
    }

    public void generateSpecializedParametersJavadoc(MethodSpec.Builder builder, JsonNode the_var, JsonNode the_documentation, JsonNode the_return) {
        String docString = this.noNode(the_documentation) ? "No @documentation." : the_documentation.textValue();
        String retString = this.noNode(the_return) ? "@return not documented." : the_return.textValue();
        builder.addJavadoc(docString, new Object[0]);
        builder.addJavadoc("\n\n", new Object[0]);
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            JsonNode entry = the_var.path(key);
            if (entry != null && !(entry instanceof MissingNode)) {
                JsonNode jsonNode;
                JsonNode firstNode = entry.get(0);
                if (firstNode instanceof ArrayNode) {
                    firstNode = ((ArrayNode)firstNode).get(0);
                }
                String documentation = this.noNode(jsonNode = firstNode.get("@documentation")) ? "-- no @documentation" : jsonNode.textValue();
                JsonNode jsonNode2 = firstNode.get("@type");
                String type = this.noNode(jsonNode2) ? "xsd:string" : jsonNode2.textValue();
                builder.addJavadoc("@param $N $L (expected type: $L)\n", new Object[]{key, documentation, type});
                continue;
            }
            builder.addJavadoc("@param $N -- no bindings schemas \n", new Object[]{key});
        }
        builder.addJavadoc(retString, new Object[0]);
    }

    public boolean noNode(JsonNode jsonNode2) {
        return jsonNode2 == null || jsonNode2 instanceof MissingNode || jsonNode2 instanceof NullNode;
    }

    public String generateExampleForType(String declaredType, String localPart, ProvFactory pFactory) {
        if (declaredType == null) {
            return "test1_" + localPart;
        }
        switch (declaredType) {
            case "xsd:date": 
            case "xsd:dateTime": {
                return pFactory.newTimeNow().toXMLFormat();
            }
            case "xsd:float": {
                return "123.00f";
            }
            case "xsd:int": {
                return "12345";
            }
        }
        return "test2_" + localPart;
    }

    public String createExamplar(JsonNode the_var, String key, int num, ProvFactory pFactory) {
        if (the_var.get(key).get(0).get("@examplar") != null) {
            return the_var.get(key).get(0).get("@examplar").toString();
        }
        if (the_var.get(key).get(0).get("@id") != null) {
            JsonNode jsonNode1 = the_var.get(key);
            JsonNode jsonNode2 = jsonNode1 == null ? null : jsonNode1.get(0);
            JsonNode jsonNode3 = jsonNode2 == null ? null : jsonNode2.get("@type");
            String idType = jsonNode3 == null ? null : jsonNode3.textValue();
            String example = this.generateExampleForType(idType, key, pFactory);
            Class<?> declaredJavaType = this.getJavaTypeForDeclaredType(the_var, key);
            String converter = this.getConverterForDeclaredType2(declaredJavaType);
            if (converter == null) {
                return "\"v" + num + "\"";
            }
            return converter + "(" + example + ")";
        }
        if (the_var.get(key).get(0).get(0) == null) {
            System.out.println("key is " + key);
            System.out.println("decl is " + String.valueOf(the_var));
            throw new UnsupportedOperationException();
        }
        JsonNode hasType = the_var.get(key).get(0).get(0).get("@type");
        if (hasType != null) {
            String keyType;
            switch (keyType = hasType.textValue()) {
                case "xsd:int": {
                    return "" + num;
                }
                case "xsd:long": {
                    return num + "L";
                }
                case "xsd:string": {
                    return "\"v" + num + "\"";
                }
                case "xsd:boolean": {
                    return "true";
                }
                case "xsd:float": {
                    return num + ".01f";
                }
                case "xsd:double": {
                    return num + ".01d";
                }
                case "xsd:date": 
                case "xsd:dateTime": {
                    return "\"" + pFactory.newTimeNow().toXMLFormat() + "\"";
                }
            }
            throw new UnsupportedOperationException();
        }
        System.out.println("key is " + key);
        System.out.println("decl is " + String.valueOf(the_var));
        throw new UnsupportedOperationException();
    }

    public String getDeclaredType(JsonNode the_var, String key) {
        if (the_var.get(key).get(0).get("@id") != null) {
            return "prov:QualifiedName";
        }
        if (the_var.get(key).get(0).get(0) == null) {
            System.out.println("key is " + key);
            System.out.println("decl is " + String.valueOf(the_var));
            throw new UnsupportedOperationException();
        }
        JsonNode hasType = the_var.get(key).get(0).get(0).get("@type");
        if (hasType != null) {
            String keyType = hasType.textValue();
            return keyType;
        }
        System.out.println("key is " + key);
        System.out.println("decl is " + String.valueOf(the_var));
        throw new UnsupportedOperationException();
    }

    public String getDeclaredType(Map<String, List<Descriptor>> theVar, String key) {
        if (theVar.get(key).get(0) instanceof NameDescriptor) {
            return "prov:QualifiedName";
        }
        if (((AttributeDescriptorList)theVar.get(key).get(0)).getItems().get(0) == null) {
            System.out.println("key is " + key);
            System.out.println("decl is " + String.valueOf(theVar));
            throw new UnsupportedOperationException();
        }
        String keyType = ((AttributeDescriptorList)theVar.get(key).get(0)).getItems().get(0).getType();
        if (keyType == null) {
            System.out.println("key is " + key);
            System.out.println("decl is " + String.valueOf(theVar));
            throw new IllegalStateException();
        }
        return keyType;
    }

    public String varPrefix(String localPart) {
        return "__var_" + localPart;
    }

    public String attPrefix(String localPart) {
        return "__att_" + localPart;
    }

    public String getConverterForDeclaredType2(Class cl) {
        if (cl != null) {
            String keyType;
            switch (keyType = cl.getName()) {
                case "java.lang.Integer": {
                    return "Integer.valueOf";
                }
                case "java.lang.Long": {
                    return "Long.valueOf";
                }
                case "java.lang.String": {
                    return null;
                }
                case "java.lang.Boolean": {
                    return "Boolean.valueOf";
                }
                case "java.lang.Float": {
                    return "Float.valueOf";
                }
                case "java.lang.Double": {
                    return "Double.valueOf";
                }
            }
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public String getConverterForDeclaredType(Class cl) {
        if (cl != null) {
            String keyType;
            switch (keyType = cl.getName()) {
                case "java.lang.Integer": {
                    return "toInt";
                }
                case "java.lang.Long": {
                    return "toLong";
                }
                case "java.lang.String": {
                    return null;
                }
                case "java.lang.Boolean": {
                    return "toBoolean";
                }
                case "java.lang.Float": {
                    return "toFloat";
                }
                case "java.lang.Double": {
                    return "toDouble";
                }
            }
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public String getResultSetMethodForClass(Class<?> cl) {
        if (cl != null) {
            String keyType;
            switch (keyType = cl.getName()) {
                case "java.lang.Integer": {
                    return "getInt";
                }
                case "java.lang.Long": {
                    return "getLong";
                }
                case "java.lang.String": {
                    return "getString";
                }
                case "java.lang.Boolean": {
                    return "getBoolean";
                }
                case "java.lang.Float": {
                    return "getFloat";
                }
                case "java.lang.Double": {
                    return "getDouble";
                }
            }
            throw new UnsupportedOperationException("Unknown class " + keyType);
        }
        return null;
    }

    public JavaFile specWithComment(TypeSpec typeSpec, String templateName, String packge, StackTraceElement stackTraceElement) {
        return JavaFile.builder((String)packge, (TypeSpec)typeSpec).addFileComment("Generated automatically by ProvToolbox for template '$L'", new Object[]{templateName}).addFileComment("\nby class $L, method $L,\nin file $L, at line $L", new Object[]{stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber()}).build();
    }

    public JavaFile specWithComment(TypeSpec typeSpec, TemplatesProjectConfiguration configs, String packge, StackTraceElement stackTraceElement) {
        return JavaFile.builder((String)packge, (TypeSpec)typeSpec).addFileComment("Generated automatically by ProvToolbox for template configuration '$L'", new Object[]{configs.name}).addFileComment("\nby class $L, method $L,\nin file $L, at line $L", new Object[]{stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber()}).build();
    }

    public String pySpecWithComment(String templateName, StackTraceElement stackTraceElement) {
        return "Generated automatically by ProvToolbox for template '" + templateName + "'\nby class " + stackTraceElement.getClassName() + ", method " + stackTraceElement.getMethodName() + ", \nin file " + stackTraceElement.getFileName() + ", at line $L " + stackTraceElement.getLineNumber();
    }

    public String pySpecWithComment(TemplatesProjectConfiguration configs, StackTraceElement stackTraceElement) {
        return "Generated automatically by ProvToolbox for template configuration '" + configs.name + "'\nby class " + stackTraceElement.getClassName() + ", method " + stackTraceElement.getMethodName() + ", \nin file " + stackTraceElement.getFileName() + ", at line $L " + stackTraceElement.getLineNumber();
    }

    public void specWithComment(MethodSpec.Builder mspec) {
        if (this.debugComment) {
            StackTraceElement stackTraceElement = this.previousMethodAndLine();
            mspec.addComment("Generated by class $L, method $L", new Object[]{stackTraceElement.getClassName(), stackTraceElement.getMethodName()});
            mspec.addComment("in file $L, at line $L", new Object[]{stackTraceElement.getFileName(), stackTraceElement.getLineNumber()});
        }
    }

    public void specWithJavaDoc(MethodSpec.Builder mspec) {
        if (this.debugComment) {
            StackTraceElement stackTraceElement = this.previousMethodAndLine();
            mspec.addJavadoc("Generated by class $L, method $L", new Object[]{stackTraceElement.getClassName(), stackTraceElement.getMethodName()});
            mspec.addJavadoc("in file $L, at line $L", new Object[]{stackTraceElement.getFileName(), stackTraceElement.getLineNumber()});
        }
    }

    public StackTraceElement thisMethodAndLine() {
        RuntimeException exception = new RuntimeException();
        return exception.getStackTrace()[1];
    }

    public StackTraceElement previousMethodAndLine() {
        RuntimeException exception = new RuntimeException();
        return exception.getStackTrace()[2];
    }

    public ClassName getClass(String name, Locations locations) {
        return ClassName.get((String)locations.getFilePackage(name), (String)name, (String[])new String[0]);
    }
}

