/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.IndexedDocument;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.template.compiler.CompilerBeanChecker;
import org.openprovenance.prov.template.compiler.CompilerBeanCompleter;
import org.openprovenance.prov.template.compiler.CompilerBeanCompleter2;
import org.openprovenance.prov.template.compiler.CompilerBeanCompleter2Composite;
import org.openprovenance.prov.template.compiler.CompilerBeanCompleter3;
import org.openprovenance.prov.template.compiler.CompilerBeanEnactor;
import org.openprovenance.prov.template.compiler.CompilerBeanEnactor2;
import org.openprovenance.prov.template.compiler.CompilerBeanEnactor2Composite;
import org.openprovenance.prov.template.compiler.CompilerBeanEnactor2CompositeWithPrincipal;
import org.openprovenance.prov.template.compiler.CompilerBeanEnactor2WithPrincipal;
import org.openprovenance.prov.template.compiler.CompilerBeanGenerator;
import org.openprovenance.prov.template.compiler.CompilerBeanProcessor;
import org.openprovenance.prov.template.compiler.CompilerBuilderInit;
import org.openprovenance.prov.template.compiler.CompilerClientTest;
import org.openprovenance.prov.template.compiler.CompilerCompositeConfigurations;
import org.openprovenance.prov.template.compiler.CompilerConfigurations;
import org.openprovenance.prov.template.compiler.CompilerDelegator;
import org.openprovenance.prov.template.compiler.CompilerDocumentation;
import org.openprovenance.prov.template.compiler.CompilerInputOutputProcessor;
import org.openprovenance.prov.template.compiler.CompilerJsonSchema;
import org.openprovenance.prov.template.compiler.CompilerLogger;
import org.openprovenance.prov.template.compiler.CompilerMaven;
import org.openprovenance.prov.template.compiler.CompilerProcessor;
import org.openprovenance.prov.template.compiler.CompilerQueryInvoker;
import org.openprovenance.prov.template.compiler.CompilerQueryInvokerWithPrincipal;
import org.openprovenance.prov.template.compiler.CompilerSQL;
import org.openprovenance.prov.template.compiler.CompilerScript;
import org.openprovenance.prov.template.compiler.CompilerTableConfigurator;
import org.openprovenance.prov.template.compiler.CompilerTableConfiguratorForTypes;
import org.openprovenance.prov.template.compiler.CompilerTableConfiguratorWithMap;
import org.openprovenance.prov.template.compiler.CompilerTemplateBuilders;
import org.openprovenance.prov.template.compiler.CompilerTemplateInvoker;
import org.openprovenance.prov.template.compiler.CompilerTypeConverter;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.common.BeanKind;
import org.openprovenance.prov.template.compiler.common.CompilerCommon;
import org.openprovenance.prov.template.compiler.common.Constants;
import org.openprovenance.prov.template.compiler.configuration.CompositeTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplateConfigurationEnum;
import org.openprovenance.prov.template.compiler.configuration.TemplatesProjectConfiguration;
import org.openprovenance.prov.template.compiler.expansion.CompilerExpansionBuilder;
import org.openprovenance.prov.template.compiler.expansion.CompilerTypeManagement;
import org.openprovenance.prov.template.compiler.expansion.CompilerTypedRecord;
import org.openprovenance.prov.template.compiler.expansion.StatementTypeAction;
import org.openprovenance.prov.template.compiler.integration.CompilerIntegrator;
import org.openprovenance.prov.template.compiler.sql.CompilerSqlIntegration;
import org.openprovenance.prov.template.descriptors.Descriptor;
import org.openprovenance.prov.template.descriptors.DescriptorUtils;
import org.openprovenance.prov.template.descriptors.NameDescriptor;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;
import org.openprovenance.prov.vanilla.ProvFactory;

public class ConfigProcessor
implements Constants {
    public static final TypeVariableName typeResult = TypeVariableName.get((String)"RESULT");
    public static final TypeVariableName typeOutput = TypeVariableName.get((String)"OUTPUT");
    public static final TypeVariableName typeOut = TypeVariableName.get((String)"OUT");
    public static final TypeVariableName typeIn = TypeVariableName.get((String)"IN");
    static final TypeVariableName typeT = TypeVariableName.get((String)"T");
    static final TypeName biconsumerType2 = ParameterizedTypeName.get((ClassName)ClassName.get(BiConsumer.class), (TypeName[])new TypeName[]{typeResult, typeT});
    public static final TypeName biconsumerTypeOut = ParameterizedTypeName.get((ClassName)ClassName.get(BiConsumer.class), (TypeName[])new TypeName[]{typeResult, typeOut});
    static final TypeName consumerT = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{typeT});
    public static final TypeName consumerIn = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{typeIn});
    static final TypeName biconsumerType = ParameterizedTypeName.get((ClassName)ClassName.get(BiConsumer.class), (TypeName[])new TypeName[]{ClassName.get(StringBuilder.class), typeT});
    public static final TypeName biconsumerTypeIn = ParameterizedTypeName.get((ClassName)ClassName.get(BiConsumer.class), (TypeName[])new TypeName[]{ClassName.get(StringBuilder.class), typeIn});
    static final TypeName listTypeT = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{typeT});
    private final org.openprovenance.prov.model.ProvFactory pFactory;
    private final CompilerSQL compilerSQL;
    private final boolean debugComment;
    public static final DescriptorUtils descriptorUtils;
    private final CompilerIntegrator compilerIntegrator;
    boolean withMain = true;
    public static final ObjectMapper objectMapper;
    private final CompilerUtil compilerUtil;
    private final CompilerLogger compilerLogger;
    private final CompilerTemplateBuilders compilerTemplateBuilders;
    private final CompilerTableConfigurator compilerTableConfigurator;
    private final CompilerTableConfiguratorWithMap compilerTableConfiguratorWithMap;
    private final CompilerTableConfiguratorForTypes compilerTableConfiguratorForTypes;
    private final CompilerBeanProcessor compilerBeanProcessor;
    private final CompilerInputOutputProcessor compilerInputOutputProcessor;
    private final CompilerTemplateInvoker compilerTemplateInvoker;
    private final CompilerBeanCompleter compilerBeanCompleter;
    private final CompilerBeanCompleter2 compilerBeanCompleter2;
    private final CompilerBeanCompleter3 compilerBeanCompleter3;
    private final CompilerBeanCompleter2Composite compilerBeanCompleter2Composite;
    private final CompilerTypeConverter compilerTypeConverter;
    private final CompilerBeanEnactor compilerBeanEnactor;
    private final CompilerBeanEnactor2 compilerBeanEnactor2;
    private final CompilerBeanEnactor2WithPrincipal compilerBeanEnactor2WP;
    private final CompilerSqlIntegration compilerSqlIntegration;
    private final CompilerBeanEnactor2Composite compilerBeanEnactor2composite;
    private final CompilerBeanEnactor2CompositeWithPrincipal compilerBeanEnactor2compositeWP;
    private final CompilerQueryInvoker compilerQueryInvoker;
    private final CompilerQueryInvokerWithPrincipal compilerQueryInvokerWithPrincipal;
    private final CompilerBeanChecker compilerBeanChecker;
    private final CompilerDelegator compilerDelegator;
    private final CompilerConfigurations compilerConfigurations;
    private final CompilerCompositeConfigurations compilerCompositeConfigurations;
    private final CompilerMaven compilerMaven;
    private final CompilerScript compilerScript = new CompilerScript(this);
    private final CompilerDocumentation compilerDocumentation;
    private final CompilerCommon compilerCommon;
    private final CompilerExpansionBuilder compilerExpansionBuilder;
    private final CompilerBuilderInit compilerBuilderInit;
    private final CompilerTypeManagement compilerTypeManagement;
    private final CompilerTypedRecord compilerTypedRecord;
    private final CompilerBeanGenerator compilerBeanGenerator;
    private final CompilerProcessor compilerProcessor;
    private final CompilerJsonSchema compilerJsonSchema;
    private final CompilerClientTest compilerClientTest;
    private Set<String> referencedSqlTables = new HashSet<String>();
    private final Map<String, Map<String, String>> inputMap = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> outputMap = new HashMap<String, Map<String, String>>();
    private HashMap<String, Map<String, Map<String, String>>> ioMap = null;

    public ConfigProcessor(org.openprovenance.prov.model.ProvFactory pFactory) {
        this.debugComment = true;
        this.pFactory = pFactory;
        this.compilerUtil = new CompilerUtil(pFactory);
        this.compilerTypeConverter = new CompilerTypeConverter(pFactory);
        this.compilerBeanCompleter = new CompilerBeanCompleter(pFactory);
        this.compilerSQL = new CompilerSQL(pFactory, "ID");
        this.compilerCommon = new CompilerCommon(pFactory, this.compilerSQL);
        this.compilerBeanGenerator = new CompilerBeanGenerator(pFactory);
        this.compilerIntegrator = new CompilerIntegrator(pFactory, this.compilerCommon, this.compilerBeanGenerator);
        this.compilerTypeManagement = new CompilerTypeManagement(this.withMain, this.compilerCommon, pFactory, this.debugComment);
        this.compilerExpansionBuilder = new CompilerExpansionBuilder(this.withMain, this.compilerCommon, pFactory, this.debugComment, this.compilerTypeManagement);
        this.compilerTypedRecord = new CompilerTypedRecord(this.withMain, this.compilerCommon, pFactory, this.debugComment);
        this.compilerBuilderInit = new CompilerBuilderInit(pFactory);
        this.compilerBeanChecker = new CompilerBeanChecker(pFactory);
        this.compilerProcessor = new CompilerProcessor(pFactory);
        this.compilerJsonSchema = new CompilerJsonSchema(pFactory);
        this.compilerClientTest = new CompilerClientTest(pFactory);
        this.compilerTemplateInvoker = new CompilerTemplateInvoker(pFactory);
        this.compilerBeanEnactor2 = new CompilerBeanEnactor2(pFactory);
        this.compilerBeanEnactor2WP = new CompilerBeanEnactor2WithPrincipal(pFactory);
        this.compilerBeanEnactor2composite = new CompilerBeanEnactor2Composite(pFactory);
        this.compilerBeanEnactor = new CompilerBeanEnactor(pFactory);
        this.compilerBeanCompleter2 = new CompilerBeanCompleter2(pFactory);
        this.compilerBeanCompleter3 = new CompilerBeanCompleter3(pFactory);
        this.compilerBeanCompleter2Composite = new CompilerBeanCompleter2Composite(pFactory);
        this.compilerBeanProcessor = new CompilerBeanProcessor(pFactory);
        this.compilerCompositeConfigurations = new CompilerCompositeConfigurations(pFactory);
        this.compilerConfigurations = new CompilerConfigurations(pFactory);
        this.compilerDelegator = new CompilerDelegator(pFactory);
        this.compilerDocumentation = new CompilerDocumentation(pFactory);
        this.compilerInputOutputProcessor = new CompilerInputOutputProcessor(pFactory);
        this.compilerLogger = new CompilerLogger(pFactory);
        this.compilerMaven = new CompilerMaven(pFactory, this);
        this.compilerQueryInvoker = new CompilerQueryInvoker(pFactory);
        this.compilerTableConfigurator = new CompilerTableConfigurator(pFactory);
        this.compilerTableConfiguratorWithMap = new CompilerTableConfiguratorWithMap(pFactory);
        this.compilerTemplateBuilders = new CompilerTemplateBuilders(pFactory);
        this.compilerTableConfiguratorForTypes = new CompilerTableConfiguratorForTypes(pFactory);
        this.compilerSqlIntegration = new CompilerSqlIntegration(pFactory);
        this.compilerQueryInvokerWithPrincipal = new CompilerQueryInvokerWithPrincipal(pFactory);
        this.compilerBeanEnactor2compositeWP = new CompilerBeanEnactor2CompositeWithPrincipal(pFactory);
    }

    public int processTemplateGenerationConfig(String template_builder, String inputBaseDir, String outputBaseDir, org.openprovenance.prov.model.ProvFactory pFactory) {
        try {
            TemplatesProjectConfiguration configs = (TemplatesProjectConfiguration)objectMapper.readValue(new File(this.addBaseDirIfRelative(template_builder, inputBaseDir)), TemplatesProjectConfiguration.class);
            String root_dir = outputBaseDir + "/" + configs.destination + "/" + configs.name;
            new File(root_dir).mkdirs();
            String cli_lib = configs.name + "_cli";
            String cli_dir = root_dir + "/" + cli_lib;
            new File(cli_dir).mkdirs();
            String l2p_lib = configs.name + "_l2p";
            String l2p_dir = root_dir + "/" + l2p_lib;
            new File(l2p_dir).mkdirs();
            String l2p_src_dir = l2p_dir + "/src/main/java";
            String l2p_test_src_dir = l2p_dir + "/src/test/java";
            String cli_src_dir = cli_dir + "/src/main/java";
            String cli_test_src_dir = cli_dir + "/src/test/java";
            String cli_webjar_dir = cli_dir + "/src/main/resources/META-INF/resources/webjars/" + configs.name + "_cli/" + configs.version;
            String cli_webjar_bindings_dir = cli_webjar_dir + "/bindings";
            String cli_webjar_templates_dir = cli_webjar_dir + "/templates";
            new File(l2p_src_dir).mkdirs();
            new File(cli_src_dir).mkdirs();
            new File(l2p_test_src_dir).mkdirs();
            new File(cli_test_src_dir).mkdirs();
            new File(cli_webjar_dir).mkdirs();
            new File(cli_webjar_bindings_dir).mkdirs();
            new File(cli_webjar_templates_dir).mkdirs();
            Locations locations = new Locations(configs, cli_src_dir, l2p_src_dir);
            for (TemplateCompilerConfig aconfig : configs.templates) {
                TemplateCompilerConfig config;
                if (TemplateConfigurationEnum.isSimple(aconfig)) {
                    config = (SimpleTemplateCompilerConfig)aconfig;
                    config.template = this.addBaseDirIfRelative(config.template, inputBaseDir);
                    config.bindings = this.addBaseDirIfRelative(config.bindings, inputBaseDir);
                    locations.updateWithConfig(config);
                    this.doGenerateServerForEntry((SimpleTemplateCompilerConfig)config, configs, locations, cli_src_dir, l2p_src_dir, pFactory, cli_webjar_dir);
                    FileUtils.copyFileToDirectory((File)new File(config.template), (File)new File(cli_webjar_templates_dir));
                    FileUtils.copyFileToDirectory((File)new File(config.bindings), (File)new File(cli_webjar_bindings_dir));
                    continue;
                }
                config = (CompositeTemplateCompilerConfig)aconfig;
                String simple = ((CompositeTemplateCompilerConfig)config).consistsOf;
                List<String> sharing = ((CompositeTemplateCompilerConfig)config).sharing;
                boolean found = false;
                for (TemplateCompilerConfig aconfig2 : configs.templates) {
                    if (!Objects.equals(aconfig2.name, simple)) continue;
                    found = true;
                    SimpleTemplateCompilerConfig sc = (SimpleTemplateCompilerConfig)aconfig2;
                    sc.template = this.addBaseDirIfRelative(sc.template, inputBaseDir);
                    sc.bindings = this.addBaseDirIfRelative(sc.bindings, inputBaseDir);
                    SimpleTemplateCompilerConfig sc2 = sc.cloneAsInstanceInComposition(((CompositeTemplateCompilerConfig)config).name, ((CompositeTemplateCompilerConfig)config).sharing);
                    this.doGenerateServerForEntry((CompositeTemplateCompilerConfig)config, sc2, configs, locations, cli_src_dir, l2p_src_dir, cli_webjar_dir);
                }
                if (found) continue;
                throw new UnsupportedOperationException("Composite template configuration referencing unknown template " + simple);
            }
            this.compilerBeanGenerator.generateSimpleConfigsWithVariants(locations, configs);
            if (configs.integrator) {
                SpecificationFile beanChecker3 = this.compilerBeanChecker.generateBeanChecker(configs, locations, BeanDirection.INPUTS, this.compilerBeanGenerator.variantTable, "BeanChecker2");
                beanChecker3.save();
            }
            this.generateJSonSchemaEnd(configs, cli_src_dir);
            this.generateSQLEnd(configs, cli_src_dir);
            this.generateDocumentationEnd(configs, cli_src_dir);
            this.doGenerateProject(configs, locations, root_dir, cli_lib, l2p_lib, l2p_dir, l2p_src_dir, l2p_test_src_dir, cli_test_src_dir, cli_webjar_dir);
            this.doGenerateClientAndProject(configs, locations, cli_lib, cli_dir, cli_src_dir);
            System.out.println(objectMapper.writeValueAsString(this.getInputOutputMaps()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private String addBaseDirIfRelative(String template_builder, String baseDir) {
        if (template_builder.startsWith("/")) {
            return template_builder;
        }
        return baseDir + "/" + template_builder;
    }

    public Set<String> getReferencedSqlTables() {
        return this.referencedSqlTables;
    }

    public void findSqlTableReferences(TemplateBindingsSchema config) {
        Map<String, List<Descriptor>> vars = config.getVar();
        for (String var : vars.keySet()) {
            List<Descriptor> descriptors = vars.get(var);
            for (Descriptor descriptor : descriptors) {
                NameDescriptor nd;
                if (!(descriptor instanceof NameDescriptor) || (nd = (NameDescriptor)descriptor).getTable() == null) continue;
                this.referencedSqlTables.add(nd.getTable());
            }
        }
    }

    public void generateJSonSchemaEnd(TemplatesProjectConfiguration configs, String cli_src_dir) {
        if (configs.jsonschema != null) {
            this.compilerJsonSchema.generateJSonSchemaEnd(configs.jsonschema, cli_src_dir + "/../resources");
        }
    }

    public void generateSQLEnd(TemplatesProjectConfiguration configs, String cli_src_dir) {
        if (configs.sqlFile != null) {
            this.compilerSQL.generateSQLEnd(configs.sqlFile, cli_src_dir + "/../resources", this.getReferencedSqlTables());
        }
    }

    public void generateDocumentationEnd(TemplatesProjectConfiguration configs, String cli_webjar_dir) {
        if (configs.documentation != null) {
            this.compilerDocumentation.generateDocumentationEnd(configs, cli_webjar_dir);
        }
    }

    public void doGenerateProject(TemplatesProjectConfiguration configs, Locations locations, String root_dir, String cli_lib, String l2p_lib, String l2p_dir, String l2p_src_dir, String l2p_test_src_dir, String cli_test_src_dir, String cli_webjar_dir) {
        String init_dir = l2p_src_dir + "/" + configs.root_package.replace('.', '/') + "/";
        String l2p_test_dir = l2p_test_src_dir + "/" + configs.root_package.replace('.', '/') + "/";
        String cli_test_dir = cli_test_src_dir + "/" + configs.root_package.replace('.', '/') + "/";
        SpecificationFile init = this.compilerBuilderInit.generateInitializer(configs, locations, init_dir, "Init.java");
        init.save();
        SpecificationFile testfile = this.compilerMaven.generateTestFile_l2p(configs, l2p_test_dir, "ExampleTest.java");
        testfile.save();
        this.compilerMaven.makeRootPom(configs, root_dir, cli_lib, l2p_lib);
        this.compilerMaven.makeSubPom(configs, l2p_dir, l2p_lib, true, false, false, false);
        SpecificationFile testfile2 = this.compilerClientTest.generateTestFile_cli(configs, locations, cli_test_dir, "ExampleTest.java");
        testfile2.save();
    }

    public void doGenerateClientAndProject(TemplatesProjectConfiguration configs, Locations locations, String cli_lib, String cli_dir, String cli_src_dir) {
        String openprovenance_dir = cli_src_dir + "/" + "org.openprovenance.prov.client".replace('.', '/') + "/";
        this.compilerMaven.makeSubPom(configs, cli_dir, cli_lib, false, configs.jsweet, true, this.compilerCommon.getFoundEscape());
        SpecificationFile logger = this.compilerLogger.generateLogger(configs, locations, "Logger", this.getInputOutputMaps());
        logger.save();
        SpecificationFile intface = this.compilerLogger.generateBuilderInterface(configs, openprovenance_dir, "Builder.java");
        intface.save();
        SpecificationFile intface2 = this.compilerLogger.generateLoggerInterface(configs, openprovenance_dir, "LoggerInterface.java");
        intface2.save();
        SpecificationFile intface3 = this.compilerLogger.generateProcessorArgsInterface(configs, openprovenance_dir, "ProcessorArgsInterface.java");
        intface3.save();
        SpecificationFile intface3b = this.compilerLogger.generateRecordsProcessorInterface(configs, openprovenance_dir, "RecordsProcessorInterface.java");
        intface3b.save();
        this.exportMiscFiles(configs, cli_dir, cli_lib);
        this.compilerScript.generateScript(configs);
        SpecificationFile templateBuilders = this.compilerTemplateBuilders.generateTemplateBuilders(configs, locations, "TemplateBuilders");
        templateBuilders.save();
        SpecificationFile tableConfigurator = this.compilerTableConfigurator.generateTableConfigurator(configs, locations);
        tableConfigurator.save();
        SpecificationFile tableConfigurator2 = this.compilerTableConfigurator.generateCompositeTableConfigurator(configs, locations);
        tableConfigurator2.save();
        SpecificationFile beanProcessor = this.compilerBeanProcessor.generateBeanProcessor(configs, locations, "BeanProcessor");
        beanProcessor.save();
        String integrator_package = locations.getFilePackage(BeanDirection.OUTPUTS);
        String integrator_dir = locations.convertToDirectory(integrator_package);
        SpecificationFile beanCompleter = this.compilerBeanCompleter.generateBeanCompleter(configs, locations, "BeanCompleter");
        beanCompleter.save();
        if (configs.integrator) {
            SpecificationFile inputOutputProcessor = this.compilerInputOutputProcessor.generateInputOutputProcessor(configs, locations, integrator_package, true, integrator_dir, "InputOutputProcessor.java");
            inputOutputProcessor.save();
            SpecificationFile inputProcessor = this.compilerInputOutputProcessor.generateInputOutputProcessor(configs, locations, integrator_package, false, integrator_dir, "InputProcessor.java");
            inputProcessor.save();
            SpecificationFile templateInvoker = this.compilerTemplateInvoker.generateTemplateInvoker(configs, locations, "TemplateInvoker");
            templateInvoker.save();
            SpecificationFile beanCompleter2 = this.compilerBeanCompleter2.generateBeanCompleter2(configs, locations, "BeanCompleter2");
            beanCompleter2.save();
            SpecificationFile beanCompleter3 = this.compilerBeanCompleter3.generateBeanCompleter3(configs, locations, "BeanCompleter3");
            beanCompleter3.save();
            SpecificationFile beanCompleter2Composite = this.compilerBeanCompleter2Composite.generateBeanCompleter2Composite(configs, locations, "CompositeBeanCompleter2");
            beanCompleter2Composite.save();
        }
        SpecificationFile typeConverter = this.compilerTypeConverter.generateTypeConverter(configs, locations, "TypeConverter");
        typeConverter.save();
        SpecificationFile beanEnactor = this.compilerBeanEnactor.generateBeanEnactor(configs, locations, "BeanEnactor");
        beanEnactor.save();
        if (configs.integrator) {
            SpecificationFile beanEnactor2 = this.compilerBeanEnactor2.generateBeanEnactor2(configs, locations, "BeanEnactor2");
            beanEnactor2.save();
            SpecificationFile beanEnactor2WP = this.compilerBeanEnactor2WP.generateBeanEnactor2WithPrincipal(configs, locations, "BeanEnactor4");
            beanEnactor2WP.save();
            SpecificationFile beanEnactor2Composite = this.compilerBeanEnactor2composite.generateBeanEnactor2Composite(configs, locations, "BeanEnactor2Composite");
            beanEnactor2Composite.save();
            SpecificationFile beanEnactor2CompositeWP = this.compilerBeanEnactor2compositeWP.generateBeanEnactor2CompositeWithPrincipal(configs, locations, "BeanEnactor4Composite");
            beanEnactor2CompositeWP.save();
            SpecificationFile queryComposer3 = this.compilerQueryInvoker.generateQueryInvoker(configs, locations, false, "QueryInvoker2");
            queryComposer3.save();
            SpecificationFile queryComposerWP = this.compilerQueryInvokerWithPrincipal.generateQueryInvokerWithPrincipal(configs, locations, "QueryInvoker4");
            queryComposerWP.save();
            if (configs.sqlFile != null) {
                SpecificationFile generateSqlIntegration_beanCompleter = this.compilerSqlIntegration.generateSqlIntegration_BeanCompleter(configs, locations, "SqlBeanCompleter");
                generateSqlIntegration_beanCompleter.save();
                SpecificationFile generateSqlIntegration_compositeBeanCompleter = this.compilerSqlIntegration.generateSqlIntegration_CompositeBeanCompleter(configs, locations, "SqlCompositeBeanCompleter");
                generateSqlIntegration_compositeBeanCompleter.save();
                SpecificationFile generateSqlIntegration_beanCompleter3 = this.compilerSqlIntegration.generateSqlIntegration_BeanCompleter3(configs, locations, "SqlBeanCompleter3");
                generateSqlIntegration_beanCompleter3.save();
                SpecificationFile generateSqlIntegration_beanCompleter4 = this.compilerSqlIntegration.generateSqlIntegration_BeanCompleter4(configs, locations, "SqlBeanCompleter4");
                generateSqlIntegration_beanCompleter4.save();
                SpecificationFile generateSqlIntegration_enactorImplementation = this.compilerSqlIntegration.generateSqlIntegration_EnactorImplementation(configs, locations, "SqlEnactorImplementation");
                generateSqlIntegration_enactorImplementation.save();
                SpecificationFile generateSqlIntegration_enactorImplementation3 = this.compilerSqlIntegration.generateSqlIntegration_IntegratorEnactorImplementation(configs, locations, "SqlEnactorImplementation3");
                generateSqlIntegration_enactorImplementation3.save();
                SpecificationFile generateSqlIntegration_enactorImplementation4 = this.compilerSqlIntegration.generateSqlIntegration_IntegratorEnactorImplementation4(configs, locations, "SqlEnactorImplementation4");
                generateSqlIntegration_enactorImplementation4.save();
                SpecificationFile generateSqlIntegration_beanEnactorImplementation = this.compilerSqlIntegration.generateSqlIntegration_CompositeEnactorImplementation(configs, locations, "SqlCompositeEnactorImplementation");
                generateSqlIntegration_beanEnactorImplementation.save();
                SpecificationFile generateSqlIntegration_compositeBeanEnactor = this.compilerSqlIntegration.generateSqlIntegration_CompositeBeanEnactor(configs, locations, "SqlCompositeBeanEnactor");
                generateSqlIntegration_compositeBeanEnactor.save();
                SpecificationFile generateSqlIntegration_beanEnactor = this.compilerSqlIntegration.generateSqlIntegration_BeanEnactor(configs, locations, "SqlBeanEnactor");
                generateSqlIntegration_beanEnactor.save();
                SpecificationFile generateSqlIntegration_beanEnactor3 = this.compilerSqlIntegration.generateSqlIntegration_BeanEnactor3(configs, locations, "SqlBeanEnactor3");
                generateSqlIntegration_beanEnactor3.save();
                SpecificationFile generateSqlIntegration_beanEnactor4 = this.compilerSqlIntegration.generateSqlIntegration_BeanEnactor4(configs, locations, "SqlBeanEnactor4");
                generateSqlIntegration_beanEnactor4.save();
                SpecificationFile generateSqlIntegration_compositeEnactorImplementation3 = this.compilerSqlIntegration.generateSqlIntegration_CompositeEnactorImplementation3(configs, locations, "SqlCompositeEnactorImplementation3");
                generateSqlIntegration_compositeEnactorImplementation3.save();
                SpecificationFile generateSqlIntegration_compositeEnactorImplementation4 = this.compilerSqlIntegration.generateSqlIntegration_CompositeEnactorImplementation4(configs, locations, "SqlCompositeEnactorImplementation4");
                generateSqlIntegration_compositeEnactorImplementation4.save();
                SpecificationFile generatedSqlIntegration_compositeBeanCompleter3 = this.compilerSqlIntegration.generateSqlIntegration_CompositeBeanCompleter3(configs, locations, "SqlCompositeBeanCompleter3");
                generatedSqlIntegration_compositeBeanCompleter3.save();
                SpecificationFile generatedSqlIntegration_compositeBeanCompleter4 = this.compilerSqlIntegration.generateSqlIntegration_CompositeBeanCompleter4(configs, locations, "SqlCompositeBeanCompleter4");
                generatedSqlIntegration_compositeBeanCompleter4.save();
                SpecificationFile generateSqlIntegration_compositeBeanEnactor3 = this.compilerSqlIntegration.generateSqlIntegration_CompositeBeanEnactor3(configs, locations, "SqlCompositeBeanEnactor3");
                generateSqlIntegration_compositeBeanEnactor3.save();
                SpecificationFile generateSqlIntegration_compositeBeanEnactor4 = this.compilerSqlIntegration.generateSqlIntegration_CompositeBeanEnactor4(configs, locations, "SqlCompositeBeanEnactor4");
                generateSqlIntegration_compositeBeanEnactor4.save();
                SpecificationFile generatedSqlIntegration_compositeEnactorConfigurator3 = this.compilerSqlIntegration.generateSqlIntegration_CompositeEnactorConfigurator3(configs, locations, "SqlCompositeEnactorConfigurator3");
                generatedSqlIntegration_compositeEnactorConfigurator3.save();
                SpecificationFile generatedSqlIntegration_compositeEnactorConfigurator4 = this.compilerSqlIntegration.generateSqlIntegration_CompositeEnactorConfigurator4(configs, locations, "SqlCompositeEnactorConfigurator4");
                generatedSqlIntegration_compositeEnactorConfigurator4.save();
                SpecificationFile generatedSqlIntegration_enactorConfigurator3 = this.compilerSqlIntegration.generateSqlIntegration_EnactorConfigurator3(configs, locations, "SqlEnactorConfigurator3");
                generatedSqlIntegration_enactorConfigurator3.save();
                SpecificationFile generatedSqlIntegration_enactorConfigurator4 = this.compilerSqlIntegration.generateSqlIntegration_EnactorConfigurator4(configs, locations, "SqlEnactorConfigurator4");
                generatedSqlIntegration_enactorConfigurator4.save();
            }
        }
        SpecificationFile queryComposer = this.compilerQueryInvoker.generateQueryInvoker(configs, locations, true, "QueryInvoker");
        queryComposer.save();
        SpecificationFile beanChecker = this.compilerBeanChecker.generateBeanChecker(configs, locations, BeanDirection.COMMON, null, "BeanChecker");
        beanChecker.save();
        SpecificationFile beanDelegator = this.compilerDelegator.generateDelegator(configs, locations, "Delegator");
        beanDelegator.save();
        if (configs.sqlFile != null) {
            SpecificationFile configurationSql = this.compilerConfigurations.generateSqlConfigurator(configs, "SqlConfigurator", locations, locations.convertToDirectory(locations.getFilePackage("SqlConfigurator")), "SqlConfigurator.java");
            configurationSql.save();
        }
        SpecificationFile configurationPropertyOrder = this.compilerConfigurations.generatePropertyOrderConfigurator(configs, "PropertyOrderConfigurator", locations, locations.convertToDirectory(locations.getFilePackage("PropertyOrderConfigurator")), "PropertyOrderConfigurator.java");
        configurationPropertyOrder.save();
        SpecificationFile configurationCsv = this.compilerConfigurations.generateCsvConfigurator(configs, "CsvConfigurator", locations, locations.convertToDirectory(locations.getFilePackage("CsvConfigurator")), "CsvConfigurator.java");
        configurationCsv.save();
        SpecificationFile configurationBuilder = this.compilerConfigurations.generateBuilderConfigurator(configs, "BuilderConfigurator", locations, locations.convertToDirectory(locations.getFilePackage("BuilderConfigurator")), "BuilderConfigurator.java");
        configurationBuilder.save();
        if (configs.sqlFile != null) {
            SpecificationFile configurationSqlInsert = this.compilerConfigurations.generateSqlInsertConfigurator(configs, "SqlInsertConfigurator", locations, locations.convertToDirectory(locations.getFilePackage("SqlInsertConfigurator")), "SqlInsertConfigurator.java");
            configurationSqlInsert.save();
        }
        SpecificationFile configurationConverter = this.compilerConfigurations.generateConverterConfigurator(configs, "ConverterConfigurator", locations, locations.convertToDirectory(locations.getFilePackage("ConverterConfigurator")), "ConverterConfigurator.java");
        configurationConverter.save();
        SpecificationFile record2recordConverter = this.compilerConfigurations.generateRecord2RecordConfiguration(configs, "CsvRecord2ObjectRecordConfigurator", locations, locations.convertToDirectory(locations.getFilePackage("CsvRecord2ObjectRecordConfigurator")), "CsvRecord2ObjectRecordConfigurator.java");
        record2recordConverter.save();
        if (configs.integrator) {
            SpecificationFile configurationInputPropertyOrder = this.compilerConfigurations.generateInputsConfigurator(configs, "InputsConfigurator", locations, locations.convertToDirectory(locations.getFilePackage("InputsConfigurator")), "InputsConfigurator.java");
            configurationInputPropertyOrder.save();
            SpecificationFile configurationOutputPropertyOrder = this.compilerConfigurations.generateOutputsConfigurator(configs, "OutputsConfigurator", locations, locations.convertToDirectory(locations.getFilePackage("OutputsConfigurator")), "OutputsConfigurator.java");
            configurationOutputPropertyOrder.save();
            SpecificationFile configurationEnactor = this.compilerConfigurations.generateEnactorConfigurator(configs, "EnactorConfigurator", locations, locations.convertToDirectory(locations.getFilePackage("EnactorConfigurator")), "EnactorConfigurator.java");
            configurationEnactor.save();
            SpecificationFile configurationEnactor2 = this.compilerConfigurations.generateEnactorConfigurator2(configs, "EnactorConfigurator2", locations.getFilePackage(BeanDirection.INPUTS), locations, locations.convertToDirectory(locations.getFilePackage("EnactorConfigurator2")), "EnactorConfigurator2.java");
            configurationEnactor2.save();
            SpecificationFile compositeConfigurationEnactor2 = this.compilerCompositeConfigurations.generateCompositeEnactorConfigurator2(configs, locations, "CompositeEnactorConfigurator2");
            compositeConfigurationEnactor2.save();
        }
        SpecificationFile compositeConfigurationEnactor = this.compilerCompositeConfigurations.generateCompositeEnactorConfigurator(configs, locations, "CompositeEnactorConfigurator");
        compositeConfigurationEnactor.save();
    }

    private void exportMiscFiles(TemplatesProjectConfiguration configs, String cli_dir, String cli_lib) {
        String targetLocation;
        InputStream is;
        if (configs.jsweet) {
            is = this.getClass().getResourceAsStream("/js/TemplateManager.js");
            targetLocation = cli_dir + "/src/main/js";
            try {
                FileUtils.copyToFile((InputStream)is, (File)new File(targetLocation + "/TemplateManager.js"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        is = this.getClass().getResourceAsStream("/css/provtemplate.css");
        targetLocation = cli_dir + "/src/main/css";
        try {
            FileUtils.copyToFile((InputStream)is, (File)new File(targetLocation + "/provtemplate.css"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JsonNode readTree(File file) throws IOException {
        return objectMapper.readTree(file);
    }

    public TemplateBindingsSchema getBindingsSchema(String location) {
        return this.compilerUtil.getBindingsSchema(location);
    }

    public Document readDocumentFromFile(SimpleTemplateCompilerConfig config) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, FileNotFoundException {
        return this.compilerUtil.readDocumentFromFile(config.template);
    }

    public void doGenerateServerForEntry(SimpleTemplateCompilerConfig config, TemplatesProjectConfiguration configs, Locations locations, String cli_src_dir, String l2p_src_dir, org.openprovenance.prov.model.ProvFactory pFactory, String cli_webjar_dir) {
        JsonNode bindings_schema = this.compilerUtil.get_bindings_schema(config);
        TemplateBindingsSchema bindingsSchema = this.compilerUtil.getBindingsSchema(config);
        this.findSqlTableReferences(bindingsSchema);
        try {
            Document doc = this.readDocumentFromFile(config);
            this.generate(doc, locations, config.name, config.package_, cli_src_dir, l2p_src_dir, "resource", configs.jsonschema, configs.documentation, bindings_schema, bindingsSchema, configs.sqlTables, cli_webjar_dir, config.inComposition, config.sharing, null, configs);
        }
        catch (FileNotFoundException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.out.println("could not find Interop Framework");
            e.printStackTrace();
            System.out.println(Arrays.asList("doc", config.name, config.package_, cli_src_dir, l2p_src_dir, "resource", bindings_schema));
        }
    }

    public void doGenerateServerForEntry(CompositeTemplateCompilerConfig compositeTemplateCompilerConfig, SimpleTemplateCompilerConfig config, TemplatesProjectConfiguration configs, Locations locations, String cli_src_dir, String l2p_src_dir, String cli_webjar_dir) {
        JsonNode bindings_schema = this.compilerUtil.get_bindings_schema(config);
        TemplateBindingsSchema bindingsSchema = this.compilerUtil.getBindingsSchema(config);
        try {
            Document doc = this.readDocumentFromFile(config);
            this.generate(doc, locations, config.name, config.package_, cli_src_dir, l2p_src_dir, "resource", configs.jsonschema, configs.documentation, bindings_schema, bindingsSchema, configs.sqlTables, cli_webjar_dir, config.inComposition, compositeTemplateCompilerConfig.sharing, compositeTemplateCompilerConfig.consistsOf, configs);
        }
        catch (FileNotFoundException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.out.println("could not find Interop Framework");
            e.printStackTrace();
            System.out.println(Arrays.asList("doc", config.name, config.package_, cli_src_dir, l2p_src_dir, "resource", bindings_schema));
        }
    }

    public void doGenerateServerForEntry1(Document doc, SimpleTemplateCompilerConfig config, TemplatesProjectConfiguration configs, Locations locations, String cli_src_dir, String l2p_src_dir, String cli_webjar_dir) {
        JsonNode bindings_schema = this.compilerUtil.get_bindings_schema(config);
        TemplateBindingsSchema bindingsSchema = this.compilerUtil.getBindingsSchema(config);
        try {
            this.generate(doc, locations, config.name, config.package_, cli_src_dir, l2p_src_dir, "resource", configs.jsonschema, configs.documentation, bindings_schema, bindingsSchema, configs.sqlTables, cli_webjar_dir, config.inComposition, config.sharing, null, configs);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public boolean generate(Document doc, Locations locations, String templateName, String packageName, String cli_src_dir, String l2p_src_dir, String resource, String jsonschema, String documentation, JsonNode bindings_schema, TemplateBindingsSchema bindingsSchema, Map<String, Map<String, String>> sqlTables, String cli_webjar_dir, boolean inComposition, List<String> sharing, String consistsOf, TemplatesProjectConfiguration configs) {
        try {
            String cli_webjar_html_dir;
            String bn = this.compilerUtil.templateNameClass(templateName);
            String bnI = this.compilerUtil.templateNameClass(templateName) + "Interface";
            String bnTM = this.compilerUtil.templateNameClass(templateName) + "TypeManagement";
            String bnTR = this.compilerUtil.templateNameClass(templateName) + "TypedRecord";
            String bean = this.compilerUtil.commonNameClass(templateName);
            String outputs = this.compilerUtil.outputsNameClass(templateName);
            String inputs = this.compilerUtil.inputsNameClass(templateName);
            String integratorBuilder = this.compilerUtil.integratorBuilderNameClass(templateName);
            String compositeBeanNameClass = this.compilerUtil.commonNameClass(templateName);
            if (consistsOf == null) {
                this.buildJoinTable(templateName, bindingsSchema);
            }
            IndexedDocument indexed = this.makeIndexedDocument(doc);
            ((Bundle)CompilerUtil.u.getBundle(doc).get(0)).getStatement().clear();
            ((Bundle)CompilerUtil.u.getBundle(doc).get(0)).getStatement().addAll(CompilerUtil.u.getStatement(indexed.toDocument()));
            boolean val0 = true;
            boolean val1 = true;
            boolean val2 = true;
            boolean val2b = true;
            boolean val5 = true;
            boolean val6 = true;
            boolean val3 = true;
            boolean val4 = true;
            boolean val7 = true;
            if (!inComposition) {
                Pair<SpecificationFile, Map<Integer, List<Integer>>> tmp = this.compilerCommon.generateCommonLib(configs, locations, doc, bn, templateName, locations.getFilePackage(BeanDirection.COMMON), bindingsSchema, indexed, BeanKind.SIMPLE, bn + ".java", consistsOf);
                SpecificationFile spec2 = (SpecificationFile)tmp.getLeft();
                val2 = spec2.save();
                Map successorTable = (Map)tmp.getRight();
                SpecificationFile spec5 = this.compilerTypeManagement.generateTypeDeclaration(configs, locations, doc, bn, templateName, packageName, bindings_schema, bindingsSchema, locations.convertToDirectory(l2p_src_dir, locations.getFileBackendPackage(bnTM)), bnTM + ".java");
                SpecificationFile spec0 = this.compilerExpansionBuilder.generateBuilderSpecification(configs, locations, doc, bn, templateName, packageName, bindings_schema, bindingsSchema, successorTable, locations.convertToDirectory(l2p_src_dir, locations.getFileBackendPackage(bn)), bn + ".java");
                val0 = spec0.save();
                SpecificationFile spec1 = this.compilerExpansionBuilder.generateBuilderInterfaceSpecification(configs, locations, doc, bn, templateName, packageName, bindingsSchema, locations.convertToDirectory(l2p_src_dir, locations.getFileBackendPackage(bnI)), bnI + ".java");
                val1 = spec1.save();
                SpecificationFile spec2b = this.compilerCommon.generateSQLInterface(configs, locations, "SQL");
                val2b = spec2b.save();
                val2 &= val2b;
                SpecificationFile spec6 = this.compilerTypedRecord.generatedTypedRecordConstructor(configs, locations, doc, bn, templateName, packageName, resource, bindings_schema, bindingsSchema, locations.convertToDirectory(l2p_src_dir, locations.getFileBackendPackage(bnTR)), bnTR + ".java");
                val5 = spec5.save();
                val6 = spec6.save();
                SpecificationFile tableConfiguratorWithMap = this.compilerTableConfiguratorWithMap.generateTableConfigurator(configs, locations, locations.convertToDirectory(l2p_src_dir, locations.getFileBackendPackage(bnI)));
                tableConfiguratorWithMap.save();
                SpecificationFile tableConfiguratorForTypes = this.compilerTableConfiguratorForTypes.generateTableConfigurator(configs, locations, locations.convertToDirectory(l2p_src_dir, locations.getFileBackendPackage(bnI)));
                tableConfiguratorForTypes.save();
            }
            String integratorPackage = locations.getFilePackage(BeanDirection.OUTPUTS);
            String integratorDir = locations.convertToDirectory(integratorPackage);
            if (!inComposition) {
                SpecificationFile spec3 = this.compilerBeanGenerator.generateBean(configs, locations, templateName, bindingsSchema, BeanKind.SIMPLE, BeanDirection.COMMON, null, null, null, bean + ".java");
                val3 = spec3.save();
                if (configs.integrator) {
                    SpecificationFile spec3b = this.compilerBeanGenerator.generateBean(configs, locations, templateName, bindingsSchema, BeanKind.SIMPLE, BeanDirection.OUTPUTS, null, null, null, outputs + ".java");
                    val3 &= spec3b.save();
                    SpecificationFile spec3c = this.compilerBeanGenerator.generateBean(configs, locations, templateName, bindingsSchema, BeanKind.SIMPLE, BeanDirection.INPUTS, null, null, null, inputs + ".java");
                    val3 &= spec3c.save();
                    SpecificationFile spec7 = this.compilerIntegrator.generateIntegrator(locations, templateName, integratorPackage, bindingsSchema, "Logger", BeanKind.SIMPLE, consistsOf, integratorDir, integratorBuilder + ".java");
                    val3 &= spec7.save();
                    SpecificationFile spec4b = this.compilerProcessor.generateProcessor(locations, templateName, locations.getFilePackage(BeanDirection.INPUTS), bindingsSchema, true, this.compilerUtil.integratorNameClass(templateName) + ".java", consistsOf);
                    val4 &= spec4b.save();
                }
                SpecificationFile spec4 = this.compilerProcessor.generateProcessor(locations, templateName, locations.getFilePackage(BeanDirection.COMMON), bindingsSchema, false, this.compilerUtil.processorNameClass(templateName) + ".java", consistsOf);
                val4 = spec4.save();
            }
            if (!inComposition) {
                this.compilerJsonSchema.generateJSonSchema(templateName, bindingsSchema, null, "#/definitions/", sharing);
                if (configs.sqlFile != null) {
                    this.compilerSQL.generateSQL(templateName, bindingsSchema);
                    this.compilerSQL.generateSQLInsertFunction(jsonschema + "SQL", templateName, null, cli_src_dir + "/../sql", bindingsSchema, Arrays.asList(new String[0]), this.getInputOutputMaps(), configs.search);
                    this.compilerSQL.generateSQLPrimitiveTables(sqlTables, bindingsSchema);
                }
            }
            if (inComposition) {
                Pair<SpecificationFile, Map<Integer, List<Integer>>> tmp;
                if (consistsOf == null) {
                    throw new NullPointerException("No composed class has been specified for composite " + templateName);
                }
                this.compilerJsonSchema.generateJSonSchema(templateName + "_1", bindingsSchema, null, "#/definitions/", null);
                if (configs.sqlFile != null) {
                    this.compilerSQL.generateSQLInsertFunction(jsonschema + "SQL", templateName, consistsOf, cli_src_dir + "/../sql", bindingsSchema, sharing, this.getInputOutputMaps(), configs.search);
                }
                SimpleTemplateCompilerConfig config = new SimpleTemplateCompilerConfig();
                config.name = compositeBeanNameClass;
                config.package_ = packageName;
                config.bindings = "openprovenance:composite-bean.json";
                config.template = "openprovenance:composite-bean.provn";
                TemplateBindingsSchema bindingsSchema2 = this.compilerUtil.getBindingsSchema(config);
                this.compilerJsonSchema.generateJSonSchema(templateName, bindingsSchema2, consistsOf, "#/definitions/", sharing);
                if (configs.sqlFile != null) {
                    this.compilerSQL.generateSQL(templateName, bindingsSchema2);
                }
                SpecificationFile spec4 = this.compilerProcessor.generateProcessor(locations, templateName, locations.getFilePackage(BeanDirection.COMMON), bindingsSchema2, false, this.compilerUtil.processorNameClass(templateName) + ".java", consistsOf);
                val4 = spec4.save();
                SpecificationFile spec7b = this.compilerBeanGenerator.generateBean(configs, locations, templateName, bindingsSchema2, BeanKind.COMPOSITE, BeanDirection.COMMON, consistsOf, null, null, compositeBeanNameClass + ".java");
                if (spec7b != null) {
                    val3 &= spec7b.save();
                }
                if (configs.integrator) {
                    SpecificationFile spec7d;
                    SpecificationFile spec7c = this.compilerBeanGenerator.generateBean(configs, locations, templateName, bindingsSchema2, BeanKind.COMPOSITE, BeanDirection.OUTPUTS, consistsOf, null, null, outputs + ".java");
                    if (spec7c != null) {
                        val3 &= spec7c.save();
                    }
                    if ((spec7d = this.compilerBeanGenerator.generateBean(configs, locations, templateName, bindingsSchema2, BeanKind.COMPOSITE, BeanDirection.INPUTS, consistsOf, sharing, null, inputs + ".java")) != null) {
                        val3 &= spec7d.save();
                    }
                }
                if ((tmp = this.compilerCommon.generateCommonLib(configs, locations, doc, bn, templateName, locations.getFilePackage(BeanDirection.COMMON), bindingsSchema2, indexed, BeanKind.COMPOSITE, bn + ".java", consistsOf)).getLeft() != null) {
                    SpecificationFile spec2 = (SpecificationFile)tmp.getLeft();
                    val3 &= spec2.save();
                }
                if (configs.integrator) {
                    SpecificationFile spec7 = this.compilerIntegrator.generateIntegrator(locations, templateName, integratorPackage, bindingsSchema2, "Logger", BeanKind.COMPOSITE, consistsOf, integratorDir, integratorBuilder + ".java");
                    val3 &= spec7.save();
                }
            }
            if (!inComposition) {
                cli_webjar_html_dir = cli_webjar_dir + "/html";
                new File(cli_webjar_html_dir).mkdirs();
                this.compilerDocumentation.generateDocumentation(documentation, templateName, cli_webjar_html_dir, bindingsSchema, null);
            } else {
                cli_webjar_html_dir = cli_webjar_dir + "/html";
                new File(cli_webjar_html_dir).mkdirs();
                this.compilerDocumentation.generateDocumentation(documentation, templateName, cli_webjar_html_dir, bindingsSchema, sharing);
            }
            return val1 & val2 & val3 & val4;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Map<String, Map<String, Map<String, String>>> getInputOutputMaps() {
        HashMap<String, Map<String, Map<String, String>>> map;
        if (this.ioMap != null) {
            return this.ioMap;
        }
        this.ioMap = map = new HashMap<String, Map<String, Map<String, String>>>(){
            {
                this.put("input", ConfigProcessor.this.inputMap);
                this.put("output", ConfigProcessor.this.outputMap);
            }
        };
        return map;
    }

    public void buildJoinTable(String templateName, TemplateBindingsSchema bindingsSchema) {
        for (String key : descriptorUtils.fieldNames(bindingsSchema)) {
            Optional<String> sqlRelationName = descriptorUtils.getSqlTable(key, bindingsSchema);
            if (descriptorUtils.isOutput(key, bindingsSchema)) {
                sqlRelationName.ifPresent(rel -> {
                    Map map = this.outputMap.computeIfAbsent(templateName, any -> new HashMap());
                    map.put(key, rel);
                });
                continue;
            }
            if (!descriptorUtils.isInput(key, bindingsSchema)) continue;
            sqlRelationName.ifPresent(rel -> {
                Map map = this.inputMap.computeIfAbsent(templateName, any -> new HashMap());
                map.put(key, rel);
            });
        }
    }

    private IndexedDocument makeIndexedDocument(Document doc) {
        IndexedDocument indexed = new IndexedDocument(this.pFactory, this.pFactory.newDocument(), true);
        Bundle bun = (Bundle)CompilerUtil.u.getBundle(doc).get(0);
        CompilerUtil.u.forAllStatement(bun.getStatement(), (StatementAction)indexed);
        indexed.getWasDerivedFrom().forEach(wdf -> {
            if (wdf.getId() == null) {
                wdf.setId(StatementTypeAction.gensym());
            }
        });
        return indexed;
    }

    public CompilerJsonSchema getCompilerJsonSchema() {
        return this.compilerJsonSchema;
    }

    public static void main(String[] args) {
        if (args.length != 3 && args.length != 2) {
            throw new IllegalArgumentException("Usage: ConfigProcessor <config-file> <inputBaseDir> <outputBaseDir>");
        }
        ProvFactory pf = new ProvFactory();
        ConfigProcessor cp = new ConfigProcessor((org.openprovenance.prov.model.ProvFactory)pf);
        String inputBaseDir = args[1];
        String outputBaseDir = args.length == 3 ? args[2] : inputBaseDir;
        cp.processTemplateGenerationConfig(args[0], inputBaseDir, outputBaseDir, (org.openprovenance.prov.model.ProvFactory)pf);
    }

    static {
        objectMapper = new ObjectMapper();
        descriptorUtils = new DescriptorUtils();
        descriptorUtils.setupDeserializer(objectMapper);
    }
}

