/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.configuration;

import java.io.File;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesProjectConfiguration;

public class Locations {
    private final String cli_src_dir;
    private final TemplatesProjectConfiguration configs;
    private final String configurator_package;
    private final String logger_package;
    private final String configurator_package2;
    private final String l2p_src_dir;
    private String config_common_package;
    private String config_backend;
    private String config_integrator_package;
    private String config_access_control_package;
    private String config_sql_common_backend_package;
    private String config_sql_integration_backend_package;
    private String config_sql_access_control_backend_package;
    public final String python_dir;
    static final String CONFIG2_EXTENSION = "2";

    public void updateWithConfig(TemplateCompilerConfig config) {
        if (config.package_ == null) {
            config.package_ = this.configs.root_package;
        }
        this.config_common_package = config.package_ + ".client.common";
        this.config_integrator_package = config.package_ + ".client.integrator";
        this.config_access_control_package = config.package_ + ".client.access_control";
        this.config_backend = config.package_;
        this.config_sql_common_backend_package = this.config_backend + ".sql.common";
        this.config_sql_integration_backend_package = this.config_backend + ".sql.integration";
        this.config_sql_access_control_backend_package = this.config_backend + ".sql.access_control";
    }

    public Locations(TemplatesProjectConfiguration configs, String cli_src_dir, String l2p_src_dir) {
        this.configs = configs;
        this.cli_src_dir = cli_src_dir;
        this.l2p_src_dir = l2p_src_dir;
        this.python_dir = configs.python_dir;
        this.configurator_package = configs.root_package + ".client.configurator";
        this.configurator_package2 = configs.root_package + ".client.configurator2";
        this.logger_package = configs.root_package + ".client.logger";
    }

    public String convertToDirectory(String rootDir, String aPackage) {
        String theDirectory = rootDir + "/" + aPackage.replace('.', '/') + "/";
        new File(theDirectory).mkdirs();
        return theDirectory;
    }

    public String convertToDirectory(String aPackage) {
        return this.cli_src_dir + "/" + aPackage.replace('.', '/') + "/";
    }

    public String convertToBackendDirectory(String aPackage) {
        return this.l2p_src_dir + "/" + aPackage.replace('.', '/') + "/";
    }

    public String getFilePackage(String file) {
        switch (file) {
            case "SqlBeanCompleter": 
            case "SqlBeanEnactor": 
            case "SqlEnactorImplementation": 
            case "SqlCompositeBeanCompleter": 
            case "SqlCompositeEnactorImplementation": 
            case "SqlCompositeBeanEnactor": {
                return this.config_sql_common_backend_package;
            }
            case "SqlBeanCompleter3": 
            case "SqlEnactorImplementation3": 
            case "SqlCompositeBeanEnactor3": 
            case "SqlCompositeBeanCompleter3": 
            case "SqlCompositeEnactorImplementation3": 
            case "SqlBeanEnactor3": 
            case "SqlEnactorConfigurator3": 
            case "SqlCompositeEnactorConfigurator3": {
                return this.config_sql_integration_backend_package;
            }
            case "SqlBeanCompleter4": 
            case "BeanEnactor4Composite": 
            case "BeanEnactor4": 
            case "QueryInvoker4": 
            case "SqlEnactorImplementation4": 
            case "SqlBeanEnactor4": 
            case "SqlEnactorConfigurator4": 
            case "SqlCompositeBeanEnactor4": 
            case "SqlCompositeEnactorConfigurator4": 
            case "SqlCompositeEnactorImplementation4": 
            case "SqlCompositeBeanCompleter4": {
                return this.config_sql_access_control_backend_package;
            }
            case "Logger": 
            case "TemplateBuilders": {
                return this.logger_package;
            }
            case "BeanEnactor2": 
            case "BeanEnactor2Composite": 
            case "TemplateInvoker": 
            case "InputOutputProcessor": 
            case "QueryInvoker2": 
            case "InputProcessor": 
            case "CompositeBeanCompleter2": 
            case "BeanChecker2": 
            case "BeanCompleter2": 
            case "BeanCompleter3": {
                return this.config_integrator_package;
            }
            case "TableConfigurator": 
            case "TableConfiguratorForTypes": 
            case "TableConfiguratorWithMap": 
            case "TableConfiguratorForTypesWithMap": 
            case "ConverterConfigurator": 
            case "BuilderConfigurator": 
            case "SqlInsertConfigurator": 
            case "PropertyOrderConfigurator": 
            case "OutputsConfigurator": 
            case "InputsConfigurator": 
            case "SqlConfigurator": 
            case "CsvConfigurator": 
            case "EnactorConfigurator": 
            case "CompositeEnactorConfigurator": 
            case "CsvRecord2ObjectRecordConfigurator": 
            case "CompositeTableConfigurator": {
                return this.configurator_package;
            }
            case "CompositeEnactorConfigurator2": 
            case "EnactorConfigurator2": {
                return this.configurator_package2;
            }
            case "TypeConverter": 
            case "Delegator": 
            case "BeanCompleter": 
            case "BeanChecker": 
            case "QueryInvoker": 
            case "BeanEnactor": 
            case "BeanProcessor": {
                return this.config_common_package;
            }
            case "SQL": {
                return "org.openprovenance.prov.client";
            }
        }
        throw new UnsupportedOperationException("Unknown file " + file);
    }

    public String getFilePackage(BeanDirection dir) {
        switch (dir) {
            case INPUTS: {
                return this.config_integrator_package;
            }
            case OUTPUTS: {
                return this.config_integrator_package;
            }
            case COMMON: {
                return this.config_common_package;
            }
        }
        throw new IllegalStateException("never here");
    }

    public String getFileBackendPackage(String name) {
        return this.config_backend;
    }
}

