/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerSQL;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.sql.PrettyPrinter;
import org.openprovenance.prov.template.compiler.sql.QueryBuilder;
import org.openprovenance.prov.template.descriptors.AttributeDescriptor;
import org.openprovenance.prov.template.descriptors.Descriptor;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;

public class CompilerSqlComposer {
    public static final String[] ARRAY_OF_STRING = new String[0];
    public static final String TOKEN_VAR_NAME = "_token";
    public static final String DUMMY = "__dummy_";
    private final CompilerUtil compilerUtil;
    final Map<String, String> functionDeclarations;
    final Map<String, String> arrayFunctionDeclarations;
    private final String tableKey;
    Map<String, String> nameMap = CompilerSQL.initNameMap();

    public CompilerSqlComposer(ProvFactory pFactory, String tableKey, Map<String, String> functionDeclarations, Map<String, String> arrayFunctionDeclarations) {
        this.tableKey = tableKey;
        this.functionDeclarations = functionDeclarations;
        this.arrayFunctionDeclarations = arrayFunctionDeclarations;
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    public static <T> Collector<T, List<T>, List<T>> toListCollector() {
        return Collector.of(ArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, new Collector.Characteristics[0]);
    }

    public static <T> Collector<Pair<T, T>, List<T>, List<T>> toListCollector2() {
        return Collector.of(ArrayList::new, (l, p) -> {
            l.add(p.getLeft());
            l.add(p.getRight());
        }, (left, right) -> {
            left.addAll(right);
            return left;
        }, new Collector.Characteristics[0]);
    }

    public void generateSQLInsertFunction(String jsonschema, String templateName, String consistOf, String root_dir, TemplateBindingsSchema templateBindingsSchema, List<String> shared) {
        final String orig_templateName = consistOf == null ? templateName : consistOf;
        Map<String, List<Descriptor>> var = templateBindingsSchema.getVar();
        String insertFunctionName = "insert_" + templateName;
        Map funParams = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(key -> ConfigProcessor.descriptorUtils.isInput((String)key, templateBindingsSchema) || shared.contains(key)).collect(Collectors.toMap(key -> this.appendPossiblySharedOutput((String)key, shared.contains(key)), key -> QueryBuilder.unquote(CompilerSqlComposer.getTheSqlType(this.compilerUtil, key, templateBindingsSchema, var)), (x, y) -> y, LinkedHashMap::new));
        Map functionReturns = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(key -> ConfigProcessor.descriptorUtils.isOutput((String)key, templateBindingsSchema) && !shared.contains(key)).collect(Collectors.toMap(this::sqlify, key -> QueryBuilder.unquote(CompilerSqlComposer.getTheSqlType(this.compilerUtil, key, templateBindingsSchema, var)), (x, y) -> y, () -> new LinkedHashMap<String, Object>(){
            {
                this.put(CompilerSqlComposer.this.tableKey, QueryBuilder.unquote("INT"));
            }
        }));
        if (functionReturns.keySet().size() == 1) {
            functionReturns.put(DUMMY, QueryBuilder.unquote("INT"));
        }
        Map insertValues2 = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().collect(Collectors.toMap(this::sqlify, key -> {
            if (ConfigProcessor.descriptorUtils.isInput((String)key, templateBindingsSchema)) {
                return QueryBuilder.unquote("input_" + this.sqlify((String)key));
            }
            boolean isShared = shared.contains(key);
            if (isShared) {
                return QueryBuilder.unquote(this.appendPossiblySharedOutput((String)key, isShared));
            }
            String the_table = ConfigProcessor.descriptorUtils.getSqlTable((String)key, templateBindingsSchema).orElse((String)key);
            String new_table = this.newTableWithId((String)key);
            String new_id = the_table + "_id";
            return pp -> QueryBuilder.select(new_id).apply((PrettyPrinter)pp).from(new_table);
        }, (x, y) -> y, LinkedHashMap::new));
        Function<String, Map> otherInputs = key -> {
            Optional<Map<String, String>> sqlNewInputs = ConfigProcessor.descriptorUtils.getSqlNewInputs((String)key, templateBindingsSchema);
            if (sqlNewInputs.isPresent()) {
                Map<String, String> theInputs = sqlNewInputs.get();
                ConfigProcessor.descriptorUtils.checkSqlInputs(theInputs, templateBindingsSchema);
                ArrayList<String> newIns = new ArrayList<String>(theInputs.keySet());
                Map m = newIns.stream().collect(Collectors.toMap(i -> i, i -> QueryBuilder.unquote("input_" + this.sqlify((String)theInputs.get(i))), (x, y) -> y, LinkedHashMap::new));
                return m;
            }
            Optional<Map<String, String>> sqlAlsoOutputs = ConfigProcessor.descriptorUtils.getSqlAlsoOutputs((String)key, templateBindingsSchema);
            if (sqlAlsoOutputs.isPresent()) {
                Map<String, String> theOutputs = sqlAlsoOutputs.get();
                ConfigProcessor.descriptorUtils.checkSqlOutputs(theOutputs, templateBindingsSchema);
                ArrayList<String> newOuts = new ArrayList<String>(theOutputs.keySet());
                Map m = newOuts.stream().collect(Collectors.toMap(i -> i, i -> QueryBuilder.unquote("input_policy"), (x, y) -> y, LinkedHashMap::new));
                return m;
            }
            return CompilerSqlComposer.Default_Values();
        };
        Map cteValues2 = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(key -> ConfigProcessor.descriptorUtils.isOutput((String)key, templateBindingsSchema) && !shared.contains(key)).collect(Collectors.toMap(this::newTableWithId, key -> {
            final String the_table = ConfigProcessor.descriptorUtils.getSqlTable((String)key, templateBindingsSchema).orElse((String)key);
            Optional<AttributeDescriptor.SqlForeign> sqlForeign = ConfigProcessor.descriptorUtils.getOutputSqlForeign((String)key, templateBindingsSchema);
            if (sqlForeign.isPresent()) {
                String foreignType = "input_" + sqlForeign.get().getType();
                String foreignAttribute = "input_" + sqlForeign.get().getAttribute();
                String foreignItem = "input_" + sqlForeign.get().getItem();
                String theTable = ConfigProcessor.descriptorUtils.getSqlTable((String)key, templateBindingsSchema).orElse((String)key);
                return pp -> new QueryBuilder((PrettyPrinter)pp).selectExp("f_build_and_execute_select(" + foreignType + ", " + foreignAttribute + ", " + foreignItem + " )").alias(key + "_id");
            }
            return pp -> new QueryBuilder((PrettyPrinter)pp).insertInto(the_table).values((Map)otherInputs.apply((String)key)).returning((Collection<String>)new LinkedList<String>(this){
                final /* synthetic */ CompilerSqlComposer this$0;
                {
                    this.this$0 = this$0;
                    this.add(the_table + ".ID AS " + the_table + "_id");
                }
            });
        }, (x, y) -> y, LinkedHashMap::new));
        List outputs = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(key -> ConfigProcessor.descriptorUtils.isOutput((String)key, templateBindingsSchema) && !shared.contains(key)).map(key -> orig_templateName + "." + key).collect(Collectors.toCollection(() -> new LinkedList<String>(this){
            final /* synthetic */ CompilerSqlComposer this$0;
            {
                this.this$0 = this$0;
                this.add(orig_templateName + "." + this.this$0.tableKey);
            }
        }));
        if (outputs.size() == 1) {
            outputs.add("1 AS __dummy_");
        }
        QueryBuilder fun = new QueryBuilder().comment("Generated by method " + this.getClass().getName() + ".generateSQLInsertFunction").next(QueryBuilder.createFunction(insertFunctionName)).params(funParams).returns("table", functionReturns).bodyStart("").cte(cteValues2).insertInto(orig_templateName).values(insertValues2).returning(outputs).bodyEnd("");
        String sql = fun.getSQL();
        this.functionDeclarations.put(templateName, sql);
    }

    private String localId(String key) {
        return "_" + key + "_id";
    }

    public void generateSQLInsertArrayFunction(String templateName, String consistOf, TemplateBindingsSchema templateBindingsSchema, List<String> shared) {
        final String template_type = (consistOf == null ? templateName : consistOf) + "_type";
        Map<String, List<Descriptor>> var = templateBindingsSchema.getVar();
        String insertFunctionName = "insert_" + templateName + "_array";
        Predicate<String> isOutput = key -> ConfigProcessor.descriptorUtils.isOutput((String)key, templateBindingsSchema);
        Predicate<String> isInput = key -> ConfigProcessor.descriptorUtils.isInput((String)key, templateBindingsSchema);
        Function<String, String> table = key -> ConfigProcessor.descriptorUtils.getSqlTable((String)key, templateBindingsSchema).orElse((String)key);
        HashMap<String, Object> funParams = new HashMap<String, Object>(this){
            final /* synthetic */ CompilerSqlComposer this$0;
            {
                this.this$0 = this$0;
                this.put("_records", QueryBuilder.arrayOf(template_type));
            }
        };
        Map functionReturns = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(isOutput).collect(Collectors.toMap(this::sqlify, key -> QueryBuilder.unquote(CompilerSqlComposer.getTheSqlType(this.compilerUtil, key, templateBindingsSchema, var)), (x, y) -> y, () -> new LinkedHashMap<String, Object>(){
            {
                this.put(CompilerSqlComposer.this.tableKey, QueryBuilder.unquote("INT"));
            }
        }));
        Map cteValues1 = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(key -> isOutput.test((String)key) && shared.contains(key)).collect(Collectors.toMap(this::table_tokens, key -> pp0 -> QueryBuilder.select(TOKEN_VAR_NAME, "id", this.insert_into_table((String)table.apply((String)key), this.additionalColumnsWithoutAlias2(templateBindingsSchema, (String)key))).apply((PrettyPrinter)pp0).from(pp -> QueryBuilder.select(this.makeArray(TOKEN_VAR_NAME, this.nextVal((String)table.apply((String)key)), this.additionalColumnsWithAlias(templateBindingsSchema, (String)key))).apply((PrettyPrinter)pp).from(pp1 -> QueryBuilder.select(this.makeArray("DISTINCT ON (" + key + ") " + key + " AS _token", this.additionalColumnsWithoutAlias(templateBindingsSchema, (String)key))).apply((PrettyPrinter)pp1).from("_input_table"), this.table_tokens0((String)key)), this.table_tokens((String)key)), (x, y) -> y, () -> new LinkedHashMap<String, Function<PrettyPrinter, ?>>(){
            {
                this.put("_input_table", pp -> QueryBuilder.select("*").apply((PrettyPrinter)pp).from("unnest (_records)"));
            }
        }));
        List insertColumns = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(isOutput).map(key -> shared.contains(key) ? this.localId((String)key) : "(_arecord)." + this.sqlify((String)key)).collect(Collectors.toCollection(() -> new LinkedList<String>(){
            {
                this.add("(_arecord)." + CompilerSqlComposer.this.tableKey);
            }
        }));
        List theArguments = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(key -> isInput.test((String)key) || shared.contains(key)).map(key -> shared.contains(key) ? this.table_token_id_pairs((String)key) + ".id" : key).map(this::sqlify).collect(Collectors.toList());
        QueryBuilder fun = new QueryBuilder().comment("Generated by method " + this.getClass().getName() + ".generateSQLInsertArrayFunction").next(QueryBuilder.createFunction(insertFunctionName)).params(funParams).returns("table", functionReturns).bodyStart("").cte(cteValues1).selectExp(insertColumns.toArray(ARRAY_OF_STRING)).from(pp -> shared.stream().reduce(QueryBuilder.select(this.makeArray(shared.stream().map(theColumn -> this.table_token_id_pairs((String)theColumn) + ".id AS " + this.localId((String)theColumn)).collect(Collectors.toList()), QueryBuilder.functionCall("insert_" + templateName, theArguments, "_arecord"))).apply((PrettyPrinter)pp).from("_input_table"), (qb, s) -> qb.join(pp1 -> QueryBuilder.select(this.getId(this.table_tokens((String)s)), this.getToken(this.table_tokens((String)s))).apply((PrettyPrinter)pp1).from(this.table_tokens((String)s)), this.table_token_id_pairs((String)s)).on((String)s, "=", this.getToken(this.table_token_id_pairs((String)s))), (qb1, qb2) -> {
            throw new UnsupportedOperationException();
        }), "inserted_rows").bodyEnd("");
        String sql = fun.getSQL();
        this.arrayFunctionDeclarations.put(insertFunctionName, sql);
    }

    public void generateSQLInsertCompositeAndLinkerFunction(String templateName, String consistOf, TemplateBindingsSchema templateBindingsSchema, List<String> shared) {
        final String template_type = (consistOf == null ? templateName : consistOf) + "_type";
        Map<String, List<Descriptor>> var = templateBindingsSchema.getVar();
        String insertFunctionName = "insert_" + templateName + "_and_linker";
        String insertArrayFunctionName = "insert_" + templateName + "_array";
        Predicate<String> isOutput = key -> ConfigProcessor.descriptorUtils.isOutput((String)key, templateBindingsSchema);
        Predicate<String> isInput = key -> ConfigProcessor.descriptorUtils.isInput((String)key, templateBindingsSchema);
        Function<String, String> table = key -> ConfigProcessor.descriptorUtils.getSqlTable((String)key, templateBindingsSchema).orElse((String)key);
        HashMap<String, Object> funParams = new HashMap<String, Object>(this){
            final /* synthetic */ CompilerSqlComposer this$0;
            {
                this.this$0 = this$0;
                this.put("_records", QueryBuilder.arrayOf(template_type));
            }
        };
        Map functionReturns = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(isOutput).collect(Collectors.toMap(this::sqlify, key -> QueryBuilder.unquote(CompilerSqlComposer.getTheSqlType(this.compilerUtil, key, templateBindingsSchema, var)), (x, y) -> y, () -> new LinkedHashMap<String, Object>(){
            {
                this.put(CompilerSqlComposer.this.tableKey, QueryBuilder.unquote("INT"));
            }
        }));
        functionReturns.put("parent", QueryBuilder.unquote("INT"));
        LinkedHashMap cteValues2 = new LinkedHashMap();
        cteValues2.put("inserted_consistsOf", pp -> QueryBuilder.select("*").apply((PrettyPrinter)pp).from(insertArrayFunctionName + " (_records)"));
        LinkedHashMap<String, Object> inserted_values1 = new LinkedHashMap<String, Object>();
        inserted_values1.put("bean", QueryBuilder.unquote("null"));
        inserted_values1.put("count", pp -> QueryBuilder.select("count(ID)").apply((PrettyPrinter)pp).from("inserted_consistsOf"));
        inserted_values1.put("type", "plead_transforming");
        cteValues2.put("the_record", pp -> new QueryBuilder((PrettyPrinter)pp).insertInto(templateName).values(inserted_values1).returning(Collections.singleton("ID")));
        Function<PrettyPrinter, QueryBuilder> fbuild = pp -> {
            pp.open();
            QueryBuilder qb = QueryBuilder.select("ID AS composite").apply((PrettyPrinter)pp).from("the_record");
            pp.close();
            return qb;
        };
        cteValues2.put("the_product", pp -> QueryBuilder.select(fbuild, "ID AS simple").apply((PrettyPrinter)pp).from("inserted_consistsOf"));
        cteValues2.put("the_linker", pp -> new QueryBuilder((PrettyPrinter)pp).insertInto(templateName + "_linker(composite,simple) ").selectExp("*").from("the_product"));
        List insertColumns = ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema).stream().filter(isOutput).map(key -> shared.contains(key) ? key : this.sqlify((String)key)).collect(Collectors.toCollection(() -> new LinkedList<String>(){
            {
                this.add("ID");
            }
        }));
        insertColumns.add("(select ID AS parent from the_record)");
        QueryBuilder fun = new QueryBuilder().comment("Generated by method " + this.getClass().getName() + ".generateSQLInsertCompositeAndLinkerFunction").next(QueryBuilder.createFunction(insertFunctionName)).params(funParams).returns("table", functionReturns).bodyStart("").cte(cteValues2).selectExp(insertColumns.toArray(ARRAY_OF_STRING)).from("inserted_consistsOf").bodyEnd("");
        String sql = fun.getSQL();
        this.arrayFunctionDeclarations.put(insertFunctionName, sql);
    }

    private List<String> additionalColumnsWithAlias(TemplateBindingsSchema templateBindingsSchema, String key) {
        Map newInputs = ConfigProcessor.descriptorUtils.getSqlNewInputs(key, templateBindingsSchema).orElseGet(HashMap::new);
        return newInputs.keySet().stream().map(k -> (String)newInputs.get(k) + " AS " + k + " -- @sql.new.inputs").collect(Collectors.toList());
    }

    private List<String> additionalColumnsWithoutAlias(TemplateBindingsSchema templateBindingsSchema, String key) {
        Map newInputs = ConfigProcessor.descriptorUtils.getSqlNewInputs(key, templateBindingsSchema).orElseGet(HashMap::new);
        return newInputs.keySet().stream().map(newInputs::get).collect(Collectors.toList());
    }

    private List<String> additionalColumnsWithoutAlias2(TemplateBindingsSchema templateBindingsSchema, String key) {
        Map newInputs = ConfigProcessor.descriptorUtils.getSqlNewInputs(key, templateBindingsSchema).orElseGet(HashMap::new);
        return new ArrayList<String>(newInputs.keySet());
    }

    private Object[] makeArray(List<String> strings, Function<PrettyPrinter, QueryBuilder> funarg) {
        int size = strings.size();
        Object[] result = new Object[size + 1];
        strings.toArray(result);
        result[size] = funarg;
        return result;
    }

    private Object[] makeArray(String s1, String s2, List<String> strings) {
        int size = strings.size();
        Object[] result = new Object[size + 2];
        int i = 2;
        result[0] = s1;
        result[1] = s2;
        for (String s : strings) {
            result[i] = s;
            ++i;
        }
        return result;
    }

    private Object[] makeArray(String s1, List<String> strings) {
        int size = strings.size();
        Object[] result = new Object[size + 1];
        int i = 1;
        result[0] = s1;
        for (String s : strings) {
            result[i] = s;
            ++i;
        }
        return result;
    }

    private String insert_into_table(String table) {
        return "insert_into_" + table + "(id) as id";
    }

    private String insert_into_table(String table, List<String> strings) {
        String suffix = String.join((CharSequence)",", strings);
        if (suffix.isBlank()) {
            return "insert_into_" + table + "(id) as _newid";
        }
        return "insert_into_" + table + "(id, " + suffix + ") as _newid";
    }

    private String nextVal(String key) {
        return "cast(nextval('" + key + "_id_seq') as INT) as id";
    }

    static HashMap<String, Object> Default_Values() {
        return new HashMap<String, Object>();
    }

    private String newTableWithId(String key) {
        return "_new_" + key + "_with_id";
    }

    private String table_tokens(String key) {
        return "_" + key + "_tokens";
    }

    private String table_tokens0(String key) {
        return "_" + key + "_tokens0";
    }

    private String getToken(String table) {
        return table + "._token";
    }

    private String getId(String table) {
        return table + ".id";
    }

    private String table_token_id_pairs(String key) {
        return "_" + key + "_token_id_pairs";
    }

    private String table_ids(String key) {
        return "_" + key + "_ids";
    }

    public static String getTheSqlType(CompilerUtil compilerUtil, String key, TemplateBindingsSchema templateBindingsSchema, Map<String, List<Descriptor>> var) {
        String defaultSqlType = CompilerSQL.convertToSQLType(compilerUtil.getJavaTypeForDeclaredType(var, key).getName());
        String overrideSqlType = ConfigProcessor.descriptorUtils.getSqlType(key, templateBindingsSchema);
        String theSqlType = overrideSqlType != null && !"nullableTEXT".equals(overrideSqlType) && !"nonNullableTEXT".equals(overrideSqlType) ? overrideSqlType : defaultSqlType;
        return theSqlType;
    }

    private String appendPossiblySharedOutput(String key, boolean isShared) {
        return (isShared ? "composite_" : "input_") + this.sqlify(key);
    }

    public String sqlify(String key) {
        return this.nameMap.getOrDefault(key, key);
    }

    public void generateSQLSearchRecordFunction(String baseRelation, Map<String, List<String>> templates, String templateName, String consistOf, String rootDir, TemplateBindingsSchema templateBindingsSchema, List<String> shared) {
        String searchFunction = "search_records_for_" + baseRelation;
        HashMap<String, Object> funParams = new HashMap<String, Object>(){
            {
                this.put("from_date", QueryBuilder.unquote("timestamptz"));
                this.put("to_date", QueryBuilder.unquote("timestamptz"));
            }
        };
        LinkedHashMap<String, Object> functionReturns = new LinkedHashMap<String, Object>(){
            {
                this.put("ID", QueryBuilder.unquote("INT"));
                this.put("created_at", QueryBuilder.unquote("timestamptz"));
                this.put("table_name", QueryBuilder.unquote("text"));
                this.put("key", QueryBuilder.unquote("INT"));
            }
        };
        String coalescedKey = templates.keySet().stream().map(p -> p + ".id").collect(Collectors.joining(", ", "COALESCE (", ")"));
        String nameCase = templates.keySet().stream().map(p -> ((List)templates.get(p)).stream().map(c -> p + "." + c + " IS NOT NULL ").collect(Collectors.joining(" OR ", " WHEN ", "  THEN '" + p + "'"))).collect(Collectors.joining(" ", "CASE ", " END"));
        QueryBuilder fun = new QueryBuilder().comment("Generated by method " + this.getClass().getName() + ".generateSQLSearchRecordFunction").next(QueryBuilder.createFunction(searchFunction)).params(funParams).returns("table", functionReturns).bodyStart("").selectExp(baseRelation + ".id as ID", "created_at", nameCase + " AS table_name", coalescedKey + " as key").from(baseRelation);
        for (String string : templates.keySet()) {
            boolean first = true;
            fun.leftJoin(string);
            for (String column : templates.get(string)) {
                if (first) {
                    fun.on(baseRelation + ".id = " + string + "." + column);
                    first = false;
                    continue;
                }
                fun.or(baseRelation + ".id = " + string + "." + column);
            }
        }
        fun.newline().whereOpen("from_date", "is", "null").or("created_at", ">", "from_date").close();
        fun.andOpen("to_date", "is", "null").or("created_at", "<", "to_date").close();
        boolean first = true;
        for (String template : templates.keySet()) {
            for (String column : templates.get(template)) {
                if (first) {
                    fun.begin(5).andOpen(template + "." + column, "is not", "null");
                    first = false;
                    continue;
                }
                fun.allowBreak().or(template + "." + column, "is not", "null");
            }
        }
        fun.close().end();
        fun.orderBy("created_at").desc();
        fun.bodyEnd("");
        String string = fun.getSQL();
        this.arrayFunctionDeclarations.put(searchFunction, string);
    }

    public void generateSQLSearchRecordByIdFunctionOLD(String baseRelation, Map<String, List<String>> templates, String templateName, String consistOf, String rootDir, TemplateBindingsSchema templateBindingsSchema, List<String> shared) {
        String searchFunction = "search_records_by_id_for_" + baseRelation;
        HashMap<String, Object> funParams = new HashMap<String, Object>(){
            {
                this.put("input_id", QueryBuilder.unquote("INT"));
            }
        };
        LinkedHashMap<String, Object> functionReturns = new LinkedHashMap<String, Object>(){
            {
                this.put("ID", QueryBuilder.unquote("INT"));
                this.put("created_at", QueryBuilder.unquote("timestamptz"));
                this.put("table_name", QueryBuilder.unquote("text"));
                this.put("key", QueryBuilder.unquote("INT"));
            }
        };
        String coalescedKey = templates.keySet().stream().map(p -> p + ".id").collect(Collectors.joining(", ", "COALESCE (", ")"));
        String nameCase = templates.keySet().stream().map(p -> ((List)templates.get(p)).stream().map(c -> p + "." + c + " IS NOT NULL ").collect(Collectors.joining(" OR ", " WHEN ", "  THEN '" + p + "'"))).collect(Collectors.joining(" ", "CASE ", " END"));
        QueryBuilder fun = new QueryBuilder().comment("Generated by method " + this.getClass().getName() + ".generateSQLSearchRecordByIdFunction").next(QueryBuilder.createFunction(searchFunction)).params(funParams).returns("table", functionReturns).bodyStart("").selectExp(baseRelation + ".id as ID", "created_at", nameCase + " AS table_name", coalescedKey + " as key").from(baseRelation);
        for (String string : templates.keySet()) {
            boolean first = true;
            fun.leftJoin(string);
            for (String column : templates.get(string)) {
                if (first) {
                    fun.on(baseRelation + ".id = input_id").andOpen(baseRelation + ".id = " + string + "." + column);
                    first = false;
                    continue;
                }
                fun.or(baseRelation + ".id = " + string + "." + column);
            }
            fun.close();
        }
        boolean first = true;
        for (String template : templates.keySet()) {
            for (String column : templates.get(template)) {
                if (first) {
                    fun.begin(5).whereOpen(template + "." + column, "is not", "null");
                    first = false;
                    continue;
                }
                fun.allowBreak().or(template + "." + column, "is not", "null");
            }
        }
        fun.close().end();
        fun.orderBy("created_at").desc();
        fun.bodyEnd("");
        String string = fun.getSQL();
        this.arrayFunctionDeclarations.put(searchFunction, string);
    }

    public String sqlQuote(String s) {
        return "'" + s + "'";
    }

    public void generateSQLSearchRecordByIdFunction(String baseRelation, Map<String, List<String>> templates, String templateName, String consistOf, String rootDir, TemplateBindingsSchema templateBindingsSchema, List<String> shared) {
        String searchFunction = "search_records_by_id_for_" + baseRelation;
        HashMap<String, Object> funParams = new HashMap<String, Object>(){
            {
                this.put("input_id", QueryBuilder.unquote("INT"));
            }
        };
        LinkedHashMap<String, Object> functionReturns = new LinkedHashMap<String, Object>(){
            {
                this.put("ID", QueryBuilder.unquote("INT"));
                this.put("created_at", QueryBuilder.unquote("timestamptz"));
                this.put("table_name", QueryBuilder.unquote("text"));
                this.put("property", QueryBuilder.unquote("text"));
                this.put("key", QueryBuilder.unquote("INT"));
            }
        };
        QueryBuilder fun = new QueryBuilder().comment("Generated by method " + this.getClass().getName() + ".generateSQLSearchRecordByIdFunction").next(QueryBuilder.createFunction(searchFunction)).params(funParams).returns("table", functionReturns).bodyStart("");
        boolean first = true;
        for (String template : templates.keySet()) {
            for (String column : templates.get(template)) {
                if (first) {
                    fun.selectExp(baseRelation + ".id as ID", baseRelation + ".created_at", this.sqlQuote(template) + " AS table_name", this.sqlQuote(column) + " AS property", template + ".id as key").from(baseRelation);
                    first = false;
                } else {
                    fun.newline().newline().union(pp -> QueryBuilder.select(baseRelation + ".id as ID", baseRelation + ".created_at", this.sqlQuote(template) + " AS table_name", this.sqlQuote(column) + " AS property", template + ".id as key").apply((PrettyPrinter)pp).from(baseRelation));
                }
                fun.leftJoin(template);
                fun.newline().on(baseRelation + ".id = input_id").and(baseRelation + ".id = " + template + "." + column);
                fun.newline().where(template + "." + column, "is not", "null");
            }
        }
        fun.orderBy("created_at").desc();
        fun.bodyEnd("");
        String sql = fun.getSQL();
        this.arrayFunctionDeclarations.put(searchFunction, sql);
    }

    public void generateInsertIntoSharedRelation(String template, TemplateBindingsSchema templateBindingsSchema, List<String> shared) {
        HashSet sqlTables = new HashSet();
        for (String key : shared) {
            ConfigProcessor.descriptorUtils.getSqlTable(key, templateBindingsSchema).ifPresent(sqlTables::add);
        }
        for (String relation : sqlTables) {
            final List<String> extras = CompilerSqlComposer.findExtrasValuesForRelation(templateBindingsSchema, relation);
            if (!extras.isEmpty()) {
                System.out.println("###############################  in generateInsertIntoSharedRelation EXTRAS " + String.valueOf(extras) + " " + relation);
            }
            String insert_into_function_name = "insert_into_" + relation;
            QueryBuilder fun = new QueryBuilder().comment("Generated by method " + this.getClass().getName() + ".generateInsertIntoSharedRelation").next(QueryBuilder.createFunction(insert_into_function_name)).params(new LinkedHashMap<String, Object>(this){
                final /* synthetic */ CompilerSqlComposer this$0;
                {
                    this.this$0 = this$0;
                    this.put("input_id", QueryBuilder.unquote("BIGINT"));
                    extras.forEach((? super T e) -> this.put("input_" + e, QueryBuilder.unquote("INT")));
                }
            }).returns("table", new HashMap<String, Object>(){
                {
                    this.put("id", QueryBuilder.unquote("INT"));
                }
            }).bodyStart("").insertInto(relation).values(new LinkedHashMap<String, Object>(this){
                final /* synthetic */ CompilerSqlComposer this$0;
                {
                    this.this$0 = this$0;
                    this.put("id", pp -> QueryBuilder.select("input_id").apply((PrettyPrinter)pp));
                    extras.forEach((? super T e) -> this.put(e, pp -> QueryBuilder.select("input_" + e).apply((PrettyPrinter)pp)));
                }
            }).returning(Collections.singleton(relation + ".id as id"));
            fun.bodyEnd("");
            String sql = fun.getSQL();
            this.arrayFunctionDeclarations.put(insert_into_function_name, sql);
        }
    }

    public static List<String> findExtrasValuesForRelation(TemplateBindingsSchema templateBindingsSchema, String relation) {
        ArrayList<String> extras = new ArrayList<String>();
        Map<String, List<Descriptor>> theVars = templateBindingsSchema.getVar();
        for (String key : theVars.keySet()) {
            Optional<Map<String, String>> sqlNewInputs = ConfigProcessor.descriptorUtils.getSqlNewInputs(key, templateBindingsSchema);
            if (!sqlNewInputs.isPresent()) continue;
            Map<String, String> theInputs = sqlNewInputs.get();
            for (String theKey : theInputs.keySet()) {
                if (!relation.equals(theInputs.get(theKey))) continue;
                extras.add(theKey);
            }
        }
        return extras;
    }
}

