/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.emitter.minilanguage;

import java.util.List;
import org.openprovenance.prov.template.emitter.Element;
import org.openprovenance.prov.template.emitter.minilanguage.Expression;
import org.openprovenance.prov.template.emitter.minilanguage.Statement;
import org.openprovenance.prov.template.emitter.minilanguage.emitters.Python;

public class Conditional
extends Statement {
    public Expression predicate;
    public List<Statement> consequents;
    public List<Statement> alternates;

    public Conditional(List<Element> elements) {
        super(elements);
    }

    @Override
    public void emit(Python emitter, List<String> classVariables, List<String> listVariables) {
        emitter.emitBeginLine("if ");
        this.predicate.emit(emitter, true, classVariables, listVariables);
        emitter.emitContinueLine(":");
        emitter.emitNewline();
        emitter.indent();
        if (this.consequents != null) {
            for (Statement consequent : this.consequents) {
                consequent.emit(emitter, classVariables, listVariables);
            }
            emitter.emitLine("pass");
        }
        emitter.unindent();
        if (this.alternates != null && !this.alternates.isEmpty()) {
            emitter.emitBeginLine("else:");
            emitter.emitNewline();
            emitter.indent();
            for (Statement alternate : this.alternates) {
                alternate.emit(emitter, classVariables, listVariables);
            }
            emitter.unindent();
        }
    }

    @Override
    public String toString() {
        return "Conditional{predicate=" + String.valueOf(this.predicate) + ", consequents=" + String.valueOf(this.consequents) + ", alternates=" + String.valueOf(this.alternates) + "}";
    }
}

