/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanDirection;
import org.openprovenance.prov.template.compiler.configuration.CompositeTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SimpleTemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplateCompilerConfig;
import org.openprovenance.prov.template.compiler.configuration.TemplatesProjectConfiguration;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;

public class CompilerBeanCompleter2 {
    private final CompilerUtil compilerUtil;
    private final boolean debugComment = true;

    public CompilerBeanCompleter2(ProvFactory pFactory) {
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    SpecificationFile generateBeanCompleter2(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("BeanCompleter2");
        builder.addField(CompilerUtil.mapType, "m", new Modifier[]{Modifier.FINAL});
        MethodSpec.Builder callMe2 = MethodSpec.methodBuilder((String)"getMap");
        this.compilerUtil.specWithComment(callMe2);
        callMe2.addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(CompilerUtil.classType, "cl", new Modifier[0]).addParameter(String.class, "key", new Modifier[0]).returns((TypeName)CompilerUtil.typeT).addTypeVariable(CompilerUtil.typeT).addStatement("return ($T) m.get($N)", new Object[]{CompilerUtil.typeT, "key"});
        builder.addMethod(callMe2.build());
        TypeSpec.Builder inface = this.compilerUtil.generateInterfaceInit("Getter");
        inface.addMethod(MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addParameter(CompilerUtil.classType, "cl", new Modifier[0]).addParameter(String.class, "col", new Modifier[0]).returns((TypeName)CompilerUtil.typeT).addTypeVariable(CompilerUtil.typeT).build());
        builder.addType(inface.build());
        builder.addField((TypeName)TypeVariableName.get((String)"Getter"), "getter", new Modifier[]{Modifier.FINAL, Modifier.PROTECTED});
        MethodSpec.Builder cbuilder2 = MethodSpec.constructorBuilder();
        this.compilerUtil.specWithComment(cbuilder2);
        cbuilder2.addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(CompilerUtil.mapType, "m", new Modifier[0]).addStatement("this.$N = $N", new Object[]{"m", "m"}).addComment("The following code implements this assignment, in a way that jsweet can compile", new Object[0]).addComment("this.getter = this::getMap", new Object[0]);
        cbuilder2.addStatement("this.getter = $L", new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)TypeVariableName.get((String)"Getter")).addMethod(MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(CompilerUtil.classType, "cl", new Modifier[0]).addParameter(String.class, "col", new Modifier[0]).returns((TypeName)CompilerUtil.typeT).addTypeVariable(CompilerUtil.typeT).addStatement("return getMap(cl, col)", new Object[0]).build()).build()});
        builder.addMethod(cbuilder2.build());
        MethodSpec.Builder cbuilder3 = MethodSpec.constructorBuilder();
        this.compilerUtil.specWithComment(cbuilder3);
        cbuilder3.addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)TypeVariableName.get((String)"Getter"), "getter", new Modifier[0]).addStatement("this.$N = null", new Object[]{"m"}).addStatement("this.getter = ($N) getter", new Object[]{"Getter"});
        builder.addMethod(cbuilder3.build());
        for (TemplateCompilerConfig config : configs.templates) {
            ClassName outputClassName;
            locations.updateWithConfig(config);
            if (config instanceof SimpleTemplateCompilerConfig) {
                TemplateBindingsSchema bindingsSchema = this.compilerUtil.getBindingsSchema((SimpleTemplateCompilerConfig)config);
                String outputBeanNameClass = this.compilerUtil.outputsNameClass(config.name);
                String inputBeanNameClass = this.compilerUtil.inputsNameClass(config.name);
                outputClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.OUTPUTS), (String)outputBeanNameClass, (String[])new String[0]);
                MethodSpec.Builder mspec = this.createProcessMethod(config.name, bindingsSchema, outputClassName, true);
                builder.addMethod(mspec.build());
                ClassName inputClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.INPUTS), (String)inputBeanNameClass, (String[])new String[0]);
                MethodSpec.Builder mspec2 = this.createProcessMethod(config.name, bindingsSchema, inputClassName, false);
                builder.addMethod(mspec2.build());
                continue;
            }
            CompositeTemplateCompilerConfig config1 = (CompositeTemplateCompilerConfig)config;
            String consistOf = config1.consistsOf;
            String outputBeanNameClass = this.compilerUtil.outputsNameClass(config.name);
            outputClassName = ClassName.get((String)locations.getFilePackage(BeanDirection.OUTPUTS), (String)outputBeanNameClass, (String[])new String[0]);
            String composeeName = this.compilerUtil.outputsNameClass(consistOf);
            ClassName composeeClass = ClassName.get((String)locations.getFilePackage(BeanDirection.OUTPUTS), (String)composeeName, (String[])new String[0]);
            MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)outputClassName, (String)"bean", (Modifier[])new Modifier[0]).build()).returns((TypeName)outputClassName);
            this.compilerUtil.specWithComment(mspec);
            mspec.beginControlFlow("do ", new Object[0]);
            mspec.addStatement("$T composee=new $T()", new Object[]{composeeClass, composeeClass});
            mspec.addStatement("$N.$N(composee)", new Object[]{"bean", "__addElements"});
            mspec.addStatement("$N(composee)", new Object[]{"process"});
            mspec.endControlFlow("while (next()) ", new Object[0]);
            mspec.addStatement("return $N", new Object[]{"bean"});
            builder.addMethod(mspec.build());
        }
        builder.addMethod(MethodSpec.methodBuilder((String)"postEnactmentProcessing").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Integer.class, "id", new Modifier[0]).addParameter(String.class, "template", new Modifier[0]).returns(Void.TYPE).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"next").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addStatement("return true", new Object[0]).build());
        TypeSpec theLogger = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theLogger, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToDirectory(myPackage), fileName + ".java", myPackage);
    }

    private MethodSpec.Builder createProcessMethod(String template, TemplateBindingsSchema bindingsSchema, ClassName outputClassName, boolean isOutput) {
        MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)outputClassName, (String)"bean", (Modifier[])new Modifier[0]).build()).returns((TypeName)outputClassName);
        this.compilerUtil.specWithComment(mspec);
        if (isOutput) {
            mspec.addStatement("$N.ID= getter.get(Integer.class,$S)", new Object[]{"bean", "ID"});
            mspec.addStatement("$N($N.ID,$S)", new Object[]{"postEnactmentProcessing", "bean", template});
        }
        for (String key : ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema)) {
            Class<?> cl;
            if (isOutput && ConfigProcessor.descriptorUtils.isOutput(key, bindingsSchema)) {
                cl = this.compilerUtil.getJavaTypeForDeclaredType(bindingsSchema.getVar(), key);
                mspec.addStatement("$N.$N= getter.get($N.class,$S)", new Object[]{"bean", key, cl.getSimpleName(), key});
                continue;
            }
            if (isOutput || !ConfigProcessor.descriptorUtils.isInput(key, bindingsSchema)) continue;
            cl = this.compilerUtil.getJavaTypeForDeclaredType(bindingsSchema.getVar(), key);
            mspec.addStatement("$N.$N= getter.get($N.class,$S)", new Object[]{"bean", key, cl.getSimpleName(), key});
        }
        mspec.addStatement("return bean", new Object[0]);
        return mspec;
    }
}

