/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.tuple.Pair;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.ConfigProcessor;
import org.openprovenance.prov.template.compiler.common.BeanKind;
import org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer;
import org.openprovenance.prov.template.compiler.util.CompilerException;
import org.openprovenance.prov.template.descriptors.AttributeDescriptor;
import org.openprovenance.prov.template.descriptors.AttributeDescriptorList;
import org.openprovenance.prov.template.descriptors.Descriptor;
import org.openprovenance.prov.template.descriptors.NameDescriptor;
import org.openprovenance.prov.template.descriptors.TemplateBindingsSchema;

public class CompilerSQL {
    public static final String SMALL_INDENTATION = "  ";
    private final CompilerUtil compilerUtil;
    private final ProvFactory pFactory;
    ObjectMapper om = new ObjectMapper();
    private final String tableKey;
    private final Map<String, String> tableDeclarations = new LinkedHashMap<String, String>();
    private final Map<String, String> functionDeclarations = new LinkedHashMap<String, String>();
    private final Map<String, String> primitiveDeclarations = new LinkedHashMap<String, String>();
    private final Map<String, String> typeDeclarations = new LinkedHashMap<String, String>();
    private final Map<String, String> arrayFunctionDeclarations = new LinkedHashMap<String, String>();
    static Map<String, String> nameMap = CompilerSQL.initNameMap();
    private final boolean debugComment = true;
    Set<String> declaredSqlTables = new HashSet<String>();

    public CompilerSQL(ProvFactory pFactory, String tableKey) {
        this.tableKey = tableKey;
        this.compilerUtil = new CompilerUtil(pFactory);
        this.pFactory = pFactory;
    }

    public void generateSQLEnd(String sqlFile, String root_dir, Set<String> referencedSqlTables) {
        this.checkSQLtables(referencedSqlTables, this.declaredSqlTables);
        new File(root_dir).mkdirs();
        String path = root_dir + "/" + sqlFile;
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(path));
            for (String k : this.primitiveDeclarations.keySet()) {
                ps.println(this.primitiveDeclarations.get(k));
                ps.println("\n\n");
            }
            for (String k : this.typeDeclarations.keySet()) {
                ps.println(this.typeDeclarations.get(k));
                ps.println("\n\n");
            }
            for (String k : this.tableDeclarations.keySet()) {
                ps.println(this.tableDeclarations.get(k));
                ps.println("\n\n");
            }
            for (String k : this.functionDeclarations.keySet()) {
                ps.println(this.functionDeclarations.get(k));
                ps.println("\n\n");
            }
            for (String k : this.arrayFunctionDeclarations.keySet()) {
                ps.println(this.arrayFunctionDeclarations.get(k));
                ps.println("\n\n");
            }
            ps.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void checkSQLtables(Set<String> referencedSqlTables, Set<String> declaredSqlTables) {
        HashSet<String> undeclaredTables = new HashSet<String>(referencedSqlTables);
        if (declaredSqlTables != null) {
            undeclaredTables.removeAll(declaredSqlTables);
        }
        HashSet unreferencedTables = declaredSqlTables == null ? new HashSet() : new HashSet<String>(declaredSqlTables);
        unreferencedTables.removeAll(referencedSqlTables);
        if (!undeclaredTables.isEmpty()) {
            System.out.println("referenced " + String.valueOf(referencedSqlTables));
            System.out.println("declared " + String.valueOf(declaredSqlTables));
            throw new CompilerException("Undeclared tables: " + String.valueOf(undeclaredTables));
        }
        if (!unreferencedTables.isEmpty()) {
            System.out.println("referenced " + String.valueOf(referencedSqlTables));
            System.out.println("declared " + String.valueOf(declaredSqlTables));
            throw new CompilerException("Unreferenced tables: " + String.valueOf(unreferencedTables));
        }
    }

    public void generateSQL(String templateName, TemplateBindingsSchema templateBindingsSchema) {
        StringBuilder res = new StringBuilder();
        Map<String, List<Descriptor>> var = templateBindingsSchema.getVar();
        res.append("-- Generated by method ").append(this.getClass().getName()).append(".generateSQL()\n");
        res.append("\n").append("CREATE TABLE IF NOT EXISTS ").append(templateName).append("\n(\n");
        res.append(SMALL_INDENTATION).append(this.tableKey).append(" SERIAL");
        String documentation = null;
        for (String key : ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema)) {
            Descriptor entry;
            res.append(",\n");
            String sqlTypeFromJava = CompilerSQL.convertToSQLType(this.compilerUtil.getJavaTypeForDeclaredType(var, key).getName());
            String sqlType = ConfigProcessor.descriptorUtils.getSqlType(key, templateBindingsSchema);
            if (sqlType != null && !sqlType.equals("nullableTEXT") && !sqlType.equals("nonNullableTEXT")) {
                sqlTypeFromJava = sqlType;
            }
            if ((documentation = this.retrieveDocumentation(entry = var.get(key).get(0))) != null) {
                res.append(SMALL_INDENTATION).append(SMALL_INDENTATION).append("--  ").append(documentation).append("\n");
            }
            res.append(SMALL_INDENTATION).append(CompilerSQL.sqlify(key)).append(" ").append(sqlTypeFromJava);
        }
        res.append("\n);\n\n");
        this.tableDeclarations.put(templateName, res.toString());
        this.generateSqlTypeDeclaration(templateName, templateBindingsSchema, var);
    }

    private void generateSqlTypeDeclaration(String templateName, TemplateBindingsSchema templateBindingsSchema, Map<String, List<Descriptor>> var) {
        StringBuilder res2 = new StringBuilder();
        boolean first = true;
        res2.append("\n-- Generated by method ").append(this.getClass().getName()).append(".generateSqlTypeDeclaration()");
        String templateNameType = templateName + "_type";
        this.ensureNoSQLClashForTypes(templateNameType, templateBindingsSchema);
        res2.append("\nDROP TYPE IF EXISTS ").append(templateNameType).append(" CASCADE;\n");
        res2.append("CREATE TYPE ").append(templateNameType).append(" AS ");
        res2.append(" (\n");
        for (String key : ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema)) {
            first = this.sepIfNotFirst(res2, first, ",\n");
            String sqlType = CompilerSqlComposer.getTheSqlType(this.compilerUtil, key, templateBindingsSchema, var);
            String sqlifiedKey = CompilerSQL.sqlify(key);
            if (!key.equals(sqlifiedKey)) {
                this.ensureNoSQLClassForColumns(sqlifiedKey, templateBindingsSchema);
            }
            res2.append(SMALL_INDENTATION).append(sqlifiedKey).append(" ").append(sqlType);
        }
        res2.append("\n );\n");
        this.typeDeclarations.put(templateName, res2.toString());
    }

    public void ensureNoSQLClassForColumns(String sqlifiedKey, TemplateBindingsSchema templateBindingsSchema) {
        for (String key : ConfigProcessor.descriptorUtils.fieldNames(templateBindingsSchema)) {
            if (!sqlifiedKey.equals(key)) continue;
            throw new CompilerException("Cannot use reserved column '" + key + "' in template " + templateBindingsSchema.getTemplate());
        }
    }

    public void ensureNoSQLClashForTypes(String var, TemplateBindingsSchema templateBindingsSchema) {
        if (templateBindingsSchema.getVar().containsKey(var)) {
            throw new CompilerException("Cannot use reserved word '" + var + "' as a field name in template " + templateBindingsSchema.getTemplate());
        }
    }

    private String retrieveDocumentation(Descriptor entry) {
        return ConfigProcessor.descriptorUtils.getFromDescriptor(entry, AttributeDescriptor::getDocumentation, NameDescriptor::getDocumentation);
    }

    public void generateSQLstatements(TypeSpec.Builder builder, String templateName, TemplateBindingsSchema bindingsSchema, BeanKind beanKind) {
        StringBuffer sb = new StringBuffer();
        this.getInsertStringAndCount(templateName, ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema), sb);
        FieldSpec.Builder builder1 = FieldSpec.builder(String.class, (String)"_sqlInsert1", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
        builder1.initializer("$S", new Object[]{sb.toString()});
        builder.addField(builder1.build());
        builder.addMethod(this.generateSQLInsert(templateName, beanKind));
        builder.addMethod(this.generateSQLInsertStatement(templateName, bindingsSchema, beanKind));
    }

    public MethodSpec generateSQLInsert(String template, BeanKind beanKind) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getSQLInsert").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        this.compilerUtil.specWithComment(builder);
        if (beanKind.equals((Object)BeanKind.COMPOSITE)) {
            builder.addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
        } else {
            builder.addStatement("return _sqlInsert1", new Object[0]);
        }
        return builder.build();
    }

    public MethodSpec generateSQLInsertStatement(String template, TemplateBindingsSchema bindingsSchema, BeanKind beanKind) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getSQLInsertStatement").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        this.compilerUtil.specWithComment(builder);
        if (beanKind.equals((Object)BeanKind.COMPOSITE)) {
            builder.addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
        } else {
            Collection<String> variables = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
            StringBuffer sb = new StringBuffer();
            int count = this.getInsertStringAndCount(template, variables, sb);
            sb = new StringBuffer();
            sb.append(" VALUES (");
            boolean first = true;
            for (int i = 0; i < count; ++i) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("?");
            }
            sb.append(");");
            builder.addStatement("return _sqlInsert1+$S", new Object[]{sb.toString()});
        }
        return builder.build();
    }

    public int getInsertStringAndCount(String template, Collection<String> variables, StringBuffer sb) {
        sb.append("INSERT INTO  ");
        sb.append(template);
        sb.append(" (");
        boolean first = true;
        int count = 0;
        for (String key : variables) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(CompilerSQL.sqlify(key));
            ++count;
        }
        sb.append(")");
        return count;
    }

    public static Map<String, String> initNameMap() {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("order", "_order");
        res.put("end", "_end");
        res.put("start", "_start");
        return res;
    }

    public static String sqlify(String key) {
        return nameMap.getOrDefault(key, key);
    }

    public static String convertToSQLType(String name) {
        switch (name) {
            case "java.lang.String": {
                return "TEXT";
            }
            case "java.lang.Integer": {
                return "INT";
            }
            case "java.lang.Float": {
                return "FLOAT";
            }
            case "java.lang.Double": {
                return "double precision";
            }
            case "java.lang.Boolean": {
                return "BOOLEAN";
            }
        }
        throw new UnsupportedOperationException("conversion to SQL type " + name);
    }

    public MethodSpec generateCommonSQLMethod2(String template, TemplateBindingsSchema bindingsSchema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)this.compilerUtil.sqlName(template)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE);
        String var = "sb";
        this.compilerUtil.specWithComment(builder);
        Map<String, List<Descriptor>> theVar = bindingsSchema.getVar();
        Collection<String> fieldNames = ConfigProcessor.descriptorUtils.fieldNames(bindingsSchema);
        builder.addParameter(StringBuffer.class, var, new Modifier[0]);
        for (String key : fieldNames) {
            String newkey = "__" + key;
            builder.addParameter(this.compilerUtil.getJavaTypeForDeclaredType(theVar, key), newkey, new Modifier[0]);
        }
        Object constant = "(";
        boolean first = true;
        for (String key : fieldNames) {
            String newName = "__" + key;
            Class<?> clazz = this.compilerUtil.getJavaTypeForDeclaredType(theVar, key);
            boolean isQualifiedName = this.compilerUtil.isVariableDenotingQualifiedName(key, theVar);
            if (first) {
                first = false;
            } else {
                constant = (String)constant + ",";
            }
            builder.addStatement("$N.append($S)", new Object[]{var, constant});
            constant = "";
            if (String.class.equals(clazz)) {
                String myStatement = "$N.append($N)";
                String myEscapeStatement = "$N.append($T.escapeJavaScript($N))";
                boolean doEscape = false;
                if (!isQualifiedName) {
                    Descriptor descriptor = theVar.get(key).get(0);
                    boolean bl = doEscape = ((AttributeDescriptorList)descriptor).getItems().get(0).getEscape() != null;
                    if (doEscape) {
                        // empty if block
                    }
                }
                builder.beginControlFlow("if ($N==null)", new Object[]{newName});
                builder.addStatement("$N.append($S)", new Object[]{var, "''"});
                builder.nextControlFlow("else", new Object[0]).addStatement("$N.append($S)", new Object[]{var, "'"});
                if (doEscape) {
                    builder.addStatement(myEscapeStatement, new Object[]{var, ClassName.get((String)"org.openprovenance.apache.commons.lang", (String)"StringEscapeUtils", (String[])new String[0]), newName});
                } else {
                    builder.addStatement(myStatement, new Object[]{var, newName});
                }
                builder.addStatement("$N.append($S)", new Object[]{var, "'"}).endControlFlow();
                continue;
            }
            builder.beginControlFlow("if ($N==null)", new Object[]{newName});
            builder.addStatement("$N.append($S)", new Object[]{var, "''"});
            builder.nextControlFlow("else", new Object[0]);
            builder.addStatement("$N.append($S)", new Object[]{var, constant});
            builder.addStatement("$N.append($N)", new Object[]{var, newName});
            builder.endControlFlow();
        }
        builder.addStatement("$N.append($S)", new Object[]{var, ")"});
        MethodSpec method = builder.build();
        return method;
    }

    public void generateSQLPrimitiveTables(Map<String, Map<String, String>> sqlTables, TemplateBindingsSchema bindingsSchema) {
        if (sqlTables != null) {
            this.declaredSqlTables.addAll(sqlTables.keySet());
            for (String table : sqlTables.keySet()) {
                StringBuilder res = new StringBuilder();
                boolean first = true;
                res.append("-- Generated by method ").append(this.getClass().getName()).append(".generateSQLPrimitiveTables()\n");
                res.append("\nCREATE TABLE IF NOT EXISTS ").append(table);
                res.append(" (\n");
                Map<String, String> sqlTable = sqlTables.get(table);
                for (String key : sqlTable.keySet()) {
                    first = this.sepIfNotFirst(res, first, ",\n");
                    res.append(SMALL_INDENTATION).append(key).append(" ").append(sqlTable.get(key));
                }
                res.append("\n );\n");
                this.primitiveDeclarations.put(table, res.toString());
            }
        }
    }

    public void generateSQLCompositeAndLinkerTable(String templateName) {
        StringBuilder res = new StringBuilder();
        boolean first = true;
        res.append("-- Generated by method ").append(this.getClass().getName()).append(".generateSQLCompositeAndLinkerTable()\n");
        res.append("\nCREATE TABLE IF NOT EXISTS ").append(templateName).append("_linker");
        res.append(" (\n");
        res.append(SMALL_INDENTATION).append(this.tableKey).append(" SERIAL").append(",\n");
        res.append(SMALL_INDENTATION).append("--  The file resulting from transformation").append("\n");
        res.append(SMALL_INDENTATION).append("composite INT").append(",\n");
        res.append(SMALL_INDENTATION).append("--  The file that was transformed").append("\n");
        res.append(SMALL_INDENTATION).append("simple INT").append(",\n");
        res.append(SMALL_INDENTATION).append("created_at timestamp with time zone NOT NULL DEFAULT NOW()");
        res.append("\n);\n\n");
        this.tableDeclarations.put(templateName + "_linker", res.toString());
    }

    public void generateAccessControlTables() {
        StringBuilder res = new StringBuilder();
        res.append("-- Generated by method ").append(this.getClass().getName()).append(".generateAccessControlTables()\n");
        res.append("\nCREATE TABLE IF NOT EXISTS record_index\n(\n  ID SERIAL,\n  key INT,\n  table_name TEXT,\n  principal TEXT,\n  hash jsonb\n);\n\n\nCREATE TABLE IF NOT EXISTS access_control\n(\n  ID SERIAL,\n  record INT,\n  authorized TEXT\n);\n\nALTER TABLE record_index \nDROP CONSTRAINT IF EXISTS record_index_pkey CASCADE;\n\n\nALTER TABLE record_index \nADD CONSTRAINT record_index_pkey\nPRIMARY KEY (ID);\n\n\nALTER TABLE access_control \nDROP CONSTRAINT IF EXISTS fk_access_control_record CASCADE;\n\n\nALTER TABLE access_control \nADD CONSTRAINT fk_access_control_record \nFOREIGN KEY (record) \nREFERENCES record_index (ID)\nON DELETE CASCADE;\n");
        this.tableDeclarations.put("access-control", res.toString());
    }

    public void generateSQLInsertFunction(String jsonschema, String templateName, String consistOf, String root_dir, TemplateBindingsSchema templateBindingsSchema, List<String> shared, Map<String, Map<String, Map<String, String>>> inputOutputMaps, List<String> search) {
        new CompilerSqlComposer(this.pFactory, this.tableKey, this.functionDeclarations, this.arrayFunctionDeclarations).generateSQLInsertFunction(jsonschema, templateName, consistOf, root_dir, templateBindingsSchema, shared);
        if (shared != null && !shared.isEmpty()) {
            new CompilerSqlComposer(this.pFactory, this.tableKey, this.functionDeclarations, this.arrayFunctionDeclarations).generateInsertIntoSharedRelation(templateName, templateBindingsSchema, shared);
            new CompilerSqlComposer(this.pFactory, this.tableKey, this.functionDeclarations, this.arrayFunctionDeclarations).generateSQLInsertArrayFunction(templateName, consistOf, templateBindingsSchema, shared);
            new CompilerSqlComposer(this.pFactory, this.tableKey, this.functionDeclarations, this.arrayFunctionDeclarations).generateSQLInsertCompositeAndLinkerFunction(templateName, consistOf, templateBindingsSchema, shared);
            if (consistOf != null) {
                this.generateSQLCompositeAndLinkerTable(templateName);
            }
        }
        this.generateAccessControlTables();
        if (search != null) {
            for (String baseRelation : search) {
                List<Pair<String, String>> templatesWithBaseRelation = this.getTemplatesWithBaseRelation(baseRelation, inputOutputMaps);
                Map<String, List<String>> groupedTemplatesWithBaseRelation = templatesWithBaseRelation.stream().collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList())));
                new CompilerSqlComposer(this.pFactory, this.tableKey, this.functionDeclarations, this.arrayFunctionDeclarations).generateSQLSearchRecordFunction(baseRelation, groupedTemplatesWithBaseRelation, templateName, consistOf, root_dir, templateBindingsSchema, shared);
                new CompilerSqlComposer(this.pFactory, this.tableKey, this.functionDeclarations, this.arrayFunctionDeclarations).generateSQLSearchRecordByIdFunction(baseRelation, groupedTemplatesWithBaseRelation, templateName, consistOf, root_dir, templateBindingsSchema, shared);
            }
        }
    }

    public List<Pair<String, String>> getTemplatesWithBaseRelation(String baseRelation, Map<String, Map<String, Map<String, String>>> inputOutputMaps) {
        LinkedList<Pair<String, String>> templates2 = new LinkedList<Pair<String, String>>();
        if (inputOutputMaps != null) {
            for (String key : inputOutputMaps.keySet()) {
                Map<String, Map<String, String>> map = inputOutputMaps.get(key);
                for (String template : map.keySet()) {
                    Map<String, String> map2 = map.get(template);
                    for (String property : map2.keySet()) {
                        if (!map2.get(property).equals(baseRelation)) continue;
                        templates2.add((Pair<String, String>)Pair.of((Object)template, (Object)property));
                    }
                }
            }
        }
        return templates2;
    }

    private boolean sepIfNotFirst(StringBuilder res, boolean first, String sep) {
        if (first) {
            first = false;
        } else {
            res.append(sep);
        }
        return first;
    }
}

