/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler.sql;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.configuration.Locations;
import org.openprovenance.prov.template.compiler.configuration.SpecificationFile;
import org.openprovenance.prov.template.compiler.configuration.TemplatesProjectConfiguration;

public class CompilerSqlIntegration {
    private final CompilerUtil compilerUtil;
    public static ParameterizedTypeName BIFUN = ParameterizedTypeName.get(BiFunction.class, (Type[])new Type[]{Integer.class, String.class, Object.class});

    public CompilerSqlIntegration(ProvFactory pFactory) {
        this.compilerUtil = new CompilerUtil(pFactory);
    }

    public SpecificationFile generateSqlIntegration_BeanCompleter(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlBeanCompleter");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter"), (String)"BeanCompleter", (String[])new String[0]));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ResultSet.class, "rs", new Modifier[0]);
        constructor.addStatement("super(new Getter() {\n            @Override\n            public <T> T get(Class<T> cl, String col) {\n                try {\n                    return rs.getObject(col,cl);\n                } catch ($T e) {\n                    e.printStackTrace();\n                    throw new RuntimeException(e);\n                }\n            }\n        })", new Object[]{SQLException.class});
        builder.addMethod(constructor.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_CompositeBeanCompleter(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlCompositeBeanCompleter");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ClassName.get((String)locations.getFilePackage("SqlBeanCompleter"), (String)"SqlBeanCompleter", (String[])new String[0]));
        FieldSpec.Builder field = FieldSpec.builder(ResultSet.class, (String)"rs", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addField(field.build());
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ResultSet.class, "rs", new Modifier[0]);
        constructor.addStatement("super(rs)", new Object[0]);
        constructor.addStatement("this.rs=rs", new Object[0]);
        builder.addMethod(constructor.build());
        MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"next").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Boolean.TYPE);
        mspec.beginControlFlow("try", new Object[0]);
        mspec.addStatement("return rs.next()", new Object[0]);
        mspec.nextControlFlow("catch ($T e)", new Object[]{SQLException.class});
        mspec.addStatement("throw new RuntimeException(e)", new Object[0]);
        mspec.endControlFlow();
        builder.addMethod(mspec.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_BeanCompleter3(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlBeanCompleter3");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter2"), (String)"BeanCompleter2", (String[])new String[0]));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ResultSet.class, "rs", new Modifier[0]).addStatement("super(newGetter(rs))", new Object[0]);
        builder.addMethod(constructor.build());
        MethodSpec.Builder staticMethod = MethodSpec.methodBuilder((String)"newGetter").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter2"), (String)"BeanCompleter2", (String[])new String[]{"Getter"})).addParameter(ResultSet.class, "rs", new Modifier[0]);
        staticMethod.addStatement("return new Getter() {\n            @Override\n            public <T> T get(Class<T> cl, String col) {\n                try {\n                    return rs.getObject(col,cl);\n                } catch ($T e) {\n                    e.printStackTrace();\n                    throw new RuntimeException(e);\n                }\n            }\n        }", new Object[]{SQLException.class});
        builder.addMethod(staticMethod.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_BeanCompleter4(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlBeanCompleter4");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ClassName.get((String)locations.getFilePackage("SqlBeanCompleter3"), (String)"SqlBeanCompleter3", (String[])new String[0]));
        FieldSpec.Builder field = FieldSpec.builder((TypeName)BIFUN, (String)"postProcessing", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addField(field.build());
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ResultSet.class, "rs", new Modifier[0]).addParameter((TypeName)BIFUN, "postProcessing", new Modifier[0]).addStatement("super(rs)", new Object[0]).addStatement("this.postProcessing=postProcessing", new Object[0]);
        builder.addMethod(constructor.build());
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"postEnactmentProcessing").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Integer.class, "id", new Modifier[0]).addParameter(String.class, "template", new Modifier[0]);
        method.addStatement("if (postProcessing != null) {\n            postProcessing.apply(id, template);\n        }", new Object[0]);
        builder.addMethod(method.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_EnactorImplementation(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlEnactorImplementation");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage("BeanEnactor"), (String)"BeanEnactor", (String[])new String[]{"EnactorImplementation"}), (TypeName[])new TypeName[]{TypeName.get(ResultSet.class)}));
        ParameterizedTypeName querierType = ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(ResultSet.class)});
        FieldSpec.Builder field1 = FieldSpec.builder((TypeName)querierType, (String)"querier", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addField(field1.build());
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)querierType, "querier", new Modifier[0]);
        constructor.addStatement("this.querier=querier", new Object[0]);
        builder.addMethod(constructor.build());
        MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"generic_enact").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addTypeVariable(TypeVariableName.get((String)"T")).addParameter((TypeName)TypeVariableName.get((String)"T"), "bean", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}), "check", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(BiConsumer.class), (TypeName[])new TypeName[]{ClassName.get(StringBuilder.class), TypeVariableName.get((String)"T")}), "composeQuery", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(BiConsumer.class), (TypeName[])new TypeName[]{TypeName.get(ResultSet.class), TypeVariableName.get((String)"T")}), "completeBean", new Modifier[0]).returns((TypeName)TypeVariableName.get((String)"T"));
        mspec.addStatement("check.accept(bean)", new Object[0]);
        mspec.addStatement("$T sb = new $T()", new Object[]{StringBuilder.class, StringBuilder.class});
        mspec.addStatement("composeQuery.accept(sb, bean)", new Object[0]);
        mspec.addStatement("String statement = sb.toString()", new Object[0]);
        mspec.addStatement("$T rs", new Object[]{ResultSet.class});
        mspec.beginControlFlow("try", new Object[0]);
        mspec.addStatement("rs = querier.apply(statement)", new Object[0]);
        mspec.beginControlFlow("if (!rs.next())", new Object[0]);
        mspec.addStatement("rs.close()", new Object[0]);
        mspec.addStatement("throw new $T(\"Single row result was expected but result set is empty \")", new Object[]{SQLException.class});
        mspec.endControlFlow();
        mspec.addStatement("completeBean.accept(rs, bean)", new Object[0]);
        mspec.beginControlFlow("if (rs.next())", new Object[0]);
        mspec.addStatement("rs.close()", new Object[0]);
        mspec.addStatement("throw new $T(\"Single row result was expected for query \")", new Object[]{SQLException.class});
        mspec.nextControlFlow("else", new Object[0]);
        mspec.addStatement("rs.close()", new Object[0]);
        mspec.endControlFlow();
        mspec.nextControlFlow("catch ($T e)", new Object[]{SQLException.class});
        mspec.addStatement("e.printStackTrace()", new Object[0]);
        mspec.addStatement("throw new $T(\"Issue in enactment \" + statement, e)", new Object[]{UncheckedException.class});
        mspec.endControlFlow();
        mspec.addStatement("return bean", new Object[0]);
        builder.addMethod(mspec.build());
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"beanCompleterFactory").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter"), (String)"BeanCompleter", (String[])new String[0])).addParameter(ResultSet.class, "rs", new Modifier[0]);
        method.addStatement("return new $T(rs)", new Object[]{ClassName.get((String)locations.getFilePackage("SqlBeanCompleter"), (String)"SqlBeanCompleter", (String[])new String[0])});
        builder.addMethod(method.build());
        MethodSpec.Builder staticMethod = MethodSpec.methodBuilder((String)"printResultSet").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(ResultSet.class, "resultSet", new Modifier[0]);
        staticMethod.beginControlFlow("try", new Object[0]);
        staticMethod.addStatement("$T rsmd = resultSet.getMetaData()", new Object[]{ResultSetMetaData.class});
        staticMethod.addStatement("int columnsNumber = rsmd.getColumnCount()", new Object[0]);
        staticMethod.beginControlFlow("do", new Object[0]);
        staticMethod.addStatement("// in generic_enact, we have already done next(), we are on the first record", new Object[0]);
        staticMethod.addStatement("System.out.print (\"Row \" + resultSet.getRow() + \" \")", new Object[0]);
        staticMethod.beginControlFlow("for (int i = 1; i <= columnsNumber; i++)", new Object[0]);
        staticMethod.beginControlFlow("if (i > 1)", new Object[0]);
        staticMethod.addStatement("System.out.print(\",  \")", new Object[0]);
        staticMethod.endControlFlow();
        staticMethod.addStatement("String columnValue = resultSet.getString(i)", new Object[0]);
        staticMethod.addStatement("System.out.print(columnValue + \" \" + rsmd.getColumnName(i))", new Object[0]);
        staticMethod.endControlFlow();
        staticMethod.addStatement("System.out.println(\"\")", new Object[0]);
        staticMethod.endControlFlow("while (resultSet.next())", new Object[0]);
        staticMethod.nextControlFlow("catch ($T e)", new Object[]{SQLException.class});
        staticMethod.addStatement("throw new $T(e)", new Object[]{RuntimeException.class});
        staticMethod.endControlFlow();
        builder.addMethod(staticMethod.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_IntegratorEnactorImplementation(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlEnactorImplementation3");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage("BeanEnactor2"), (String)"BeanEnactor2", (String[])new String[]{"EnactorImplementation"}), (TypeName[])new TypeName[]{TypeName.get(ResultSet.class)}));
        ParameterizedTypeName querierType = ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(ResultSet.class)});
        FieldSpec.Builder field1 = FieldSpec.builder((TypeName)querierType, (String)"querier", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addField(field1.build());
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)querierType, "querier", new Modifier[0]);
        constructor.addStatement("this.querier=querier", new Object[0]);
        builder.addMethod(constructor.build());
        MethodSpec.Builder mspec = MethodSpec.methodBuilder((String)"generic_enact").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addTypeVariable(TypeVariableName.get((String)"IN")).addTypeVariable(TypeVariableName.get((String)"OUT")).addParameter((TypeName)TypeVariableName.get((String)"OUT"), "output", new Modifier[0]).addParameter((TypeName)TypeVariableName.get((String)"IN"), "bean", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"IN")}), "check", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(BiConsumer.class), (TypeName[])new TypeName[]{ClassName.get(StringBuilder.class), TypeVariableName.get((String)"IN")}), "composeQuery", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(BiConsumer.class), (TypeName[])new TypeName[]{TypeName.get(ResultSet.class), TypeVariableName.get((String)"OUT")}), "completeBean", new Modifier[0]).returns((TypeName)TypeVariableName.get((String)"OUT"));
        mspec.addStatement("check.accept(bean)", new Object[0]);
        mspec.addStatement("$T sb = new $T()", new Object[]{StringBuilder.class, StringBuilder.class});
        mspec.addStatement("composeQuery.accept(sb, bean)", new Object[0]);
        mspec.addStatement("String statement = sb.toString()", new Object[0]);
        mspec.addStatement("$T rs", new Object[]{ResultSet.class});
        mspec.beginControlFlow("try", new Object[0]);
        mspec.addStatement("rs = querier.apply(statement)", new Object[0]);
        mspec.beginControlFlow("if (!rs.next())", new Object[0]);
        mspec.addStatement("rs.close()", new Object[0]);
        mspec.addStatement("throw new $T(\"Single row result was expected but result set is empty \")", new Object[]{SQLException.class});
        mspec.endControlFlow();
        mspec.addStatement("completeBean.accept(rs, output)", new Object[0]);
        mspec.beginControlFlow("if (rs.next())", new Object[0]);
        mspec.addStatement("rs.close()", new Object[0]);
        mspec.addStatement("throw new $T(\"Single row result was expected for query \")", new Object[]{SQLException.class});
        mspec.nextControlFlow("else", new Object[0]);
        mspec.addStatement("rs.close()", new Object[0]);
        mspec.endControlFlow();
        mspec.nextControlFlow("catch ($T e)", new Object[]{SQLException.class});
        mspec.addStatement("e.printStackTrace()", new Object[0]);
        mspec.addStatement("throw new $T(\"Issue in enactment \" + statement, e)", new Object[]{UncheckedException.class});
        mspec.endControlFlow();
        mspec.addStatement("return output", new Object[0]);
        builder.addMethod(mspec.build());
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"beanCompleterFactory").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter2"), (String)"BeanCompleter2", (String[])new String[0])).addParameter(ResultSet.class, "rs", new Modifier[0]);
        method.addStatement("return new $T(rs)", new Object[]{ClassName.get((String)locations.getFilePackage("SqlBeanCompleter3"), (String)"SqlBeanCompleter3", (String[])new String[0])});
        builder.addMethod(method.build());
        MethodSpec.Builder method2 = MethodSpec.methodBuilder((String)"beanCompleterFactory").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter2"), (String)"BeanCompleter2", (String[])new String[0])).addParameter(ResultSet.class, "rs", new Modifier[0]).addParameter(Object[].class, "extra", new Modifier[0]);
        method2.addStatement("return new $T(rs)", new Object[]{ClassName.get((String)locations.getFilePackage("SqlBeanCompleter3"), (String)"SqlBeanCompleter3", (String[])new String[0])});
        builder.addMethod(method2.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_IntegratorEnactorImplementation4(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlEnactorImplementation4");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ClassName.get((String)locations.getFilePackage("SqlEnactorImplementation3"), (String)"SqlEnactorImplementation3", (String[])new String[0]));
        builder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage("BeanEnactor2"), (String)"BeanEnactor2", (String[])new String[]{"EnactorImplementation"}), (TypeName[])new TypeName[]{TypeName.get(ResultSet.class)}));
        builder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage("BeanEnactor4"), (String)"BeanEnactor4", (String[])new String[]{"EnactorImplementation"}), (TypeName[])new TypeName[]{TypeName.get(ResultSet.class)}));
        ParameterizedTypeName querierType = ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(ResultSet.class)});
        FieldSpec.Builder field1 = FieldSpec.builder((TypeName)querierType, (String)"querier", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addField(field1.build());
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)querierType, "querier", new Modifier[0]);
        constructor.addStatement("super(querier)", new Object[0]);
        constructor.addStatement("this.querier=querier", new Object[0]);
        builder.addMethod(constructor.build());
        MethodSpec.Builder method3 = MethodSpec.methodBuilder((String)"beanCompleterFactory").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter2"), (String)"BeanCompleter2", (String[])new String[0])).addParameter(ResultSet.class, "rs", new Modifier[0]).addParameter(Object[].class, "extra", new Modifier[0]).addParameter((TypeName)BIFUN, "postProcessing", new Modifier[0]);
        method3.addStatement("return new $T(rs,$N)", new Object[]{ClassName.get((String)locations.getFilePackage("SqlBeanCompleter4"), (String)"SqlBeanCompleter4", (String[])new String[0]), "postProcessing"});
        builder.addMethod(method3.build());
        MethodSpec.Builder method4 = MethodSpec.methodBuilder((String)"beanCompleterFactory").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter2"), (String)"BeanCompleter2", (String[])new String[0])).addParameter(ResultSet.class, "rs", new Modifier[0]).addParameter((TypeName)BIFUN, "postProcessing", new Modifier[0]);
        method4.addStatement("return new $T(rs,$N)", new Object[]{ClassName.get((String)locations.getFilePackage("SqlBeanCompleter4"), (String)"SqlBeanCompleter4", (String[])new String[0]), "postProcessing"});
        builder.addMethod(method4.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_CompositeEnactorImplementation(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlCompositeEnactorImplementation");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ClassName.get((String)locations.getFilePackage("SqlEnactorImplementation"), (String)"SqlEnactorImplementation", (String[])new String[0]));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(ResultSet.class)}), "querier", new Modifier[0]);
        constructor.addStatement("super(querier)", new Object[0]);
        builder.addMethod(constructor.build());
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"beanCompleterFactory").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter"), (String)"BeanCompleter", (String[])new String[0])).addParameter(ResultSet.class, "rs", new Modifier[0]);
        method.addStatement("return new $T(rs)", new Object[]{ClassName.get((String)locations.getFilePackage("SqlCompositeBeanCompleter"), (String)"SqlCompositeBeanCompleter", (String[])new String[0])});
        builder.addMethod(method.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_CompositeBeanEnactor(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlCompositeBeanEnactor");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage("BeanEnactor"), (String)"BeanEnactor", (String[])new String[0]), (TypeName[])new TypeName[]{TypeName.get(ResultSet.class)}));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(ResultSet.class)}), "querier", new Modifier[0]);
        constructor.addStatement("super(new  $T(querier), new $T())", new Object[]{ClassName.get((String)locations.getFilePackage("SqlCompositeEnactorImplementation"), (String)"SqlCompositeEnactorImplementation", (String[])new String[0]), ClassName.get((String)locations.getFilePackage("BeanChecker"), (String)"BeanChecker", (String[])new String[0])});
        builder.addMethod(constructor.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_BeanEnactor(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlBeanEnactor");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage("BeanEnactor"), (String)"BeanEnactor", (String[])new String[0]), (TypeName[])new TypeName[]{TypeName.get(ResultSet.class)}));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(ResultSet.class)}), "querier", new Modifier[0]);
        constructor.addStatement("super(new  $T(querier), new $T())", new Object[]{ClassName.get((String)locations.getFilePackage("SqlEnactorImplementation"), (String)"SqlEnactorImplementation", (String[])new String[0]), ClassName.get((String)locations.getFilePackage("BeanChecker"), (String)"BeanChecker", (String[])new String[0])});
        builder.addMethod(constructor.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_BeanEnactor3(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlBeanEnactor3");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage("BeanEnactor2"), (String)"BeanEnactor2", (String[])new String[0]), (TypeName[])new TypeName[]{TypeName.get(ResultSet.class)}));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(ResultSet.class)}), "querier", new Modifier[0]);
        constructor.addStatement("super(new  $T(querier), new $T())", new Object[]{ClassName.get((String)locations.getFilePackage("SqlCompositeEnactorImplementation3"), (String)"SqlCompositeEnactorImplementation3", (String[])new String[0]), ClassName.get((String)locations.getFilePackage("BeanChecker2"), (String)"BeanChecker2", (String[])new String[0])});
        builder.addMethod(constructor.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_BeanEnactor4(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlBeanEnactor4");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage("BeanEnactor4"), (String)"BeanEnactor4", (String[])new String[0]), (TypeName[])new TypeName[]{TypeName.get(ResultSet.class)}));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(ResultSet.class)}), "querier", new Modifier[0]).addParameter((TypeName)BIFUN, "postProcessing", new Modifier[0]);
        constructor.addStatement("super(new  $T(querier), new $T(), $N)", new Object[]{ClassName.get((String)locations.getFilePackage("SqlCompositeEnactorImplementation4"), (String)"SqlCompositeEnactorImplementation4", (String[])new String[0]), ClassName.get((String)locations.getFilePackage("BeanChecker2"), (String)"BeanChecker2", (String[])new String[0]), "postProcessing"});
        builder.addMethod(constructor.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_CompositeEnactorImplementation3(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlCompositeEnactorImplementation3");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ClassName.get((String)locations.getFilePackage("SqlEnactorImplementation3"), (String)"SqlEnactorImplementation3", (String[])new String[0]));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(ResultSet.class)}), "querier", new Modifier[0]);
        constructor.addStatement("super(querier)", new Object[0]);
        builder.addMethod(constructor.build());
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"beanCompleterFactory").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter2"), (String)"BeanCompleter2", (String[])new String[0])).addParameter(ResultSet.class, "rs", new Modifier[0]);
        method.addStatement("return new $T(rs)", new Object[]{ClassName.get((String)locations.getFilePackage("SqlCompositeBeanCompleter3"), (String)"SqlCompositeBeanCompleter3", (String[])new String[0])});
        builder.addMethod(method.build());
        MethodSpec.Builder method2 = MethodSpec.methodBuilder((String)"beanCompleterFactory").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter2"), (String)"BeanCompleter2", (String[])new String[0])).addParameter(ResultSet.class, "rs", new Modifier[0]).addParameter(Object[].class, "extra", new Modifier[0]);
        method2.addStatement("return new $T(rs, extra)", new Object[]{ClassName.get((String)locations.getFilePackage("SqlCompositeBeanCompleter3"), (String)"SqlCompositeBeanCompleter3", (String[])new String[0])});
        builder.addMethod(method2.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_CompositeEnactorImplementation4(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlCompositeEnactorImplementation4");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ClassName.get((String)locations.getFilePackage("SqlEnactorImplementation4"), (String)"SqlEnactorImplementation4", (String[])new String[0]));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(ResultSet.class)}), "querier", new Modifier[0]);
        constructor.addStatement("super(querier)", new Object[0]);
        builder.addMethod(constructor.build());
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"beanCompleterFactory").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter2"), (String)"BeanCompleter2", (String[])new String[0])).addParameter(ResultSet.class, "rs", new Modifier[0]);
        method.addStatement("return new $T(rs)", new Object[]{ClassName.get((String)locations.getFilePackage("SqlCompositeBeanCompleter4"), (String)"SqlCompositeBeanCompleter4", (String[])new String[0])});
        builder.addMethod(method.build());
        MethodSpec.Builder method2 = MethodSpec.methodBuilder((String)"beanCompleterFactory").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter2"), (String)"BeanCompleter2", (String[])new String[0])).addParameter(ResultSet.class, "rs", new Modifier[0]).addParameter(Object[].class, "extra", new Modifier[0]);
        method2.addStatement("return new $T(rs, extra)", new Object[]{ClassName.get((String)locations.getFilePackage("SqlCompositeBeanCompleter4"), (String)"SqlCompositeBeanCompleter4", (String[])new String[0])});
        builder.addMethod(method2.build());
        MethodSpec.Builder method3 = MethodSpec.methodBuilder((String)"beanCompleterFactory").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter2"), (String)"BeanCompleter2", (String[])new String[0])).addParameter(ResultSet.class, "rs", new Modifier[0]).addParameter(Object[].class, "extra", new Modifier[0]).addParameter((TypeName)BIFUN, "postProcessing", new Modifier[0]);
        method3.addStatement("return new $T(rs, extra,postProcessing)", new Object[]{ClassName.get((String)locations.getFilePackage("SqlCompositeBeanCompleter4"), (String)"SqlCompositeBeanCompleter4", (String[])new String[0])});
        builder.addMethod(method3.build());
        MethodSpec.Builder method4 = MethodSpec.methodBuilder((String)"beanCompleterFactory").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter2"), (String)"BeanCompleter2", (String[])new String[0])).addParameter(ResultSet.class, "rs", new Modifier[0]).addParameter((TypeName)BIFUN, "postProcessing", new Modifier[0]);
        method4.addStatement("return new $T(rs,postProcessing)", new Object[]{ClassName.get((String)locations.getFilePackage("SqlCompositeBeanCompleter4"), (String)"SqlCompositeBeanCompleter4", (String[])new String[0])});
        builder.addMethod(method4.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_CompositeBeanCompleter3(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlCompositeBeanCompleter3");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ClassName.get((String)locations.getFilePackage("BeanCompleter3"), (String)"BeanCompleter3", (String[])new String[0]));
        FieldSpec.Builder field1 = FieldSpec.builder(Object[].class, (String)"extra", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addField(field1.build());
        FieldSpec.Builder field2 = FieldSpec.builder(ResultSet.class, (String)"rs", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addField(field2.build());
        FieldSpec.Builder field3 = FieldSpec.builder(String.class, (String)"PARENT_COLUMN", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{"parent"});
        builder.addField(field3.build());
        MethodSpec.Builder constructor1 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ResultSet.class, "rs", new Modifier[0]).addStatement("this(rs,(Object[]) null)", new Object[0]);
        builder.addMethod(constructor1.build());
        MethodSpec.Builder constructor2 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ResultSet.class, "rs", new Modifier[0]).addParameter(Object[].class, "extra", new Modifier[0]).addStatement("super($T.newGetter(rs))", new Object[]{ClassName.get((String)locations.getFilePackage("SqlBeanCompleter3"), (String)"SqlBeanCompleter3", (String[])new String[0])}).addStatement("this.rs=rs", new Object[0]).addStatement("this.extra=extra", new Object[0]);
        builder.addMethod(constructor2.build());
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"getValueFromLocation").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.class).addStatement("return (Integer) extra[0]", new Object[0]);
        builder.addMethod(method.build());
        MethodSpec.Builder method2 = MethodSpec.methodBuilder((String)"next").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Boolean.TYPE);
        method2.beginControlFlow("try", new Object[0]);
        method2.addStatement("return rs.next()", new Object[0]);
        method2.nextControlFlow("catch ($T e)", new Object[]{SQLException.class});
        method2.addStatement("throw new $T(e)", new Object[]{RuntimeException.class});
        method2.endControlFlow();
        builder.addMethod(method2.build());
        MethodSpec.Builder method3 = MethodSpec.methodBuilder((String)"setValueInLocation").addModifiers(new Modifier[]{Modifier.PUBLIC});
        method3.beginControlFlow("if (extra != null)", new Object[0]);
        method3.addStatement("int parent = getter.get(Integer.class, PARENT_COLUMN)", new Object[0]);
        method3.addStatement("extra[0]= parent", new Object[0]);
        method3.endControlFlow();
        builder.addMethod(method3.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_CompositeBeanCompleter4(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlCompositeBeanCompleter4");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ClassName.get((String)locations.getFilePackage("SqlCompositeBeanCompleter3"), (String)"SqlCompositeBeanCompleter3", (String[])new String[0]));
        FieldSpec.Builder field4 = FieldSpec.builder((TypeName)BIFUN, (String)"postProcessing", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addField(field4.build());
        MethodSpec.Builder constructor1 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ResultSet.class, "rs", new Modifier[0]).addStatement("this(rs,(Object[]) null)", new Object[0]);
        builder.addMethod(constructor1.build());
        MethodSpec.Builder constructor2 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ResultSet.class, "rs", new Modifier[0]).addParameter(Object[].class, "extra", new Modifier[0]).addStatement("super(rs,extra)", new Object[0]).addStatement("this.postProcessing=null", new Object[0]);
        builder.addMethod(constructor2.build());
        MethodSpec.Builder constructor3 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ResultSet.class, "rs", new Modifier[0]).addParameter(Object[].class, "extra", new Modifier[0]).addParameter((TypeName)BIFUN, "postProcessing", new Modifier[0]).addStatement("super(rs,extra)", new Object[0]).addStatement("this.postProcessing=postProcessing", new Object[0]);
        builder.addMethod(constructor3.build());
        MethodSpec.Builder constructor4 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ResultSet.class, "rs", new Modifier[0]).addParameter((TypeName)BIFUN, "postProcessing", new Modifier[0]).addStatement("super(rs,null)", new Object[0]).addStatement("this.postProcessing=postProcessing", new Object[0]);
        builder.addMethod(constructor4.build());
        MethodSpec.Builder postMethod = MethodSpec.methodBuilder((String)"postEnactmentProcessing").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Integer.class, "id", new Modifier[0]).addParameter(String.class, "template", new Modifier[0]).beginControlFlow("if (postProcessing != null)", new Object[0]).addStatement("postProcessing.apply(id, template)", new Object[0]).endControlFlow().returns(Void.TYPE);
        builder.addMethod(postMethod.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_CompositeBeanEnactor3(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlCompositeBeanEnactor3");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage("BeanEnactor2Composite"), (String)"BeanEnactor2Composite", (String[])new String[0]), (TypeName[])new TypeName[]{TypeName.get(ResultSet.class)}));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(ResultSet.class)}), "querier", new Modifier[0]);
        constructor.addStatement("super(new  $T(querier), new $T())", new Object[]{ClassName.get((String)locations.getFilePackage("SqlCompositeEnactorImplementation3"), (String)"SqlCompositeEnactorImplementation3", (String[])new String[0]), ClassName.get((String)locations.getFilePackage("BeanChecker2"), (String)"BeanChecker2", (String[])new String[0])});
        builder.addMethod(constructor.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_CompositeBeanEnactor4(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlCompositeBeanEnactor4");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)locations.getFilePackage("BeanEnactor4Composite"), (String)"BeanEnactor4Composite", (String[])new String[0]), (TypeName[])new TypeName[]{TypeName.get(ResultSet.class)}));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(ResultSet.class)}), "querier", new Modifier[0]).addParameter((TypeName)BIFUN, "postProcessing", new Modifier[0]);
        constructor.addStatement("super(new  $T(querier), new $T(),$N)", new Object[]{ClassName.get((String)locations.getFilePackage("SqlCompositeEnactorImplementation4"), (String)"SqlCompositeEnactorImplementation4", (String[])new String[0]), ClassName.get((String)locations.getFilePackage("BeanChecker2"), (String)"BeanChecker2", (String[])new String[0]), "postProcessing"});
        builder.addMethod(constructor.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_CompositeEnactorConfigurator3(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlCompositeEnactorConfigurator3");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ClassName.get((String)locations.getFilePackage("CompositeEnactorConfigurator2"), (String)"CompositeEnactorConfigurator2", (String[])new String[0]));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(ResultSet.class)}), "querier", new Modifier[0]);
        constructor.addStatement("super(new  $T(querier))", new Object[]{ClassName.get((String)locations.getFilePackage("SqlCompositeBeanEnactor3"), (String)"SqlCompositeBeanEnactor3", (String[])new String[0])});
        builder.addMethod(constructor.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_CompositeEnactorConfigurator4(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlCompositeEnactorConfigurator4");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ClassName.get((String)locations.getFilePackage("CompositeEnactorConfigurator2"), (String)"CompositeEnactorConfigurator2", (String[])new String[0]));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(ResultSet.class)}), "querier", new Modifier[0]).addParameter((TypeName)BIFUN, "postProcessing", new Modifier[0]);
        constructor.addStatement("super(new  $T($N,$N))", new Object[]{ClassName.get((String)locations.getFilePackage("SqlCompositeBeanEnactor4"), (String)"SqlCompositeBeanEnactor4", (String[])new String[0]), "querier", "postProcessing"});
        builder.addMethod(constructor.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_EnactorConfigurator3(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlEnactorConfigurator3");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ClassName.get((String)locations.getFilePackage("EnactorConfigurator2"), (String)"EnactorConfigurator2", (String[])new String[0]));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(ResultSet.class)}), "querier", new Modifier[0]);
        constructor.addStatement("super(new  $T(querier))", new Object[]{ClassName.get((String)locations.getFilePackage("SqlBeanEnactor3"), (String)"SqlBeanEnactor3", (String[])new String[0])});
        builder.addMethod(constructor.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }

    public SpecificationFile generateSqlIntegration_EnactorConfigurator4(TemplatesProjectConfiguration configs, Locations locations, String fileName) {
        StackTraceElement stackTraceElement = this.compilerUtil.thisMethodAndLine();
        TypeSpec.Builder builder = this.compilerUtil.generateClassInit("SqlEnactorConfigurator4");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.superclass((TypeName)ClassName.get((String)locations.getFilePackage("EnactorConfigurator2"), (String)"EnactorConfigurator2", (String[])new String[0]));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(ResultSet.class)}), "querier", new Modifier[0]).addParameter((TypeName)BIFUN, "postProcessing", new Modifier[0]);
        constructor.addStatement("super(new  $T($N,$N))", new Object[]{ClassName.get((String)locations.getFilePackage("SqlBeanEnactor4"), (String)"SqlBeanEnactor4", (String[])new String[0]), "querier", "postProcessing"});
        builder.addMethod(constructor.build());
        TypeSpec theClass = builder.build();
        String myPackage = locations.getFilePackage(fileName);
        JavaFile myfile = this.compilerUtil.specWithComment(theClass, configs, myPackage, stackTraceElement);
        return new SpecificationFile(myfile, locations.convertToBackendDirectory(myPackage), fileName + ".java", myPackage);
    }
}

