/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.descriptors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum OutputFieldValue {
    True,
    Optional,
    False;

    private static final Map<String, OutputFieldValue> namesMap;

    @JsonCreator
    public static OutputFieldValue forValue(String value) {
        OutputFieldValue inputFieldValue = namesMap.get(StringUtils.lowerCase((String)value));
        if (inputFieldValue == null) {
            throw new UnsupportedOperationException("Unknown output field value " + value);
        }
        return inputFieldValue;
    }

    @JsonValue
    public String toValue() {
        for (Map.Entry<String, OutputFieldValue> entry : namesMap.entrySet()) {
            if (entry.getValue() != this) continue;
            return entry.getKey();
        }
        return null;
    }

    @JsonIgnore
    public static boolean isOutput(OutputFieldValue outputFieldValue) {
        if (outputFieldValue == null) {
            return false;
        }
        switch (outputFieldValue.ordinal()) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new UnsupportedOperationException("never reaching this point");
    }

    @JsonIgnore
    public static boolean hasOutput(OutputFieldValue outputFieldValue) {
        if (outputFieldValue == null) {
            return false;
        }
        switch (outputFieldValue.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        throw new UnsupportedOperationException("never reaching this point");
    }

    static {
        namesMap = new HashMap<String, OutputFieldValue>(3);
        namesMap.put("true", True);
        namesMap.put("optional", Optional);
        namesMap.put("false", False);
    }
}

