/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.emitter.minilanguage;

import java.util.List;
import org.openprovenance.prov.template.emitter.Element;
import org.openprovenance.prov.template.emitter.minilanguage.Expression;
import org.openprovenance.prov.template.emitter.minilanguage.Lambda;
import org.openprovenance.prov.template.emitter.minilanguage.Parameter;
import org.openprovenance.prov.template.emitter.minilanguage.Statement;
import org.openprovenance.prov.template.emitter.minilanguage.emitters.Python;

public class Return
extends Statement {
    private final Expression value;
    static int lambdaCount = 0;

    public Return(List<Element> value, List<Element> elements) {
        super(elements);
        this.value = Expression.makeExpression(value);
    }

    @Override
    public String toString() {
        return "Return{value=" + String.valueOf(this.value) + "}";
    }

    @Override
    public void emit(Python emitter, List<String> classVariables, List<String> instanceVariables) {
        if (this.value instanceof Lambda) {
            int suffix = lambdaCount++;
            Lambda lambda = (Lambda)this.value;
            emitter.emitBeginLine("def lambda" + suffix + " (");
            boolean first = true;
            for (Parameter p : lambda.parameters) {
                if (!first) {
                    emitter.emitContinueLine(",");
                }
                first = false;
                emitter.emitContinueLine(p.name);
            }
            emitter.emitContinueLine("):");
            emitter.emitNewline();
            emitter.indent();
            for (Statement s : lambda.body) {
                s.emit(emitter, classVariables, instanceVariables);
            }
            emitter.unindent();
            emitter.emitNewline();
            emitter.emitLine("return lambda" + suffix);
            emitter.emitNewline();
        } else {
            emitter.emitBeginLine("return ");
            this.value.emit(emitter, true, classVariables, instanceVariables);
            emitter.emitNewline();
        }
    }
}

