-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS activity (
  id SERIAL,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS impact (
  id SERIAL,
  serial INT,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS aspect (
  id SERIAL,
  serial INT,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS environmentType (
  id SERIAL,
  serial INT,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS policy (
  id SERIAL,
  serial INT,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS objective (
  id SERIAL,
  serial INT,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS target (
  id SERIAL,
  serial INT,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS reports (
  id SERIAL,
  serial INT,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS method (
  id SERIAL,
  serial INT,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS methods (
  id SERIAL,
  serial INT,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS progress (
  id SERIAL,
  serial INT,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS obligation (
  id SERIAL,
  serial INT,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSqlTypeDeclaration()
DROP TYPE IF EXISTS plead_transforming_type CASCADE;
CREATE TYPE plead_transforming_type AS  (
  transformed_file TEXT,
  file TEXT,
  organization INT,
  engineer INT,
  transforming INT,
  n_rows INT,
  n_cols INT,
  path TEXT,
  time timestamptz,
  start timestamptz,
  end timestamptz
 );





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSqlTypeDeclaration()
DROP TYPE IF EXISTS plead_filtering_type CASCADE;
CREATE TYPE plead_filtering_type AS  (
  filtered_file TEXT,
  file TEXT,
  method TEXT,
  organization INT,
  engineer INT,
  filtering INT,
  n_rows INT,
  n_cols INT,
  path TEXT,
  time timestamptz,
  start timestamptz,
  end timestamptz
 );





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSqlTypeDeclaration()
DROP TYPE IF EXISTS plead_training_type CASCADE;
CREATE TYPE plead_training_type AS  (
  pipeline TEXT,
  training_dataset TEXT,
  organization INT,
  engineer INT,
  training INT,
  path TEXT,
  time timestamptz,
  start timestamptz,
  end timestamptz
 );





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSqlTypeDeclaration()
DROP TYPE IF EXISTS plead_validating_type CASCADE;
CREATE TYPE plead_validating_type AS  (
  score INT,
  testing_dataset TEXT,
  organization INT,
  engineer INT,
  validating INT,
  path TEXT,
  score_value double precision,
  time timestamptz,
  start timestamptz,
  end timestamptz
 );





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSqlTypeDeclaration()
DROP TYPE IF EXISTS plead_approving_type CASCADE;
CREATE TYPE plead_approving_type AS  (
  approved_pipeline TEXT,
  approval_record INT,
  pipeline TEXT,
  score INT,
  organization INT,
  manager INT,
  approving INT,
  signature TEXT,
  path TEXT,
  time timestamptz,
  start timestamptz,
  end timestamptz
 );





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSqlTypeDeclaration()
DROP TYPE IF EXISTS plead_splitting_type CASCADE;
CREATE TYPE plead_splitting_type AS  (
  split_file1 TEXT,
  split_file2 TEXT,
  file TEXT,
  organization INT,
  engineer INT,
  splitting INT,
  n_rows1 INT,
  n_cols1 INT,
  path1 TEXT,
  n_rows2 INT,
  n_cols2 INT,
  path2 TEXT,
  time timestamptz,
  start timestamptz,
  end timestamptz
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQL()

CREATE TABLE IF NOT EXISTS plead_transforming
(
  ID SERIAL,
    --  The file resulting from transformation
  transformed_file TEXT,
    --  The file before transformation
  file TEXT,
    --  An organization aiming managing the ML pipeline
  organization INT,
    --  The engineer developing the ML pipeline
  engineer INT,
    --  The activity of transforming the file
  transforming INT,
    --  The number of rows in the file
  n_rows INT,
    --  The number of columns in the file
  n_cols INT,
    --  The actual path of the file
  path TEXT,
    --  Time when the transformed file is created
  time timestamptz,
    --  Time when the transformation starts
  start timestamptz,
    --  Time when the transformation ends
  end timestamptz
);





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQL()

CREATE TABLE IF NOT EXISTS plead_filtering
(
  ID SERIAL,
    --  The file resulting from the filtering
  filtered_file TEXT,
    --  The file before filtering
  file TEXT,
    --  The the method to filter the file
  method TEXT,
    --  An organization aiming managing the ML pipeline
  organization INT,
    --  The engineer developing the ML pipeline
  engineer INT,
    --  The activity of filtering the file
  filtering INT,
    --  The number of rows in the file
  n_rows INT,
    --  The number of columns in the file
  n_cols INT,
    --  The actual path of the file
  path TEXT,
    --  Time when the filtered file is created
  time timestamptz,
    --  Time when the transformation starts
  start timestamptz,
    --  Time when the transformation ends
  end timestamptz
);





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQL()

CREATE TABLE IF NOT EXISTS plead_training
(
  ID SERIAL,
    --  The pipeline resulting from the training
  pipeline TEXT,
    --  The dataset used int he training
  training_dataset TEXT,
    --  An organization aiming managing the ML pipeline
  organization INT,
    --  The engineer developing the ML pipeline
  engineer INT,
    --  The activity of transforming the file
  training INT,
    --  The actual path of the file
  path TEXT,
    --  Time when the pipeline is created
  time timestamptz,
    --  Time when the transformation starts
  start timestamptz,
    --  Time when the transformation ends
  end timestamptz
);





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQL()

CREATE TABLE IF NOT EXISTS plead_validating
(
  ID SERIAL,
    --  The result of the validation
  score INT,
    --  The dataset used in the validation
  testing_dataset TEXT,
    --  An organization aiming managing the ML pipeline
  organization INT,
    --  The engineer developing the ML pipeline
  engineer INT,
    --  The activity of validating with the test dataset
  validating INT,
    --  The actual path of the file
  path TEXT,
    --  The validation score
  score_value double precision,
    --  Time when the pipeline is created
  time timestamptz,
    --  Time when the transformation starts
  start timestamptz,
    --  Time when the transformation ends
  end timestamptz
);





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQL()

CREATE TABLE IF NOT EXISTS plead_approving
(
  ID SERIAL,
    --  The approved pipeline
  approved_pipeline TEXT,
    --  The approval record
  approval_record INT,
    --  The pipeline before approval
  pipeline TEXT,
    --  The score obtained through validation
  score INT,
    --  An organization aiming managing the ML pipeline
  organization INT,
    --  The manager approving the ML pipeline
  manager INT,
    --  The activity of approving the pipeline
  approving INT,
    --  The approval's signature
  signature TEXT,
    --  The actual path of the file
  path TEXT,
    --  Time when the filtered file is created
  time timestamptz,
    --  Time when the transformation starts
  start timestamptz,
    --  Time when the transformation ends
  end timestamptz
);





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQL()

CREATE TABLE IF NOT EXISTS plead_splitting
(
  ID SERIAL,
    --  The first file resulting from the split
  split_file1 TEXT,
    --  The second file resulting from the split
  split_file2 TEXT,
    --  The file before transformation
  file TEXT,
    --  An organization aiming managing the ML pipeline
  organization INT,
    --  The engineer developing the ML pipeline
  engineer INT,
    --  The activity of transforming the file
  splitting INT,
    --  The number of rows in the file
  n_rows1 INT,
    --  The number of columns in the file
  n_cols1 INT,
    --  The actual path of the file
  path1 TEXT,
    --  The number of rows in the file
  n_rows2 INT,
    --  The number of columns in the file
  n_cols2 INT,
    --  The actual path of the file
  path2 TEXT,
    --  Time when the transformed file is created
  time timestamptz,
    --  Time when the transformation starts
  start timestamptz,
    --  Time when the transformation ends
  end timestamptz
);







-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertFunctionWithSharing

CREATE OR REPLACE FUNCTION insert_plead_transforming(input_file TEXT, 
                                                     input_organization INT, 
                                                     input_engineer INT, 
                                                     input_n_rows INT, 
                                                     input_n_cols INT, 
                                                     input_path TEXT, 
                                                     input_time timestamptz, 
                                                     input_start timestamptz, 
                                                     input_end timestamptz)
 RETURNS table(ID INT, transformed_file TEXT, transforming INT)
 AS $$
  WITH
        _new_transformed_file_with_id AS (INSERT INTO file DEFAULT VALUES 
                                          RETURNING file.ID AS file_id), 
        _new_transforming_with_id AS (INSERT INTO activity DEFAULT VALUES 
                                      RETURNING activity.ID AS activity_id)
  INSERT INTO plead_transforming(transformed_file, file, organization, engineer, transforming, n_rows, n_cols, path, time, start, end)
  VALUES ((SELECT file_id FROM _new_transformed_file_with_id), 
          input_file, 
          input_organization, 
          input_engineer, 
          (SELECT activity_id FROM _new_transforming_with_id), 
          input_n_rows, 
          input_n_cols, 
          input_path, 
          input_time, 
          input_start, 
          input_end)
  RETURNING plead_transforming.ID, plead_transforming.transformed_file, plead_transforming.transforming
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertFunctionWithSharing

CREATE OR REPLACE FUNCTION insert_plead_filtering(input_file TEXT, 
                                                  input_method TEXT, 
                                                  input_organization INT, 
                                                  input_engineer INT, 
                                                  input_n_rows INT, 
                                                  input_n_cols INT, 
                                                  input_path TEXT, 
                                                  input_time timestamptz, 
                                                  input_start timestamptz, 
                                                  input_end timestamptz)
 RETURNS table(ID INT, filtered_file TEXT, filtering INT)
 AS $$
  WITH
        _new_filtered_file_with_id AS (INSERT INTO file DEFAULT VALUES 
                                       RETURNING file.ID AS file_id), 
        _new_filtering_with_id AS (INSERT INTO activity DEFAULT VALUES 
                                   RETURNING activity.ID AS activity_id)
  INSERT INTO plead_filtering(filtered_file, file, method, organization, engineer, filtering, n_rows, n_cols, path, time, start, end)
  VALUES ((SELECT file_id FROM _new_filtered_file_with_id), 
          input_file, 
          input_method, 
          input_organization, 
          input_engineer, 
          (SELECT activity_id FROM _new_filtering_with_id), 
          input_n_rows, 
          input_n_cols, 
          input_path, 
          input_time, 
          input_start, 
          input_end)
  RETURNING plead_filtering.ID, plead_filtering.filtered_file, plead_filtering.filtering
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertFunctionWithSharing

CREATE OR REPLACE FUNCTION insert_plead_training(input_training_dataset TEXT, 
                                                 input_organization INT, 
                                                 input_engineer INT, 
                                                 input_path TEXT, 
                                                 input_time timestamptz, 
                                                 input_start timestamptz, 
                                                 input_end timestamptz)
 RETURNS table(ID INT, pipeline TEXT, training INT)
 AS $$
  WITH
        _new_pipeline_with_id AS (INSERT INTO file DEFAULT VALUES 
                                  RETURNING file.ID AS file_id), 
        _new_training_with_id AS (INSERT INTO activity DEFAULT VALUES 
                                  RETURNING activity.ID AS activity_id)
  INSERT INTO plead_training(pipeline, training_dataset, organization, engineer, training, path, time, start, end)
  VALUES ((SELECT file_id FROM _new_pipeline_with_id), 
          input_training_dataset, 
          input_organization, 
          input_engineer, 
          (SELECT activity_id FROM _new_training_with_id), 
          input_path, 
          input_time, 
          input_start, 
          input_end)
  RETURNING plead_training.ID, plead_training.pipeline, plead_training.training
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertFunctionWithSharing

CREATE OR REPLACE FUNCTION insert_plead_validating(input_testing_dataset TEXT, 
                                                   input_organization INT, 
                                                   input_engineer INT, 
                                                   input_path TEXT, 
                                                   input_score_value double precision, 
                                                   input_time timestamptz, 
                                                   input_start timestamptz, 
                                                   input_end timestamptz)
 RETURNS table(ID INT, score INT, validating INT)
 AS $$
  WITH
        _new_score_with_id AS (INSERT INTO score DEFAULT VALUES 
                               RETURNING score.ID AS score_id), 
        _new_validating_with_id AS (INSERT INTO activity DEFAULT VALUES 
                                    RETURNING activity.ID AS activity_id)
  INSERT INTO plead_validating(score, testing_dataset, organization, engineer, validating, path, score_value, time, start, end)
  VALUES ((SELECT score_id FROM _new_score_with_id), 
          input_testing_dataset, 
          input_organization, 
          input_engineer, 
          (SELECT activity_id FROM _new_validating_with_id), 
          input_path, 
          input_score_value, 
          input_time, 
          input_start, 
          input_end)
  RETURNING plead_validating.ID, plead_validating.score, plead_validating.validating
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertFunctionWithSharing

CREATE OR REPLACE FUNCTION insert_plead_approving(input_pipeline TEXT, 
                                                  input_score INT, 
                                                  input_organization INT, 
                                                  input_manager INT, 
                                                  input_signature TEXT, 
                                                  input_path TEXT, 
                                                  input_time timestamptz, 
                                                  input_start timestamptz, 
                                                  input_end timestamptz)
 RETURNS table(ID INT, approved_pipeline TEXT, approval_record INT, approving INT)
 AS $$
  WITH
        _new_approved_pipeline_with_id AS (INSERT INTO file DEFAULT VALUES 
                                           RETURNING file.ID AS file_id), 
        _new_approval_record_with_id AS (INSERT INTO approval_record DEFAULT VALUES 
                                         RETURNING approval_record.ID AS approval_record_id), 
        _new_approving_with_id AS (INSERT INTO activity DEFAULT VALUES 
                                   RETURNING activity.ID AS activity_id)
  INSERT INTO plead_approving(approved_pipeline, approval_record, pipeline, score, organization, manager, approving, signature, path, time, start, end)
  VALUES ((SELECT file_id FROM _new_approved_pipeline_with_id), 
          (SELECT approval_record_id FROM _new_approval_record_with_id), 
          input_pipeline, 
          input_score, 
          input_organization, 
          input_manager, 
          (SELECT activity_id FROM _new_approving_with_id), 
          input_signature, 
          input_path, 
          input_time, 
          input_start, 
          input_end)
  RETURNING plead_approving.ID, plead_approving.approved_pipeline, plead_approving.approval_record, plead_approving.approving
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertFunctionWithSharing

CREATE OR REPLACE FUNCTION insert_plead_splitting(input_file TEXT, 
                                                  input_organization INT, 
                                                  input_engineer INT, 
                                                  input_n_rows1 INT, 
                                                  input_n_cols1 INT, 
                                                  input_path1 TEXT, 
                                                  input_n_rows2 INT, 
                                                  input_n_cols2 INT, 
                                                  input_path2 TEXT, 
                                                  input_time timestamptz, 
                                                  input_start timestamptz, 
                                                  input_end timestamptz)
 RETURNS table(ID INT, split_file1 TEXT, split_file2 TEXT, splitting INT)
 AS $$
  WITH
        _new_split_file1_with_id AS (INSERT INTO file DEFAULT VALUES 
                                     RETURNING file.ID AS file_id), 
        _new_split_file2_with_id AS (INSERT INTO file DEFAULT VALUES 
                                     RETURNING file.ID AS file_id), 
        _new_splitting_with_id AS (INSERT INTO activity DEFAULT VALUES 
                                   RETURNING activity.ID AS activity_id)
  INSERT INTO plead_splitting(split_file1, 
                              split_file2, 
                              file, 
                              organization, 
                              engineer, 
                              splitting, 
                              n_rows1, 
                              n_cols1, 
                              path1, 
                              n_rows2, 
                              n_cols2, 
                              path2, 
                              time, 
                              start, 
                              end)
  VALUES ((SELECT file_id FROM _new_split_file1_with_id), 
          (SELECT file_id FROM _new_split_file2_with_id), 
          input_file, 
          input_organization, 
          input_engineer, 
          (SELECT activity_id FROM _new_splitting_with_id), 
          input_n_rows1, 
          input_n_cols1, 
          input_path1, 
          input_n_rows2, 
          input_n_cols2, 
          input_path2, 
          input_time, 
          input_start, 
          input_end)
  RETURNING plead_splitting.ID, plead_splitting.split_file1, plead_splitting.split_file2, plead_splitting.splitting
 $$ language SQL;




