-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS file (
  id SERIAL,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS agent (
  id SERIAL,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS score (
  id SERIAL,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS approval_record (
  id SERIAL,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS activity (
  id SERIAL,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS method (
  id SERIAL,
  serial INT,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSqlTypeDeclaration()
DROP TYPE IF EXISTS plead_transforming_type CASCADE;
CREATE TYPE plead_transforming_type AS  (
  transformed_file INT,
  filename TEXT,
  file INT,
  method INT,
  organization INT,
  engineer INT,
  transforming INT,
  n_rows INT,
  n_cols INT,
  path TEXT,
  time timestamptz,
  _start timestamptz,
  _end timestamptz
 );





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSqlTypeDeclaration()
DROP TYPE IF EXISTS plead_filtering_type CASCADE;
CREATE TYPE plead_filtering_type AS  (
  filtered_file INT,
  filename TEXT,
  file INT,
  method INT,
  organization INT,
  engineer INT,
  filtering INT,
  n_rows INT,
  n_cols INT,
  path TEXT,
  time timestamptz,
  _start timestamptz,
  _end timestamptz
 );





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSqlTypeDeclaration()
DROP TYPE IF EXISTS plead_training_type CASCADE;
CREATE TYPE plead_training_type AS  (
  pipeline INT,
  filename TEXT,
  training_dataset INT,
  organization INT,
  engineer INT,
  training INT,
  path TEXT,
  time timestamptz,
  _start timestamptz,
  _end timestamptz
 );





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSqlTypeDeclaration()
DROP TYPE IF EXISTS plead_validating_type CASCADE;
CREATE TYPE plead_validating_type AS  (
  score INT,
  testing_dataset INT,
  organization INT,
  engineer INT,
  validating INT,
  path TEXT,
  score_value double precision,
  time timestamptz,
  _start timestamptz,
  _end timestamptz
 );





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSqlTypeDeclaration()
DROP TYPE IF EXISTS plead_approving_type CASCADE;
CREATE TYPE plead_approving_type AS  (
  approved_pipeline INT,
  filename TEXT,
  pipeline INT,
  approval_record INT,
  score INT,
  organization INT,
  manager INT,
  approving INT,
  signature TEXT,
  path TEXT,
  time timestamptz,
  _start timestamptz,
  _end timestamptz
 );





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSqlTypeDeclaration()
DROP TYPE IF EXISTS plead_splitting_type CASCADE;
CREATE TYPE plead_splitting_type AS  (
  split_file1 INT,
  filename1 TEXT,
  split_file2 INT,
  filename2 TEXT,
  file INT,
  organization INT,
  engineer INT,
  splitting INT,
  n_rows1 INT,
  n_cols1 INT,
  path1 TEXT,
  n_rows2 INT,
  n_cols2 INT,
  path2 TEXT,
  time timestamptz,
  _start timestamptz,
  _end timestamptz
 );





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSqlTypeDeclaration()
DROP TYPE IF EXISTS plead_transforming_composite_type CASCADE;
CREATE TYPE plead_transforming_composite_type AS  (
  bean TEXT,
  count INT,
  type TEXT
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQL()

CREATE TABLE IF NOT EXISTS plead_transforming
(
  ID SERIAL,
    --  The file resulting from transformation
  transformed_file INT,
    --  The name of the transformed file
  filename TEXT,
    --  The file before transformation
  file INT,
    --  The method to transform the file
  method INT,
    --  An organization aiming managing the ML pipeline
  organization INT,
    --  The engineer developing the ML pipeline
  engineer INT,
    --  The activity of transforming the file
  transforming INT,
    --  The number of rows in the file
  n_rows INT,
    --  The number of columns in the file
  n_cols INT,
    --  The actual path of the file
  path TEXT,
    --  Time when the transformed file is created
  time timestamptz,
    --  Time when the transformation starts
  _start timestamptz,
    --  Time when the transformation ends
  _end timestamptz
);





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQL()

CREATE TABLE IF NOT EXISTS plead_filtering
(
  ID SERIAL,
    --  The file resulting from filtering
  filtered_file INT,
    --  The file name resulting from the filtering
  filename TEXT,
    --  The file before filtering
  file INT,
    --  The method to filter the file
  method INT,
    --  An organization aiming managing the ML pipeline
  organization INT,
    --  The engineer developing the ML pipeline
  engineer INT,
    --  The activity of filtering the file
  filtering INT,
    --  The number of rows in the file
  n_rows INT,
    --  The number of columns in the file
  n_cols INT,
    --  The actual path of the file
  path TEXT,
    --  Time when the filtered file is created
  time timestamptz,
    --  Time when the transformation starts
  _start timestamptz,
    --  Time when the transformation ends
  _end timestamptz
);





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQL()

CREATE TABLE IF NOT EXISTS plead_training
(
  ID SERIAL,
    --  The pipeline resulting from the training
  pipeline INT,
    --  The pipeline filename resulting from the training
  filename TEXT,
    --  The dataset used in the training
  training_dataset INT,
    --  An organization aiming managing the ML pipeline
  organization INT,
    --  The engineer developing the ML pipeline
  engineer INT,
    --  The activity of transforming the file
  training INT,
    --  The actual path of the file
  path TEXT,
    --  Time when the pipeline is created
  time timestamptz,
    --  Time when the transformation starts
  _start timestamptz,
    --  Time when the transformation ends
  _end timestamptz
);





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQL()

CREATE TABLE IF NOT EXISTS plead_validating
(
  ID SERIAL,
    --  The result of the validation
  score INT,
    --  The dataset used in the validation
  testing_dataset INT,
    --  An organization aiming managing the ML pipeline
  organization INT,
    --  The engineer developing the ML pipeline
  engineer INT,
    --  The activity of validating with the test dataset
  validating INT,
    --  The actual path of the file
  path TEXT,
    --  The validation score
  score_value double precision,
    --  Time when the pipeline is created
  time timestamptz,
    --  Time when the transformation starts
  _start timestamptz,
    --  Time when the transformation ends
  _end timestamptz
);





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQL()

CREATE TABLE IF NOT EXISTS plead_approving
(
  ID SERIAL,
    --  The approved pipeline
  approved_pipeline INT,
    --  The filename of the approved pipeline
  filename TEXT,
    --  The pipeline before approval
  pipeline INT,
    --  The approval record
  approval_record INT,
    --  The score obtained through validation
  score INT,
    --  An organization aiming managing the ML pipeline
  organization INT,
    --  The manager approving the ML pipeline
  manager INT,
    --  The activity of approving the pipeline
  approving INT,
    --  The approval's signature
  signature TEXT,
    --  The actual path of the file
  path TEXT,
    --  Time when the filtered file is created
  time timestamptz,
    --  Time when the transformation starts
  _start timestamptz,
    --  Time when the transformation ends
  _end timestamptz
);





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQL()

CREATE TABLE IF NOT EXISTS plead_splitting
(
  ID SERIAL,
    --  The first file resulting from the split
  split_file1 INT,
    --  The first filename resulting from the split
  filename1 TEXT,
    --  The second file resulting from the split
  split_file2 INT,
    --  The second filename resulting from the split
  filename2 TEXT,
    --  The file before splitting
  file INT,
    --  An organization aiming managing the ML pipeline
  organization INT,
    --  The engineer developing the ML pipeline
  engineer INT,
    --  The activity of transforming the file
  splitting INT,
    --  The number of rows in the file
  n_rows1 INT,
    --  The number of columns in the file
  n_cols1 INT,
    --  The actual path of the file
  path1 TEXT,
    --  The number of rows in the file
  n_rows2 INT,
    --  The number of columns in the file
  n_cols2 INT,
    --  The actual path of the file
  path2 TEXT,
    --  Time when the transformed file is created
  time timestamptz,
    --  Time when the transformation starts
  _start timestamptz,
    --  Time when the transformation ends
  _end timestamptz
);





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQL()

CREATE TABLE IF NOT EXISTS plead_transforming_composite
(
  ID SERIAL,
    --  The bean identifier (not used for now)
  bean TEXT,
    --  The number of records being composed (calculated automatically)
  count INT,
    --  The type of bean being composed
  type TEXT
);







-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertFunctionWithSharing

CREATE OR REPLACE FUNCTION insert_plead_transforming(input_filename TEXT, 
                                                     input_file INT, 
                                                     input_method INT, 
                                                     input_organization INT, 
                                                     input_engineer INT, 
                                                     input_n_rows INT, 
                                                     input_n_cols INT, 
                                                     input_path TEXT, 
                                                     input_time timestamptz, 
                                                     input__start timestamptz, 
                                                     input__end timestamptz)
 RETURNS table(ID INT, transformed_file INT, transforming INT)
 AS $$
  WITH
        _new_transformed_file_with_id AS (INSERT INTO file DEFAULT VALUES 
                                          RETURNING file.ID AS file_id), 
        _new_transforming_with_id AS (INSERT INTO activity DEFAULT VALUES 
                                      RETURNING activity.ID AS activity_id)
  INSERT INTO plead_transforming(transformed_file, filename, file, method, organization, engineer, transforming, n_rows, n_cols, path, time, _start, _end)
  VALUES ((SELECT file_id FROM _new_transformed_file_with_id), 
          input_filename, 
          input_file, 
          input_method, 
          input_organization, 
          input_engineer, 
          (SELECT activity_id FROM _new_transforming_with_id), 
          input_n_rows, 
          input_n_cols, 
          input_path, 
          input_time, 
          input__start, 
          input__end)
  RETURNING plead_transforming.ID, plead_transforming.transformed_file, plead_transforming.transforming
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertFunctionWithSharing

CREATE OR REPLACE FUNCTION insert_plead_filtering(input_filename TEXT, 
                                                  input_file INT, 
                                                  input_method INT, 
                                                  input_organization INT, 
                                                  input_engineer INT, 
                                                  input_n_rows INT, 
                                                  input_n_cols INT, 
                                                  input_path TEXT, 
                                                  input_time timestamptz, 
                                                  input__start timestamptz, 
                                                  input__end timestamptz)
 RETURNS table(ID INT, filtered_file INT, filtering INT)
 AS $$
  WITH
        _new_filtered_file_with_id AS (INSERT INTO file DEFAULT VALUES 
                                       RETURNING file.ID AS file_id), 
        _new_filtering_with_id AS (INSERT INTO activity DEFAULT VALUES 
                                   RETURNING activity.ID AS activity_id)
  INSERT INTO plead_filtering(filtered_file, filename, file, method, organization, engineer, filtering, n_rows, n_cols, path, time, _start, _end)
  VALUES ((SELECT file_id FROM _new_filtered_file_with_id), 
          input_filename, 
          input_file, 
          input_method, 
          input_organization, 
          input_engineer, 
          (SELECT activity_id FROM _new_filtering_with_id), 
          input_n_rows, 
          input_n_cols, 
          input_path, 
          input_time, 
          input__start, 
          input__end)
  RETURNING plead_filtering.ID, plead_filtering.filtered_file, plead_filtering.filtering
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertFunctionWithSharing

CREATE OR REPLACE FUNCTION insert_plead_training(input_filename TEXT, 
                                                 input_training_dataset INT, 
                                                 input_organization INT, 
                                                 input_engineer INT, 
                                                 input_path TEXT, 
                                                 input_time timestamptz, 
                                                 input__start timestamptz, 
                                                 input__end timestamptz)
 RETURNS table(ID INT, pipeline INT, training INT)
 AS $$
  WITH
        _new_pipeline_with_id AS (INSERT INTO file DEFAULT VALUES 
                                  RETURNING file.ID AS file_id), 
        _new_training_with_id AS (INSERT INTO activity DEFAULT VALUES 
                                  RETURNING activity.ID AS activity_id)
  INSERT INTO plead_training(pipeline, filename, training_dataset, organization, engineer, training, path, time, _start, _end)
  VALUES ((SELECT file_id FROM _new_pipeline_with_id), 
          input_filename, 
          input_training_dataset, 
          input_organization, 
          input_engineer, 
          (SELECT activity_id FROM _new_training_with_id), 
          input_path, 
          input_time, 
          input__start, 
          input__end)
  RETURNING plead_training.ID, plead_training.pipeline, plead_training.training
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertFunctionWithSharing

CREATE OR REPLACE FUNCTION insert_plead_validating(input_testing_dataset INT, 
                                                   input_organization INT, 
                                                   input_engineer INT, 
                                                   input_path TEXT, 
                                                   input_score_value double precision, 
                                                   input_time timestamptz, 
                                                   input__start timestamptz, 
                                                   input__end timestamptz)
 RETURNS table(ID INT, score INT, validating INT)
 AS $$
  WITH
        _new_score_with_id AS (INSERT INTO score DEFAULT VALUES 
                               RETURNING score.ID AS score_id), 
        _new_validating_with_id AS (INSERT INTO activity DEFAULT VALUES 
                                    RETURNING activity.ID AS activity_id)
  INSERT INTO plead_validating(score, testing_dataset, organization, engineer, validating, path, score_value, time, _start, _end)
  VALUES ((SELECT score_id FROM _new_score_with_id), 
          input_testing_dataset, 
          input_organization, 
          input_engineer, 
          (SELECT activity_id FROM _new_validating_with_id), 
          input_path, 
          input_score_value, 
          input_time, 
          input__start, 
          input__end)
  RETURNING plead_validating.ID, plead_validating.score, plead_validating.validating
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertFunctionWithSharing

CREATE OR REPLACE FUNCTION insert_plead_approving(input_filename TEXT, 
                                                  input_pipeline INT, 
                                                  input_score INT, 
                                                  input_organization INT, 
                                                  input_manager INT, 
                                                  input_signature TEXT, 
                                                  input_path TEXT, 
                                                  input_time timestamptz, 
                                                  input__start timestamptz, 
                                                  input__end timestamptz)
 RETURNS table(ID INT, approved_pipeline INT, approval_record INT, approving INT)
 AS $$
  WITH
        _new_approved_pipeline_with_id AS (INSERT INTO file DEFAULT VALUES 
                                           RETURNING file.ID AS file_id), 
        _new_approval_record_with_id AS (INSERT INTO approval_record DEFAULT VALUES 
                                         RETURNING approval_record.ID AS approval_record_id), 
        _new_approving_with_id AS (INSERT INTO activity DEFAULT VALUES 
                                   RETURNING activity.ID AS activity_id)
  INSERT INTO plead_approving(approved_pipeline, 
                              filename, 
                              pipeline, 
                              approval_record, 
                              score, 
                              organization, 
                              manager, 
                              approving, 
                              signature, 
                              path, 
                              time, 
                              _start, 
                              _end)
  VALUES ((SELECT file_id FROM _new_approved_pipeline_with_id), 
          input_filename, 
          input_pipeline, 
          (SELECT approval_record_id FROM _new_approval_record_with_id), 
          input_score, 
          input_organization, 
          input_manager, 
          (SELECT activity_id FROM _new_approving_with_id), 
          input_signature, 
          input_path, 
          input_time, 
          input__start, 
          input__end)
  RETURNING plead_approving.ID, plead_approving.approved_pipeline, plead_approving.approval_record, plead_approving.approving
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertFunctionWithSharing

CREATE OR REPLACE FUNCTION insert_plead_splitting(input_filename1 TEXT, 
                                                  input_filename2 TEXT, 
                                                  input_file INT, 
                                                  input_organization INT, 
                                                  input_engineer INT, 
                                                  input_n_rows1 INT, 
                                                  input_n_cols1 INT, 
                                                  input_path1 TEXT, 
                                                  input_n_rows2 INT, 
                                                  input_n_cols2 INT, 
                                                  input_path2 TEXT, 
                                                  input_time timestamptz, 
                                                  input__start timestamptz, 
                                                  input__end timestamptz)
 RETURNS table(ID INT, split_file1 INT, split_file2 INT, splitting INT)
 AS $$
  WITH
        _new_split_file1_with_id AS (INSERT INTO file DEFAULT VALUES 
                                     RETURNING file.ID AS file_id), 
        _new_split_file2_with_id AS (INSERT INTO file DEFAULT VALUES 
                                     RETURNING file.ID AS file_id), 
        _new_splitting_with_id AS (INSERT INTO activity DEFAULT VALUES 
                                   RETURNING activity.ID AS activity_id)
  INSERT INTO plead_splitting(split_file1, 
                              filename1, 
                              split_file2, 
                              filename2, 
                              file, 
                              organization, 
                              engineer, 
                              splitting, 
                              n_rows1, 
                              n_cols1, 
                              path1, 
                              n_rows2, 
                              n_cols2, 
                              path2, 
                              time, 
                              _start, 
                              _end)
  VALUES ((SELECT file_id FROM _new_split_file1_with_id), 
          input_filename1, 
          (SELECT file_id FROM _new_split_file2_with_id), 
          input_filename2, 
          input_file, 
          input_organization, 
          input_engineer, 
          (SELECT activity_id FROM _new_splitting_with_id), 
          input_n_rows1, 
          input_n_cols1, 
          input_path1, 
          input_n_rows2, 
          input_n_cols2, 
          input_path2, 
          input_time, 
          input__start, 
          input__end)
  RETURNING plead_splitting.ID, plead_splitting.split_file1, plead_splitting.split_file2, plead_splitting.splitting
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertFunctionWithSharing

CREATE OR REPLACE FUNCTION insert_plead_transforming_composite(composite_transformed_file INT, 
                                                               input_filename TEXT, 
                                                               input_file INT, 
                                                               input_method INT, 
                                                               input_organization INT, 
                                                               input_engineer INT, 
                                                               composite_transforming INT, 
                                                               input_n_rows INT, 
                                                               input_n_cols INT, 
                                                               input_path TEXT, 
                                                               input_time timestamptz, 
                                                               input__start timestamptz, 
                                                               input__end timestamptz)
 RETURNS table(ID INT, __dummy_ INT)
 AS $$
  INSERT INTO plead_transforming(transformed_file, filename, file, method, organization, engineer, transforming, n_rows, n_cols, path, time, _start, _end)
  VALUES (composite_transformed_file, 
          input_filename, 
          input_file, 
          input_method, 
          input_organization, 
          input_engineer, 
          composite_transforming, 
          input_n_rows, 
          input_n_cols, 
          input_path, 
          input_time, 
          input__start, 
          input__end)
  RETURNING plead_transforming.ID, 1 AS __dummy_
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLSearchRecordFunction

CREATE OR REPLACE FUNCTION search_records_for_activity(from_date timestamptz, to_date timestamptz)
 RETURNS table(ID INT, created_at timestamptz, table_name text, key INT)
 AS $$
  SELECT activity.id as ID, 
         created_at, 
         CASE  WHEN plead_validating.validating IS NOT NULL   THEN 'plead_validating'  WHEN plead_filtering.filtering IS NOT NULL   THEN 'plead_filtering'  WHEN plead_approving.approving IS NOT NULL   THEN 'plead_approving'  WHEN plead_splitting.splitting IS NOT NULL   THEN 'plead_splitting'  WHEN plead_transforming.transforming IS NOT NULL   THEN 'plead_transforming'  WHEN plead_training.training IS NOT NULL   THEN 'plead_training' END AS table_name, 
         COALESCE (plead_validating.id, plead_filtering.id, plead_approving.id, plead_splitting.id, plead_transforming.id, plead_training.id) as key
  FROM activity
   LEFT JOIN plead_validating ON activity.id = plead_validating.validating
   LEFT JOIN plead_filtering ON activity.id = plead_filtering.filtering
   LEFT JOIN plead_approving ON activity.id = plead_approving.approving
   LEFT JOIN plead_splitting ON activity.id = plead_splitting.splitting
   LEFT JOIN plead_transforming ON activity.id = plead_transforming.transforming
   LEFT JOIN plead_training ON activity.id = plead_training.training
    WHERE (from_date is null OR (created_at > from_date)) AND ((to_date is null) OR (created_at < to_date)) AND ((plead_validating.validating is not null)
                                                                                                                 OR (plead_filtering.filtering is not null)
                                                                                                                 OR (plead_approving.approving is not null)
                                                                                                                 OR (plead_splitting.splitting is not null)
                                                                                                                 OR (plead_transforming.transforming is not null)
                                                                                                                 OR (plead_training.training is not null))
   ORDER BY created_at DESC 
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLSearchRecordByIdFunction

CREATE OR REPLACE FUNCTION search_records_by_id_for_activity(input_id INT)
 RETURNS table(ID INT, created_at timestamptz, table_name text, property text, key INT)
 AS $$
  SELECT activity.id as ID, activity.created_at, 'plead_validating' AS table_name, 'validating' AS property, plead_validating.id as key
  FROM activity
   LEFT JOIN plead_validating
   ON activity.id = input_id AND activity.id = plead_validating.validating
    WHERE plead_validating.validating is not null
  
   UNION 
  SELECT activity.id as ID, activity.created_at, 'plead_filtering' AS table_name, 'filtering' AS property, plead_filtering.id as key 
  FROM activity
   LEFT JOIN plead_filtering
   ON activity.id = input_id AND activity.id = plead_filtering.filtering
    WHERE plead_filtering.filtering is not null
  
   UNION 
  SELECT activity.id as ID, activity.created_at, 'plead_approving' AS table_name, 'approving' AS property, plead_approving.id as key 
  FROM activity
   LEFT JOIN plead_approving
   ON activity.id = input_id AND activity.id = plead_approving.approving
    WHERE plead_approving.approving is not null
  
   UNION 
  SELECT activity.id as ID, activity.created_at, 'plead_splitting' AS table_name, 'splitting' AS property, plead_splitting.id as key 
  FROM activity
   LEFT JOIN plead_splitting
   ON activity.id = input_id AND activity.id = plead_splitting.splitting
    WHERE plead_splitting.splitting is not null
  
   UNION 
  SELECT activity.id as ID, activity.created_at, 'plead_transforming' AS table_name, 'transforming' AS property, plead_transforming.id as key 
  FROM activity
   LEFT JOIN plead_transforming
   ON activity.id = input_id AND activity.id = plead_transforming.transforming
    WHERE plead_transforming.transforming is not null
  
   UNION 
  SELECT activity.id as ID, activity.created_at, 'plead_training' AS table_name, 'training' AS property, plead_training.id as key 
  FROM activity
   LEFT JOIN plead_training
   ON activity.id = input_id AND activity.id = plead_training.training
    WHERE plead_training.training is not null
   ORDER BY created_at DESC 
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLSearchRecordFunction

CREATE OR REPLACE FUNCTION search_records_for_file(from_date timestamptz, to_date timestamptz)
 RETURNS table(ID INT, created_at timestamptz, table_name text, key INT)
 AS $$
  SELECT file.id as ID, 
         created_at, 
         CASE  WHEN plead_validating.testing_dataset IS NOT NULL   THEN 'plead_validating'  WHEN plead_filtering.filtered_file IS NOT NULL  OR plead_filtering.file IS NOT NULL   THEN 'plead_filtering'  WHEN plead_approving.approved_pipeline IS NOT NULL  OR plead_approving.pipeline IS NOT NULL   THEN 'plead_approving'  WHEN plead_splitting.split_file2 IS NOT NULL  OR plead_splitting.split_file1 IS NOT NULL  OR plead_splitting.file IS NOT NULL   THEN 'plead_splitting'  WHEN plead_transforming.transformed_file IS NOT NULL  OR plead_transforming.file IS NOT NULL   THEN 'plead_transforming'  WHEN plead_training.pipeline IS NOT NULL  OR plead_training.training_dataset IS NOT NULL   THEN 'plead_training' END AS table_name, 
         COALESCE (plead_validating.id, plead_filtering.id, plead_approving.id, plead_splitting.id, plead_transforming.id, plead_training.id) as key
  FROM file
   LEFT JOIN plead_validating ON file.id = plead_validating.testing_dataset
   LEFT JOIN plead_filtering ON file.id = plead_filtering.filtered_file OR file.id = plead_filtering.file
   LEFT JOIN plead_approving ON file.id = plead_approving.approved_pipeline OR file.id = plead_approving.pipeline
   LEFT JOIN plead_splitting ON file.id = plead_splitting.split_file2 OR file.id = plead_splitting.split_file1 OR file.id = plead_splitting.file
   LEFT JOIN plead_transforming ON file.id = plead_transforming.transformed_file OR file.id = plead_transforming.file
   LEFT JOIN plead_training ON file.id = plead_training.pipeline OR file.id = plead_training.training_dataset
    WHERE (from_date is null OR (created_at > from_date)) AND ((to_date is null) OR (created_at < to_date)) AND ((plead_validating.testing_dataset is not null)
                                                                                                                 OR (plead_filtering.filtered_file is not null)
                                                                                                                 OR (plead_filtering.file is not null)
                                                                                                                 OR (plead_approving.approved_pipeline is not null)
                                                                                                                 OR (plead_approving.pipeline is not null)
                                                                                                                 OR (plead_splitting.split_file2 is not null)
                                                                                                                 OR (plead_splitting.split_file1 is not null)
                                                                                                                 OR (plead_splitting.file is not null)
                                                                                                                 OR (plead_transforming.transformed_file is not null)
                                                                                                                 OR (plead_transforming.file is not null)
                                                                                                                 OR (plead_training.pipeline is not null)
                                                                                                                 OR (plead_training.training_dataset is not null))
   ORDER BY created_at DESC 
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLSearchRecordByIdFunction

CREATE OR REPLACE FUNCTION search_records_by_id_for_file(input_id INT)
 RETURNS table(ID INT, created_at timestamptz, table_name text, property text, key INT)
 AS $$
  SELECT file.id as ID, file.created_at, 'plead_validating' AS table_name, 'testing_dataset' AS property, plead_validating.id as key
  FROM file
   LEFT JOIN plead_validating
   ON file.id = input_id AND file.id = plead_validating.testing_dataset
    WHERE plead_validating.testing_dataset is not null
  
   UNION 
  SELECT file.id as ID, file.created_at, 'plead_filtering' AS table_name, 'filtered_file' AS property, plead_filtering.id as key 
  FROM file
   LEFT JOIN plead_filtering
   ON file.id = input_id AND file.id = plead_filtering.filtered_file
    WHERE plead_filtering.filtered_file is not null
  
   UNION 
  SELECT file.id as ID, file.created_at, 'plead_filtering' AS table_name, 'file' AS property, plead_filtering.id as key 
  FROM file
   LEFT JOIN plead_filtering
   ON file.id = input_id AND file.id = plead_filtering.file
    WHERE plead_filtering.file is not null
  
   UNION 
  SELECT file.id as ID, file.created_at, 'plead_approving' AS table_name, 'approved_pipeline' AS property, plead_approving.id as key 
  FROM file
   LEFT JOIN plead_approving
   ON file.id = input_id AND file.id = plead_approving.approved_pipeline
    WHERE plead_approving.approved_pipeline is not null
  
   UNION 
  SELECT file.id as ID, file.created_at, 'plead_approving' AS table_name, 'pipeline' AS property, plead_approving.id as key 
  FROM file
   LEFT JOIN plead_approving
   ON file.id = input_id AND file.id = plead_approving.pipeline
    WHERE plead_approving.pipeline is not null
  
   UNION 
  SELECT file.id as ID, file.created_at, 'plead_splitting' AS table_name, 'split_file2' AS property, plead_splitting.id as key 
  FROM file
   LEFT JOIN plead_splitting
   ON file.id = input_id AND file.id = plead_splitting.split_file2
    WHERE plead_splitting.split_file2 is not null
  
   UNION 
  SELECT file.id as ID, file.created_at, 'plead_splitting' AS table_name, 'split_file1' AS property, plead_splitting.id as key 
  FROM file
   LEFT JOIN plead_splitting
   ON file.id = input_id AND file.id = plead_splitting.split_file1
    WHERE plead_splitting.split_file1 is not null
  
   UNION 
  SELECT file.id as ID, file.created_at, 'plead_splitting' AS table_name, 'file' AS property, plead_splitting.id as key 
  FROM file
   LEFT JOIN plead_splitting
   ON file.id = input_id AND file.id = plead_splitting.file
    WHERE plead_splitting.file is not null
  
   UNION 
  SELECT file.id as ID, file.created_at, 'plead_transforming' AS table_name, 'transformed_file' AS property, plead_transforming.id as key 
  FROM file
   LEFT JOIN plead_transforming
   ON file.id = input_id AND file.id = plead_transforming.transformed_file
    WHERE plead_transforming.transformed_file is not null
  
   UNION 
  SELECT file.id as ID, file.created_at, 'plead_transforming' AS table_name, 'file' AS property, plead_transforming.id as key 
  FROM file
   LEFT JOIN plead_transforming
   ON file.id = input_id AND file.id = plead_transforming.file
    WHERE plead_transforming.file is not null
  
   UNION 
  SELECT file.id as ID, file.created_at, 'plead_training' AS table_name, 'pipeline' AS property, plead_training.id as key 
  FROM file
   LEFT JOIN plead_training
   ON file.id = input_id AND file.id = plead_training.pipeline
    WHERE plead_training.pipeline is not null
  
   UNION 
  SELECT file.id as ID, file.created_at, 'plead_training' AS table_name, 'training_dataset' AS property, plead_training.id as key 
  FROM file
   LEFT JOIN plead_training
   ON file.id = input_id AND file.id = plead_training.training_dataset
    WHERE plead_training.training_dataset is not null
   ORDER BY created_at DESC 
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLSearchRecordFunction

CREATE OR REPLACE FUNCTION search_records_for_agent(from_date timestamptz, to_date timestamptz)
 RETURNS table(ID INT, created_at timestamptz, table_name text, key INT)
 AS $$
  SELECT agent.id as ID, 
         created_at, 
         CASE  WHEN plead_validating.organization IS NOT NULL  OR plead_validating.engineer IS NOT NULL   THEN 'plead_validating'  WHEN plead_filtering.organization IS NOT NULL  OR plead_filtering.engineer IS NOT NULL   THEN 'plead_filtering'  WHEN plead_approving.manager IS NOT NULL  OR plead_approving.organization IS NOT NULL   THEN 'plead_approving'  WHEN plead_splitting.organization IS NOT NULL  OR plead_splitting.engineer IS NOT NULL   THEN 'plead_splitting'  WHEN plead_transforming.organization IS NOT NULL  OR plead_transforming.engineer IS NOT NULL   THEN 'plead_transforming'  WHEN plead_training.organization IS NOT NULL  OR plead_training.engineer IS NOT NULL   THEN 'plead_training' END AS table_name, 
         COALESCE (plead_validating.id, plead_filtering.id, plead_approving.id, plead_splitting.id, plead_transforming.id, plead_training.id) as key
  FROM agent
   LEFT JOIN plead_validating ON agent.id = plead_validating.organization OR agent.id = plead_validating.engineer
   LEFT JOIN plead_filtering ON agent.id = plead_filtering.organization OR agent.id = plead_filtering.engineer
   LEFT JOIN plead_approving ON agent.id = plead_approving.manager OR agent.id = plead_approving.organization
   LEFT JOIN plead_splitting ON agent.id = plead_splitting.organization OR agent.id = plead_splitting.engineer
   LEFT JOIN plead_transforming ON agent.id = plead_transforming.organization OR agent.id = plead_transforming.engineer
   LEFT JOIN plead_training ON agent.id = plead_training.organization OR agent.id = plead_training.engineer
    WHERE (from_date is null OR (created_at > from_date)) AND ((to_date is null) OR (created_at < to_date)) AND ((plead_validating.organization is not null)
                                                                                                                 OR (plead_validating.engineer is not null)
                                                                                                                 OR (plead_filtering.organization is not null)
                                                                                                                 OR (plead_filtering.engineer is not null)
                                                                                                                 OR (plead_approving.manager is not null)
                                                                                                                 OR (plead_approving.organization is not null)
                                                                                                                 OR (plead_splitting.organization is not null)
                                                                                                                 OR (plead_splitting.engineer is not null)
                                                                                                                 OR (plead_transforming.organization is not null)
                                                                                                                 OR (plead_transforming.engineer is not null)
                                                                                                                 OR (plead_training.organization is not null)
                                                                                                                 OR (plead_training.engineer is not null))
   ORDER BY created_at DESC 
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLSearchRecordByIdFunction

CREATE OR REPLACE FUNCTION search_records_by_id_for_agent(input_id INT)
 RETURNS table(ID INT, created_at timestamptz, table_name text, property text, key INT)
 AS $$
  SELECT agent.id as ID, agent.created_at, 'plead_validating' AS table_name, 'organization' AS property, plead_validating.id as key
  FROM agent
   LEFT JOIN plead_validating
   ON agent.id = input_id AND agent.id = plead_validating.organization
    WHERE plead_validating.organization is not null
  
   UNION 
  SELECT agent.id as ID, agent.created_at, 'plead_validating' AS table_name, 'engineer' AS property, plead_validating.id as key 
  FROM agent
   LEFT JOIN plead_validating
   ON agent.id = input_id AND agent.id = plead_validating.engineer
    WHERE plead_validating.engineer is not null
  
   UNION 
  SELECT agent.id as ID, agent.created_at, 'plead_filtering' AS table_name, 'organization' AS property, plead_filtering.id as key 
  FROM agent
   LEFT JOIN plead_filtering
   ON agent.id = input_id AND agent.id = plead_filtering.organization
    WHERE plead_filtering.organization is not null
  
   UNION 
  SELECT agent.id as ID, agent.created_at, 'plead_filtering' AS table_name, 'engineer' AS property, plead_filtering.id as key 
  FROM agent
   LEFT JOIN plead_filtering
   ON agent.id = input_id AND agent.id = plead_filtering.engineer
    WHERE plead_filtering.engineer is not null
  
   UNION 
  SELECT agent.id as ID, agent.created_at, 'plead_approving' AS table_name, 'manager' AS property, plead_approving.id as key 
  FROM agent
   LEFT JOIN plead_approving
   ON agent.id = input_id AND agent.id = plead_approving.manager
    WHERE plead_approving.manager is not null
  
   UNION 
  SELECT agent.id as ID, agent.created_at, 'plead_approving' AS table_name, 'organization' AS property, plead_approving.id as key 
  FROM agent
   LEFT JOIN plead_approving
   ON agent.id = input_id AND agent.id = plead_approving.organization
    WHERE plead_approving.organization is not null
  
   UNION 
  SELECT agent.id as ID, agent.created_at, 'plead_splitting' AS table_name, 'organization' AS property, plead_splitting.id as key 
  FROM agent
   LEFT JOIN plead_splitting
   ON agent.id = input_id AND agent.id = plead_splitting.organization
    WHERE plead_splitting.organization is not null
  
   UNION 
  SELECT agent.id as ID, agent.created_at, 'plead_splitting' AS table_name, 'engineer' AS property, plead_splitting.id as key 
  FROM agent
   LEFT JOIN plead_splitting
   ON agent.id = input_id AND agent.id = plead_splitting.engineer
    WHERE plead_splitting.engineer is not null
  
   UNION 
  SELECT agent.id as ID, agent.created_at, 'plead_transforming' AS table_name, 'organization' AS property, plead_transforming.id as key 
  FROM agent
   LEFT JOIN plead_transforming
   ON agent.id = input_id AND agent.id = plead_transforming.organization
    WHERE plead_transforming.organization is not null
  
   UNION 
  SELECT agent.id as ID, agent.created_at, 'plead_transforming' AS table_name, 'engineer' AS property, plead_transforming.id as key 
  FROM agent
   LEFT JOIN plead_transforming
   ON agent.id = input_id AND agent.id = plead_transforming.engineer
    WHERE plead_transforming.engineer is not null
  
   UNION 
  SELECT agent.id as ID, agent.created_at, 'plead_training' AS table_name, 'organization' AS property, plead_training.id as key 
  FROM agent
   LEFT JOIN plead_training
   ON agent.id = input_id AND agent.id = plead_training.organization
    WHERE plead_training.organization is not null
  
   UNION 
  SELECT agent.id as ID, agent.created_at, 'plead_training' AS table_name, 'engineer' AS property, plead_training.id as key 
  FROM agent
   LEFT JOIN plead_training
   ON agent.id = input_id AND agent.id = plead_training.engineer
    WHERE plead_training.engineer is not null
   ORDER BY created_at DESC 
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLSearchRecordFunction

CREATE OR REPLACE FUNCTION search_records_for_method(from_date timestamptz, to_date timestamptz)
 RETURNS table(ID INT, created_at timestamptz, table_name text, key INT)
 AS $$
  SELECT method.id as ID, 
         created_at, 
         CASE  WHEN plead_filtering.method IS NOT NULL   THEN 'plead_filtering'  WHEN plead_transforming.method IS NOT NULL   THEN 'plead_transforming' END AS table_name, 
         COALESCE (plead_filtering.id, plead_transforming.id) as key
  FROM method
   LEFT JOIN plead_filtering ON method.id = plead_filtering.method
   LEFT JOIN plead_transforming ON method.id = plead_transforming.method
    WHERE (from_date is null OR (created_at > from_date)) AND ((to_date is null) OR (created_at < to_date)) AND ((plead_filtering.method is not null)
                                                                                                                 OR (plead_transforming.method is not null))
   ORDER BY created_at DESC 
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLSearchRecordByIdFunction

CREATE OR REPLACE FUNCTION search_records_by_id_for_method(input_id INT)
 RETURNS table(ID INT, created_at timestamptz, table_name text, property text, key INT)
 AS $$
  SELECT method.id as ID, method.created_at, 'plead_filtering' AS table_name, 'method' AS property, plead_filtering.id as key
  FROM method
   LEFT JOIN plead_filtering
   ON method.id = input_id AND method.id = plead_filtering.method
    WHERE plead_filtering.method is not null
  
   UNION 
  SELECT method.id as ID, method.created_at, 'plead_transforming' AS table_name, 'method' AS property, plead_transforming.id as key 
  FROM method
   LEFT JOIN plead_transforming
   ON method.id = input_id AND method.id = plead_transforming.method
    WHERE plead_transforming.method is not null
   ORDER BY created_at DESC 
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLSearchRecordFunction

CREATE OR REPLACE FUNCTION search_records_for_score(from_date timestamptz, to_date timestamptz)
 RETURNS table(ID INT, created_at timestamptz, table_name text, key INT)
 AS $$
  SELECT score.id as ID, 
         created_at, 
         CASE  WHEN plead_validating.score IS NOT NULL   THEN 'plead_validating'  WHEN plead_approving.score IS NOT NULL   THEN 'plead_approving' END AS table_name, 
         COALESCE (plead_validating.id, plead_approving.id) as key
  FROM score
   LEFT JOIN plead_validating ON score.id = plead_validating.score
   LEFT JOIN plead_approving ON score.id = plead_approving.score
    WHERE (from_date is null OR (created_at > from_date)) AND ((to_date is null) OR (created_at < to_date)) AND ((plead_validating.score is not null)
                                                                                                                 OR (plead_approving.score is not null))
   ORDER BY created_at DESC 
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLSearchRecordByIdFunction

CREATE OR REPLACE FUNCTION search_records_by_id_for_score(input_id INT)
 RETURNS table(ID INT, created_at timestamptz, table_name text, property text, key INT)
 AS $$
  SELECT score.id as ID, score.created_at, 'plead_validating' AS table_name, 'score' AS property, plead_validating.id as key
  FROM score
   LEFT JOIN plead_validating
   ON score.id = input_id AND score.id = plead_validating.score
    WHERE plead_validating.score is not null
  
   UNION 
  SELECT score.id as ID, score.created_at, 'plead_approving' AS table_name, 'score' AS property, plead_approving.id as key 
  FROM score
   LEFT JOIN plead_approving
   ON score.id = input_id AND score.id = plead_approving.score
    WHERE plead_approving.score is not null
   ORDER BY created_at DESC 
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLSearchRecordFunction

CREATE OR REPLACE FUNCTION search_records_for_approval_record(from_date timestamptz, to_date timestamptz)
 RETURNS table(ID INT, created_at timestamptz, table_name text, key INT)
 AS $$
  SELECT approval_record.id as ID, 
         created_at, 
         CASE  WHEN plead_approving.approval_record IS NOT NULL   THEN 'plead_approving' END AS table_name, 
         COALESCE (plead_approving.id) as key
  FROM approval_record
   LEFT JOIN plead_approving ON approval_record.id = plead_approving.approval_record
    WHERE (from_date is null OR (created_at > from_date)) AND ((to_date is null) OR (created_at < to_date)) AND ((plead_approving.approval_record is not null))
   ORDER BY created_at DESC 
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLSearchRecordByIdFunction

CREATE OR REPLACE FUNCTION search_records_by_id_for_approval_record(input_id INT)
 RETURNS table(ID INT, created_at timestamptz, table_name text, property text, key INT)
 AS $$
  SELECT approval_record.id as ID, approval_record.created_at, 'plead_approving' AS table_name, 'approval_record' AS property, plead_approving.id as key
  FROM approval_record
   LEFT JOIN plead_approving
   ON approval_record.id = input_id AND approval_record.id = plead_approving.approval_record
    WHERE plead_approving.approval_record is not null
   ORDER BY created_at DESC 
 $$ language SQL;






-- 

--- PRELUDE_TO_AUTO_GENERATE

 CREATE OR REPLACE FUNCTION insert_into_activity (input_id BIGINT)
    returns table(id INT)
as $$
INSERT INTO activity (id)
SELECT input_id
RETURNING activity.id as id
$$ language SQL;


CREATE TABLE IF NOT EXISTS policy (
  id SERIAL,
  serial INT,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );


CREATE OR REPLACE FUNCTION insert_into_policy (input_id BIGINT, input_serial INT)
                    returns table(id INT) 
                as $$
                INSERT INTO policy (id, serial)
                SELECT input_id, input_serial
                RETURNING policy.id as id
                $$ language SQL;
				CREATE TABLE IF NOT EXISTS plead_transforming_composite_linker
(
  ID SERIAL,
    --  The file resulting from transformation
  composite INT,
  --  The file that was transformed
  simple INT,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
);


CREATE TABLE IF NOT EXISTS file
   (
  id SERIAL,
  serial INT,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );


CREATE OR REPLACE FUNCTION insert_into_file (input_id BIGINT)
    returns table(id INT)
as $$
INSERT INTO file (id)
SELECT input_id
RETURNING file.id as id
$$ language SQL;





-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertArrayFunction

CREATE OR REPLACE FUNCTION insert_plead_transforming_composite_array(_records plead_transforming_type [])
 RETURNS table(ID INT, 
               transformed_file INT, 
               transforming INT)
 AS $$
  WITH
        _input_table AS (SELECT * 
                         FROM unnest (_records)), 
        _transformed_file_tokens AS (SELECT _token, 
                                            id, 
                                            insert_into_file(id) as _newid 
                                     FROM (SELECT _token, 
                                                  cast(nextval('file_id_seq') as INT) as id 
                                           FROM (SELECT DISTINCT ON (transformed_file) transformed_file AS _token 
                                                 FROM _input_table) _transformed_file_tokens0) _transformed_file_tokens), 
        _transforming_tokens AS (SELECT _token, 
                                        id, 
                                        insert_into_activity(id) as _newid 
                                 FROM (SELECT _token, 
                                              cast(nextval('activity_id_seq') as INT) as id 
                                       FROM (SELECT DISTINCT ON (transforming) transforming AS _token 
                                             FROM _input_table) _transforming_tokens0) _transforming_tokens)
  SELECT (_arecord).ID, 
         _transformed_file_id, 
         _transforming_id
  FROM (SELECT _transformed_file_token_id_pairs.id AS _transformed_file_id, 
               _transforming_token_id_pairs.id AS _transforming_id, 
               insert_plead_transforming_composite(_transformed_file_token_id_pairs.id, 
                                                   filename, 
                                                   file, 
                                                   method, 
                                                   organization, 
                                                   engineer, 
                                                   _transforming_token_id_pairs.id, 
                                                   n_rows, 
                                                   n_cols, 
                                                   path, 
                                                   time, 
                                                   _start, 
                                                   _end)  AS _arecord  
        FROM _input_table
        JOIN (SELECT _transformed_file_tokens.id, 
                     _transformed_file_tokens._token 
              FROM _transformed_file_tokens) _transformed_file_token_id_pairs
         ON transformed_file = _transformed_file_token_id_pairs._token
        JOIN (SELECT _transforming_tokens.id, 
                     _transforming_tokens._token 
              FROM _transforming_tokens) _transforming_token_id_pairs
         ON transforming = _transforming_token_id_pairs._token) inserted_rows
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertCompositeAndLinkerFunction

CREATE OR REPLACE FUNCTION insert_plead_transforming_composite_and_linker(_records plead_transforming_type [])
 RETURNS table(ID INT, transformed_file INT, transforming INT, parent INT)
 AS $$
  WITH
        inserted_consistsOf AS (SELECT * FROM insert_plead_transforming_composite_array (_records)), 
        the_record AS (INSERT INTO plead_transforming_composite(bean, count, type)
                       VALUES (null, (SELECT count(ID) FROM inserted_consistsOf), 'plead_transforming')
                       RETURNING ID), 
        the_product AS (SELECT (SELECT ID AS composite FROM the_record), ID AS simple FROM inserted_consistsOf), 
        the_linker AS (INSERT INTO plead_transforming_composite_linker(composite,simple) SELECT *
                       FROM the_product)
  SELECT ID, transformed_file, transforming, (select ID AS parent from the_record)
  FROM inserted_consistsOf
 $$ language SQL;




