/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.library.ptm.sql.integration;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.template.library.ptm.client.integrator.BeanCompleter2;
import org.openprovenance.prov.template.library.ptm.client.integrator.BeanEnactor2;
import org.openprovenance.prov.template.library.ptm.sql.integration.SqlBeanCompleter3;

public class SqlEnactorImplementation3
implements BeanEnactor2.EnactorImplementation<ResultSet> {
    private final Function<String, ResultSet> querier;

    public SqlEnactorImplementation3(Function<String, ResultSet> querier) {
        this.querier = querier;
    }

    @Override
    public <IN, OUT> OUT generic_enact(OUT output, IN bean, Consumer<IN> check, BiConsumer<StringBuilder, IN> composeQuery, BiConsumer<ResultSet, OUT> completeBean) {
        check.accept(bean);
        StringBuilder sb = new StringBuilder();
        composeQuery.accept(sb, bean);
        String statement = sb.toString();
        try {
            ResultSet rs = this.querier.apply(statement);
            if (!rs.next()) {
                rs.close();
                throw new SQLException("Single row result was expected but result set is empty ");
            }
            completeBean.accept(rs, output);
            if (rs.next()) {
                rs.close();
                throw new SQLException("Single row result was expected for query ");
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new UncheckedException("Issue in enactment " + statement, (Exception)e);
        }
        return output;
    }

    @Override
    public BeanCompleter2 beanCompleterFactory(ResultSet rs) {
        return new SqlBeanCompleter3(rs);
    }

    @Override
    public BeanCompleter2 beanCompleterFactory(ResultSet rs, Object[] extra) {
        return new SqlBeanCompleter3(rs);
    }
}

