/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.templates.library;

import java.util.List;
import org.openprovenance.prov.template.library.plead.client.integrator.InputOutputProcessor;
import org.openprovenance.prov.template.library.plead.client.integrator.Plead_approvingInputs;
import org.openprovenance.prov.template.library.plead.client.integrator.Plead_approvingOutputs;
import org.openprovenance.prov.template.library.plead.client.integrator.Plead_filteringInputs;
import org.openprovenance.prov.template.library.plead.client.integrator.Plead_filteringOutputs;
import org.openprovenance.prov.template.library.plead.client.integrator.Plead_splittingInputs;
import org.openprovenance.prov.template.library.plead.client.integrator.Plead_splittingOutputs;
import org.openprovenance.prov.template.library.plead.client.integrator.Plead_trainingInputs;
import org.openprovenance.prov.template.library.plead.client.integrator.Plead_trainingOutputs;
import org.openprovenance.prov.template.library.plead.client.integrator.Plead_transformingInputs;
import org.openprovenance.prov.template.library.plead.client.integrator.Plead_transformingOutputs;
import org.openprovenance.prov.template.library.plead.client.integrator.Plead_validatingInputs;
import org.openprovenance.prov.template.library.plead.client.integrator.Plead_validatingOutputs;
import org.openprovenance.prov.vanilla.ProvFactory;

public class PleadWorkflow {
    private final List<Object> inputs;
    private final List<Object> outputs;
    Integer organization = 111;
    Integer engineer = 222;
    Integer manager = 333;
    private final InputOutputProcessor templateInvoker;
    private final ProvFactory pf = ProvFactory.getFactory();

    public PleadWorkflow(InputOutputProcessor templateInvoker, List<Object> inputs, List<Object> outputs) {
        this.templateInvoker = templateInvoker;
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public void workflow(String filenameRoot, Integer oldFileId, Integer tmethod, Integer fmethod, Integer n_rows, Integer n_cols, String path, String start, String end) {
        Plead_transformingInputs transformingInputs = new Plead_transformingInputs();
        transformingInputs.filename = filenameRoot + "-transformed.csv";
        transformingInputs.file = oldFileId;
        transformingInputs.method = tmethod;
        transformingInputs.organization = this.organization;
        transformingInputs.engineer = this.engineer;
        transformingInputs.n_rows = n_rows;
        transformingInputs.n_cols = n_cols;
        transformingInputs.path = path;
        transformingInputs.time = this.pf.newTimeNow().toString();
        transformingInputs.start = start;
        transformingInputs.end = end;
        if (this.inputs != null) {
            this.inputs.add(transformingInputs);
        }
        Plead_transformingOutputs transformingOutputs = this.templateInvoker.process(transformingInputs);
        if (this.outputs != null) {
            this.outputs.add(transformingOutputs);
        }
        Plead_filteringInputs filteringInputs = new Plead_filteringInputs();
        filteringInputs.filename = filenameRoot + "-filtered.csv";
        filteringInputs.file = transformingOutputs.transformed_file;
        filteringInputs.method = fmethod;
        filteringInputs.organization = this.organization;
        filteringInputs.engineer = this.engineer;
        filteringInputs.n_rows = n_rows;
        filteringInputs.n_cols = n_cols;
        filteringInputs.path = path;
        filteringInputs.time = this.pf.newTimeNow().toString();
        filteringInputs.start = start;
        filteringInputs.end = end;
        if (this.inputs != null) {
            this.inputs.add(filteringInputs);
        }
        Plead_filteringOutputs filteringOutputs = this.templateInvoker.process(filteringInputs);
        if (this.outputs != null) {
            this.outputs.add(filteringOutputs);
        }
        Plead_splittingInputs splittingInputs = new Plead_splittingInputs();
        splittingInputs.filename1 = filenameRoot + "-training.csv";
        splittingInputs.filename2 = filenameRoot + "-validation.csv";
        splittingInputs.file = filteringOutputs.filtered_file;
        splittingInputs.organization = this.organization;
        splittingInputs.engineer = this.engineer;
        splittingInputs.path1 = path;
        splittingInputs.time = this.pf.newTimeNow().toString();
        if (this.inputs != null) {
            this.inputs.add(splittingInputs);
        }
        Plead_splittingOutputs splittingOutputs = this.templateInvoker.process(splittingInputs);
        if (this.outputs != null) {
            this.outputs.add(splittingOutputs);
        }
        Plead_trainingInputs trainingInputs = new Plead_trainingInputs();
        trainingInputs.filename = filenameRoot + ".pipeline";
        trainingInputs.training_dataset = splittingOutputs.split_file1;
        trainingInputs.organization = this.organization;
        trainingInputs.engineer = this.engineer;
        trainingInputs.path = path;
        trainingInputs.time = this.pf.newTimeNow().toString();
        if (this.inputs != null) {
            this.inputs.add(trainingInputs);
        }
        Plead_trainingOutputs trainingOutputs = this.templateInvoker.process(trainingInputs);
        if (this.outputs != null) {
            this.outputs.add(trainingOutputs);
        }
        Plead_validatingInputs validatingInputs = new Plead_validatingInputs();
        validatingInputs.score_value = Math.random();
        validatingInputs.testing_dataset = splittingOutputs.split_file2;
        validatingInputs.organization = this.organization;
        validatingInputs.engineer = this.engineer;
        validatingInputs.path = path;
        validatingInputs.time = this.pf.newTimeNow().toString();
        if (this.inputs != null) {
            this.inputs.add(validatingInputs);
        }
        Plead_validatingOutputs validatingOutputs = this.templateInvoker.process(validatingInputs);
        if (this.outputs != null) {
            this.outputs.add(validatingOutputs);
        }
        Plead_approvingInputs approvingInputs = new Plead_approvingInputs();
        approvingInputs.pipeline = trainingOutputs.pipeline;
        approvingInputs.filename = filenameRoot + ".approved-pipeline";
        approvingInputs.score = validatingOutputs.score;
        approvingInputs.signature = "signature";
        approvingInputs.organization = this.organization;
        approvingInputs.manager = this.manager;
        approvingInputs.path = path;
        approvingInputs.time = this.pf.newTimeNow().toString();
        if (this.inputs != null) {
            this.inputs.add(approvingInputs);
        }
        Plead_approvingOutputs approvingOutputs = this.templateInvoker.process(approvingInputs);
        if (this.outputs != null) {
            this.outputs.add(approvingOutputs);
        }
    }
}

