// Generated automatically by ProvToolbox for template configuration 'template_library'
// by class org.openprovenance.prov.template.compiler.sql.CompilerSqlIntegration, method generateSqlIntegration_EnactorImplementation,
// in file CompilerSqlIntegration.java, at line 290
package org.openprovenance.prov.template.library.pg.sql.common;

import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.StringBuilder;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.template.library.pg.client.common.BeanCompleter;
import org.openprovenance.prov.template.library.pg.client.common.BeanEnactor;

public class SqlEnactorImplementation implements BeanEnactor.EnactorImplementation<ResultSet> {
  private final Function<String, ResultSet> querier;

  public SqlEnactorImplementation(Function<String, ResultSet> querier) {
    this.querier=querier;
  }

  @Override
  public <T> T generic_enact(T bean, Consumer<T> check, BiConsumer<StringBuilder, T> composeQuery,
      BiConsumer<ResultSet, T> completeBean) {
    check.accept(bean);
    StringBuilder sb = new StringBuilder();
    composeQuery.accept(sb, bean);
    String statement = sb.toString();
    ResultSet rs;
    try {
      rs = querier.apply(statement);
      if (!rs.next()) {
        rs.close();
        throw new SQLException("Single row result was expected but result set is empty ");
      }
      completeBean.accept(rs, bean);
      if (rs.next()) {
        rs.close();
        throw new SQLException("Single row result was expected for query ");
      } else {
        rs.close();
      }
    } catch (SQLException e) {
      e.printStackTrace();
      throw new UncheckedException("Issue in enactment " + statement, e);
    }
    return bean;
  }

  @Override
  public BeanCompleter beanCompleterFactory(ResultSet rs) {
    return new SqlBeanCompleter(rs);
  }

  public static void printResultSet(ResultSet resultSet) {
    try {
      ResultSetMetaData rsmd = resultSet.getMetaData();
      int columnsNumber = rsmd.getColumnCount();
      do {
        // in generic_enact, we have already done next(), we are on the first record;
        System.out.print ("Row " + resultSet.getRow() + " ");
        for (int i = 1; i <= columnsNumber; i++) {
          if (i > 1) {
            System.out.print(",  ");
          }
          String columnValue = resultSet.getString(i);
          System.out.print(columnValue + " " + rsmd.getColumnName(i));
        }
        System.out.println("");
      } while (resultSet.next());
    } catch (SQLException e) {
      throw new RuntimeException(e);
    }
  }
}
