-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS activity (
  id SERIAL,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQLPrimitiveTables()

CREATE TABLE IF NOT EXISTS file (
  id SERIAL,
  created_at timestamp with time zone NOT NULL DEFAULT NOW()
 );





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSqlTypeDeclaration()
DROP TYPE IF EXISTS ptm_expanding_type CASCADE;
CREATE TYPE ptm_expanding_type AS  (
  document TEXT,
  provenance TEXT,
  template TEXT,
  bindings TEXT,
  agent INT,
  expanding INT,
  email TEXT,
  time timestamptz
 );





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSqlTypeDeclaration()
DROP TYPE IF EXISTS ptm_mexpanding_type CASCADE;
CREATE TYPE ptm_mexpanding_type AS  (
  template TEXT,
  provenance TEXT,
  mtemplate TEXT,
  bindings TEXT,
  agent INT,
  mexpanding INT,
  email TEXT,
  time timestamptz
 );




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQL()

CREATE TABLE IF NOT EXISTS ptm_expanding
(
  ID SERIAL,
    --  The document resulting from template expansion
  document TEXT,
    --  The provenance of the document resulting from the template expansion
  provenance TEXT,
    --  The template to be expanded
  template TEXT,
    --  The bindings used in expansion
  bindings TEXT,
    --  The agent controlling the expansion
  agent INT,
    --  The activity of expanding the template
  expanding INT,
    --  The agent's email
  email TEXT,
    --  Time when the transformed file is created
  time timestamptz
);





-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateAccessControlTables()

CREATE TABLE IF NOT EXISTS record_index
(
  ID SERIAL,
  key INT,
  table_name TEXT,
  principal TEXT,
  hash jsonb
);


CREATE TABLE IF NOT EXISTS access_control
(
  ID SERIAL,
  record INT,
  authorized TEXT
);

ALTER TABLE record_index 
DROP CONSTRAINT IF EXISTS record_index_pkey CASCADE;


ALTER TABLE record_index 
ADD CONSTRAINT record_index_pkey
PRIMARY KEY (ID);


ALTER TABLE access_control 
DROP CONSTRAINT IF EXISTS fk_access_control_record CASCADE;


ALTER TABLE access_control 
ADD CONSTRAINT fk_access_control_record 
FOREIGN KEY (record) 
REFERENCES record_index (ID)
ON DELETE CASCADE;




-- Generated by method org.openprovenance.prov.template.compiler.CompilerSQL.generateSQL()

CREATE TABLE IF NOT EXISTS ptm_mexpanding
(
  ID SERIAL,
    --  The template resulting from the mtemplate expansion
  template TEXT,
    --  The provenance of the document resulting from the template expansion
  provenance TEXT,
    --  The meta template to be expanded
  mtemplate TEXT,
    --  The bindings used in expansion
  bindings TEXT,
    --  The agent controlling the expansion
  agent INT,
    --  The activity of expanding the template
  mexpanding INT,
    --  The agent's email
  email TEXT,
    --  Time when the transformed file is created
  time timestamptz
);







-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertFunction

CREATE OR REPLACE FUNCTION insert_ptm_expanding(input_template TEXT, input_bindings TEXT, input_agent INT, input_email TEXT, input_time timestamptz)
 RETURNS table(ID INT, document TEXT, provenance TEXT, expanding INT)
 AS $$
  WITH
        _new_document_with_id AS (INSERT INTO file DEFAULT VALUES 
                                  RETURNING file.ID AS file_id), 
        _new_provenance_with_id AS (INSERT INTO file DEFAULT VALUES 
                                    RETURNING file.ID AS file_id), 
        _new_expanding_with_id AS (INSERT INTO activity DEFAULT VALUES 
                                   RETURNING activity.ID AS activity_id)
  INSERT INTO ptm_expanding(document, provenance, template, bindings, agent, expanding, email, time)
  VALUES ((SELECT file_id FROM _new_document_with_id), 
          (SELECT file_id FROM _new_provenance_with_id), 
          input_template, 
          input_bindings, 
          input_agent, 
          (SELECT activity_id FROM _new_expanding_with_id), 
          input_email, 
          input_time)
  RETURNING ptm_expanding.ID, ptm_expanding.document, ptm_expanding.provenance, ptm_expanding.expanding
 $$ language SQL;






-- Generated by method org.openprovenance.prov.template.compiler.sql.CompilerSqlComposer.generateSQLInsertFunction

CREATE OR REPLACE FUNCTION insert_ptm_mexpanding(input_mtemplate TEXT, input_bindings TEXT, input_agent INT, input_email TEXT, input_time timestamptz)
 RETURNS table(ID INT, template TEXT, provenance TEXT, mexpanding INT)
 AS $$
  WITH
        _new_template_with_id AS (INSERT INTO file DEFAULT VALUES 
                                  RETURNING file.ID AS file_id), 
        _new_provenance_with_id AS (INSERT INTO file DEFAULT VALUES 
                                    RETURNING file.ID AS file_id), 
        _new_mexpanding_with_id AS (INSERT INTO activity DEFAULT VALUES 
                                    RETURNING activity.ID AS activity_id)
  INSERT INTO ptm_mexpanding(template, provenance, mtemplate, bindings, agent, mexpanding, email, time)
  VALUES ((SELECT file_id FROM _new_template_with_id), 
          (SELECT file_id FROM _new_provenance_with_id), 
          input_mtemplate, 
          input_bindings, 
          input_agent, 
          (SELECT activity_id FROM _new_mexpanding_with_id), 
          input_email, 
          input_time)
  RETURNING ptm_mexpanding.ID, ptm_mexpanding.template, ptm_mexpanding.provenance, ptm_mexpanding.mexpanding
 $$ language SQL;




