/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.TypedValue;
import org.openprovenance.prov.template.Bindings;
import org.openprovenance.prov.template.ExpandAction;
import org.openprovenance.prov.template.Groupings;
import org.openprovenance.prov.template.Using;
import org.openprovenance.prov.xml.ProvUtilities;

public class Expand {
    static Logger logger = Logger.getLogger(Expand.class);
    public static final String VAR_NS = "http://openprovenance.org/var#";
    public static final String VARGEN_NS = "http://openprovenance.org/vargen#";
    public static final String TMPL_NS = "http://openprovenance.org/tmpl#";
    public static final String TMPL_PREFIX = "tmpl";
    public static final String VAR_PREFIX = "var";
    public static final String VARGEN_PREFIX = "vargen";
    public static final String LINKED = "linked";
    public static final String LINKED_URI = "http://openprovenance.org/tmpl#linked";
    public static final String LABEL = "label";
    public static final String TIME = "time";
    public static final String STARTTIME = "startTime";
    public static final String ENDTIME = "endTime";
    public static final String LABEL_URI = "http://openprovenance.org/tmpl#label";
    public static final String TIME_URI = "http://openprovenance.org/tmpl#time";
    public static final String STARTTIME_URI = "http://openprovenance.org/tmpl#startTime";
    public static final String ENDTIME_URI = "http://openprovenance.org/tmpl#endTime";
    private final boolean addOrderp;
    private final boolean allUpdatedRequired;
    private final ProvFactory pf;
    static ProvUtilities u = new ProvUtilities();
    boolean allExpanded = true;

    public Expand(ProvFactory pf, boolean addOrderp, boolean allUpdatedRequired) {
        this.pf = pf;
        this.addOrderp = addOrderp;
        this.allUpdatedRequired = allUpdatedRequired;
    }

    Document expand(Document template, Bindings bindings) {
        return null;
    }

    public Document expander(Document docIn, String out, Document docBindings) {
        Bundle bun = (Bundle)docIn.getStatementOrBundle().get(0);
        Bindings bindings1 = Bindings.fromDocument(docBindings, this.pf);
        Groupings grp1 = Groupings.fromDocument(docIn);
        logger.debug((Object)("expander: Found groupings " + grp1));
        Bundle bun1 = (Bundle)this.expand(bun, bindings1, grp1).get(0);
        Document doc1 = this.pf.newDocument();
        doc1.getStatementOrBundle().add(bun1);
        bun1.setNamespace(Namespace.gatherNamespaces((Bundle)bun1));
        doc1.setNamespace(new Namespace());
        return doc1;
    }

    public List<StatementOrBundle> expand(Statement statement, Bindings bindings1, Groupings grp1) {
        Using us1 = this.usedGroups(statement, grp1, bindings1);
        return this.expand(statement, bindings1, grp1, us1);
    }

    public boolean getAllExpanded() {
        return this.allExpanded;
    }

    public List<StatementOrBundle> expand(Bundle bun, Bindings bindings1, Groupings grp1) {
        Hashtable<QualifiedName, QualifiedName> env0 = new Hashtable<QualifiedName, QualifiedName>();
        Hashtable<QualifiedName, List<TypedValue>> env1 = new Hashtable<QualifiedName, List<TypedValue>>();
        ExpandAction action = new ExpandAction(this.pf, (org.openprovenance.prov.model.ProvUtilities)u, this, env0, env1, null, bindings1, grp1, this.addOrderp, this.allUpdatedRequired);
        u.doAction((StatementOrBundle)bun, (StatementAction)action);
        this.allExpanded = this.allExpanded && action.getAllExpanded();
        return action.getList();
    }

    public List<StatementOrBundle> expand(Statement statement, Bindings bindings1, Groupings grp1, Using us1) {
        LinkedList<StatementOrBundle> results = new LinkedList<StatementOrBundle>();
        Iterator<List<Integer>> iter = us1.iterator();
        while (iter.hasNext()) {
            List<Integer> index = iter.next();
            Hashtable<QualifiedName, QualifiedName> env = us1.get(bindings1, grp1, index);
            Hashtable<QualifiedName, List<TypedValue>> env2 = us1.getAttr(Expand.freeAttributeVariables(statement, this.pf), bindings1, (Using.UsingIterator)iter);
            ExpandAction action = new ExpandAction(this.pf, (org.openprovenance.prov.model.ProvUtilities)u, this, env, env2, index, bindings1, grp1, this.addOrderp, this.allUpdatedRequired);
            u.doAction((StatementOrBundle)statement, (StatementAction)action);
            this.allExpanded = this.allExpanded && action.getAllExpanded();
            results.addAll(action.getList());
        }
        return results;
    }

    public static Set<QualifiedName> freeVariables(Statement statement) {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        for (int i = 0; i < u.getFirstTimeIndex(statement); ++i) {
            Object o = u.getter(statement, i);
            if (o instanceof QualifiedName) {
                QualifiedName name = (QualifiedName)o;
                if (name == null || !Expand.isVariable(name)) continue;
                result.add(name);
                continue;
            }
            if (!(o instanceof List)) continue;
            List ll = (List)o;
            for (QualifiedName name : ll) {
                if (name == null || !Expand.isVariable(name)) continue;
                result.add(name);
            }
        }
        return result;
    }

    public static Set<QualifiedName> freeVariables(Bundle statement) {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        QualifiedName name = statement.getId();
        if (name != null && Expand.isVariable(name)) {
            result.add(name);
        }
        return result;
    }

    public static HashSet<QualifiedName> freeAttributeVariables(Statement statement, ProvFactory pf) {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        Collection ll = pf.getAttributes(statement);
        for (Attribute attr : ll) {
            QualifiedName qn;
            Object o;
            if (!pf.getName().PROV_QUALIFIED_NAME.equals((Object)attr.getType()) || !((o = attr.getValue()) instanceof QualifiedName) || !Expand.isVariable(qn = (QualifiedName)o)) continue;
            result.add(qn);
        }
        return result;
    }

    Using usedGroups(Statement statement, Groupings groupings, Bindings bindings) {
        Set<QualifiedName> vars = Expand.freeVariables(statement);
        HashSet<Integer> groups = new HashSet<Integer>();
        for (QualifiedName var : vars) {
            for (int grp = 0; grp < groupings.size(); ++grp) {
                List<QualifiedName> names = groupings.get(grp);
                if (!names.contains(var)) continue;
                groups.add(grp);
            }
        }
        Using u = new Using();
        Object[] sorted = groups.toArray(new Integer[0]);
        Arrays.sort(sorted);
        for (Object g : sorted) {
            List<QualifiedName> vs = groupings.get((Integer)g);
            QualifiedName qn = vs.get(0);
            List<QualifiedName> vals = bindings.getVariables().get(qn);
            if (vals != null) {
                u.addGroup((Integer)g, vals.size());
                continue;
            }
            if (Expand.isGensymVariable(qn)) {
                u.addGroup((Integer)g, 1);
                continue;
            }
            List<List<TypedValue>> attrs = bindings.getAttributes().get(vs.get(0));
            if (attrs == null) continue;
            u.addGroup((Integer)g, attrs.size());
        }
        return u;
    }

    public static boolean isVariable(QualifiedName id) {
        if (id == null) {
            return false;
        }
        String namespaceURI = id.getNamespaceURI();
        return VAR_NS.equals(namespaceURI) || VARGEN_NS.equals(namespaceURI);
    }

    public static boolean isGensymVariable(QualifiedName id) {
        if (id == null) {
            return false;
        }
        String namespaceURI = id.getNamespaceURI();
        return VARGEN_NS.equals(namespaceURI);
    }
}

